/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro;
// eigene Pakete
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Calendar;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellRenderer;


import de.lunqual.rzpro.ausgabe.AusgabeFactory;
import de.lunqual.rzpro.ausgabe.CSVExport;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBFactory;
import de.lunqual.rzpro.designs.DesignFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.splash.SplashFenster;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.fonts.FontFactory;
import de.lunqual.rzpro.hilfefactory.HilfeFactory;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.fenster.FensterItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.localefactory.LocaleFactory;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
import de.lunqual.rzpro.tafel.TafelFactory;

/**
 * rzpro ist die Hauptklasse, von der aus alles andere gestartet wird ein
 * Verweis auf rzpro wird jeder anderen Klasse mitgegeben. die "Factories"
 * übernehmen spezielle Aufgaben und sind über diese Klasse aufrufbar...
 *
 * @author lunqual
 */

public class RzPro{

	// Const 
	// Application allgemein
	public static final String APP_NAME = "Rezeptbuch Pro";
	public static final int APP_VERSION = 4;
	public static final int APP_MAJOR = 2;
	public static final int APP_MINOR = 0;
	public static final String APP_BUILD = "24.12.2025";

	// maximale Länger der Strings in der Datenbank
	public static final int STRING_SIZE = 255;
	// nach xxx millisekunden läuft der Timer für listen ab
	public static final int LIST_TIMEOUT = 250;
	// maximaler Intervall in Minuten für die Bestandswarnung
	public static final int MAX_BESTANDSWARNUNG_INTERVAL = 240;
	public static final int MAX_AUFTRAGSLISTE_INTERVAL = 240;
	
	private static final int TIMEOUT_SPAN=60000;
	
	// nach xxx millisekunden läuft der Timer im Zutatendialog ab
	public static final int ZUTATEN_TIMEOUT = 125;
	// soll Garbage Collection bei jedem "Sperren" erfolgen ?
	// Das löst an sich noch keine Garbage-Collection aus, sondern sagt der JRE
	// nur,
	// dass jetzt ein günstiger Zeitpunkt wäre...
	public static final String DEFAULT_GC_HANDLING = "yes";

	// Diese Zahl wird als 0 betrachtet. Die Dezimalstellen sollten so gewählt
	// werden, wie die
	// allgemeine Zahlendarstellung erfordert. Normalerweise wird auf 4
	// Dezimalstellen gerechnet,
	// DOUBLE_NULL sollte dann also 0.0001 sein. Dafür wird eine Option gesetzt,
	// diese Definition hier ist
	// nur die Vorgabe !
	public static final double DOUBLE_NULL = 0.0001;

	// Voreinstellungen
	public static final int OPTION_KALKULATION_DEFAULT_CURRENCY = 1;
	public static final int CURRENCY_DEFAULT_SCALE = 4;
	public static final int OPTION_REZEPTUR_DEFAULT_EINHEIT = 1;

	public static final String DATEFORMAT_NORMAL = "dd.MM.yyyy H:mm:ss";
	public static final String DATEFORMAT_HOUR = "dd.MM.yyyy H:mm";
	public static final String DATEFORMAT = "EEEEE, d. MMMMM yyyy ";

	// fundamentale Rezepturtypen
	public static final int TYP_ID_REZEPT = 1;
	public static final int TYP_ID_NOTIZ = 2;
	public static final int TYP_ID_VERWEIS = 3;
	public static final int TYP_ID_AUSSTATTUNG = 4;
	public static final int TYP_ID_FILTERSCHICHT = 5;
	// Zahlenformate

	// fundamentale Zeilentypen
	public static final String TYP_COMMENT = "0";
	public static final String TYP_CALC = "1";
	public static final String TYP_AUSSTATTUNG_EINFACH = "+";
	public static final String TYP_AUSSTATTUNG_MULTI = "*";

	// einheiten
	public static final int EINHEIT_COMMENT = 0;
	public static final int EINHEIT_LITER = 1;
	public static final int EINHEIT_KG = 2;
	public static final int EINHEIT_LA = 3;
	public static final int EINHEIT_STAERKE = 4;
	public static final int EINHEIT_EXTRAKT = 5;
	public static final int EINHEIT_FAKTOR = 6;
	public static final int EINHEIT_ACID = 7;
	public static final int	EINHEIT_COMMENT_WARNING = 8;
	public static final int EINHEIT_KOSTEN = 9;
	public static final int EINHEIT_KOSTEN_STEUER = 10;

	LogFactory log;
	OptionFactory options;
	DesignFactory design;
	FontFactory fonts;
	LocaleFactory locale;
	FensterFactory fenster;
	DBFactory database;
	DialogControl dialog;
	AusgabeFactory ausgabe;
	ReportFactory report;
	HilfeFactory hilfe;
	TafelFactory tafel;
	CSVExport csv;

    Timer   							inactivityTimer;
	 AWTEventListener 		tm;	
	 int									countdown;
	 int									countdown_value;
	private static final long eventMask = AWTEvent.MOUSE_MOTION_EVENT_MASK   + AWTEvent.MOUSE_EVENT_MASK  + AWTEvent.KEY_EVENT_MASK;
	
	double nullValue = DOUBLE_NULL;
	/**
	 * gibt an, ob das Programm gerade gestartet wurde oder ob es schon läuft
	 * wird zum Sperren/Entsperren gebraucht
	 */
	boolean startup = true;

	static SplashFenster splash;
	/**
	 * Creates a new instance of rzpro
	 */
	public RzPro() {
	}
	
	public void initInactivityTimer() {
		if(inactivityTimer != null) {
			inactivityTimer.stop();
			inactivityTimer = null;
		}
		if(tm != null) {
			Toolkit.getDefaultToolkit().removeAWTEventListener(tm);
			tm = null;
		}
		
	    String java = "Java Version = " +
	    		System.getProperty("java.vm.vendor") + " " +
		    	System.getProperty("java.version") + " " +
		    	System.getProperty("java.vm.name") + " " +
		    	System.getProperty("user.language");
		    
	    this.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "kernel", java);
		String memory =
		    		"Memory Max= " + Long.toString( (Runtime.getRuntime().maxMemory()/(1024*1024))) + " MB " + 
					"Memory total = " +Long.toString( (Runtime.getRuntime().totalMemory()/(1024*1024))) + " MB";
	    this.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "kernel", "memory = " + memory);		    	
		String os = "OS = " + System.getProperty("os.name") + " "  + System.getProperty("os.arch")   + " " +  	System.getProperty("os.version") + 
			    	String.valueOf(Runtime.getRuntime().availableProcessors()
		    );
	    this.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "kernel", os);
		String mysql = "MySQL Version = " +getDatabase().dbGetDatabaseVersion();
	    this.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "kernel", mysql);
		String driver = "Driver Version = " + getDatabase().dbGetDriverVersion();
	    this.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "kernel", driver);
		
		int value = getOptionFactory().getOption("default.inactivity.timeout",OptionFactory.DEFAULT_INACTIVITY_TIMEOUT);
		if(value > 0) {
			setupTM();
			countdown = value;
			countdown_value = countdown;
			this.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "kernel", "timeout set to " + value + " minutes");
			inactivityTimer = new Timer(TIMEOUT_SPAN , new ActionListener() {
	            public void actionPerformed(ActionEvent evt) {
	                 inactivityTimerEvent();
	            }
		    });
			inactivityTimer.start();
		}else {
			this.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "kernel", "no timeout set");
		}
	}
	
	private void setupTM(){
		 tm = new AWTEventListener()
			{
			    public void eventDispatched(AWTEvent e)
			    {
			    	if(inactivityTimer != null) {
			    		if(inactivityTimer.isRunning()) {
			    			inactivityTimer.restart();
			    			countdown = countdown_value;
			    		}
			    	}
			    }
		 };
		 if(tm != null) {
			Toolkit.getDefaultToolkit().addAWTEventListener(tm,eventMask);
		 }
	}
	
	private  void inactivityTimerEvent() {
		inactivityTimer.stop();
		if(countdown == 1) {
			countdown =  getOptionFactory().getOption("default.inactivity.timeout",OptionFactory.DEFAULT_INACTIVITY_TIMEOUT);
			countdown_value = countdown;
			FensterItem fi = getFensterFactory().getFensterListe().getFensterItem(FensterFactory.FENSTER_LOGIN);
			if(fi == null) {
				JRzFrame frame = getFensterFactory().getFensterListe().getActive();
				if(frame != null) {
					getFensterFactory().getFensterListe().sperren(frame);
				}
			} 
		}else {
			--countdown;
		}
		inactivityTimer.start();
	}
		

	public int getCountdown() {
		if(tm == null) {
			return -1;
		} else {
			return countdown;
		}
	}
	
	
	/** das Programm starten.. alle nötigen Klassen instanzieren */
	public void openApp() {
		log = new LogFactory(this);
		splash.setStatus(5);
		design = new DesignFactory(this);
		splash.setStatus(10);
		options = new OptionFactory(this);
		log.initLog();
		splash.setStatus(15);
		locale = new LocaleFactory(this); // Sprache ;
		splash.setStatus(25);
		database = new DBFactory(this);
		splash.setStatus(30);
		fonts = new FontFactory(this);
		splash.setStatus(40);
		fenster = new FensterFactory(this);
		splash.setStatus(50);
		dialog = new DialogControl(this);
		splash.setStatus(60);
		ausgabe = new AusgabeFactory(this);
		splash.setStatus(70);
		report = new ReportFactory(this);
		splash.setStatus(85);
		hilfe = new HilfeFactory(this);
		splash.setStatus(92);
		tafel = new TafelFactory(this);
		splash.setStatus(95);
		csv = new CSVExport(this);
		splash.setStatus(98);
		// NullValue setzen;
		nullValue = options.getDouble("nff.null", DOUBLE_NULL);
		// Loginfenster anzeigen
		fenster.getFensterListe().createWindow(FensterFactory.FENSTER_LOGIN,true, null);
		
		
	}
	
	
	
	public int getPreferredRowHeight(JTable table, int row) {
	    int pref = 0;
	    for (int column = 0; column < table.getColumnCount(); column++) {
	        TableCellRenderer renderer = table.getCellRenderer(row, column);
	        Component comp = table.prepareRenderer(renderer, row, column);
	        pref = (comp.getPreferredSize().height > pref)?comp.getPreferredSize().height:pref;
	    }
	    return pref > 0 ? pref: table.getRowHeight();
	}

	public void setPreferredRowHeight(JTable table, int row) {
	    int prefHeight = getPreferredRowHeight(table, row);
	    table.setRowHeight(row, prefHeight);
	}

	
	public void setPreferredRowHeights(JTable table) {
	    for (int row = 0; row < table.getRowCount(); row++) {
	        setPreferredRowHeight(table, row);
	    }
	}

	
	 public void saveToFile(JFrame frame,String caption,String text) {
			final JFileChooser fc = new JFileChooser(new File(getOptionFactory().getOption("rz_save.path")));
			fc.setDialogTitle(caption);
			int returnVal = fc.showOpenDialog(frame);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = fc.getSelectedFile();
				getOptionFactory().setOption("rz_save.path", file.getAbsolutePath());
				try {
					boolean write = true;
					File e = new File(file.getAbsolutePath());
					if(e.exists() && !e.isDirectory()) {
						DialogItem di = new DialogItem(
		                        DialogControl.FRAGE_DIALOG,
		                        "",0.0,
		                        this.getLocale().getString("rz.question_overwrite"),
		                        this.getLocale().getString("rz.question_overwrite"),
		                        this.getLocale().getString("rz.question_overwrite.1")
		                        	.replaceAll("%s",e.getAbsolutePath()),
		                        "frage.png",
		                        this.getLocale().getString("string_ja"),
		                        this.getLocale().getString("string_nein"),
		                        (JRzFrame)frame
			                );
						  	if(di != null) {
						  		this.getDialogFactory().getDialog(di);
						  		if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
						  			write = true;
						  		} else {
						  			write = false;
						  		}
							}
					} 
					if(write) {
						PrintWriter out = new PrintWriter(file.getAbsolutePath());
						out.print(text);
						out.close();
					}
				} catch (FileNotFoundException e) {
				}
		}
    }

	/**
	 * File Dialog
	 */
	public String getTextFile(JFrame frame,String caption) {
		String ret ="";
		final JFileChooser fc = new JFileChooser(new File(getOptionFactory().getOption("rz.path")));
		FileNameExtensionFilter filter = new FileNameExtensionFilter("Textdateien", "txt", "text");
		fc.setFileFilter(filter);
		fc.setDialogTitle(caption);
		int returnVal = fc.showOpenDialog(frame);
		if (returnVal == JFileChooser.APPROVE_OPTION) {
	          File file = fc.getSelectedFile();
	          Path path = Paths.get(file.getAbsolutePath());
	          getOptionFactory().setOption("rz.path", file.getAbsolutePath());
	          try {
	        	  String line;
	        	  BufferedReader reader = Files.newBufferedReader(path);
	        	  while ((line = reader.readLine()) != null) {
	  				ret += line + "\n";
	  			  }
	        	  	reader.close();
	        	  } catch (IOException e) {
			}
	     }
	
		 return ret;
	}

	
	/**
	 * Nachrichten über Login-OK, Login-Abbruch oder Programm beenden !
	 *
	 * @param msg
	 */

	public void sysMessage(final MessageItem msg) {
		switch (msg.getMsgCode()) {
			case MessageItem.MSG_LOGIN_OK :
				// falls das AnmeldeEinstellungs-Fenster noch offen steht,
				// sollte es geschlossen werden
				getFensterFactory().getFensterListe().disposeFrame(String.valueOf(FensterFactory.FENSTER_LOGIN_EINSTELLUNGEN)+ FensterFactory.WINDOW_SEPARATOR + "0");
				if (startup) {
					fenster.getFensterListe().disposeFrame((JRzFrame) msg.getData());	
					fenster.getFensterListe().createWindow(FensterFactory.FENSTER_AUSWAHL, true, null);
					startup = false;
				} else {
					fenster.getFensterListe().disposeFrame((JRzFrame) msg.getData());
					fenster.getFensterListe().entSperren();
				}
				initInactivityTimer();
				break;
			case MessageItem.MSG_LOGIN_CANCEL :
				closeApp();
				break;
			case MessageItem.MSG_QUIT :
				log.logMessage(LogFactory.LOG_MESSAGE, "RzPro", "quit Program");
				closeApp();
				break;
		}
	}


	
	/** getVersionString gibt den Namen und die Version zurück */
	public String getVersionString() {
		return APP_NAME + " (" + APP_VERSION + "." + APP_MAJOR + "."
				+ APP_MINOR + "/" + APP_BUILD + ")";
	}

	/** aufräumen und Programm beenden */
	public void closeApp() {
		database.dbClose();
		fenster.getFensterListe().disposeAllWindows();
		options.cleanUp();
		log = null;
		options = null;
		locale = null;
		fenster = null;
		fonts = null;
		database = null;
		dialog = null;
		ausgabe = null;
		report = null;
		hilfe = null;
		tafel = null;
		csv = null;
		disposeSplash(); // vorsichtshalber
		System.exit(0);
	}

	
    public void roundDatum(Calendar c) {
		c.set(Calendar.HOUR_OF_DAY,0);
		c.set(Calendar.MINUTE,0);
		c.set(Calendar.SECOND,0);
		c.set(Calendar.MILLISECOND,0);
    }
   
    public void roundDatumUp(Calendar c) {
		c.set(Calendar.HOUR_OF_DAY,23);
		c.set(Calendar.MINUTE,59);
		c.set(Calendar.SECOND,59);
		c.set(Calendar.MILLISECOND,999);
    }
    public Calendar getToday() {
    	Calendar c=Calendar.getInstance();
    	roundDatum(c);
    	return c;
    }
	public boolean FileTest(String filename) {
		final File f = new File(filename);
		return f.exists();
	}

	public boolean isZero(final double value) {
		return Math.abs(value) < nullValue;
	}

	public void setWaitCursor(final Window w) {
		if (w != null) {
			w.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		}
	}

	public boolean isMain() {
		return true;
	}
	
	
	public void setFreeCursor(final Window w) {
		if (w != null) {
			w.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		}
	}
	
	public LogFactory getLogFactory() {
		return log;
	}
	public DesignFactory getDesignFactory() {
		return design;
	}
	public OptionFactory getOptionFactory() {
		return options;
	}
	public LocaleFactory getLocale() {
		return locale;
	}
	public FensterFactory getFensterFactory() {
		return fenster;
	}
	public FontFactory getFontFactory() {
		return fonts;
	}
	public DBFactory getDatabase() {
		return database;
	}
	public DialogControl getDialogFactory() {
		return dialog;
	}
	public AusgabeFactory getAusgabeFactory() {
		return ausgabe;
	}
	public ReportFactory getReportFactory() {
		return report;
	}
	public HilfeFactory getHilfeFactory() {
		return hilfe;
	}
	public TafelFactory getTafelFactory() {
		return tafel;
	}
	public CSVExport getCSVExport() {
		return csv;
	}
	public void disposeSplash() {
		if (splash != null) {
			splash.dispose();
			splash = null;
		}
	}

	public void setSplashStatus(final int percent) {
		if (splash != null) {
			splash.setStatus(percent);
		}
	}
	


	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(final String[] args) {
		splash = new SplashFenster();
		final RzPro r = new RzPro();

		r.openApp();
	}
}