/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;


import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.adressen.AdressListe;

/**
 * @author labor
 *
 */
public class AdressenAusgabeDrucken extends ReportAusgabe{

    AdressListe			al;
    tableModel				modell;

    public static final String			DEFAULT_ORIENTATION="portrait";
    /**
     *
     */
    public AdressenAusgabeDrucken(RzPro r,Object reportData,String optionKey,java.awt.Window w) {
        super(r, reportData,optionKey,w);
        rz = r;
        al = (AdressListe)reportData;
        this.optionKey = optionKey;
        modell =null;
        df = new SimpleDateFormat("dd.MM.yyyy H:mm");
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void createModel(){
        final tableModel modell = new tableModel();
        if(modell != null) {
	        final Date datum = new Date();
	        for (int i = 0;i < al.size();i++){
	            final AdressItem ai = al.getItem(i);
	            modell.addItem(
	                rz.getDatabase().dbGetUser(),
		            ai.getFirma(), ai.getVorname() + " " + ai.getNachname(),
		            ai.getKdnummer1(), ai.getKdnummer2(),
		            ai.getStrasse() + ", " + ai.getPLZ() + " " + ai.getOrt(),
		            ai.getFon(),  ai.getMobil(),  ai.getFax(), ai.getMail(),
		            ai.getComment(),
		            rz.getLocale().getString("string_erstellt").replaceAll("%s",ai.getErstelltToString()).replaceAll("%v",ai.getUser1()),
		            rz.getLocale().getString("string_geaendert").replaceAll("%s",ai.getGeaendertToString()).replaceAll("%v",ai.getUser2()),
		            datum
	            );
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {	"user","Firma" ,"Name","Kd1","Kd2","Ort","Telefon","Mobil","Fax","Mail","Comment","Erstellt","Geaendert","datum"};

              private final Class[] COLUMN_TYPE = {
                String.class,String.class, String.class, String.class, String.class,
                String.class, String.class, String.class, String.class,
                String.class, String.class,String.class,String.class,java.util.Date.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
			final String user,final String Firma, final String Name,final String Kd1,final String Kd2,
			final String Ort, final String Telefon,final String Mobil,final String Fax,
			final String Mail,final String Comment,final String Erstellt,final String Geaendert,
			final Date datum
			)
        {
            	liste.add (new Object[] { user,Firma, Name, Kd1, Kd2, Ort, Telefon, Mobil, Fax, Mail, Comment, Erstellt, Geaendert, datum });
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

