/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.adressen.AdressListe;
import de.lunqual.rzpro.items.adressen.AdressenRezepturenlisteItem;
/**
 * @author labor
 *
 */
public class AdressenRezepturenlisteDrucken extends ReportAusgabe {

	AdressListe									liste;
	public static final String			DEFAULT_ORIENTATION="portrait";
    /**
     *
     */
    public AdressenRezepturenlisteDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        liste = (AdressListe)reportData;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
        	ArrayList <AdressenRezepturenlisteItem> arl = rz.getDatabase().getAdressen().getAdressenRezepturenliste(liste);
        	Date d =new Date();
        	if(arl.size()>0) {
        		for (int i=0;i<arl.size();i++) {
        			modell.addItem(rz.getDatabase().dbGetUser(),arl.get(i).getName(),arl.get(i).toString(),d);
        		}
        	}
        	
        }
        report = getReport();
        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
        report.setQuery ("default");
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","firma","zeile","datum"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,
                String.class, 
                String.class,
                java.util.Date.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String firma,
                final String zeile,
                final java.util.Date datum
                )
        {
            	liste.add (new Object[] {user,firma,zeile,datum});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

