/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.rezeptur.AusstattungsItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class AusstattungRawDrucken extends ReportAusgabe {

    AusstattungsItem ai = null;
    public static final String			DEFAULT_ORIENTATION="portrait";
    /**
     *
     */
    public AusstattungRawDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        ai = (AusstattungsItem)reportData;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(ai != null){
	            final String titel = ai.getTitel();
	            final String zeilen[] = ai.getComment().split("\\n");
	            final String erstellt  = rz.getLocale().getString("string_erstellt").replaceAll("%s", ai.getErstelltToString()).replaceAll("%v",ai.getUser1());
	            final String geaendert = rz.getLocale().getString("string_geaendert").replaceAll("%s", ai.getGeaendertToString()).replaceAll("%v",ai.getUser2());
	            final String adressen = ai.getAdressListe().toVerboseString();
	            final String stichworte = ai.getStichwortListe().toVerboseString();
	            final Date datum = new Date();
	            for (final String element : zeilen) {
	                modell.addItem(rz.getDatabase().dbGetUser(),titel, adressen, stichworte, erstellt, geaendert, element, datum,
	                rz.getLocale().formatNumber(ai.getGebindegroesse(),OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_liter"),
	                rz.getLocale().formatNumber(ai.getGebindeGewicht(),OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_kg"),
	                rz.getLocale().formatNumber(ai.getPreis(),OptionFactory.NF_NORMAL) + " " + 	rz.getDatabase().getCurrency().dbGetCurrency(ai.getWaehrung(),true).getName(),
	                ai.getArtikelnummer()
	                );
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","titel","adressen","stichworte","erstellt","geaendert","zeile","datum",
                "gebindegroesse","gebindegewicht","gebindepreis","artikelnummer"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,String.class, String.class, String.class, String.class, String.class, String.class, java.util.Date.class,
                String.class,String.class,String.class,String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String titel,
                final String adressen,
                final String stichworte,
                final String erstellt,
                final String geaendert,
                final String zeile,
                final java.util.Date datum,
                final String groesse,
                final String gewicht,
                final String preis,
                final String artikelnummer
                )
        {
            	liste.add (new Object[] {user,titel,adressen,stichworte,erstellt,geaendert,zeile,datum,groesse,gewicht,preis,artikelnummer});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

