/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.bestellung.BestellungsItem;
import de.lunqual.rzpro.items.bestellung.BestellungsListe;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class BestellungslisteDrucken extends ReportAusgabe {

    int 						key;
    public static final String			DEFAULT_ORIENTATION="portrait";
    BestellungsListe			liste;
    /**
     *
     */
    public BestellungslisteDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w,BestellungsListe liste) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        key = ((Integer)reportData).intValue();
        this.liste=liste;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        Date now = new Date();
        modell = new tableModel();
        if(modell != null) {
        	if(liste != null) {
        		for(int i =	0;i < liste.size();i++) {
        			BestellungsItem bi = liste.getItem(i);
        			modell.addItem(
        					rz.getDatabase().dbGetUser(),
        					bi.getUser_1(),
        					now,
        					bi.getErstellt(),
        					bi.getBezeichnung(),
        					bi.getArtikelnummer(),
        					bi.getFirma(),
        					rz.getLocale().getString("report.bestellungen.bestellmenge") + rz.getLocale().formatNumber(bi.getMenge(),OptionFactory.NF_NORMAL) + " " + rz.getDatabase().getEinheiten().getGrundeinheit(bi.getEinheit()),
        					rz.getLocale().getString("report.bestellungen.restmenge") + rz.getLocale().formatNumber(bi.getRest(),OptionFactory.NF_NORMAL)+ " " + rz.getDatabase().getEinheiten().getGrundeinheit(bi.getEinheit())
        					);
        		}
		        report = getReport();
		        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
		        report.setQuery ("default");
        	}
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user",
                "user_1",
                "datum",
                "bestelldatum",
                "bezeichnung",
                "artikelnummer",
                "firma",
                "bestellmenge",
                "restmenge"
              };

              private final Class[] COLUMN_TYPE = {
            		  String.class,
            		  String.class,
            		  java.util.Date.class,
            		  java.util.Date.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String user_1,
                final Date datum,
                final Date bestelldatum,
                final String bezeichnung,
                final String artikelnummer,
                final String firma,
                final String bestellmenge,
                final String restmenge
                )
        {
            	liste.add (new Object[] {user,user_1,datum,bestelldatum,bezeichnung,artikelnummer,firma,bestellmenge,restmenge});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

