package de.lunqual.rzpro.ausgabe;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.JFileChooser;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.buchung.StatistikRezepturItem;
import de.lunqual.rzpro.items.buchung.StatistikRezepturListe;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.inventur.InventurZeilenItem;
import de.lunqual.rzpro.items.inventur.InventurZeilenliste;
import de.lunqual.rzpro.items.rezeptur.ChangesItem;
import de.lunqual.rzpro.items.statistik.StatistikItem;
import de.lunqual.rzpro.items.statistik.WerteItem;
import de.lunqual.rzpro.items.verbrauch.VerbrauchsItem;
import de.lunqual.rzpro.items.verbrauch.VerbrauchsListe;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsListe;
import java.nio.file.Path;
import java.nio.file.Paths;


public class CSVExport {
	
	public static final int		EXPORT_FILE 	= 1;
	public static final int 		EXPORT_COPY 	= 2;
	String							trenner;
	RzPro 							rz;
	SimpleDateFormat		df0,df,df1,df2,dfi;
	
	public CSVExport(RzPro rz) {
		super();
		this.rz = rz;
		trenner = rz.getOptionFactory().getOption("csv.character");
        df0 = new SimpleDateFormat("dd.MM.yyyy");
        df = new SimpleDateFormat("dd.MM.yyyy HH:mm / D");
        df1 = new SimpleDateFormat("D");
        df2 = new SimpleDateFormat("yyyy");
        dfi = new SimpleDateFormat("dd.MM.yyyy HH:mm");        
	}

	public void verlaufCSV(BuchungsListe liste,String losnummer,String bemerkungen, String buchungsnummer,int mode) {
		if(liste != null) {
			String csv = this.getBuchungCSV2(liste,losnummer,bemerkungen,buchungsnummer);
			switch(mode) {
				case EXPORT_FILE:
					saveFile(csv);
					break;
				case EXPORT_COPY:
					saveCopy(csv);
					break;
			}
		}	
	}
	
	
	
	public void inventurCSV( InventurZeilenliste liste, String sort,String filter, int mode) {
		if(liste != null) {
			String csv = this.getInventurCSV(liste,sort,filter);
			switch(mode) {
				case EXPORT_FILE:
					saveFile(csv);
					break;
				case EXPORT_COPY:
					saveCopy(csv);
					break;
			}
		}
	}
	
	private String getInventurCSV(InventurZeilenliste liste,String sort, String filter) {
		String csv = rz.getLocale().getString("csv.inventur.titel") + "\n";
		csv += rz.getLocale().getString("csv.inventur.sort") + trenner + embedCSV(sort) +"\n";
		csv += rz.getLocale().getString("csv.inventur.filter") + trenner + embedCSV(filter) +"\n\n";
		
		csv += embedCSV(rz.getLocale().getString("csv.inventur.datum"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.art"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.raum"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.behaelter"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.inhalt"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.staerke"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.liter20"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.la"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.liter"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.tt"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.tafel3"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.brutto"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.tara"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.netto"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.extraktfrei"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.tafel2"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.litergewicht"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.benutzer"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.lager"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.steuerartikel"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.sorte"));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.steuerlager"));
		csv += "\n";
		double liter20 =0.0;
		double la = 0.0;
		for(int i = 0;i < liste.size();i++) {
			InventurZeilenItem zi = liste.getItem(i);
			liter20 += zi.getLiter20();
			la += zi.getLa();
			csv += embedCSV(dfi.format(zi.getErstellt()));
    		if(zi.getTyp() == InventurZeilenItem.TYP_LITER) {
    			csv += embedCSV(rz.getLocale().getString("inventureingabe.table_typ_liter"));
    		} else {
    			csv += embedCSV(rz.getLocale().getString("inventureingabe.table_typ_gewicht"));
    		}
    		csv += embedCSV(zi.getRaumText());
    		csv += embedCSV(zi.getTanknummer());
    		csv += embedCSV(zi.getInhalt());
    		csv += embedCSV(rz.getLocale().formatNumber(zi.getStaerke(),OptionFactory.NF_STAERKE));
    		csv += embedCSV(rz.getLocale().formatNumber(zi.getLiter20(),OptionFactory.NF_INVENTUR));
    		csv += embedCSV(rz.getLocale().formatNumber(zi.getLa(),OptionFactory.NF_INVENTUR));
    		switch (zi.getTyp()) {
    			case InventurZeilenItem.TYP_LITER:
    				csv += embedCSV(rz.getLocale().formatNumber(zi.getLiter(),OptionFactory.NF_INVENTUR) );
    				break;
    			case InventurZeilenItem.TYP_GEWICHT:
    				csv += trenner;
    				break;
    			case InventurZeilenItem.TYP_LEER:
    				csv += trenner ;
    				break;
    		}
    		switch (zi.getTyp()) {
    			case InventurZeilenItem.TYP_LITER:
        			csv += embedCSV( rz.getLocale().formatNumber(zi.getTanktemperatur(),OptionFactory.NF_INVENTUR) );
    				break;
    			case InventurZeilenItem.TYP_GEWICHT:
    				csv += trenner ;
    				break;
    			case InventurZeilenItem.TYP_LEER:
    				csv += trenner ;
    				break;
    		}
    		switch (zi.getTyp()) {
    			case InventurZeilenItem.TYP_LITER:
        			csv += embedCSV(rz.getLocale().formatNumber(zi.getTafel3(),OptionFactory.NF_INVENTUR) );
    				break;
    			case InventurZeilenItem.TYP_GEWICHT:
    				csv += trenner;
    				break;
    			case InventurZeilenItem.TYP_LEER:
    				csv += trenner ;
    				break;
    		}
    		switch (zi.getTyp()) {
    			case InventurZeilenItem.TYP_LITER:
    				csv += trenner;
    				break;
    			case InventurZeilenItem.TYP_GEWICHT:
        			csv += embedCSV(rz.getLocale().formatNumber(zi.getBrutto(),OptionFactory.NF_INVENTUR) );
    				break;
    			case InventurZeilenItem.TYP_LEER:
    				csv += trenner ;
    				break;
    		}//tara
    		switch (zi.getTyp()) {
    			case InventurZeilenItem.TYP_LITER:
    				csv += trenner;
    				break;
    			case InventurZeilenItem.TYP_GEWICHT:
    				csv += embedCSV( rz.getLocale().formatNumber(zi.getTara(),OptionFactory.NF_INVENTUR) );
    				break;
    			case InventurZeilenItem.TYP_LEER:
    				csv += trenner;
    				break;
    		}
    		switch (zi.getTyp()) {
    			case InventurZeilenItem.TYP_LITER:
    				csv += trenner;
    				break;
    			case InventurZeilenItem.TYP_GEWICHT:
    				csv += embedCSV( rz.getLocale().formatNumber(zi.getNetto(),OptionFactory.NF_INVENTUR) );
    				break;
    			case InventurZeilenItem.TYP_LEER:
    				csv += trenner ;
    				break;
    		}
    		switch (zi.getTyp()) {
    			case InventurZeilenItem.TYP_LITER:
    				csv += trenner;
    				break;
    			case InventurZeilenItem.TYP_GEWICHT:
    				if(zi.getExtrakt() == 0) {
        				csv += embedCSV( rz.getLocale().getString("string_ja"));
        			} else {
        				csv += embedCSV( rz.getLocale().getString("string_nein"));
        			}
    				break;
    			case InventurZeilenItem.TYP_LEER:
    				csv += trenner;
    				break;
    		}
    		switch (zi.getTyp()) {
    			case InventurZeilenItem.TYP_LITER:
    				csv += trenner;
    				break;
    			case InventurZeilenItem.TYP_GEWICHT:
        			if(zi.getExtrakt() == 0) {
        				csv += embedCSV(rz.getLocale().formatNumber(zi.getTafel2(),OptionFactory.NF_INVENTUR) );
        			} else {
        				csv += trenner;
        			}
    			break;
    			case InventurZeilenItem.TYP_LEER:
    				csv+= trenner ;
    				break;
    		}
    		switch (zi.getTyp()) {
    			case InventurZeilenItem.TYP_LITER:
    				csv += trenner;
    				break;
    			case InventurZeilenItem.TYP_GEWICHT:
    				if(zi.getExtrakt() == 0) {
        				csv += trenner;
        				} else {
        				csv += embedCSV(rz.getLocale().formatNumber(zi.getLitergewicht(),OptionFactory.NF_LITERGEWICHT) );
        				}
    				break;
				case InventurZeilenItem.TYP_LEER:
					 csv += trenner ;
					break;
    		}
    		csv += embedCSV(zi.getUser_1());
    		csv += embedCSV(zi.getStrLager());
    		csv += embedCSV(zi.getSteuer_artikel());
    		csv += embedCSV(zi.getStrSorte());
    		csv += embedCSV(zi.getStrSteuerlager());
    		csv += "\n";
		}
		csv += "\n\n";

		csv += embedCSV(rz.getLocale().formatNumber(liter20, OptionFactory.NF_INVENTUR));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.liter20"));

		csv += embedCSV(rz.getLocale().formatNumber(la, OptionFactory.NF_INVENTUR));
		csv += embedCSV(rz.getLocale().getString("csv.inventur.la"));
		
		return csv;
	}
	
	
	public void BuchungenCSV(BuchungsListe bl,Date von,Date bis,int mode) {
		if(bl != null) {
			String csv = this.getBuchungCSV1(bl,von,bis);
			switch(mode) {
				case EXPORT_FILE:
					saveFile(csv);
					break;
				case EXPORT_COPY:
					saveCopy(csv);
					break;
			}
		}
	}

	
	
	private String getBuchungCSV1(BuchungsListe bl,Date von,Date bis) {
		String csv = rz.getLocale().getString("csv.buchungen.header")   + trenner;
		if(von != null && bis != null) {
			csv += embedCSV(    rz.getLocale().getString("csv.buchungen.datum_header").replaceAll("%v", df0.format(von)).replaceAll("%b", df0.format(bis))    ) + "\n\n";
		} else {
			csv += embedCSV(rz.getLocale().getString("csv.buchungen.ohne_datum")) + "\n\n";
		}
		csv += this.getBuchungCSV(bl);
		return csv;
	}
	
	private String getBuchungCSV2(BuchungsListe liste,String losnummer,String bemerkungen,String buchungsnummer) {
		String csv =embedCSV( rz.getLocale().getString("csv.verlauf.header") ) + "\n";
		if(liste != null && !liste.isEmpty()) {
			csv += embedCSV(rz.getLocale().getString("csv.verlauf.losnummer")) +  embedCSV(losnummer) + "\n";
			csv += embedCSV(rz.getLocale().getString("csv.verlauf.bemerkungen"))  + embedCSV(bemerkungen) + "\n";
			csv += embedCSV(rz.getLocale().getString("csv.verlauf.buchungsnummer"))  + embedCSV(buchungsnummer) + "\n\n";
		}
		csv += this.getBuchungCSV(liste);
		return csv;
	}
	
	
	
	private String getBuchungCSV(BuchungsListe bl) {
		String csv = "";
		//Kopfzeile
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.nummer"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.art"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.datum"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.herstellung_losnummer"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.herstellung"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.probe"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.benutzer"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.bezeichnung"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.losnummer"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.staerke"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.liter"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.kg"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.la"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.rest_liter"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.rest_kg"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.rest_la"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.bemerkungen"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.steuerartikel"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.sorte"));
		csv += embedCSV(rz.getLocale().getString("csv.buchungen.steuerlager"));
		csv += "\n";
		double liter =0.0;
		double kg = 0.0;
		double la = 0.0;
		for(int i = 0;i < bl.size();i++) {
			BuchungsItem bi = bl.getItem(i);
			if(bi != null) {
				liter += bi.getLiter();
				kg += bi.getKg();
				la += bi.getLa();
				csv += embedCSV( String.valueOf(bi.getId()));
				csv += embedCSV( rz.getDatabase().getBuchungen().getCodeToString(bi.getCode()) );
				csv += embedCSV(  df.format(bi.getDatum()) + " ("+ rz.getDatabase().getKalender().getYear20(Integer.valueOf(df2.format(bi.getDatum()))) + rz.getDatabase().getKalender().getDate20(Integer.valueOf(df1.format(bi.getDatum())))+")"  );
				csv += embedCSV(bi.getHerstellung_losnummer()==null?"":bi.getHerstellung_losnummer());
				csv += embedCSV(bi.getHerstellung_bezeichnung()==null?"":bi.getHerstellung_bezeichnung());
				csv += embedCSV(bi.getHerstellungProbe() == null?"":bi.getHerstellungProbe());
				csv+= embedCSV(bi.getUser());
				csv += embedCSV(bi.getBezeichnung());
				csv += embedCSV(bi.getLosnummer()==null?"":bi.getLosnummer());				
				csv += embedCSV( rz.isZero(bi.getStaerke())?"":rz.getLocale().formatNumber(bi.getStaerke(), OptionFactory.NF_STAERKE));
				csv += embedCSV(rz.isZero(bi.getLiter())?"":rz.getLocale().formatNumber(bi.getLiter(), OptionFactory.NF_NORMAL));
				csv += embedCSV(rz.isZero(bi.getKg())?"":rz.getLocale().formatNumber(bi.getKg(), OptionFactory.NF_NORMAL));
				csv += embedCSV(rz.isZero(bi.getLa())?"":rz.getLocale().formatNumber(bi.getLa(), OptionFactory.NF_NORMAL));
				csv += embedCSV(rz.isZero(bi.getRest_liter())?"":rz.getLocale().formatNumber(bi.getRest_liter(), OptionFactory.NF_NORMAL));
				csv += embedCSV(rz.isZero(bi.getRest_kg())?"":rz.getLocale().formatNumber(bi.getRest_kg(), OptionFactory.NF_NORMAL));
				csv += embedCSV(rz.isZero(bi.getRest_la())?"":rz.getLocale().formatNumber(bi.getRest_la(), OptionFactory.NF_NORMAL));
				csv += embedCSV(bi.getComment() == null?"":bi.getComment());
				csv += embedCSV(bi.getSteuer_artikel() == null?"":bi.getSteuer_artikel());	
				csv += embedCSV(bi.getStrSorte() == null?"":bi.getStrSorte());
				csv += embedCSV(bi.getStrSteuerlager() == null?"":bi.getStrSteuerlager());
				csv += "\n";
			}
		}
		csv += "\n\n";
		csv += rz.getLocale().getString("csv.buchungen.saldo") + trenner + rz.getLocale().getString("csv.buchungen.saldo.liter") + trenner + rz.getLocale().getString("csv.buchungen.saldo.kg") + trenner + rz.getLocale().getString("csv.buchungen.saldo.la") + "\n" + trenner;
		csv += embedCSV(rz.getLocale().formatNumber(liter, OptionFactory.NF_NORMAL));
		csv += embedCSV( rz.getLocale().formatNumber(kg, OptionFactory.NF_NORMAL));
		csv += embedCSV(rz.getLocale().formatNumber(la, OptionFactory.NF_NORMAL));
		
		return csv;
	}
	
	
	public void VerbrauchCSV(VerbrauchsListe vl, int mode) {
		if(vl != null) {
			String csv = this.getVerbrauchCSV(vl);
			switch(mode) {
				case EXPORT_FILE:
					saveFile(csv);
					break;
				case EXPORT_COPY:
					saveCopy(csv);
					break;
			}
		}
	}
	
	private String getVerbrauchCSV(VerbrauchsListe vl) {
		String csv = rz.getLocale().getString("csv.verbrauch.titel") + "\n";
		String header = "";
		if ((vl.getRezepturListe() != null) && vl.getRezepturListe().isEmpty()) {
   			header += embedCSV(vl.getBezeichnung());
  		} else {
  			for(int i = 0;i < vl.getRezepturListe().size();i++) {
  				header += embedCSV((String)vl.getRezepturListe().get(i)) + "\n";
  			}
  		}
		// Zugang
		csv += header +"\n\n";
		csv += rz.getLocale().getString("csv.verbrauch.zugang") + "\n";
		csv += getHeaderString() + "\n";
		for(int i = 0; i < vl.getZugangsListe().size();i++    ) {
			final VerbrauchsItem vi=vl.getZugang(i);
			if(vi.getYear()==0) {
				csv += embedCSV(rz.getLocale().getString("ausgabe.label_verbrauch_insgesamt" )) ;
			}else {
				csv += embedCSV(String.valueOf(vi.getYear()));
			}
			
			csv += embedCSV(rz.isZero(vi.getLiter())?"":rz.getLocale().formatNumber(vi.getLiter(), OptionFactory.NF_ONE) ); 
			csv += embedCSV(rz.isZero(vi.getKg())?"":rz.getLocale().formatNumber(vi.getKg(), OptionFactory.NF_ONE) );
			csv += embedCSV(rz.isZero(vi.getLa())?"":rz.getLocale().formatNumber(vi.getLa(), OptionFactory.NF_ONE));
			csv += "\n";
		}
		//abgang
		csv += "\n\n" + rz.getLocale().getString("csv.verbrauch.abgang") + "\n";
		csv += getHeaderString() + "\n";
		for(int i = 0; i < vl.getAbgangsListe().size();i++    ) {
			final VerbrauchsItem vi=vl.getAbgang(i);
			if(vi.getYear()==0) {
				csv += embedCSV(rz.getLocale().getString("ausgabe.label_verbrauch_insgesamt" )) ;
			}else {
				csv += embedCSV(String.valueOf(vi.getYear()));
			}
			
			csv += embedCSV(rz.isZero(vi.getLiter())?"":rz.getLocale().formatNumber(Math.abs(vi.getLiter()), OptionFactory.NF_ONE) ); 
			csv += embedCSV(rz.isZero(vi.getKg())?"":rz.getLocale().formatNumber(Math.abs(vi.getKg()), OptionFactory.NF_ONE) );
			csv += embedCSV(rz.isZero(vi.getLa())?"":rz.getLocale().formatNumber(Math.abs(vi.getLa()), OptionFactory.NF_ONE));
			csv += "\n";
		}
		return csv;
	}
	
	private String getHeaderString() {
		return rz.getLocale().getString("csv.verbrauch.jahr") + trenner + 
				rz.getLocale().getString("csv.verbrauch.liter") + trenner +
				rz.getLocale().getString("csv.verbrauch.kg") + trenner +
				rz.getLocale().getString("csv.verbrauch.la");
	}
	
	public void StatistikGrafikCSV(StatistikItem si, int auswahl,int mode) {
		if(!si.getWerteListe().isEmpty()) {
			String csv = this.getStatistikGrafilkCSV(si,auswahl);
			switch(mode) {
				case EXPORT_FILE:
					saveFile(csv);
					break;
				case EXPORT_COPY:
					saveCopy(csv);
					break;
			}
		}
	}
	
	private String getStatistikGrafilkCSV(StatistikItem si,int auswahl) {
		String csv = "";
    	int jahr,monat;
		double summen[];
    	final String monate[] = new DateFormatSymbols().getMonths();
		switch(auswahl) {
			case 0:
			case 1:
			case 2:
			case 3:
			case 4:
			case 5:
				csv += embedCSV(si.getComboItem(auswahl).getHeadLine()) + "\n";
				csv += embedCSV(si.getAuswahlString()) + "\n\n";
				csv +=trenner;
    			summen = new double[si.getWerteListe().getLastYear() - si.getWerteListe().getFirstYear() + 1];
    			for(int i =0;i < summen.length;i++) {
    				summen[i] = 0.0;
    			}
    			for(jahr = si.getWerteListe().getFirstYear();jahr <= si.getWerteListe().getLastYear();jahr++) {
    				csv += embedCSV(String.valueOf(jahr) );
    			}
    			csv += "\n";
    			for(monat = 0;monat <= 12;monat++) {
    				csv += embedCSV( monate[monat]);				
    				for(jahr = si.getWerteListe().getFirstYear();jahr <= si.getWerteListe().getLastYear();jahr++) {
    					csv += embedCSV( rz.isZero(si.getValue(si.getWerteListe().getItem(jahr,monat+1),auswahl)) ? "" : 	rz.getLocale().formatNumber(si.getValue(si.getWerteListe().getItem(jahr,monat+1),auswahl),OptionFactory.NF_ONE) );
    					summen[jahr-si.getWerteListe().getFirstYear()] += si.getValue(si.getWerteListe().getItem(jahr,monat+1),auswahl);
    				}
					csv += "\n";
    			}
				csv += "Summen" + trenner;
				for(jahr = 0;jahr <summen.length;jahr++) {
					csv += embedCSV(rz.getLocale().formatNumber(summen[jahr],OptionFactory.NF_ONE));
    			}
				break;
			
			case 6:
			case 7:
			case 8:
			case 9:
			case 10:
			case 11:
				csv += embedCSV(si.getComboItem(auswahl).getHeadLine()) + "\n";
				csv += embedCSV(si.getAuswahlString()) + "\n\n";
				summen = new double[1];
    			summen[0]=0.0;
    			//Monats-Statistik, zweispaltig
    			for(jahr = si.getWerteListe().getFirstYear();jahr <= si.getWerteListe().getLastYear();jahr++) {
    				for(monat = 0;monat < 12;monat++) {
    					csv += embedCSV(String.valueOf(jahr)) ;
    					csv += embedCSV(monate[monat]) +  " ";
    					

    					csv += embedCSV(rz.isZero(si.getValue(si.getWerteListe().getItem(jahr,monat+1),auswahl)) ? "" :
    						rz.getLocale().formatNumber(si.getValue(si.getWerteListe().getItem(jahr,monat+1),auswahl),OptionFactory.NF_ONE)) + "\n";    						
    					summen[0] += si.getValue(si.getWerteListe().getItem(jahr,monat+1),auswahl) ;
    				}
    				csv += "\n";
    			}
    			csv += "\n";
    			csv += rz.getLocale().getString("csv.aenderungen.summe") + trenner + trenner;
    			csv += embedCSV(rz.getLocale().formatNumber(summen[0],OptionFactory.NF_ONE)) + trenner  + "\n";
				break;
			case 12:
			case 13:
			case 14:
			case 15:
			case 16:
			case 17:
				// Statistik nach Jahr, 2spaltig:
				csv += embedCSV(si.getComboItem(auswahl).getHeadLine()) + "\n";
				csv += embedCSV(si.getAuswahlString()) + "\n\n";
				double summe=0.0;
    			for(jahr = si.getWerteListe().getFirstYear();jahr <= si.getWerteListe().getLastYear();jahr++) {
					double la_v =0.0,la_n=0.0,liter_v=0.0,liter_n=0.0,kg_v=0.0,kg_n =0.0;
    				for(monat = 0;monat < 12;monat++) {
    					final WerteItem wi = si.getWerteListe().getItem(jahr,monat+1);
						la_v += wi.getLa_1();
						la_n += wi.getLa_2();
						liter_v += wi.getLiter_1();
						liter_n += wi.getLiter_2();
						kg_v += wi.getKg_1();
						kg_n += wi.getKg_2();
    				}
    				double value=0.0;
					switch (auswahl) {
						case 12:value =la_v;break;
						case 13:value=la_n;break;
						case 14:value=liter_v;break;
						case 15:value=liter_n;break;
						case 16:value=kg_v;break;
						case 17:value=kg_n;break;
					}
					csv += "\n";
					csv += (String.valueOf(jahr)) + trenner;
					summe+=value;
					if(rz.isZero(value)) {
						csv +="";
					}else {
						csv += embedCSV(rz.getLocale().formatNumber(value,OptionFactory.NF_ONE));
					}
					csv +="\n\n";
    			}
    			csv += rz.getLocale().getString("csv.aenderungen.summe") + trenner;
    			csv += embedCSV(rz.getLocale().formatNumber(summe,OptionFactory.NF_ONE)) + "\n";
				break;
		}
 		return csv;
	}
	
	
	public void StatistikRezepturCSV(StatistikRezepturListe liste ,String sort, int mode) {
		if(!liste.isEmpty()) {
			String csv = this.getStatistikRezepturCSV(liste,sort);
			switch(mode) {
				case EXPORT_FILE:
					saveFile(csv);
					break;
				case EXPORT_COPY:
					saveCopy(csv);
					break;
			}
		}
	}
	
	public String getStatistikRezepturCSV(StatistikRezepturListe liste,String sort) {
		String csv = embedCSV(liste.getAuswahlString()) +"\n";
		csv += embedCSV( rz.getLocale().getString("csv.statistik.sort") + sort) + "\n\n";
		csv +="Rangfolge" + trenner +"Bezeichnung" + trenner + "Liter" + trenner +"LA\n";
		for(int i=0;i < liste.size();i++) {
			StatistikRezepturItem si = liste.getItem(i);
			String zeile="";
			zeile += embedCSV(String.valueOf(i+1));
			zeile += embedCSV(si.getBezeichnung());
			zeile += embedCSV(si.getLiter());
			zeile += embedCSV(si.getLa());
			zeile += "\n";
			csv += zeile;
		}
		return csv;
	}
	
	public void AenderungenCSV(ArrayList<ChangesItem> liste ,int mode) {
		if(!liste.isEmpty()) {
			String csv = this.getAenderungenCSV(liste);
			switch(mode) {
				case EXPORT_FILE:
					saveFile(csv);
					break;
				case EXPORT_COPY:
					saveCopy(csv);
					break;
			}
		}
	}
	
	
	
	private String getAenderungenCSV(ArrayList<ChangesItem> liste) {
		String csv = embedCSV("Änderungsprotokoll") + "\n\n";
		csv +=embedCSV( rz.getLocale().getString("csv.aenderungen.datum") );
		csv += embedCSV(rz.getLocale().getString("csv.aenderungen.benutzer"));
		csv += embedCSV(rz.getLocale().getString("csv.aenderungen.rezeptur") );
		csv += embedCSV(rz.getLocale().getString("csv.aenderungen.stichworte") );
		csv += embedCSV(rz.getLocale().getString("csv.aenderungen.feld") );
		csv += embedCSV(rz.getLocale().getString("csv.aenderungen.alt") );
		csv += embedCSV(rz.getLocale().getString("csv.aenderungen.neu") )+ "\n\n";
		
		for(int i=0;i < liste.size();i++) {
			ChangesItem ci = liste.get(i);
			csv += embedCSV(dfi.format(ci.getErstellt())); 
			csv += embedCSV(ci.getUser());
			csv += embedCSV(ci.getRezeptur());
			csv += embedCSV(ci.getStichworte().toVerboseString().replaceAll(trenner," "));
			csv += embedCSV(ci.getBezeichnung());
			csv += embedCSV(ci.getAlt() );
			csv += embedCSV( ci.getNeu() );
			csv += "\n";
		}
		return csv;
	}
	
	private String embedCSV(String in) {
		return "\"" + in.replaceAll("\"", " ") + "\"" + trenner;
	}
	
	private void saveFile( String csv) {
    	String path = "";
    	final JFileChooser fc = new JFileChooser();
    	fc.setDialogTitle(rz.getLocale().getString("csv.file_titel"));
    	Path p = Paths.get(rz.getOptionFactory().getOption("csv.export.path"));
    	if(p != null) {
    		fc.setCurrentDirectory(p.getParent().toFile());
    	} else {
    		fc.setCurrentDirectory(null);
    	}
    	
    	if(fc.showSaveDialog(null) == JFileChooser.APPROVE_OPTION) {
    		path = fc.getSelectedFile().getPath();
	    	if(!path.trim().equals("")) {
	    		Boolean ok = true;
	    		File datei = new File(path);
	    		if(datei.exists() && !datei.isDirectory()) {
	                DialogItem di = new DialogItem(
	                        DialogControl.FRAGE_DIALOG,
	                        "",0.0,
	                        rz.getLocale().getString("csv.question_overwrite"),
	                        rz.getLocale().getString("csv.question_overwrite"),
	                        rz.getLocale().getString("csv.question_overwrite_1").replaceAll("%f", path),
	                        "frage.png",
	                        rz.getLocale().getString("string_ja"),
	                        rz.getLocale().getString("string_nein"),
	                        null
	                 );
	                 rz.getDialogFactory().getDialog(di);
	                 if ((di.getReplyCode() == DialogControl.DIALOG_NO) || (di.getReplyCode() == DialogControl.DIALOG_CANCEL)){
	                	 ok = false;
	                 }
	    		}
	    		if(ok) {
	    			save(path.trim(),csv);
	    		}
	    	}
    	}
	}
	  
	public void save(String path, String csv) {
				try {
					final PrintWriter out = new PrintWriter(new FileWriter(path));
					out.println(csv);
					out.flush();
			    	out.close();
			    	rz.getOptionFactory().setOption("csv.export.path", path);
			    	rz.getOptionFactory().saveOptions();
				} catch (final Exception e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_ERROR,"csv_export_file",e.getLocalizedMessage()+":" + path);
				}
		}
	  
	private void saveCopy(String csv) {
		final StringSelection s = new StringSelection(csv);
		Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s,s);
	}

}
 