/*
 * Created on 10.09.2004
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.container.ContainerItem;
import de.lunqual.rzpro.items.container.ContainerListe;

/**
 * @author labor
 *
 */
public class ContainerListeDrucken extends ReportAusgabe {

    ContainerListe 				cl;
    public static final String			DEFAULT_ORIENTATION="portrait";
    boolean duplex = false;
    /**
     *
     */
    public ContainerListeDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w,boolean duplex) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        this.duplex =duplex;
        cl = (ContainerListe)reportData;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        final Date datum = new Date();
        final tableModel modell = new tableModel();
        SimpleDateFormat df = new SimpleDateFormat("EEEE, dd.MMM yyyy");
        if(cl != null) {
            for(int i = 0;i < cl.size();i++) {
                final ContainerItem ci = (ContainerItem)cl.get(i);
                modell.addItem(
                         rz.getDatabase().dbGetUser(),
                         ci.getName(),
                         Integer.valueOf(ci.getNummer()),
                         ci.getOrdnerBezeichnung(),
                         Double.valueOf(ci.getTara()),
                         ci.getComment(),
                         datum,
                         ci.getLetzteAdresse() == null?"":ci.getLetzteAdresse(),
                         ci.getLetzteFuellung() == null?"":ci.getLetzteFuellung(),
                         ci.getLetztesDatum() == null?"":df.format(ci.getLetztesDatum()),
                         ci.getOut()==0?true:false
                		);
            }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
    	}
    }

    public void printReport(){
        try{
        	if(duplex) {
        		printDirectlyDuplex(report);
        	} else {
				printDirectly(report);
            }
        }
        catch (final Exception e){}
    }

    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
               "user","name","nummer","ordner","tara","bemerkungen","datum","adresse","fuellung","letztesDatum","out"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,String.class, Integer.class, String.class, Double.class, String.class, java.util.Date.class,String.class,String.class,String.class,Boolean.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String name,
                final Integer nummer,
                final String ordner,
                final Double tara,
                final String bemerkungen,
                final java.util.Date datum,
                final String adresse,
                final String fuellung,
                String letztesDatum,
                boolean out
                )
        {
            	liste.add (new Object[] {user,name,nummer,ordner,tara,bemerkungen,datum,adresse,fuellung,letztesDatum,out});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}


