/*
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.datenblatt.DatenblattItem;

/**
 * @author labor
 *
 */
public class DatenblattDrucken extends ReportAusgabe {

	DatenblattItem								di;
	public static final String			DEFAULT_ORIENTATION="portrait";
    /**
     *
     */
    public DatenblattDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        di = (DatenblattItem)reportData;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(di != null){
	            final String titel = di.getName();
	            final Double staerke = di.getStaerke();
	            final String zeilen[] = di.getText().split("\\n");
	            final String user = rz.getDatabase().dbGetUser();
	            final Date datum = new Date();
	            Integer band = 0;
	            for (String element : zeilen) {
	            	if(element.startsWith("$f")) {
	            		band = 1;
	            		element=element.substring(2);
	            	} else if(element.startsWith("$l")) {
	            		band = 2;
	            	}
	            	else  {
	            		band = 0;
	            	}
	               modell.addItem(datum,user,titel,staerke,band,element);
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "datum","user","titel","staerke","band","zeile"
                };

              private final Class[] COLUMN_TYPE = {
               Date.class,String.class,String.class,Double.class,Integer.class,String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
        		final Date datum,
        		final String user,
        		final String titel,
        		final Double staerke,
        		final Integer band,
        		final String zeile
                )
        {
            	liste.add (new Object[] {datum,user,titel,staerke,band,zeile});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

