/*
 * Created on 10.09.2004
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsListe;
import de.lunqual.rzpro.items.buchung.HerstellungsItem;

/**
 * @author labor
 *
 */
public class HerstellungDrucken extends ReportAusgabe {

    public static final String DEFAULT_HERSTELLUNG_ORIENTATION="portrait";

    HerstellungsItem hi;

    public HerstellungDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        hi = (HerstellungsItem)reportData;
        this.optionKey=optionKey;
    }



    /** liefert ein TableModel
     *
     */
    @Override
	public void  createModel(){
        final Date datum = new Date();
        BuchungsItem bi=null;
        final tableModel modell = new tableModel();
        String lager="";
        Double staerke= Double.valueOf(0);
        if (modell != null) {
            final BuchungsListe bl = rz.getDatabase().getBuchungen().getHerstellung(hi.getId());
            if(bl.size()> 0) {
                lager=rz.getDatabase().getLager().dbGetLager(bl.getItem(0).getLager(), true).getName();
                staerke = Double.valueOf(bl.getItem(0).getStaerke());
            }
            for(int i = 1;i < bl.size();i++) {
                bi = bl.getItem(i);
                if(bi != null) {
                    if(bi.getCode() != DBBuchung.CODE_SCHWUNDAUSGLEICH) {
                        modell.addItem(
                                rz.getDatabase().dbGetUser(),
                                datum,
                                hi.getBezeichnung(),
                                staerke,
                                lager,
                                hi.getDatum(),
                                hi.getUser(),
                                hi.getLosnummer(),
                                Boolean.valueOf(hi.isErledigt()),
                                Boolean.valueOf(hi.isUebernommen()),
                                Double.valueOf(hi.getLiter()),
                                Double.valueOf(hi.getKg()),
                                Double.valueOf(hi.getLa()),
                                Double.valueOf(hi.getSchwundsatz()),
                                Double.valueOf(Math.abs(hi.getLiter()-hi.getEndmenge_liter())),
                                Double.valueOf(Math.abs(hi.getKg()-hi.getEndmenge_kg())),
                                Double.valueOf(Math.abs(hi.getLa()-hi.getEndmenge_la())),
                                Double.valueOf(hi.getEndmenge_liter()),
                                Double.valueOf(hi.getEndmenge_kg()),
                                Double.valueOf(hi.getEndmenge_la()),
                                rz.getDatabase().getBuchungen().getTypToString(bi.getTyp()),
                                rz.getDatabase().getBuchungen().getCodeToString(bi.getCode()),
                                rz.getDatabase().getLager().dbGetLager(bi.getLager(),true).getName(),
                                bi.getDatum(),
                                bi.getUser(),
                                bi.getBezeichnung(),
                                bi.getLosnummer(),
                                bi.getComment(),
                                Boolean.valueOf(bi.isErledigt()),
                                Boolean.valueOf(bi.isUebernommen()),
                                Double.valueOf(bi.getStaerke()),
                                Double.valueOf(bi.getLitergewicht()),
                                Double.valueOf(bi.getLiter()),
                                Double.valueOf(bi.getKg()),
                                Double.valueOf(bi.getLa()),
                                Double.valueOf(bi.getRest_liter()),
                                Double.valueOf(bi.getRest_kg()),
                                Double.valueOf(bi.getRest_la()),
                                Boolean.valueOf(bi.isRest())
                                );
                	}
                }
            }
            report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
               "user","datum",
               "bezeichnung","h_staerke","h_lager","h_datum","h_user","h_losnummer","h_erledigt","h_uebernommen",
               "h_liter","h_kg","h_la",
               "h_schwundsatz","h_schwund_liter","h_schwund_kg","h_schwund_la",
               "h_endmenge_liter","h_endmenge_kg","h_endmenge_la",
               "b_typ","b_code",
               "b_lager","b_datum","b_user",
               "b_bezeichnung","b_losnummer","b_bemerkungen",
               "b_erledigt","b_uebernommen",
               "b_staerke","b_litergewicht",
               "b_liter","b_kg","b_la",
               "b_restliter","b_restkg","b_restla",
               "b_rest"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,java.util.Date.class,
                String.class,Double.class,String.class,Date.class,String.class,String.class,Boolean.class,Boolean.class,
                Double.class,Double.class,Double.class,
                Double.class,Double.class,Double.class,Double.class,
                Double.class,Double.class,Double.class,
                String.class,String.class,
                String.class,Date.class,String.class,
                String.class,String.class,String.class,
                Boolean.class,Boolean.class,
                Double.class,Double.class,
                Double.class,Double.class,Double.class,
                Double.class,Double.class,Double.class,
                Boolean.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final java.util.Date datum,
                final String bezeichnung,
                final Double h_staerke,
                final String h_lager,
                final Date h_datum,
                final String h_user,
                final String h_losnummer,
                final Boolean h_erledigt,
                final Boolean h_uebernommen,
                final Double h_liter,
                final Double h_kg,
                final Double h_la,
                final Double h_schwundsatz,
                final Double h_schwund_liter,
                final Double h_schwund_kg,
                final Double h_schwund_la,
                final Double h_endmenge_liter,
                final Double h_endmenge_kg,
                final Double h_endmenge_la,
                final String b_typ,
                final String b_code,
                final String b_lager,
                final Date b_datum,
                final String b_user,
                final String b_bezeichnung,
                final String b_losnummer,
                final String b_bemerkungen,
                final Boolean b_erledigt,
                final Boolean b_uebernommen,
                final Double b_staerke,
                final Double b_litergewicht,
                final Double b_liter,
                final Double b_kg,
                final Double b_la,
                final Double b_restliter,
                final Double b_restkg,
                final Double b_restla,
                final Boolean b_rest
                )
        {
            	liste.add (new Object[] {
                         user,
                         datum,
                         bezeichnung,
                         h_staerke,
                         h_lager,
                         h_datum,
                         h_user,
                         h_losnummer,
                         h_erledigt,
                         h_uebernommen,
                         h_liter,
                         h_kg,
                         h_la,
                         h_schwundsatz,
                         h_schwund_liter,
                         h_schwund_kg,
                         h_schwund_la,
                         h_endmenge_liter,
                         h_endmenge_kg,
                         h_endmenge_la,
                         b_typ,
                         b_code,
                         b_lager,
                         b_datum,
                         b_user,
                         b_bezeichnung,
                         b_losnummer,
                         b_bemerkungen,
                         b_erledigt,
                         b_uebernommen,
                         b_staerke,
                         b_litergewicht,
                         b_liter,
                         b_kg,
                         b_la,
                         b_restliter,
                         b_restkg,
                         b_restla,
                         b_rest
            	});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}


