/*
 * Created on 10.09.2004
 * Da diese Klasse i.d.R mehrfach kurz nacheinander mit denselben Daten aufgerufen wird
 * darf sie nicht als separater Thread laufen !
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import org.jfree.report.modules.gui.base.PreviewFrame;
import de.lunqual.rzpro.items.inventur.InventurItem;
import de.lunqual.rzpro.items.inventur.InventurSummenItem;
import de.lunqual.rzpro.items.inventur.InventurZeilenItem;
import de.lunqual.rzpro.items.inventur.InventurZeilenliste;
import de.lunqual.rzpro.RzPro;

/**
 * @author labor
 *
 */
public class InventurDrucken extends ReportAusgabe {

    public static final String DEFAULT_INVENTUR_ORIENTATION="landscape";

    InventurItem		ii;
    boolean				vorschau;
    String 				order="";
    String 				filter="";
    boolean				duplex=false;
    
    public InventurDrucken(RzPro r,Object reportData ,String optionKey,boolean vorschau,String order,String filter,java.awt.Window w,boolean duplex) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.vorschau=vorschau;
        ii = (InventurItem)reportData;
        this.optionKey=optionKey;
        this.order=order;
        this.filter=filter;
        this.duplex=duplex;
    }



    /** liefert ein TableModel
     *
     */
    @Override
	public void  createModel(){
        final String user=rz.getDatabase().dbGetUser();
        final Date datum = new Date();
        String inventur_titel = "";
        Double summe_la,summe_liter20;
        Double anzeige_la=0.0,anzeige_liter=0.0;

        final tableModel modell = new tableModel();
        if (modell != null) {
        	final InventurSummenItem si = new InventurSummenItem();
        	rz.getDatabase().getInventur().getInventurSumme(ii.getId(),si);
        	summe_la = Double.valueOf(si.getSummeLa());
        	summe_liter20 = Double.valueOf(si.getSummeLiter20());
        	
        	inventur_titel = ii.getBezeichnung();
    		final InventurZeilenliste zeilen;
        	if(filter.trim().equals("")) {
        		zeilen= rz.getDatabase().getInventur().getZeilenListe(ii,order);
        	}else {
        		zeilen = rz.getDatabase().getInventur().getZeilenListe(ii,order,filter);
        	}
        	for(int i=0;i<zeilen.size();i++) {
        		final InventurZeilenItem iz = zeilen.getItem(i);
        		anzeige_la += iz.getLa();
        		anzeige_liter += iz.getLiter20();
        	}
        	for(int i=0;i < zeilen.size();i++) {
        		final InventurZeilenItem iz = zeilen.getItem(i);
        		modell.addItem(
        			user,datum,inventur_titel,
        			summe_la,
        			summe_liter20,
        			iz.getErstellt(),
        			iz.getTanknummer(),
        			iz.getTyp()==InventurZeilenItem.TYP_LITER ?rz.getLocale().getString("report.inventur.typ_liter"):rz.getLocale().getString("report.inventur.typ_gewicht"),
                	Integer.valueOf(iz.getTyp()),
        		    iz.getRaumText(),
        		    iz.getInhalt(),
        		    Double.valueOf(iz.getStaerke()),
        		    Double.valueOf(iz.getLiter20()),
        		    Double.valueOf(iz.getLa()),
        		    Double.valueOf(iz.getLiter()),
        		    Double.valueOf(iz.getTanktemperatur()),
        		    Double.valueOf(iz.getTafel3()),
        		    Double.valueOf(iz.getBrutto()),
        		    Double.valueOf(iz.getTara()),
        		    Double.valueOf(iz.getNetto()),
        		    iz.getExtrakt()==0?rz.getLocale().getString("report.inventur.extrakt_no"):rz.getLocale().getString("inventur.extrakt_yes"),
        		    Integer.valueOf(iz.getExtrakt()),
        		    Double.valueOf(iz.getTafel2()),
        		    Double.valueOf(iz.getLitergewicht()),
        		    iz.getStrLager(),
        		    iz.getSteuer_artikel(),
        		    iz.getStrSorte(),
        		    iz.getStrSteuerlager(),
        		    Double.valueOf(anzeige_liter),
        		    Double.valueOf(anzeige_la)
        		    
        		);
        	}
        	report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
         }
    }

    @Override
	public void printReport(){
        try{
            if(vorschau) {
                final PreviewFrame frame = new PreviewFrame(report);
                frame.pack();
                frame.setVisible(true);
                frame.requestFocus();
            } else {
	            if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
	                final PreviewFrame frame = new PreviewFrame(report);
	                frame.pack();
	                frame.setVisible(true);
	                frame.requestFocus();
	            } else {
	            	if(duplex) {
	            		printDirectlyDuplex(report);
	            	} else {
						printDirectly(report);
		            }	
				}
            }
        }
        catch (final Exception e){}
    }

    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
               "user","datum",
               "inventur_titel",
               "summe_la","summe_liter20",
               "z_datum","z_tanknummer","z_typ","z_typ_n","z_raum","z_inhalt",
               "z_staerke","z_liter20","z_la",
               "z_liter","z_tt","z_tafel3",
               "z_brutto","z_tara","z_netto",
               "z_extrakt","z_extrakt_n","z_tafel2","z_litergewicht",
               "z_lager","z_steuer_artikel","z_sorte","z_steuerlager",
               "anzeige_liter","anzeige_la"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,Date.class,
                String.class,
                Double.class,Double.class,
                Date.class,String.class,String.class,Integer.class,String.class,String.class,
                Double.class,Double.class,Double.class,
                Double.class,Double.class,Double.class,
                Double.class,Double.class,Double.class,
                String.class,Double.class,Double.class,Double.class,
                String.class,String.class,String.class,String.class,
                Double.class,Double.class
                
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final Date datum,
                final String inventur_titel,
                final Double summe_la,
                final Double summe_liter20,
                final Date z_datum,
                final String z_tanknummer,
                final String z_typ,
                final Integer z_typ_n,
                final String z_raum,
                final String z_inhalt,
                final Double z_staerke,
                final Double z_liter20,
                final Double z_la,
                final Double z_liter,
                final Double z_tt,
                final Double z_tafel3,
                final Double z_brutto,
                final Double z_tara,
                final Double z_netto,
                final String z_extrakt,
                final Integer z_extrakt_n,
                final Double z_tafel2,
                final Double z_litergewicht,
                final String z_lager,
                final String z_steuer_artikel,
                final String z_sorte,
                final String z_steuerlager,
                final Double anzeige_liter,
                final Double anzeige_la
                )
        {
            	liste.add (new Object[] {
                         user,
                         datum,
                         inventur_titel,
                          summe_la,
                          summe_liter20,
                          z_datum,
                          z_tanknummer,
                          z_typ,
                          z_typ_n,
                          z_raum,
                          z_inhalt,
                          z_staerke,
                          z_liter20,
                          z_la,
                          z_liter,
                          z_tt,
                          z_tafel3,
                          z_brutto,
                          z_tara,
                          z_netto,
                          z_extrakt,
                          z_extrakt_n,
                          z_tafel2,
                          z_litergewicht,
                          z_lager,
                          z_steuer_artikel,
                          z_sorte,
                          z_steuerlager,
                          anzeige_liter,
                          anzeige_la
            	});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}


