/*
 * Created on 10.09.2004
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.konform.konformItem;
/**
 * @author labor
 *
 */
public class KonformDrucken extends ReportAusgabe {

    int 						key;
    public static final String			DEFAULT_ORIENTATION="portrait";
    ArrayList<konformItem>			liste;
    /**
     *
     */
    public	KonformDrucken(RzPro r,Object reportData ,boolean sort,boolean reverse,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        liste = rz.getDatabase().getRezeptur().getKonformListe(sort,reverse);
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(liste != null && !liste.isEmpty()){
	            final Date datum = new Date();
	            for (final konformItem m : liste) {
	            	modell.addItem(
	            			rz.getDatabase().dbGetUser(),
	            			datum,
	            			m.getRezepturBezeichnung(),
	            			m.getBemerkungen(),
	            			m.getDatumString()
	            		);
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
        		"user",
        		"datum",
        		"rezepturbezeichnung",
        		"bemerkungen",
        		"konformdatum"
              };

              private final Class[] COLUMN_TYPE = {
            		  String.class,
            		  Date.class,
            		  String.class,
            		  String.class, 
            		  String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
        		String user,
        		Date datum,
        		String rezepturbezeichnung,
        		String bemerkungen,
        		String konformdatum

                )
        {
            	liste.add (new Object[] { user,datum,rezepturbezeichnung,bemerkungen,konformdatum});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

