/*
 * Created on 10.09.2004
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.lager.LagerBestandsListe;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class LagerBestandDrucken extends ReportAusgabe {

	LagerBestandsListe lb;
	boolean				duplex=false;
	public static final String			DEFAULT_ORIENTATION="landscape";
    /**
     *
     */
    public LagerBestandDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w,boolean duplex) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.duplex=duplex;
        this.optionKey=optionKey;
        lb= (LagerBestandsListe)reportData;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        final String user = rz.getDatabase().dbGetUser();
        final Date datum = new Date();
        modell = new tableModel();
        if(modell != null) {
	        if(lb != null){
	        	for(int i = 0; i < lb.size();i++) {
	        		modell.addItem(user,datum,
	        		        lb.getLager(),
	        		        lb.getItem(i).getBezeichnung(),
							lb.getItem(i).getArtikelnummer(),
	        				Double.valueOf(lb.getItem(i).getLiter()),
							Double.valueOf(lb.getItem(i).getKg()),
							Double.valueOf(lb.getItem(i).getLa()),
							lb.getItem(i).getGrundpreis(),
							lb.getItem(i).getPreis(),
							Double.valueOf(lb.getSumme_liter()),
							Double.valueOf(lb.getSumme_kg()),
							Double.valueOf(lb.getSumme_la()),
							rz.getLocale().formatNumber(lb.getSumme_kalkulation(),OptionFactory.NF_NORMAL) + " " +
							rz.getDatabase().getCurrency().dbGetCurrency( rz.getOptionFactory().getOption("kalkulation.currency",1),true).getShortName(),
							lb.getItem(i).getTank()
	        		);
	        	}
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }

    public void printReport(){
        try{
        	if(duplex) {
        		printDirectlyDuplex(report);
        	} else {
				printDirectly(report);
            }
        }
        catch (final Exception e){}
    }
    
    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","datum","lager","bezeichnung","artikelnummer","liter","kg","la","grundpreis", "preis",
                "summe_liter","summe_kg","summe_la","summe_kalkulation","tank"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,Date.class,String.class, String.class,String.class,Double.class,Double.class,Double.class,String.class,String.class,
                Double.class,Double.class,Double.class,String.class,String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final Date datum,
                final String lager,
                final String bezeichnung,
				final String artikelnummer,
                final Double liter,
                final Double kg,
                final Double la,
                final String grundpreis,
                final String preis,
                final Double summe_liter,
                final Double summe_kg,
                final Double summe_la,
                final String summe_kalkulation,
                final String tank
                )
        {
            	liste.add (new Object[] {user,datum,lager,bezeichnung,artikelnummer,liter,kg,la,
            	        grundpreis,preis,summe_liter,summe_kg,summe_la,summe_kalkulation,tank
            	});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}


