/*
 * Created on 10.09.2004
 * Da diese Klasse i.d.R mehrfach kurz nacheinander mit denselben Daten aufgerufen wird
 * darf sie nicht als separater Thread laufen !
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

import org.jfree.report.modules.gui.base.PreviewFrame;

import de.lunqual.rzpro.fenster.buchungsfenster.HerstellungsFenster;
import de.lunqual.rzpro.items.lager.LagerDruckListe;
import de.lunqual.rzpro.items.lager.LagerListenItem;
import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsListe;
import de.lunqual.rzpro.items.buchung.HerstellungsItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class LagerListeDrucken extends ReportAusgabe {

    public static final String DEFAULT_LAGERLISTE_ORIENTATION="landscape";

    LagerDruckListe		ld;
    LagerListenItem		liste;
    boolean				vorschau;
    boolean				duplex;

    public LagerListeDrucken(RzPro r,Object reportData ,Object reportPart,String optionKey,boolean vorschau,java.awt.Window w,boolean duplex) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.vorschau=vorschau;
        this.duplex = duplex;
        ld = (LagerDruckListe)reportData;
        liste = (LagerListenItem)reportPart;
        this.optionKey=optionKey;
    }



    /** liefert ein TableModel
     *
     */
    @Override
	public void  createModel(){
        BuchungsItem bi=null;
        BuchungsListe bl=null;
        HerstellungsItem hi =null;
        final tableModel modell = new tableModel();
        final String lagerText =  rz.getDatabase().getLager().getLagerListenText(liste.getLager().getListe());
        final String r[] = rz.getDatabase().getBuchungen().getLagerSumme(liste);
        final String footer = r[0];
        final String zoll_footer=r[1];
        if (modell != null) {
            for(int i = 0; i < liste.getListe().size();i++) {
                bl = rz.getDatabase().getBuchungen().getHerstellung(((Integer)liste.getListe().get(i)).intValue());
                hi = rz.getDatabase().getBuchungen().getEinzelHerstellung(bl.getItem(0).getHerstellung());
                if(bl != null) {
                    for (int b = 0;b < bl.size();b++) {
                        bi = bl.getItem(b);
	                        if(bi != null) {
			                modell.addItem(
			                    rz.getDatabase().dbGetUser(),
			                    new Date(),
			                    lagerText,
			                    Integer.valueOf(liste.getLager().getListe()),
			                    ld.getMode() == HerstellungsFenster.AUSWAHL_ALLE ? rz.getLocale().getString("herstellfenster.auswahl_alle") : ld.getMode()==HerstellungsFenster.AUSWAHL_ERLEDIGT ? rz.getLocale().getString("herstellfenster.auswahl_erledigt") : rz.getLocale().getString("herstellfenster.auswahl_unerledigt"),
			                    ld.getBezeichnung(),
			                    ld.getLosnummer(),
			                    ld.getVon(),
			                    ld.getBis(),
			                    Integer.valueOf(bl.getItem(0).getHerstellung()),
			                    bi.getDatum(),
			                    "-"+rz.getDatabase().getLager().dbGetLager(bi.getLager(),true).getName()+"-",
			                    bi.getBezeichnung(),
			                    Double.valueOf(bl.getItem(0).getStaerke()),
			                    Double.valueOf(hi.getLiter()),
			                    Double.valueOf(hi.getKg()),
			                    Double.valueOf(hi.getLa()),
			                    bl.getItem(0).getRezeptur().getArtikelnummer(),
			                    hi.getLosnummer(),
			                    Double.valueOf(Math.abs(hi.getLiter() -hi.getEndmenge_liter())),
			                    Double.valueOf(Math.abs(hi.getKg()-hi.getEndmenge_kg())),
			                    Double.valueOf(Math.abs(hi.getLa()-hi.getEndmenge_la())),
			                    Double.valueOf(hi.getEndmenge_liter()),
			                    Double.valueOf(hi.getEndmenge_kg()),
			                    Double.valueOf(hi.getEndmenge_la()),
								Integer.valueOf(bi.getTyp()),
			                    rz.getDatabase().getBuchungen().getTypToString(bi.getTyp()),
			                    "-" + rz.getDatabase().getLager().dbGetLager(bi.getLager(),true).getName() + "-",
			                    bi.getBezeichnung(),
			                    Double.valueOf(bi.getStaerke()),
			                    bi.getRezeptur().getArtikelnummer(),
			                    bi.getLosnummer(),
			                    Double.valueOf(bi.getLiter()),
			                    Double.valueOf(bi.getKg()),
			                    Double.valueOf(bi.getLa()),
			                    rz.isZero(bi.getLa()) || rz.isZero(bl.getItem(0).getStaerke())  ? Double.valueOf(0) : Double.valueOf((bi.getLa() * 100)/bl.getItem(0).getStaerke()),
			                    rz.getLocale().getString("report.lagerliste.label_liter_auf_staerke").replaceAll("%s", rz.getLocale().formatNumber(bl.getItem(0).getStaerke(), OptionFactory.NF_STAERKE)),
			                    footer,
			                    zoll_footer,
			                    rz.getDatabase().getLager().dbGetLager(bi.getLager(), true).getErsatztext().equals("") ? bi.getBezeichnung() : rz.getDatabase().getLager().dbGetLager(bi.getLager(), true).getErsatztext(),
			                    bi.getSteuer_artikel(),
			                    bi.getStrSorte(),
			                    bi.getStrSteuerlager()
			            	);
                        }
                    }
	            }
            }
            report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
         }
    }

    @Override
	public void printReport(){
        try{
            if(vorschau) {
                final PreviewFrame frame = new PreviewFrame(report);
                frame.pack();
                frame.setVisible(true);
                frame.requestFocus();
            } else {
	            if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
	                final PreviewFrame frame = new PreviewFrame(report);
	                frame.pack();
	                frame.setVisible(true);
	                frame.requestFocus();
	            } else {
	            	if(duplex) {
	            		printDirectlyDuplex(report);
	            	} else {
						printDirectly(report);
		            }	
				}
            }
        }
        catch (final Exception e){}
    }

    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
               "user","datum",
               "lager_text","lager_liste",
               "auswahl_mode","auswahl_bezeichnung","auswahl_losnummer","auswahl_von","auswahl_bis",
               "herstellung","h_datum","h_lager","h_bezeichnung",
               "h_staerke","h_liter","h_kg","h_la","h_artikelnummer","h_losnummer",
               "h_schwund_liter","h_schwund_kg","h_schwund_la",
               "h_end_liter","h_end_kg","h_end_la",
               "abgang","b_typ","b_lager","b_bezeichnung","b_staerke","b_artikelnummer","b_losnummer",
               "b_liter","b_kg","b_la","b_liter_auf_staerke","b_liter_auf_staerke_text",
               "footer","zoll-footer","b_ersatztext",
               "steuer_artikel","steuer_sorte","steuer_lager"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,java.util.Date.class,
                String.class,Integer.class,
                String.class,String.class,String.class,Date.class,Date.class,
                Integer.class,Date.class,String.class,String.class,
                Double.class,Double.class,Double.class,Double.class,String.class,String.class,
                Double.class,Double.class,Double.class,
                Double.class,Double.class,Double.class,
                Integer.class,String.class,String.class,String.class,Double.class,String.class,String.class,
                Double.class,Double.class,Double.class,Double.class,String.class,
                String.class,String.class,String.class,
                String.class,String.class,String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final java.util.Date datum,
                final String lager_text,
                final Integer lager_liste,
                final String auswahl_mode,
                final String auswahl_bezeichnung,
                final String auswahl_losnummer,
                final Date auswahl_von,
                final Date auswahl_bis,
                final Integer herstellung,
                final Date h_datum,
                final String h_lager,
                final String h_bezeichnung,
                final Double h_staerke,
                final Double h_liter,
                final Double h_kg,
                final Double h_la,
                final String h_artikelnummer,
                final String h_losnummer,
                final Double h_schwund_liter,
                final Double h_schwund_kg,
                final Double h_schwund_la,
                final Double h_end_liter,
                final Double h_end_kg,
                final Double h_end_la,
				final Integer abgang,
                final String b_typ,
                final String b_lager,
                final String b_bezeichnung,
                final Double b_staerke,
                final String b_artikelnummer,
                final String b_losnummer,
                final Double b_liter,
                final Double b_kg,
                final Double b_la,
                final Double b_liter_auf_staerke,
                final String b_liter_auf_staerke_text,
                final String footer,
                final String zoll_footer,
                final String b_ersatztext,
                	final String steuer_artikel,
                	final String steuer_sorte,
                	final String steuer_lager
                )
        {
            	liste.add (new Object[] {
                         user,
                         datum,
                         lager_text,
                         lager_liste,
                         auswahl_mode,
                         auswahl_bezeichnung,
                         auswahl_losnummer,
                         auswahl_von,
                         auswahl_bis,
                         herstellung,
                         h_datum,
                         h_lager,
                         h_bezeichnung,
                         h_staerke,
                         h_liter,
                         h_kg,
                         h_la,
                         h_artikelnummer,
                         h_losnummer,
                         h_schwund_liter,
                         h_schwund_kg,
                         h_schwund_la,
                         h_end_liter,
                         h_end_kg,
                         h_end_la,
						 abgang,
                         b_typ,
                         b_lager,
                         b_bezeichnung,
                         b_staerke,
                         b_artikelnummer,
                         b_losnummer,
                         b_liter,
                         b_kg,
                         b_la,
                         b_liter_auf_staerke,
                         b_liter_auf_staerke_text,
                         footer,
                         zoll_footer,
                         b_ersatztext,
                         steuer_artikel,
                         steuer_sorte,
                         steuer_lager
            	});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}


