/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.mhdItem;
import de.lunqual.rzpro.items.temperaturzone.temperaturZonenItem;
/**
 * @author labor
 *
 */
public class MHDDrucken extends ReportAusgabe {

    int 						key;
    public static final String			DEFAULT_ORIENTATION="landscape";
    ArrayList<mhdItem>			liste;
    /**
     *
     */
    public MHDDrucken(RzPro r,Object reportData ,boolean sort,boolean reverse,boolean datum,Calendar von,Calendar bis,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        if(datum) {
        	liste = rz.getDatabase().getBuchungen().getMhdListe(sort,reverse,von,bis);
        } else {
        	liste = rz.getDatabase().getBuchungen().getMhdListe(sort,reverse);
        }
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(liste != null && !liste.isEmpty()){
	            final Date datum = new Date();
	            for (final mhdItem m : liste) {
	            	Calendar c=Calendar.getInstance();
        			c.setTimeInMillis(m.getMhd());
           			temperaturZonenItem ti = rz.getDatabase().getTemperatur().getZone(m.getTemperaturDurchschnitt());
	            	modell.addItem(
	            			m.getBezeichnung(),
	            			m.getLosnummer(),
	            			rz.getDatabase().getBuchungen().getMhdString(m.getMhd()),
	            			rz.getDatabase().dbGetUser(),
	            			datum,
	            			m.getArtikelnummer(),
	            			rz.getLocale().getString("ausgabe.rezeptur_temperatur_string") 
	            				.replaceAll("%z",ti.getBezeichnung())
								.replaceAll("%v",String.valueOf(m.getTempVon()))
								.replaceAll("%b",String.valueOf(m.getTempBis()))
								.replaceAll("%s",String.valueOf(m.getTemperaturDurchschnitt()))
	            	);
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
        		"bezeichnung",
        		"losnummer",
        		"mhd",
        		"user",
        		"datum",
        		"artikelnummer",
        		"temperatur"
              };

              private final Class[] COLUMN_TYPE = {
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class, 
            		  java.util.Date.class,
            		  String.class,
            		  String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
        		String bezeichnung,
        		String losnummer,
        		String mhd,
        		String user,
        		Date datum,
        		String artikelnummer,
        		String temperatur
                )
        {
            	liste.add (new Object[] {bezeichnung,losnummer,mhd,user,datum,artikelnummer,temperatur});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

