/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.proben.ProbenItem;
import de.lunqual.rzpro.items.proben.ProbenListe;
/**
 * @author labor
 *
 */
public class ProbenListeDrucken extends ReportAusgabe {

    ProbenListe pl;
    public static final String			DEFAULT_ORIENTATION="portrait";
    boolean duplex = false;
    /**
     *
     */
    public ProbenListeDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w,boolean duplex) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.duplex = duplex;
        this.optionKey=optionKey;
       	pl = (ProbenListe)reportData;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        Date datum = new Date();
        modell = new tableModel();
        if(modell != null) {
	        if(pl != null && !pl.isEmpty()){
	        	for(int i=0;i<pl.size();i++) {
	        		ProbenItem pi = pl.getItem(i);
	        		modell.addItem(
	        				(pi.isDeleted()?"X":""),
	        				rz.getDatabase().dbGetUser(),
	        				pi.getUser_1(),
	        				String.valueOf(pi.getId()),
	        				pi.getLosnummer(),
	        				pi.getBezeichnung(),
	        				pi.getAdressListe().toVerboseString(),
	        				pi.getErstelltToString(),
	        				pi.getBemerkungen(),
	        				datum
	        		);
	        		
	        	}
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }

    public void printReport(){
    	try {
        	if(duplex) {
        		printDirectlyDuplex(report);
        	} else {
				printDirectly(report);
            }	
        }
        catch (final Exception e){}
    }

    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "entsorgt","user","user_1","nummer","losnummer","bezeichnung","adressen","erstellt","zeile","datum"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,String.class,String.class,String.class,String.class, String.class, String.class, String.class, String.class, java.util.Date.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
        		final String entsorgt,
        		final String user,
                final String user_1,
                final String nummer,
                final String losnummer,
                final String bezeichnung,
                final String adressen,
                final String erstellt,
                final String zeile,
                final java.util.Date datum
                )
        {
            	liste.add (new Object[] {entsorgt,user,user_1,nummer,losnummer,bezeichnung,adressen,erstellt,zeile,datum});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

