/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.awt.Image;
import java.awt.Window;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Sides;
import javax.swing.JFileChooser;

import org.jfree.report.JFreeReport;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.gui.base.PreviewFrame;
import org.jfree.report.modules.output.pageable.graphics.PrintReportProcessor;
import org.jfree.report.modules.output.pageable.pdf.PdfReportUtil;
import org.jfree.report.modules.parser.base.ReportGenerator;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.report.ReportImageItem;
import de.lunqual.rzpro.items.report.ReportItem;

/**
 * @author labor
 *
 */
public abstract class ReportAusgabe{

    protected RzPro 						rz;
    protected SimpleDateFormat 	df;
    protected Object						reportData;
    protected String								optionKey;
    protected JFreeReport 				report;
    protected Window						window;
    private   ArrayList<ReportImageItem>	images;
    /**
     *
     */
    public ReportAusgabe(RzPro r,Object reportData,String optionKey,Window w){
        super();
        this.window=w;
        rz = r;
        images = new ArrayList<ReportImageItem>();
        this.reportData = reportData;
        this.optionKey = optionKey;
        this.report = null;
        df = new SimpleDateFormat("dd.MM.yyyy H:mm");
    }

    public void pdf(String filename,Window w) {
        createModel();
        savePDF(report,filename,w);
        if(window != null) {
            rz.setFreeCursor(window);
        }
      }
    public void run() {
        createModel();
        printReport();
        if(window != null) {
            rz.setFreeCursor(window);
        }
    }
    /** String replaceLocale(String) ersetzt Strings implements Report-Template
     * durch solche aus dem Locale-Control.
     * Wenn ein String im Template z.B. $locale.grumpf$ lautet, wird dieser
     * durch einen String mit dem Key "grumpf" aus der Sprachdatei rzlocale
     * ersetzt. Diese Funktion ersetzt ALLE vorkommenden Locale-Strings im
     * Template
     * @param inString XML-Template
     */
    private String replaceLocale(String inString){
        final ArrayList al = new ArrayList();
        String outString = inString;
        int ende;
        int pos = outString.indexOf("$locale.");
        while (pos != -1){
            ende = outString.indexOf("$",pos+1);
            al.add(outString.substring(pos + 8,ende));
            pos = ende+1;
            if (pos > outString.length()) {
				break;
			}
            pos = outString.indexOf("$locale.",pos);
        }
        for (int i=0;i < al.size();i++){
            outString = outString.replaceAll("\\$locale." + (String)al.get(i) +"\\$" ,rz.getLocale().getString((String)al.get(i)));
        }
        outString = replaceOptions(outString);
        getImages(inString);
        return replaceVars(outString);
    }

    /**
     * bilder im Report suchen und laden
     * 	<image-field x="0" y="65" width="24" height="24" scale="true" fieldname="notausgang.png" />
     */
    private void getImages(String inString) {
    		images.clear();
    		Pattern pattern = Pattern.compile("<image-field.*?>");
    		Matcher matcher = pattern.matcher(inString);
    		while (matcher.find())
    		{
        		Pattern pattern1 = Pattern.compile("fieldname=\".*?\"");
        		Matcher matcher1 = pattern1.matcher(matcher.group(0));
        		if(matcher1.find()) {
            		Pattern pattern2 = Pattern.compile("\".*?\"");
            		Matcher matcher2 = pattern2.matcher(matcher1.group(0));
            		if(matcher2.find()) {
            			String image = matcher2.group(0).replaceAll("\"", "");
            			Image im = rz.getDatabase().getIcons().getIcon(image,500).getImage();
            			if(im != null) {
            				images.add(new ReportImageItem(image, im));
            			}
            		}
        		}
    		} 
    	
    }
    
    /** ersetzt Strings
     * durch solche aus dem optionControl
     * Wenn ein String im Template z.B. $options.grumpf$ lautet, wird dieser
     * durch einen String mit dem Key "grumpf" aus der rzoptions.properties-datei
     * ersetzt. Diese Funktion ersetzt ALLE vorkommenden Locale-Strings im
     * Template
     * @param inString XML-Template
     */
    private String replaceOptions(String inString) {
        final ArrayList al = new ArrayList();
        String outString = inString;
        int ende;
        int pos = outString.indexOf("$options.");
        while (pos != -1){
            ende = outString.indexOf("$",pos+1);
            al.add(outString.substring(pos + 9,ende));
            pos = ende+1;
            if (pos > outString.length()) {
				break;
			}
            pos = outString.indexOf("$options.",pos);
        }
        for (int i=0;i < al.size();i++){
            outString = outString.replaceAll("\\$options." + (String)al.get(i) +"\\$" ,rz.getOptionFactory().getOption((String)al.get(i)));
        }
        return outString;
    }

    /** String replaceVars(String)
     * wie replaceLocale, hier werden aber Strings ersetzt, die das Muster $var.---$
     * haben
     * @param inString ist das XML-Template
     */
    private String replaceVars(String inString){
        String outString = inString;
        outString = outString.replaceAll("$var.datum$", df.format(new Date()));
        return outString;
    }



    public void savePDF(JFreeReport report,String filename,Window w) {
     	String path = "";
    	final JFileChooser fc = new JFileChooser();
    	fc.setDialogTitle(rz.getLocale().getString("zutatenverzeichnis.save_pdf"));
    	File defaultDirectory = new File(rz.getOptionFactory().getOption("reportausgabe.save_pdf_path"));
    	fc.setCurrentDirectory(defaultDirectory);
    	fc.setSelectedFile(new File(filename + ".pdf"));
    	if(fc.showSaveDialog(w) == JFileChooser.APPROVE_OPTION) {
    		boolean ok=false;
    		path = fc.getSelectedFile().getPath().trim();
    		String directory = fc.getCurrentDirectory().getPath();
	    	if(!path.equals("")) {
	    		if (rz.FileTest(path.trim())){
                    final DialogItem di  = new DialogItem(
                            DialogControl.FRAGE_DIALOG,
                            "",0.0,
                            rz.getLocale().getString("reportausgabe.save_pdf_label"),
                            rz.getLocale().getString("reportausgabe.save_pdf_label").replaceAll("%s",path),
                            rz.getLocale().getString("reportausgabe.save_pdf_caption").replaceAll("%s",path),
                            "frage.png",
                            rz.getLocale().getString("string_ja"),
                            rz.getLocale().getString("string_nein"),
                            null
                    );
                    rz.getDialogFactory().getDialog(di);
                    if(di.getReplyCode() == DialogControl.DIALOG_OK) {
                    	ok=true;
                    }
	    		}else {
	    			ok=true;
	    		}
	    	}
	    	if(ok){
	    		rz.getOptionFactory().setOption("reportausgabe.save_pdf_path",directory);
	    		rz.getOptionFactory().saveOptions();
	    		PdfReportUtil.createPDF(report,path);
	    		
	    	}
    	}




    }

    /** void printDirectly(JFreeReport) Druckt einen Report ohne Umweg über eine Vorschau aus */
    public void printDirectly( JFreeReport report ) {
        try{
            boolean doPrint = false;
            final String printerName = rz.getOptionFactory().getOption("printer.printer");
            final PrintReportProcessor reportPane = new PrintReportProcessor(report);

            //ReportPane _reportPane = new ReportPane (report);
            final Book book = new Book();
            final PrinterJob printerJob = PrinterJob.getPrinterJob();
            final PrintService ps[] = PrintServiceLookup.lookupPrintServices(null,null);
            if(PrintServiceLookup.lookupDefaultPrintService() != null){
                printerJob.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
            }
            for (final PrintService element : ps) {
                if (element.getName().equals(printerName)){
                   printerJob.setPrintService(element);
                   break;
                }
            }
            printerJob.setJobName( RzPro.APP_NAME + System.currentTimeMillis() );
            //PageFormat pageFormat = printerJob.defaultPage();
            final PageFormat pageFormat=report.getPageDefinition().getPageFormat(0);
            for (int i = 0; i <  reportPane.getNumberOfPages(); i++) {
				book.append( reportPane.getPrintable( i ), pageFormat );
			}
            if (rz.getOptionFactory().getOption("printercommand").equals("printdialog")) {
				doPrint = printerJob.printDialog();
			} else {
				doPrint = true;
			}
            if (doPrint)
            {
                try
                {
                  printerJob.setPageable( book );
                  printerJob.print();
                }
                catch (final PrinterException e)
                {
                   rz.getLogFactory().logMessage(2, "ReportControl.PrintDirectly.inner",e.getLocalizedMessage());
                }
            }
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(2, "ReportControl.PrintDirectly.outer",e.getLocalizedMessage());
        }
    }
    
    /** void printDirectly(JFreeReport) Druckt einen Report ohne Umweg über eine Vorschau aus */
    public void printDirectlyDuplex( JFreeReport report ) {
        try{
        	PrintRequestAttributeSet attr_set =	    new HashPrintRequestAttributeSet();
        	attr_set.add(Sides.DUPLEX);
            boolean doPrint = false;
            final String printerName = rz.getOptionFactory().getOption("printer.printer");
            final PrintReportProcessor reportPane = new PrintReportProcessor(report);

            //ReportPane _reportPane = new ReportPane (report);
            final Book book = new Book();
            final PrinterJob printerJob = PrinterJob.getPrinterJob();
            final PrintService ps[] = PrintServiceLookup.lookupPrintServices(null,null);
            if(PrintServiceLookup.lookupDefaultPrintService() != null){
                printerJob.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
            }
            for (final PrintService element : ps) {
                if (element.getName().equals(printerName)){
                   printerJob.setPrintService(element);
                   break;
                }
            }
            printerJob.setJobName( RzPro.APP_NAME + System.currentTimeMillis() );
            //PageFormat pageFormat = printerJob.defaultPage();
            final PageFormat pageFormat=report.getPageDefinition().getPageFormat(0);
            if(pageFormat.getOrientation() == PageFormat.LANDSCAPE) {
            	attr_set.add(Sides.TWO_SIDED_SHORT_EDGE);
            } else {
            	attr_set.add(Sides.TWO_SIDED_LONG_EDGE);
            }
            for (int i = 0; i <  reportPane.getNumberOfPages(); i++) {
				book.append( reportPane.getPrintable( i ), pageFormat );
			}
            if (rz.getOptionFactory().getOption("printercommand").equals("printdialog")) {
				doPrint = printerJob.printDialog();
			} else {
				doPrint = true;
			}
            if (doPrint)
            {
                try
                {
                  printerJob.setPageable( book );
                  printerJob.print(attr_set);
                }
                catch (final PrinterException e)
                {
                   rz.getLogFactory().logMessage(2, "ReportControl.PrintDirectly.inner",e.getLocalizedMessage());
                }
            }
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(2, "ReportControl.PrintDirectly.outer",e.getLocalizedMessage());
        }
    }

    /** holt das XML-File aus der Datenbank und initialisiert einen JFreeReport
     * @param t Name des Reports in der Datenbank
     */
    public JFreeReport getReport(){
    	JFreeReport ret = null;
    	final URL baseDir = getClass().getResource(rz.getOptionFactory().getOption("report.basedir"));
   		final ReportItem r = rz.getDatabase().getReport().dbGetReport(rz.getOptionFactory().getOption(optionKey,ReportFactory.REPORT_DEFAULT_REZEPTUR));
        final StringReader in = new StringReader(replaceLocale(r.getFormular()));
        try{
        	JFreeReportBoot.getInstance().start();
            final ReportGenerator  generator = ReportGenerator.getInstance();
            ret = generator.parseReport(new org.xml.sax.InputSource(in),  baseDir);
            for(ReportImageItem ri:images) {
            	ret.setProperty(ri.getProperty(), ri.getImage());
            }
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(2, "ReportControl.getReport", e.getLocalizedMessage());
        }
        return ret;
    }


    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    public abstract void createModel();

    /** gibt den Report aus
     *
     * @param ri  RechenItem
     */
    public void printReport(){
        try{
            if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
                final PreviewFrame frame = new PreviewFrame(report);
                frame.pack();
                frame.setVisible(true);
                frame.requestFocus();
            } else {
				printDirectly(report);
			}
        }
        catch (final Exception e){}
    }
   }
