package de.lunqual.rzpro.ausgabe;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import java.util.Date;
import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.buchung.StatistikRezepturListe;
import de.lunqual.rzpro.items.buchung.StatistikRezepturItem;

public class StatistiklisteDrucken extends ReportAusgabe{

    tableModel				modell;
    StatistikRezepturListe	si;

    public StatistiklisteDrucken(RzPro r,Object reportData,String optionKey,java.awt.Window w) {
        super(r, reportData,optionKey,w);
        rz = r;
        si  =( StatistikRezepturListe)reportData;
        this.optionKey = optionKey;
        modell =null;
        df = new SimpleDateFormat("dd.MM.yyyy H:mm");
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void createModel(){
        final tableModel modell = new tableModel();
        if(modell != null) {
        	if(si != null) {
        		for(int i = 0; i < si.size();i++) {
        			final StatistikRezepturItem ri = (StatistikRezepturItem)si.get(i);
        			modell.addItem( i+1,
        											rz.getDatabase().dbGetUser(),
        											ri.getBezeichnung(),
        											ri.getLiter(),
        											ri.getLa(),
        											si.getVon(),
        											si.getBis(),
        											new Date(),
        											si.getBezeichnung(),
        											si.getInvers(),
        											si.getLosnummer(),
        											(si.getLager() != null)?si.getLager().toPlainString():"",
        											si.getAuswahlString());
        		}
        	}
        }
        report = getReport();
        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
        report.setQuery ("default");
  }


  private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {	"nummer","user","zeile","liter","la","von","datum","bis","bezeichnung","invers","losnummer","lagerliste","auswahl"};

              private final Class[] COLUMN_TYPE = {
                Integer.class,
                String.class,
                String.class,
                String.class,
                String.class,
                Date.class,
                Date.class,
                Date.class,
                String.class,
                String.class,
                String.class,
                String.class,
                String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
			final int nummer,final String user,final String zeile,
			final String liter,final String la,final Date von,
			final Date bis, final Date datum,final String bezeichnung,
			final String invers,final String losnummer,
			final String lagerliste,
			final String auswahl
			)
        {
            	liste.add (new Object[] {nummer, user,zeile,liter,la,von,bis,datum,bezeichnung,invers,losnummer,lagerliste,auswahl });
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }

}
