/*
 * Created on 10.09.2004
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import de.lunqual.rzpro.items.tafel.TafelItem;

import de.lunqual.rzpro.RzPro;

/**
 * @author labor
 *
 */
public class TafelDrucken extends ReportAusgabe {

    TafelItem ti;

    public TafelDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        ti = (TafelItem)reportData;
        this.optionKey=optionKey;
    }



    /** liefert ein TableModel
     *
     */
    @Override
	public void  createModel(){
        final Date datum = new Date();
        final tableModel modell = new tableModel();
        if (modell != null) {
            modell.addItem(rz.getDatabase().dbGetUser(),
                    datum,
                    Double.valueOf(ti.getProzentVol()),
                    Double.valueOf(ti.getProzentMas()),
                    Double.valueOf(ti.getTemp()),
                    Double.valueOf(ti.getLiter()),
                    Double.valueOf(ti.getLiter20()),
                    Double.valueOf(ti.getKg()),
                    Double.valueOf(ti.getLa()),
                    Double.valueOf(ti.getTafel2()),
                    Double.valueOf(ti.getTafel3()),
                    Double.valueOf(ti.getTafel6()),
                    Double.valueOf(ti.getLitergewicht()),
                    Double.valueOf(ti.getVolumen()),
                    rz.getDatabase().getEinheiten().dbGetLitergewichtString(),
                    rz.getDatabase().getEinheiten().dbGetVolumenString()
            );
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
               "user","datum","prozentvol","prozentmas","temp","liter","liter20","kg","la",
               "tafel2","tafel3","tafel6","litergewicht","volumen","litergewichtstring","volumenstring"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,java.util.Date.class,
                Double.class, Double.class,  Double.class,  Double.class,
                Double.class, Double.class,  Double.class,  Double.class,
                Double.class, Double.class,  Double.class,  Double.class,
                String.class,String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final java.util.Date datum,
                final Double prozentVol,
                final Double prozentMas,
                final Double temp,
                final Double liter,
                final Double liter20,
                final Double kg,
                final Double la,
                final Double tafel2,
                final Double tafel3,
                final Double tafel6,
                final Double litergewicht,
                final Double volumen,
                final String litergewichtstring,
                final String volumenstring
                )
        {
            	liste.add (new Object[] {
                         user,
                         datum,
                         prozentVol,
                         prozentMas,
                         temp,
                         liter,
                         liter20,
                         kg,
                         la,
                         tafel2,
                         tafel3,
                         tafel6,
                         litergewicht,
                         volumen,
                         litergewichtstring,
                         volumenstring
            	});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}


