/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.temperaturzone.rezepturZonenItem;
import de.lunqual.rzpro.items.temperaturzone.rezepturZonenListe;
/**
 * @author labor
 *
 */
public class TemperaturzonenDrucken extends ReportAusgabe {

    int 						key;
    public static final String	DEFAULT_ORIENTATION="landscape";
    rezepturZonenListe			liste;
    /**
     *
     */
    public TemperaturzonenDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        liste = (rezepturZonenListe)reportData;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(liste != null && !liste.isEmpty()){
	            final Date datum = new Date();
	            for (int i = 0;i < liste.size();i++) {
	            	rezepturZonenItem rzi = liste.getItem(i);
	            	modell.addItem(
	            			rz.getDatabase().dbGetUser(),
	            			datum,
	            			rzi.getBezeichnung(),
	            			rzi.getArtikelnummer(),
	            			"Temp. Min: " + String.valueOf(rzi.getTempVon())+ " °C",
	            			"Temp. Max: " + String.valueOf(rzi.getTempBis())+ " °C",
	            			"Temp: \u00d8: " + String.valueOf(rzi.getTEmperaturDurchschnitt())+ " °C", 
	            			rzi.getZi().getBezeichnung()
	            		);
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
        		"user",
        		"datum",
        		"bezeichnung",
        		"artikelnummer",
        		"tempvon",
        		"tempbis",
        		"tempschnitt",
        		"zone"
              };

              private final Class[] COLUMN_TYPE = {
            		  String.class,
            		  Date.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
        		String 	user,
        		Date  	datum,
        		String 	bezeichnung,
        		String 	artikelnummer,
        		String 	tempvon,
        		String 	tempbis,
        		String	tempschnitt,
        		String 	zone
                )
        {
            	liste.add (new Object[] {user,datum,bezeichnung,artikelnummer,tempvon,tempbis,tempschnitt,zone});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

