/**
 * ========================================
 * JFreeReport : a free Java report library
 * ========================================
 *
 * Project Info:  http://www.jfree.org/jfreereport/index.html
 * Project Lead:  Thomas Morgner (taquera@sherito.org);
 *
 * (C) Copyright 2000-2004, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * ------------------------------
 * TriggerNestedGroupFunction.java
 * ------------------------------
 * (C)opyright 2004, by Thomas Morgner and Contributors.
 *
 * Original Author:  Thomas Morgner;
 * Contributor(s):   David Gilbert (for Simba Management Limited);
 *
 * $Id: TriggerNestedGroupFunction.java,v 1.1.2.1 2004/04/27 15:02:06 taqua Exp $
 *
 * Changes
 * -------------------------
 * 10.09.2004 : changed by lunqual
 * 24.04.2004 : Initial version
 *
 */

package de.lunqual.rzpro.ausgabe;

import org.jfree.report.function.AbstractFunction;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.Element;



public class VisibleLagerListeBandFunction extends AbstractFunction
{
  /**
   * Creates an unnamed function. Make sure the name of the function is set using {@link
   * #setName} before the function is added to the report's function collection.
   */
  public VisibleLagerListeBandFunction ()
  {
  }

  /**
   *
   * @param event the event.
   */

  @Override
public void itemsAdvanced (final ReportEvent event)
  {
    final Element freiBand = event.getReport().getItemBand().getElement("alkoholfrei");
    final Element alkBand = event.getReport().getItemBand().getElement("alkohol");

    if ((alkBand == null) || (freiBand == null) )
    {
      return;
    }

    // and now apply the visiblity to all bands affected

   final double staerke = ((Double)(event.getDataRow().get("b_staerke"))).doubleValue();
    if(staerke != 0) {
    	    alkBand.setVisible(true);
    		freiBand.setVisible(false);
    } else {
    	    alkBand.setVisible(false);
    		freiBand.setVisible(true);
    }
  }

  /**
   * Return the current expression value. <P> The value depends (obviously) on the
   * expression implementation.
   *
   * @return the value of the function.
   */
  public Object getValue ()
  {
    return null;
  }

}

