/**
 * ========================================
 * JFreeReport : a free Java report library
 * ========================================
 *
 * Project Info:  http://www.jfree.org/jfreereport/index.html
 * Project Lead:  Thomas Morgner (taquera@sherito.org);
 *
 * (C) Copyright 2000-2004, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * ------------------------------
 * TriggerNestedGroupFunction.java
 * ------------------------------
 * (C)opyright 2004, by Thomas Morgner and Contributors.
 *
 * Original Author:  Thomas Morgner;
 * Contributor(s):   David Gilbert (for Simba Management Limited);
 *
 * $Id: TriggerNestedGroupFunction.java,v 1.1.2.1 2004/04/27 15:02:06 taqua Exp $
 *
 * Changes
 * -------------------------
 * 10.09.2004 : changed by lunqual
 * 24.04.2004 : Initial version
 *
 */

package de.lunqual.rzpro.ausgabe;

import org.jfree.report.function.AbstractFunction;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.Element;

import de.lunqual.rzpro.items.trace.TraceTextItem;

public class VisibleTraceBandFunction extends AbstractFunction
{
  /**
   * Creates an unnamed function. Make sure the name of the function is set using {@link
   * #setName} before the function is added to the report's function collection.
   */
  public VisibleTraceBandFunction ()
  {
  }

  /**
   *
   * @param event the event.
   */


  @Override
public void itemsAdvanced (final ReportEvent event)
  {
    final Element textBand = event.getReport().getItemBand().getElement("text");
    final Element h3Band = event.getReport().getItemBand().getElement("h3");
    final Element h2Band = event.getReport().getItemBand().getElement("h2");
    final Element h1Band = event.getReport().getItemBand().getElement("h1");

    if ((textBand == null) || (h3Band == null) || (h2Band == null) || (h1Band == null) )
    {
      return;
    }

    // and now apply the visiblity to all bands affected

    final int typ = ((Integer)(event.getDataRow().get("typ"))).intValue();
    switch(typ) {
	    	case TraceTextItem.TRACE_TEXT:
	    		textBand.setVisible(true);
	    		h1Band.setVisible(false);
	    		h2Band.setVisible(false);
	    		h3Band.setVisible(false);
	    		break;
	    	case TraceTextItem.TRACE_H1:
	    		textBand.setVisible(false);
	    		h1Band.setVisible(true);
	    		h2Band.setVisible(false);
	    		h3Band.setVisible(false);
	    		break;
	    	case TraceTextItem.TRACE_H2:
	    		textBand.setVisible(false);
	    		h1Band.setVisible(false);
	    		h2Band.setVisible(true);
	    		h3Band.setVisible(false);
	    		break;
	    	case TraceTextItem.TRACE_H3:
	    		textBand.setVisible(false);
	    		h1Band.setVisible(false);
	    		h2Band.setVisible(false);
	    		h3Band.setVisible(true);
	    		break;
    }
  }
  /**
   * Return the current expression value. <P> The value depends (obviously) on the
   * expression implementation.
   *
   * @return the value of the function.
   */
  public Object getValue ()
  {
    return null;
  }

}
