package de.lunqual.rzpro.ausgabe;

/*
 */

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import org.jfree.report.modules.gui.base.PreviewFrame;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.auftrag.BedarfsItem;
import de.lunqual.rzpro.items.auftrag.BedarfsZutat;
/**
 * @author labor
 *
 */
public class ZutatenlisteDrucken extends ReportAusgabe {

	public static final String			DEFAULT_ORIENTATION="landscape";
	
	BedarfsItem					bi;
	boolean						vorschau;
	
    public ZutatenlisteDrucken(RzPro r,Object reportData ,String optionKey,boolean vorschau,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        this.vorschau = vorschau;
        rz = r;
        this.optionKey=optionKey;
        bi = ((BedarfsItem)reportData);
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
    	Date now = new Date();
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(bi != null){
	        	for (int i = 0;i < bi.getZutaten().size();i++) {
	        		BedarfsZutat bz = (BedarfsZutat) bi.getZutaten().get(i);
		        	modell.addItem(
		        			rz.getDatabase().dbGetUser(),
		        			now,
		        			rz.getLocale().getString("report.zutatenliste.rezepturen").replaceAll("%s", bi.toPlainString()),
		        			rz.getLocale().getString("report.zutatenliste.zutat").replaceAll("%s", bz.getBezeichnung()).replaceAll("%b", bz.isBestellung()?rz.getLocale().getString("report.zutatenliste.bestellt"):""),
		        			rz.getLocale().getString("report.zutatenliste.bedarf").replaceAll("%s",bz.bedarfToString()),
		        			rz.getLocale().getString("report.zutatenliste.bestand").replaceAll("%s",bz.bestandToString()),
		        			rz.getLocale().getString("report.zutatenliste.saldo").replaceAll("%s",bz.saldoToString())
		        		);
		        }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }

    @Override
   	public void printReport(){
           try{
               if(vorschau) {
                   final PreviewFrame frame = new PreviewFrame(report);
                   frame.pack();
                   frame.setVisible(true);
                   frame.requestFocus();
               } else {
   	            if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
   	                final PreviewFrame frame = new PreviewFrame(report);
   	                frame.pack();
   	                frame.setVisible(true);
   	                frame.requestFocus();
   	            } else {
   					printDirectly(report);
   				}
               }
           }
           catch (final Exception e){}
       }

    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","datum",
                "rezepturen",
                "zutat",
                "bedarf",
                "bestand",
                "saldo"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,java.util.Date.class,
                String.class,
                String.class,
                String.class,
                String.class,
                String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final java.util.Date datum,
                final String rezepturen,
                final String zutat,
                final String bedarf,
                final String bestand,
                final String saldo
               )
        {
            	liste.add (new Object[] {user,datum,rezepturen,zutat,bedarf,bestand,saldo});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

