/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.zutatenverzeichnis.ZutatenverzeichnisListe;
/**
 * @author labor
 *
 */
public class ZutatenverzeichnisDrucken extends ReportAusgabe {

    public static final String			DEFAULT_ORIENTATION="portrait";
    String text;
    String titel;
    String optionKey;
    /**
     *
     */
    public ZutatenverzeichnisDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.text=((ZutatenverzeichnisListe)reportData).getText();
        this.titel =((ZutatenverzeichnisListe)reportData).getTitel();
        this.optionKey=optionKey;
    }
    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(!text.trim().equals("")){
	            final Date datum = new Date();
	            final String zeilen[] = text.split("\\n");
	            for (final String zeile :zeilen) {
	                modell.addItem(titel,rz.getDatabase().dbGetUser(),zeile, datum);
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "titel","user","zeile","datum"
              };

              private final Class[] COLUMN_TYPE = {
                String.class, String.class, String.class, java.util.Date.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String titel,
        		final String user,
                final String zeile,
                final java.util.Date datum
                )
        {
            	liste.add (new Object[] {titel,user,zeile,datum});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

