package de.lunqual.rzpro.barcodes;


import java.awt.image.BufferedImage;

import java.awt.*;

import com.lowagie.text.pdf.Barcode128;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.options.OptionFactory;
public class Strichcode {
	
	RzPro rz;
	
	public Image getCode128(RzPro rz,String code) {
		this.rz = rz;
		int bc_width = rz.getOptionFactory().getOption("barcode_width",OptionFactory.BARCODE_WIDTH);
		int bc_offset = rz.getOptionFactory().getOption("barcode_offset",OptionFactory.BARCODE_OFFSET);
		
		
		BufferedImage ret = null;
		if(code != null && !code.equals("")) {
			Barcode128 code128 = new Barcode128();
		    code128.setGenerateChecksum(true);
		    code128.setCode(code);
			Image image = code128.createAwtImage(Color.black, Color.white);
			ret = new BufferedImage(bc_width,1, BufferedImage.TYPE_BYTE_GRAY);
			Graphics offg = ret.createGraphics();
			offg.setColor(Color.WHITE);
			offg.drawRect(0, 0, bc_width, 1);
		    offg.drawImage(image,bc_offset, 0,bc_width - (bc_offset*2),1, null);
		}
	   return ret;
	}

   
}