/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.items.access.accessUserItem;

/**
 *
 * @author  lunqual
 */
public class DBAccess{

    RzPro           		rz;
    Connection      	con;
    DBFactory       	db;
    DialogItem			dlgItem;

    PreparedStatement   getClientOnly;
    PreparedStatement	getListe;
    PreparedStatement	getUser;
    PreparedStatement	saveUser;
    PreparedStatement	deleteUser;

    /** Creates a new instance of DBLager */
    public DBAccess(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }

    private void setStatements(){
        try{
            getClientOnly    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_ACCESS + " where user=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getListe    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_ACCESS + " order by user",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getUser    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_ACCESS + " where user=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveUser	= con.prepareStatement("INSERT INTO " + DBFactory.TABLE_ACCESS + " (user,clientOnly) values(?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteUser	= con.prepareStatement("DELETE FROM " + DBFactory.TABLE_ACCESS + " where user=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);            
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAcid.setStatements", e.getLocalizedMessage());
        }
    }

    public boolean isClientOnly() {
    	return isClientOnly(db.dbGetUser());
    }
    
    public boolean isClientOnly(String user) {
    	boolean ret = false;
    	try {
			getClientOnly.setString(1, user);
			final ResultSet rs = getClientOnly.executeQuery();
			while (rs.next()) {
				ret = rs.getInt("clientOnly") == 0?false:true;
				rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "DBAcid.getClientOnly" ,
						ret==true?rz.getLocale().getString("dbaccess.client").replaceAll("%u", user):rz.getLocale().getString("dbaccess.main").replaceAll("%u", user) 
						
				);
			}
    	} catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAccess.isClientOnly(user)", e.getLocalizedMessage());
        }
    	return ret;
    }

    private accessUserItem getUser(String user) {
    	accessUserItem ret = null;
    	try {
    		getUser.setString(1, user.trim());
    		ResultSet rs = getUser.executeQuery();
    		if(rs.next()) {
    			ret = getUserFromRS(rs);
    		}
    	} catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAccess.getUser", e.getLocalizedMessage());
        }
    	return ret;
    }
    private accessUserItem getUserFromRS(ResultSet rs) {
    	try {
    		return new accessUserItem(
					rz,
					rs.getInt("id"),
					rs.getString("user"),
					rs.getInt("clientOnly")==0?false:true,
					rs.getLong("privileges")
					);
    	} catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAccess.getUserFromRS", e.getLocalizedMessage());
        }
    	return null;
    }
    
    public ArrayList<accessUserItem> getUsers(){
    	ArrayList<accessUserItem> liste = new ArrayList<accessUserItem>();
    	try {
			final ResultSet rs = getListe.executeQuery();
			while (rs.next()) {
				accessUserItem aui = getUserFromRS(rs);
				if(aui != null) {
					liste.add(aui);
				}
			}
    	} catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAccess.getListe", e.getLocalizedMessage());
        }
    	return liste;
    }
    
    public accessUserItem addUser(String user) {
    	accessUserItem ret = null;
    	try {
    		if(!user.trim().equals(db.dbGetUser())) {
    			getUser.setString(1, user.trim());
    			ResultSet rs = getUser.executeQuery();
    			if(!rs.next()) {
    				saveUser.setString(1, user.trim());
        			saveUser.setInt(2, 1);
        			saveUser.executeUpdate();
        			ret = getUser(user.trim());
    			}
    		}
    	} catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAccess.addUser", e.getLocalizedMessage());
        }
        return ret;
    }
    
    public void deleteUser(String user) {
    	try {
    		deleteUser.setString(1, user.trim());
    		deleteUser.executeUpdate();
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAccess.deleteUser", e.getLocalizedMessage());
	    }    	
    }
}
