package de.lunqual.rzpro.database;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.auftrag.AuftragConfigItem;
import de.lunqual.rzpro.items.auftrag.Auftragsliste;
import de.lunqual.rzpro.items.auftrag.RepeatSpanItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.dialog.DialogItem;

public class DBAuftrag {


    RzPro           rz;
    Connection      con;
    DBFactory       db;

    AuftragConfigItem	auftragConfig;
    
    PreparedStatement		getAuftragConfig;
    PreparedStatement		saveAuftragConfig;
    PreparedStatement		getAuftragsliste;
    PreparedStatement		getAuftragslisteRezeptur;    
    PreparedStatement		getAuftragslisteTank;
    PreparedStatement		getAuftragslisteAlle;
    PreparedStatement		getAuftragslisteSichtbare;
    PreparedStatement		getAuftragslisteSichtbareFilter;
    PreparedStatement		getAuftragslisteErledigte;
    PreparedStatement		getAuftragslisteInarbeit;
    PreparedStatement		saveAuftrag;
    PreparedStatement		updateAuftrag;
    PreparedStatement		deleteAuftrag;
    PreparedStatement		getAuftrag;
    PreparedStatement		getAuftragSingle;
    PreparedStatement		auftragErledigen;
    PreparedStatement		getAuftragsListeZeitraum;
    PreparedStatement		getAuftragsListeDatum;
    PreparedStatement		getAuftragsItem;
    PreparedStatement		getAnfragen;
    PreparedStatement		getRezepturenListe;
    PreparedStatement		getAuftragTank;
    
    PreparedStatement		getAuftragBenutzer;
    PreparedStatement		saveAuftragBenutzer;
    PreparedStatement		checkRepeat;
    PreparedStatement		getGruppen;
    PreparedStatement		getAuftraegeNachGruppen;
    
    PreparedStatement		getAuftragRezeptur;
    PreparedStatement		getAuftragTankRezeptur;
    
    PreparedStatement		initAuftragsConfig;
    
    public static final int 	AUFTRAEGE_ALLE=0;
    public static final int 	AUFTRAEGE_OFFENE=1;
    public static final int 	AUFTRAEGE_SICHTBARE=2;
    public static final int		AUFTRAEGE_ANFRAGEN=3;
    public static final int		AUFTRAEGE_ERLEDIGTE=4;
    public static final int		AUFTRAEGE_INARBEIT=5;
    
    public static final int		REP_MODE_ERLEDIGT = 0;
    public static final int		REP_MODE_FAELLIG = 1;
    
    public static final int		REP_SPAN_TAGE=0;
    public static final int		REP_SPAN_WOCHEN=1;
    public static final int		REP_SPAN_MONATE=2;
    public static final int		REP_SPAN_TAG_DES_MONATS=3;
    public static final int		REP_SPAN_MONATSANFANG=4;
    public static final int		REP_SPAN_MONATSENDE=5;
    
    public static final int 	DEFAULT_PRIORITY = 3;
    public static final int	 	PRIORITY_MAX = 5;
    
    Auftragsliste			auftraege;
    ArrayList				benutzer;
    ArrayList<RepeatSpanItem>				repeatSpanListe;
    
   
    public static final String	CURSOR_DATUM="datum";
    public static final String	CURSOR_GRUPPE="gruppe";
    
    
    /** Creates a new instance of DBBestellung */
    public DBAuftrag(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
        init();
    }

    
    private void setStatements(){
        try{
        	
        	initAuftragsConfig  	= con.prepareStatement("INSERT INTO " +DBFactory.TABLE_AUFTRAEGE + " (id) VALUES (1) ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getAuftragConfig   		= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_AUFTRAEGE + " WHERE id=1 ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveAuftragConfig   	= con.prepareStatement("UPDATE " +DBFactory.TABLE_AUFTRAEGE + " SET " +
            		" level_0_value=?,level_0_fg=?,level_0_bg=?,"+
            		" level_1_value=?,level_1_fg=?,level_1_bg=?,"+
            		" level_2_value=?,level_2_fg=?,level_2_bg=?,"+
            		" level_3_value=?,level_3_fg=?,level_3_bg=?,"+
            		" level_e_fg=?,level_e_bg=?,"+
            		" level_a_fg=?,level_a_bg=?,"+
            		" level_aa_fg=?,level_aa_bg=?," +
            		" level_f_fg=?,level_f_bg=?, " +
            		" darker=? " +
            		" WHERE id=1"
            		
            		,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            
            getAuftragsliste = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt=false ORDER BY faellig ASC ,wichtig DESC ,bezeichnung ASC " ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAuftragslisteRezeptur = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt=false and rezeptur_id=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAuftragslisteAlle = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_AUFTRAGSLISTE + " ORDER BY faellig ASC ,wichtig DESC ,bezeichnung ASC " ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveAuftrag=con.prepareStatement("INSERT INTO "+DBFactory.TABLE_AUFTRAGSLISTE +
            		" (rezeptur_id,bezeichnung,liter,erstellt_datum,erstellt_user,geaendert_datum,geaendert_user,erledigt_datum,erledigt_user,arbeit_user,comment,erledigt,faellig,anfrage,inarbeit,inarbeit_datum,tank,rep,rep_days,magic,rep_mode,rep_span,wichtig,gruppe,fertig,fertig_user,fertig_datum) "+
            		" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) "
            		,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateAuftrag=con.prepareStatement("UPDATE  "+DBFactory.TABLE_AUFTRAGSLISTE +
            		" set rezeptur_id=?," +
            		"bezeichnung=?," +
            		"liter=?,"+
            		"erstellt_datum=?," +
            		"erstellt_user=?," +
            		"geaendert_datum=?," +
            		"geaendert_user=?," +
            		"erledigt_datum=?," +
            		"erledigt_user=?," +
            		"arbeit_user=?," +
            		"comment=?,"+
            		"erledigt=?,"+
            		"faellig=?, "+
            		"anfrage=?, "+
            		"inarbeit=?, "+
            		"inarbeit_datum=?,"+
            		"tank=?,"+
            		"rep=?,"+
            		"rep_days=?,"+
            		"magic=?, "+
            		"rep_mode=?, " +
            		"rep_span=?, " +
            		"wichtig=?," +
            		"gruppe=?," +
            		"fertig=?, " +
            		"fertig_user=?, " +
            		"fertig_datum=? " +
            		" WHERE id=?"
            		,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteAuftrag = con.prepareStatement("DELETE FROM " + DBFactory.TABLE_AUFTRAGSLISTE + "  WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getAuftrag	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_AUFTRAGSLISTE + " WHERE rezeptur_id=? AND erledigt = false ORDER by faellig ASC LIMIT 1",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAuftragslisteTank= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_AUFTRAGSLISTE + " WHERE rezeptur_id=? AND erledigt = false ORDER by faellig ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            getAuftragTank	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt = false AND tank regexp ? ORDER by faellig",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAuftragRezeptur	= con.prepareStatement("SELECT id,name,tank FROM " +DBFactory.TABLE_REZEPTLISTE + " WHERE tank regexp(?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAuftragTankRezeptur	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt = false AND rezeptur_id=? ORDER by faellig",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            
            
            getAuftragSingle	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_AUFTRAGSLISTE + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            auftragErledigen = con.prepareStatement("UPDATE " + DBFactory.TABLE_AUFTRAGSLISTE + 
            		" set inarbeit=0, erledigt=1,liter=?,erledigt_datum=?,erledigt_user=? "+
            		"  WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            
            getAuftragslisteSichtbare = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt=false AND faellig <= ? AND anfrage = 0 ORDER BY faellig ASC ,wichtig DESC,bezeichnung ASC " ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAuftragslisteSichtbareFilter = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt=false AND anfrage = 0 and bezeichnung regexp ? ORDER BY faellig ASC ,wichtig DESC,bezeichnung ASC " ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            getAuftragslisteInarbeit = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt=false AND anfrage = 0 and inarbeit = true ORDER BY faellig ASC ,wichtig DESC ,bezeichnung ASC " ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAuftragslisteErledigte = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt=true ORDER BY faellig ASC ,wichtig DESC ,bezeichnung ASC " ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAuftragsListeZeitraum = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_AUFTRAGSLISTE + " WHERE faellig >=? and faellig <=? " ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAuftragsListeDatum = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_AUFTRAGSLISTE + " WHERE faellig=? ORDER BY wichtig DESC,bezeichnung ASC " ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAuftragsItem	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_AUFTRAGSLISTE + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            //getAnfragen = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt=0 AND anfrage=1 AND faellig >= ? ORDER by faellig ASC ,wichtig DESC ,bezeichnung ASC ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAnfragen = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt=0 AND anfrage=1 ORDER by faellig ASC ,wichtig DESC ,bezeichnung ASC ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            getRezepturenListe = con.prepareStatement("SELECT rezeptur_id FROM " +DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt=0 AND anfrage=0 ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAuftragBenutzer = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_AUFTRAG_BENUTZER ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveAuftragBenutzer = con.prepareStatement("UPDATE  " +DBFactory.TABLE_AUFTRAG_BENUTZER +" set user=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            checkRepeat = con.prepareStatement("SELECT id FROM " +DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt=1 AND rep=1 AND id=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getGruppen = con.prepareStatement("SELECT distinct gruppe FROM " +DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt=0 order by gruppe asc" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAuftraegeNachGruppen = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_AUFTRAGSLISTE + " WHERE erledigt=0 and gruppe=? order by faellig asc" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            
            repeatSpanListe = new ArrayList<RepeatSpanItem>();
    		repeatSpanListe.add(new RepeatSpanItem(rz,REP_SPAN_TAGE,rz.getLocale().getString("dbauftrag.repeat_span_tage")));
    		repeatSpanListe.add(new RepeatSpanItem(rz,REP_SPAN_WOCHEN,rz.getLocale().getString("dbauftrag.repeat_span_wochen")));
    		repeatSpanListe.add(new RepeatSpanItem(rz,REP_SPAN_MONATE,rz.getLocale().getString("dbauftrag.repeat_span_monate")));
    		repeatSpanListe.add(new RepeatSpanItem(rz,REP_SPAN_TAG_DES_MONATS,rz.getLocale().getString("dbauftrag.repeat_span_tag_des_monats")));
    		repeatSpanListe.add(new RepeatSpanItem(rz,REP_SPAN_MONATSANFANG,rz.getLocale().getString("dbauftrag.repeat_span_monatsanfang")));
    		repeatSpanListe.add(new RepeatSpanItem(rz,REP_SPAN_MONATSENDE,rz.getLocale().getString("dbauftrag.repeat_span_monatsende")));
        }catch (final Exception e){
               rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.setStatements", e.getLocalizedMessage());
        }
    }
    
    public Cursor getDatumCursor(AuftragsItem ai,JTable tbl) {
    	ImageIcon datum = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_drag_datum_cursor.png"));
    	Cursor ret = Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR);
    	if(ai != null) {
			int width=32;
			int height = 16;
			Dimension d = Toolkit.getDefaultToolkit().getBestCursorSize(width, height);
			width = (int)d.getWidth();
			height = (int)d.getHeight();
			Image img = tbl.createImage(width,height);
    		Graphics2D g2 = (Graphics2D)img.getGraphics();
    		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    		g2.setColor(rz.getOptionFactory().getRGBColorString(ai.getHg()));
    		g2.fillRect(0, 0, width, height);
    		g2.setColor(Color.BLACK);
    		g2.drawRect(0,0, width-1, height-1);
    		g2.drawImage(datum.getImage(),2,2,null);
    		if(Toolkit.getDefaultToolkit().getMaximumCursorColors() >2) {
    			ret = Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(0,0), CURSOR_DATUM);
    		}  else {
    			ret = Toolkit.getDefaultToolkit().createCustomCursor(datum.getImage(), new Point(0,0), CURSOR_DATUM);
    		}
    	}
    	return ret;
    }
    
    public Cursor getGruppenCursor(AuftragsItem ai,JTable tbl) {
    	Cursor ret = Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR);
    	if(ai != null) {
            ImageIcon gruppe =  new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_cursor.png"));
    		FontMetrics fm = tbl.getFontMetrics(tbl.getFont());
			int width = (int)(SwingUtilities.computeStringWidth(fm, "_") * ai.getBezeichnung().length())+gruppe.getIconWidth() + 10;
			int height = fm.getHeight() + 6;
			Dimension d = Toolkit.getDefaultToolkit().getBestCursorSize(width, height);
			width = (int)d.getWidth();
			height = (int)d.getHeight();
			Image img = tbl.createImage(width,height);
    		Graphics2D g2 = (Graphics2D)img.getGraphics();
    		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    		g2.setColor(rz.getOptionFactory().getRGBColorString(ai.getHg()));
    		g2.fillRect(0, 0, width, height);
    		g2.setColor(Color.BLACK);
    		g2.drawRect(0,0, width-1, height-1);
    		g2.drawImage(gruppe.getImage(),3,2,null);
    		if(Toolkit.getDefaultToolkit().getMaximumCursorColors() >2) {
    			g2.setColor(rz.getOptionFactory().getRGBColorString(ai.getVg()));
    		}
    		g2.drawString(ai.getBezeichnung(),gruppe.getIconWidth()+2,  height -4);
    		if(Toolkit.getDefaultToolkit().getMaximumCursorColors() >2) {
    			ret = Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(0,0), CURSOR_GRUPPE);
    		}  else {
    			ret = Toolkit.getDefaultToolkit().createCustomCursor(gruppe.getImage(), new Point(0,0), CURSOR_GRUPPE);
    		}
    	}
    	return ret;
    }
    
    public ArrayList<AuftragsItem> getAuftraegeNachGruppen(String gruppe) {
    	ArrayList<AuftragsItem> ret = new ArrayList<AuftragsItem>();
    	try {
    		if(gruppe != null && !gruppe.equals("")) {
    		getAuftraegeNachGruppen.setString(1, gruppe);
	    		final ResultSet rs = getAuftraegeNachGruppen.executeQuery();
	    		while(rs.next()) {
	    			ret.add(this.getAuftragsItem(rs));
	    		}
    		}
   		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAuftraegeNachGruppen", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    public void setGruppenCmb(JComboBox cmb) {
    	try {
    		cmb.removeAllItems();
    		cmb.addItem(rz.getLocale().getString("auftrag.cmb_gruppe"));
    		final ResultSet rs = getGruppen.executeQuery();
    		while(rs.next()) {
    			if(!rs.getString("gruppe").equals("")){
    				cmb.addItem(rs.getString("gruppe"));
    			}
    		}
   		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.setGruppenCmb", e.getLocalizedMessage());
		}
    }
    
    public ArrayList<RepeatSpanItem> getRepeatSpanListe() {
    	return repeatSpanListe;
    }
    public void setRepeatSpanCombo(JComboBox cmb) {
    	try {
    		cmb.removeAllItems();
    		for(RepeatSpanItem sp:repeatSpanListe) {
    			cmb.addItem(sp);
    		}
    		
   		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.setRepatSpanCombo", e.getLocalizedMessage());
		}
    }
    
    public void setAuftragBenutzerCombo(JComboBox cmb) {
    	try {
    		cmb.removeAllItems();
    		cmb.addItem(rz.getLocale().getString("auftrag.benutzer_header"));
    		final ResultSet rs = getAuftragBenutzer.executeQuery();
    		String user = "";
    		if(rs.next()) {
    			user = rs.getString("user");
        		String[] benutzer = user.split("\\s+|,");
        		for(String b:benutzer) {
        			if(!b.trim().equals("")&&!b.trim().equals(db.dbGetUser())) {
        				cmb.addItem(b.trim());
        			}
        		}
    		}
		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAuftragBenutzerArray", e.getLocalizedMessage());
		}
    }
    
    public String getAuftragBenutzerString() {
    	String ret = "";
    	try {
    		final ResultSet rs = getAuftragBenutzer.executeQuery();
    		if(rs.next()) {
    			ret = rs.getString("user");
    		}
		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAuftragBenutzerString", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    public void saveAuftragBenutzer(String benutzer) {
    	try {
    		benutzer=benutzer.replaceAll("\\s+|,", " ");
    		saveAuftragBenutzer.setString(1, benutzer.trim());
    		saveAuftragBenutzer.executeUpdate();
		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.saveAuftragBenutzer", e.getLocalizedMessage());
		}
    }
    
    public Auftragsliste getAuftragTank(String tanks) {
    	Auftragsliste ret = new Auftragsliste(rz);
    	try {
	    	    String sql = ".*[[:<:]]" + tanks.trim() + "[[:>:]].*";
	    	    getAuftragTank.setString(1, sql);
				final ResultSet rs=getAuftragTank.executeQuery();
				while(rs.next()) {
	    			ret.addItem(getAuftragsItem(rs));
				}
				getAuftragRezeptur.setString(1, sql);
				final ResultSet rs1 = getAuftragRezeptur.executeQuery();
				if(rs1.next()) {
					getAuftragTankRezeptur.setInt(1, rs1.getInt("id"));
					final ResultSet rs2=getAuftragTankRezeptur.executeQuery();
					if(rs2.next()) {
						ret.addItem(getAuftragsItem(rs2));
					}
				}
		}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAuftragTank", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    
    private Auftragsliste getAnfragen() {
    	Auftragsliste ret = new Auftragsliste(rz);
    	try {
			Calendar today = Calendar.getInstance();
			rz.roundDatum(today);
			//getAnfragen.setLong(1,today.getTimeInMillis());
			final ResultSet rs=getAnfragen.executeQuery();
			while(rs.next()) {
    			ret.addItem(getAuftragsItem(rs));
			}
		}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAnfragen", e.getLocalizedMessage());
    	}
    	return ret;
    }

    public Auftragsliste getAuftraege() {
    	return auftraege;
    }
    
    public void auftragErledigen(AuftragsItem ai) {
    	if(ai != null && ai.getId()!=0) {
	    	try {
	    		Calendar c =Calendar.getInstance();
	    		ai.setErledigt(true);
	    		ai.setErledigt_datum(c);
	    		ai.setErledigt_user(db.dbGetUser());
	    		auftragErledigen.setDouble(1,ai.getLiter());
	    		auftragErledigen.setString(2, db.dbGetDateFormatString(c.getTime()));
	    		auftragErledigen.setString(3, db.dbGetUser());
	    		auftragErledigen.setInt(4, ai.getId());
	    		auftragErledigen.executeUpdate();
	    		if(ai.isRepeat()) {
	    			checkRepeat(ai);
	    		}
	    	}catch (final Exception e){
	    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.auftragErledigen", e.getLocalizedMessage());
	    	}
    	}
    }
    
    public AuftragsItem getAuftragsItem(int auftrag) {
    	AuftragsItem ret=null;
    	try {
    		getAuftragsItem.setInt(1, auftrag);
    		final ResultSet rs=getAuftragsItem.executeQuery();
    		if(rs.next()) {
    			ret = getAuftragsItem(rs);
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAuftragsItem", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    
    public AuftragsItem getAuftragSingle(int id) {
    	AuftragsItem ret=null;
    	try {
    		getAuftragSingle.setInt(1, id);
    		final ResultSet rs=getAuftragSingle.executeQuery();
    		if(rs.next()) {
    			ret = getAuftragsItem(rs);
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAuftrag", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    public AuftragsItem getAuftrag(int rezeptur_id) {
    	AuftragsItem ret=null;
    	try {
    		getAuftrag.setInt(1, rezeptur_id);
    		final ResultSet rs=getAuftrag.executeQuery();
    		if(rs.next()) {
    			ret = getAuftragsItem(rs);
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAuftrag", e.getLocalizedMessage());
    	}
    	return ret;
    }

    public Auftragsliste getAuftragsListe(int rezeptur_id) {
    	Auftragsliste ret=new Auftragsliste(rz);
    	try {
    		getAuftragslisteTank.setInt(1, rezeptur_id);
    		final ResultSet rs=getAuftragslisteTank.executeQuery();
    		while(rs.next()) {
    			AuftragsItem ai=getAuftragsItem(rs);
    			if(ai != null) {
    				ret.addItem(ai);
    			}
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAuftrag(Liste", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    
    public void deleteAuftrag(AuftragsItem ai) {
    	try {
    		if(ai != null && !ai.isRepeat()) {
    		    	deleteAuftrag.setInt(1, ai.getId());
    		    	deleteAuftrag.executeUpdate();
    		}else {
    			DialogItem di = new DialogItem(
                        DialogControl.HINWEIS_DIALOG,
                        "",0.0,
                        rz.getLocale().getString("dbauftrag.delete_auftrag"),
                        rz.getLocale().getString("dbauftrag.delete_auftrag"),
                        rz.getLocale().getString("dbauftrag.delete_auftrag_message"),
                        "frage.png",
                        rz.getLocale().getString("string_ja"),
                        rz.getLocale().getString("string_nein"),
                        null
                );
    			if(di != null) {
			  		rz.getDialogFactory().getDialog(di);
    			}
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.deleteAuftrag", e.getLocalizedMessage());
    	}
    }
    
    public int saveAuftrag(AuftragsItem ai,JRzFrame origin) {
    	int ret = 0;
    	try {
	    	ret = saveAuftrag1(ai);
	    	if(ai.isRepeat()) {
	    		int n = checkRepeat(ai);
	    			if(n != 0) {
		    		try {
		    			rz.getFensterFactory().getFensterListe().propagateBestand(origin,n);
		    		} catch(Exception e) {}
		    	}
	    	}
    	}catch (Exception e) {
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.save1Auftrag", e.getLocalizedMessage());
    	}
    	return ret;
    }

    private int checkRepeat(AuftragsItem ai) {
    	int ret = 0;
    	try {
			checkRepeat.setInt(1, ai.getId());
			final ResultSet rs = checkRepeat.executeQuery();
			if(rs.next()) {
				AuftragsItem ai1 = ai.duplicate();
				Calendar d = Calendar.getInstance();
				if(ai.getRepStart() == REP_MODE_ERLEDIGT) {
					d.setTime(new Date());
				} else {
					d.setTimeInMillis(ai.getFaellig().getTimeInMillis());
				}
				rz.roundDatum(d);
    			Calendar f = repeatSpanListe.get(ai.getRepSpan()).berechnen(d, ai.getRepStart(),ai.getRepeat_value());
				ai1.setFaellig(f);
				ai1.setErledigt(false);
				ai1.setId(0);
				ai.setRepeat(false);
				saveAuftrag1(ai);
				ret =  saveAuftrag1(ai1);
			}
    	}catch (Exception e) {
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "checkRepeat", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    
    private int saveAuftrag1(AuftragsItem ai) {
    	int ret=0;
    	try {
    		PreparedStatement stmt;
    		if(ai.getId()==0) {
    			stmt=saveAuftrag;
   				ai.setMagic(UUID.randomUUID().toString());
    		}else {
    			stmt=updateAuftrag;
    			Calendar c = Calendar.getInstance();
    			c.setTime(db.getServerTimestamp());
    			ai.setGeaendert_datum(c);
    			ai.setGeaendert_user(db.dbGetUser());
    			stmt.setInt(28, ai.getId());
    		}
    		stmt.setInt(1, ai.getRezeptur_id());
    		if(rz.isMain()) {
	    		if(ai.isArbeitsAuftrag()) {
	    			stmt.setString(2,ai.getBezeichnung());
	    		}else {
	    			stmt.setString(2, rz.getDatabase().getRezeptur().dbGetRezepturName(ai.getRezeptur_id()));
	    		}
    		}else {
    			stmt.setString(2, rz.getDatabase().getRezeptur().dbGetRezepturName(ai.getRezeptur_id()));
    		}
    		stmt.setDouble(3, ai.getLiter());
    		stmt.setString(4, db.dbGetDateFormatString(ai.getErstellt_datum().getTime()));
    		stmt.setString(5, ai.getErstellt_user());
    		stmt.setString(6, db.dbGetDateFormatString(ai.getGeaendert_datum().getTime()));
    		stmt.setString(7, db.dbGetUser());
    		stmt.setString(8, db.dbGetDateFormatString(ai.getErledigt_datum().getTime()));
    		stmt.setString(9, ai.getErledigt_user());
    		stmt.setString(10, ai.getArbeit_user());
    		stmt.setString(11, ai.getComment());
    		stmt.setInt(12, ai.isErledigt()?1:0);
    		stmt.setLong(13,ai.getFaellig().getTimeInMillis());
    		stmt.setInt(14,(rz.isMain()?(ai.isAnfrage()?1:0):1));
    		stmt.setInt(15,(rz.isMain()?(ai.isInarbeit()?1:0):0));
    		stmt.setString(16, db.dbGetDateFormatString(ai.getInArbeit_datum().getTime()));
    		stmt.setString(17, ai.getTank());
    		stmt.setInt(18, ai.isRepeat()?1:0);
    		stmt.setInt(19, ai.getRepeat_value());
    		stmt.setString(20, ai.getMagic());
    		stmt.setInt(21, ai.getRepStart());
    		stmt.setInt(22, ai.getRepSpan());
    		stmt.setInt(23, ai.getPriority());
    		stmt.setString(24, ai.getGruppe());
    		stmt.setInt(25, ai.isFertig()?1:0);
    		stmt.setString(26, ai.getFertig_user());
    		stmt.setString(27, db.dbGetDateFormatString(ai.getFertig_datum().getTime()));
    		stmt.executeUpdate();
    		if(ai.getId()==0) {
    			ret=db.dbGetLastInsertID(DBFactory.TABLE_AUFTRAGSLISTE);
    			ai.setId(ret);
    		}else {
    			ret=ai.getId();
    		}
    	}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.saveAuftrag", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    public void refreshDatumsListe(long von,long bis) {
    	auftraege = new Auftragsliste(rz);
    	try {
    		getAuftragsListeZeitraum.setLong(1, von);
    		getAuftragsListeZeitraum.setLong(2, bis);
    		final ResultSet rs = getAuftragsListeZeitraum.executeQuery();
    		while(rs.next()) {
    			auftraege.addItem(getAuftragsItem(rs));
    		}
    	}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getRezepturenListe", e.getLocalizedMessage());
    	}
    }
    
    public Auftragsliste getAuftragsliste(int what,boolean gruppiert,String filter) {
    	init();
    	Auftragsliste ret=new Auftragsliste(rz);
    	if(what == AUFTRAEGE_ANFRAGEN) {
    		ret = getAnfragen();
    	} else {
	    	try {
	    		PreparedStatement stmt=null;
	    		switch(what) {
	    			case AUFTRAEGE_ALLE:stmt=getAuftragslisteAlle;
	    				break;
	    			case AUFTRAEGE_OFFENE: stmt=getAuftragsliste;
	    				break;
	    			case AUFTRAEGE_SICHTBARE:
	    				if(filter.trim().equals("")) {
		    				stmt=getAuftragslisteSichtbare;
		    				stmt.setLong(1,auftragConfig.getVisibleDate());
	    				} else {
	    					stmt=getAuftragslisteSichtbareFilter;
	    					stmt.setString(1, filter.replaceAll("\\s", ".*"));
	    				}

	    				break;
	    			case AUFTRAEGE_ERLEDIGTE:stmt=getAuftragslisteErledigte;
	    				break;
	    			case AUFTRAEGE_INARBEIT:stmt=getAuftragslisteInarbeit;
    					break;
	    		}
	    		if(stmt != null) {
		    		final ResultSet rs=stmt.executeQuery();
		    		while (rs.next()){
		    			if(!rz.isMain()) {
		    				if(rs.getInt("rezeptur_id") != 0) {
		    					ret.addItem(getAuftragsItem(rs));
		    				}
		    			}else {
	    					ret.addItem(getAuftragsItem(rs));
		    			}
		   			}
	    		}
	    	}catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAuftragsListe w="+what , e.getLocalizedMessage());
	    	}
    	}
    	return gruppiert?sortAuftragGruppe(ret):ret;
    	
    }
    
    public boolean checkAuftragForRezeptur(int id) {
    	boolean ret = false;
    	try {
    		getAuftragslisteRezeptur.setInt(1, id);
    		final ResultSet rs = getAuftragslisteRezeptur.executeQuery();
    		if(rs.next()) {
    			ret = true;
    		}
    	}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAuftragsListeRezeptur" , e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    private Auftragsliste sortAuftragGruppe(Auftragsliste in) {
    	Auftragsliste out = new Auftragsliste(rz);
    	while(in.size()>0) {
    		AuftragsItem ai = in.getItem(0);
    		if(ai != null) {
    			in.remove(ai);
    			out.add(ai);
   				moveAuftragGruppe(in,out,ai);
    		}
    	}
    	return out;
    }
    
    private void moveAuftragGruppe(Auftragsliste in, Auftragsliste out,AuftragsItem ai) {
    	ArrayList<AuftragsItem> remove = new ArrayList<AuftragsItem>();
    	if(!ai.getGruppe().equals("")) {
    		for(int i=0;i<in.size();i++) {
    			AuftragsItem ai1 = in.getItem(i);
    			if(ai1 != null) {
    				if(ai1.getGruppe().equals(ai.getGruppe())) {
    					out.add(ai1);
    					remove.add(ai1);
    				}
    			}
    		}
    		if(remove.size()>0) {
    			for(AuftragsItem ai2:remove) {
    				in.remove(ai2);
    			}
    		}
    	}
    }
    
    
    public Auftragsliste getAuftragslisteDatum(long datum) {
    	init();
    	Auftragsliste ret=new Auftragsliste(rz);
    	try {
    		if(datum != 0) {
    			getAuftragsListeDatum.setLong(1, datum);
	    		final ResultSet rs=getAuftragsListeDatum.executeQuery();
	    		while (rs.next()){
	    			ret.addItem(getAuftragsItem(rs));
	    			}
	    		}
    	}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAuftragsListeDatum", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    private AuftragsItem getAuftragsItem(ResultSet rs) {
    	AuftragsItem ret = null;
    	try {
    		if(rs != null) {
    		ret = new AuftragsItem(
					rz,
					rs.getInt("id"),
					rs.getDouble("liter"),
					rs.getInt("rezeptur_id"),
					rs.getString("bezeichnung"),
					rs.getLong("faellig"),
 	                db.getDateFromString(rs.getString("erstellt_datum")),
					rs.getString("erstellt_user"),
 	                db.getDateFromString(rs.getString("geaendert_datum")),
					rs.getString("geaendert_user"),
 	                db.getDateFromString(rs.getString("erledigt_datum")),
					rs.getString("erledigt_user"),
					rs.getString("arbeit_user"),
					rs.getString("comment"),
					rs.getInt("erledigt")==1?true:false,
					rs.getInt("anfrage")==1?true:false,
					rs.getInt("inarbeit")==1?true:false,
		 	        db.getDateFromString(rs.getString("inarbeit_datum")),
		 	        rs.getString("tank"),
		 	        rs.getInt("rep")==1?true:false,
					rs.getInt("rep_days"),
					rs.getString("magic"),
					rs.getInt("rep_mode"),
					rs.getInt("rep_span"),
					rs.getInt("wichtig"),
					rs.getString("gruppe"),
					rs.getInt("fertig")==1?true:false,
					rs.getString("fertig_user"),
					db.getDateFromString(rs.getString("fertig_datum"))
					);
    		}
    	}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.getAuftragsItemfromRS", e.getLocalizedMessage());
    	}
    	return ret;
    	
    }
    
    public void init() {
        try{
        	final ResultSet rs = getAuftragConfig.executeQuery();
        	if(rs.next()) {
        		auftragConfig=new AuftragConfigItem(
        				rz,
        				rs.getInt("id"),
        				rs.getInt("level_0_value"),
        				rs.getString("level_0_fg"),
        				rs.getString("level_0_bg"),
        				rs.getInt("level_1_value"),
        				rs.getString("level_1_fg"),
        				rs.getString("level_1_bg"),
        				rs.getInt("level_2_value"),
        				rs.getString("level_2_fg"),
        				rs.getString("level_2_bg"),
        				rs.getInt("level_3_value"),
        				rs.getString("level_3_fg"),
        				rs.getString("level_3_bg"),
        				rs.getString("level_e_fg"),
        				rs.getString("level_e_bg"),
        				rs.getString("level_a_fg"),
        				rs.getString("level_a_bg"),
        				rs.getString("level_aa_fg"),
        				rs.getString("level_aa_bg"),
        				rs.getString("level_f_fg"),
        				rs.getString("level_f_bg"),
        				rs.getInt("darker")
        				);
        	} else {
        		initAuftragsConfig.executeUpdate();
        		final ResultSet rs1 = getAuftragConfig.executeQuery();
        		if(rs1.next()) {
	        		auftragConfig=new AuftragConfigItem(
	        				rz,
	        				rs1.getInt("id"),
	        				rs1.getInt("level_0_value"),
	        				rs1.getString("level_0_fg"),
	        				rs1.getString("level_0_bg"),
	        				rs1.getInt("level_1_value"),
	        				rs1.getString("level_1_fg"),
	        				rs1.getString("level_1_bg"),
	        				rs1.getInt("level_2_value"),
	        				rs1.getString("level_2_fg"),
	        				rs1.getString("level_2_bg"),
	        				rs1.getInt("level_3_value"),
	        				rs1.getString("level_3_fg"),
	        				rs1.getString("level_3_bg"),
	        				rs1.getString("level_e_fg"),
	        				rs1.getString("level_e_bg"),
	        				rs1.getString("level_a_fg"),
	        				rs1.getString("level_a_bg"),
	        				rs1.getString("level_aa_fg"),
	        				rs1.getString("level_aa_bg"),
	        				rs.getString("level_f_fg"),
	        				rs.getString("level_f_bg"),
	        				rs1.getInt("darker")
	        				);
        		}
        	}

        }catch (final Exception e){
               rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.refreshAuftraege", e.getLocalizedMessage());
        }
    }

    public AuftragConfigItem getAuftragsConfig() {
    	return auftragConfig;
    }
    
    public void saveAuftragsConfig() {
    	try {
    		saveAuftragConfig.setInt(1, auftragConfig.getLevel0Value());
    		saveAuftragConfig.setString(2, auftragConfig.getLevel0Vg());    	
    		saveAuftragConfig.setString(3, auftragConfig.getLevel0Hg());
    		
    		saveAuftragConfig.setInt(4, auftragConfig.getLevel1Value());
    		saveAuftragConfig.setString(5, auftragConfig.getLevel1Vg());    	
    		saveAuftragConfig.setString(6, auftragConfig.getLevel1Hg());
    		
    		saveAuftragConfig.setInt(7, auftragConfig.getLevel2Value());
    		saveAuftragConfig.setString(8, auftragConfig.getLevel2Vg());    	
    		saveAuftragConfig.setString(9, auftragConfig.getLevel2Hg());
    		
    		saveAuftragConfig.setInt(10, auftragConfig.getLevel3Value());
    		saveAuftragConfig.setString(11, auftragConfig.getLevel3Vg());    	
    		saveAuftragConfig.setString(12, auftragConfig.getLevel3Hg());
    		
    		saveAuftragConfig.setString(13, auftragConfig.getLevelEVg());    	
    		saveAuftragConfig.setString(14, auftragConfig.getLevelEHg());
    		
    		saveAuftragConfig.setString(15, auftragConfig.getLevelAVg());    	
    		saveAuftragConfig.setString(16, auftragConfig.getLevelAHg());

    		saveAuftragConfig.setString(17, auftragConfig.getLevelAAVg());
    		saveAuftragConfig.setString(18, auftragConfig.getLevelAAHg());    		

    		saveAuftragConfig.setString(19, auftragConfig.getLevelFvg());    	
    		saveAuftragConfig.setString(20, auftragConfig.getLevelFhg());
    		
    		saveAuftragConfig.setInt(21, auftragConfig.getDarker());
    		
    		saveAuftragConfig.executeUpdate();
    		init();
    	}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAuftrag.saveAuftragConfig", e.getLocalizedMessage());
    	}
    }

}
