package de.lunqual.rzpro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.JComboBox;

import java.sql.Statement;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.bewertungen.BewertungsAbfrageItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsKategorieItem;
import de.lunqual.rzpro.items.bewertungen.BewertungenColorItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsListe;
import de.lunqual.rzpro.items.bewertungen.BewertungsShortItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsValueItem;
import de.lunqual.rzpro.items.bewertungen.KategorieItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.mischungen.MischungsAbfrageItem;
import de.lunqual.rzpro.log.LogFactory;

public class DBBewertungen {
		RzPro          						rz;
	    Connection      					con;
	    DBFactory       					db;
	    BewertungenColorItem				colors;
	    ArrayList<BewertungsValueItem >  	bewertungsValues;
	    ArrayList<BewertungsValueItem >  	bewertungsUnterkategorienValues;
	    
	    public static double				MAX_BEWERTUNG = 5.0;
	    public static double				BEWERTUNG_INVALID = -1;
	    
		public static final String			LISTENTRENNER = "===";

	    
	    PreparedStatement	getKategorien;
	    PreparedStatement	saveKategorie;
	    PreparedStatement	updateKategorie;
	    PreparedStatement	deleteKategorie;
	    PreparedStatement	getKategorie;
	    PreparedStatement	getColorItem;
	    PreparedStatement updateColorItem;
	    PreparedStatement	isBewertetLosnummer;
	    PreparedStatement	getKategorienBewertung;
	    
	    PreparedStatement 	saveBewertung;
	    PreparedStatement	updateBewertung;
	    PreparedStatement	saveKategorieBlock;
	    PreparedStatement	updateKategorieBlock;
	    
	    PreparedStatement	getBewertungValue;
	    PreparedStatement	getBewertung;
	    
	    PreparedStatement  deleteBewertung;
	    PreparedStatement	 deleteBewertungBlock;
	    
	    PreparedStatement	getTextbausteine;
	    PreparedStatement updateTextbausteine;
	    
	    public DBBewertungen(RzPro r, DBFactory aDb, Connection aCon) {
	        rz = r;
	        db = aDb;
	        con = aCon;
	        setStatements();
	        readColorItem();
	        getValueItems();
	    }
	    
	    private void setStatements(){
	        try{
	        	getKategorie	    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_BEWERTUNGEN_KATEGORIEN + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
	        	getKategorien   	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_BEWERTUNGEN_KATEGORIEN + " ORDER BY id asc",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
	            deleteKategorie    	= con.prepareStatement("DELETE FROM " +DBFactory.TABLE_BEWERTUNGEN_KATEGORIEN + "  WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
	            saveKategorie    	= con.prepareStatement("INSERT INTO " +DBFactory.TABLE_BEWERTUNGEN_KATEGORIEN + 
	            		" (bezeichnung,gewichtung,unterkategorien,erstellt,erstellt_user,geaendert,geaendert_user) VALUES (?,?,?,?,?,?,?)  ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
	            updateKategorie    	= con.prepareStatement("UPDATE " +DBFactory.TABLE_BEWERTUNGEN_KATEGORIEN + 
	            		" set bezeichnung=?,gewichtung=?,unterkategorien=?,erstellt=?,erstellt_user=?,geaendert=?,geaendert_user=? WHERE id=?  ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
	        	getColorItem	    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_BEWERTUNGEN_DEFAULTS + " WHERE id=1",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
	            updateColorItem    	= con.prepareStatement("UPDATE " +DBFactory.TABLE_BEWERTUNGEN_DEFAULTS + 
	            		" set gold_text=?,gold_value=?,gold_fg=?,gold_bg=?,silber_text=?,silber_value=?,silber_fg=?,silber_bg=?,bronze_text=?,bronze_value=?,bronze_fg=?,bronze_bg=?,none_text=?,none_fg=?,none_bg=? WHERE id=1  ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
	        	isBewertetLosnummer	    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_BEWERTUNGEN + " WHERE losnummer=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
	        	getKategorienBewertung  = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_BEWERTUNGEN_BLOCK + " WHERE bewertung=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
	        	
	        	saveBewertung    		= con.prepareStatement("INSERT INTO " +DBFactory.TABLE_BEWERTUNGEN + " (bezeichnung,losnummer,bewertung,comment,erstellt,erstellt_user,geaendert,geaendert_user,kontrolle,kontrolle_datum) VALUES (?,?,?,?,?,?,?,?,?,?)  ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
	        	updateBewertung	= con.prepareStatement("UPDATE " +DBFactory.TABLE_BEWERTUNGEN + " set bezeichnung=?,losnummer=?,bewertung=?,comment=?,erstellt=?,erstellt_user=?,geaendert=?,geaendert_user=?,kontrolle=?,kontrolle_datum=? WHERE id=?  ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);

	        	saveKategorieBlock		= con.prepareStatement("INSERT INTO " +DBFactory.TABLE_BEWERTUNGEN_BLOCK + " (bewertung,bezeichnung,gewichtung,punkte,bewertungsliste,comment) VALUES (?,?,?,?,?,?)  ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
	        	updateKategorieBlock	= con.prepareStatement("UPDATE " +DBFactory.TABLE_BEWERTUNGEN_BLOCK + " set bewertung=?,bezeichnung=?,gewichtung=?,punkte=?,bewertungsliste=?,comment=?  WHERE id=?  ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);

	        	getBewertungValue	    = con.prepareStatement("SELECT bewertung FROM " +DBFactory.TABLE_BEWERTUNGEN + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
	        	
	        	getBewertung		    = con.prepareStatement("SELECT bewertungen.id,bewertungen_block.id,bewertungen.bezeichnung,bewertungen.losnummer,bewertungen.bewertung,bewertungen.comment, " +
	        			"bewertungen_block.bewertung,bewertungen_block.bezeichnung,bewertungen_block.gewichtung,bewertungen_block.punkte,bewertungen_block.bewertungsliste,bewertungen_block.comment, " +
	        			" bewertungen.erstellt,bewertungen.erstellt_user,bewertungen.geaendert,bewertungen.geaendert_user,bewertungen.kontrolle,bewertungen.kontrolle_datum " +
	        			" FROM " +DBFactory.TABLE_BEWERTUNGEN + " left join " + DBFactory.TABLE_BEWERTUNGEN_BLOCK + " on bewertungen.id = bewertungen_block.bewertung WHERE bewertungen.id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
	        	
	            deleteBewertung    		= con.prepareStatement("DELETE FROM " +DBFactory.TABLE_BEWERTUNGEN + "  WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
	            deleteBewertungBlock    = con.prepareStatement("DELETE FROM " +DBFactory.TABLE_BEWERTUNGEN_BLOCK + "  WHERE bewertung=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
	            
	        	getTextbausteine	    = con.prepareStatement("SELECT bausteine FROM " +DBFactory.TABLE_BEWERTUNGEN_DEFAULTS ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
	        	updateTextbausteine   = con.prepareStatement("UPDATE " +DBFactory.TABLE_BEWERTUNGEN_DEFAULTS + " set bausteine=?  ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
	        	
	        }
	        catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.setStatements", e.getLocalizedMessage());
	        }
	    }
	    
	    private void getValueItems() {
	    	bewertungsValues = new ArrayList<BewertungsValueItem>();
	    	bewertungsValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_novalue"),-1));
	    	bewertungsValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_5"),5));
	    	bewertungsValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_45"),4.5));
	    	bewertungsValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_4"),4));
	    	bewertungsValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_35"),3.5));
	    	bewertungsValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_3"),3));
	    	bewertungsValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_25"),2.5));
	    	bewertungsValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_2"),2));
	    	bewertungsValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_15"),1.5));
	    	bewertungsValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_1"),1));
	    	bewertungsValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_05"),0.5));
	    	bewertungsValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_00"),0));
	    	
	    	bewertungsUnterkategorienValues = new ArrayList<BewertungsValueItem>();
	    	bewertungsUnterkategorienValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_novalue"),-1));
	    	bewertungsUnterkategorienValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_45"),4.5));
	    	bewertungsUnterkategorienValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_4"),4));
	    	bewertungsUnterkategorienValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_35"),3.5));
	    	bewertungsUnterkategorienValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_3"),3));
	    	bewertungsUnterkategorienValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_25"),2.5));
	    	bewertungsUnterkategorienValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_2"),2));
	    	bewertungsUnterkategorienValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_15"),1.5));
	    	bewertungsUnterkategorienValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_1"),1));
	    	bewertungsUnterkategorienValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_05"),0.5));
	    	bewertungsUnterkategorienValues.add(new BewertungsValueItem(rz.getLocale().getString("dbbwertungen.cmb_00"),0));
	    }
	    public void setBewertungenCmb(JComboBox cmb) {
	    	cmb.removeAll();
	    	for(BewertungsValueItem bvi:bewertungsValues) {
	    		cmb.addItem(bvi);
	    	}
	    }

	    public void setBewertungenUnterkategorienCmb(JComboBox cmb) {
	    	cmb.removeAll();
	    	for(BewertungsValueItem bvi:bewertungsUnterkategorienValues) {
	    		cmb.addItem(bvi);
	    	}
	    }
	    
	    public BewertungsValueItem getValueItemFromDouble(double value) {
	    	for(BewertungsValueItem bvi:bewertungsValues) {
	    		if(rz.isZero(bvi.getBewertung()-value)) {
	    			return bvi;
	    		}
	    	}
	    	return bewertungsValues.get(0);
	    }

	    public BewertungsValueItem getUnterkategorieValueItemFromDouble(double value) {
	    	for(BewertungsValueItem bvi:bewertungsUnterkategorienValues) {
	    		if(rz.isZero(bvi.getBewertung()-value)) {
	    			return bvi;
	    		}
	    	}
	    	return bewertungsUnterkategorienValues.get(0);
	    }
	    
	    private void readColorItem() {
	    	try {
	    		final ResultSet rs = getColorItem.executeQuery();
	    		if(rs.next()) {
	    			colors = new BewertungenColorItem(rz,
	    					rs.getString("gold_text"),
	    					rs.getDouble("gold_value"),
	    					rs.getString("gold_fg"),
	    					rs.getString("gold_bg"),
	    					rs.getString("silber_text"),
	    					rs.getDouble("silber_value"),
	    					rs.getString("silber_fg"),
	    					rs.getString("silber_bg"),
	    					rs.getString("bronze_text"),
	    					rs.getDouble("bronze_value"),
	    					rs.getString("bronze_fg"),
	    					rs.getString("bronze_bg"),
	    					rs.getString("none_text"),
	    					rs.getString("none_fg"),
	    					rs.getString("none_bg")
	    					);
	    		}
	    	}
	    	catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.readcolorItem", e.getLocalizedMessage());
	        }
	    }
	    
	    public void updateColorItem() {
	    	try {
	    		updateColorItem.setString(1,colors.getGold_text());
	    		updateColorItem.setDouble(2, colors.getGold_value());
	    		updateColorItem.setString(3, colors.getGold_fg());
	    		updateColorItem.setString(4, colors.getGold_bg());
	    		updateColorItem.setString(5,colors.getSilber_text());
	    		updateColorItem.setDouble(6, colors.getSilber_value());
	    		updateColorItem.setString(7, colors.getSilber_fg());
	    		updateColorItem.setString(8, colors.getSilber_bg());
	    		updateColorItem.setString(9,colors.getBronze_text());
	    		updateColorItem.setDouble(10, colors.getBronze_value());
	    		updateColorItem.setString(11, colors.getBronze_fg());
	    		updateColorItem.setString(12, colors.getBronze_bg());
	    		updateColorItem.setString(13,colors.getNone_text());
	    		updateColorItem.setString(14, colors.getNone_fg());
	    		updateColorItem.setString(15, colors.getNone_bg());
	    		updateColorItem.executeUpdate();
	    	}
	    	catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.updatecolorItem", e.getLocalizedMessage());
	        }
	    }
	    
	    public String getTextbausteine() {
	    	String ret = "";
	    	try {
	    		final ResultSet rs = getTextbausteine.executeQuery();
	    		if(rs.next()) {
	    			ret = rs.getString("bausteine");
	    		}
	    	}
	    	catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.gettextbausteine", e.getLocalizedMessage());
	        }
	    	return ret;
	    }
	    
	    public void updateTextbausteine(String bausteine) {
	    	try {
	    		updateTextbausteine.setString(1, bausteine);
	    		updateTextbausteine.executeUpdate();
	    	}
	    	catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.updateTextbausteine", e.getLocalizedMessage());
	        }
	    }
	    
	    public void setTextbausteinCmb(JComboBox cmb) {
	    	cmb.removeAll();
	    	String b = getTextbausteine();
	    	String[] bausteine = b.split("\\n");
	    	for(String b1:bausteine) {
	    		cmb.addItem(b1);
	    	}
	    }
	    
	    public BewertungenColorItem getColorItem() {
	    	return colors;
	    }
	    
	    public  int isBewertetLosnummer(String losnummer) {
	    	int ret = 0;
	    	try {
	    		isBewertetLosnummer.setString(1,losnummer.trim());
	    		final ResultSet rs = isBewertetLosnummer.executeQuery();
	    		if(rs.next()) {
	    			ret = rs.getInt("id");
	    		}
	    	}
	    	catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.isBewertetLosnummer", e.getLocalizedMessage());
	        }
	    	return ret;
	    }
	    
	    public void deleteKategorie(int id) {
	    	try {
	    		deleteKategorie.setInt(1,id);
	    		deleteKategorie.executeUpdate();
	    	}
	    	catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.deleteKategorie", e.getLocalizedMessage());
	        }
	    }
	    
	    public BewertungsKategorieItem getKategorie(int id) {
	    	BewertungsKategorieItem ret = null;
	    	try {
	    		if(id == 0) {
	    			 ret = new BewertungsKategorieItem(
	    					 rz,
	    					 0,
	    					 rz.getLocale().getString("dbbewertungen.kategorie_neu"),
	    					 1,
	    					 "",
	    					 db.getServerTimestamp(),
	    					 db.dbGetUser(),
	    					 db.getServerTimestamp(),
	    					 db.dbGetUser()
	    					 );
	    		}else {
	    			getKategorie.setInt(1,id);
		    		final ResultSet rs = getKategorie.executeQuery();
		    		if(rs.next()) {
		    			ret = getKategorieFromRS(rs);
		    		}
	    		}
	    	}
	    	catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.getKategorien", e.getLocalizedMessage());
	        }
	    	return ret;
	    }

	    public ArrayList<KategorieItem> getDefaultKategorien(){
	    	ArrayList<KategorieItem> ret = new ArrayList<KategorieItem>();
	    	ArrayList<BewertungsKategorieItem> liste = getKategorien();
	    	for(BewertungsKategorieItem bki:liste) {
	    		ret.add(new KategorieItem(rz,0,bki.getBezeichnung(),bki.getGewichtung(),-1,bki.getRawListe()));
	    	}
	    	return ret;
	    }
	    
	    public BewertungsItem getBewertung(String losnummer,String bezeichnung) {
	    	BewertungsItem ret = null;
	    	try {
	    		if(!losnummer.trim().equals("")) {
		    		int id = isBewertetLosnummer(losnummer.trim());
		    		if(id == 0) {
		    			ret = new BewertungsItem(
		    					rz,
		    					0,
		    					bezeichnung,
		    					losnummer,
		    					0.0,
		    					"",
		    					db.getServerTimestamp(),
		    					db.dbGetUser(),
		    					db.getServerTimestamp(),
		    					db.dbGetUser(),
		    					"",
		    					db.getServerTimestamp()
		    					);
		    		}else {
		    			ret = getBewertung(id);
		    		}
	    		}else {
	    			ret = new BewertungsItem(
	    					rz,
	    					0,
	    					bezeichnung,
	    					"",
	    					0.0,
	    					"",
	    					db.getServerTimestamp(),
	    					db.dbGetUser(),
	    					db.getServerTimestamp(),
	    					db.dbGetUser(),
	    					"",
	    					db.getServerTimestamp()
	    					);
	    		}
	    	}
	    	catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.getBewertung", e.getLocalizedMessage());
	        }
	    	return ret;
	    }
	    
	    
	    public String getBewertungsLink(String losnummer,String bezeichnung,boolean kurz) {
	    	String ret = "";
	    	if(losnummer != null && !losnummer.equals("")) {
	    		int n =isBewertetLosnummer(losnummer);
	    		if(n != 0) {
	    			BewertungsItem bwi = getBewertung(n);
    				ret += bwi.getLink();
	    		} else {
	    			ret += rz.getLocale().getString("dbbewertungen.nicht_bewertet");
	    		}
	    	    if(!kurz)ret += "&nbsp;<a href=\"bwe:" + String.valueOf(n) + "&"+ losnummer + "&" + bezeichnung.replaceAll("\"", "")+ "\">" + rz.getLocale().getString("ausgabe.bewertungen_bearbeiten") + rz.getAusgabeFactory().insertGfx("herstellfenster.bewertungen_edit.png")  +"</a>" ;
	    	}
	    	return ret;
	    }
	    /*
	     * 
	     * 
	     * BewertungsKategien
	     */
	    
	    public double getBewertungValue(int id) {
	    	double ret = -1.0;
	    	try {
		    	if(id != 0) {
		    		getBewertungValue.setInt(1, id);
		    		final ResultSet rs = getBewertungValue.executeQuery();
		    		if(rs.next()) {
		    			ret = rs.getDouble("bewertung");
		    		}
		    	}
	    	}
	    	catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.getBewertungValue", e.getLocalizedMessage());
	        }
	    	return ret;
	    }
	    
	    public ArrayList<BewertungsKategorieItem> getKategorien(){
	    	ArrayList<BewertungsKategorieItem> ret = new ArrayList<BewertungsKategorieItem>();
	    	try {
	    		final ResultSet rs = getKategorien.executeQuery();
	    		while(rs.next()) {
	    			ret.add(getKategorieFromRS(rs));
	    		}
	    	}
	    	catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.getKategorien", e.getLocalizedMessage());
	        }
	    	return ret;
	    }
	    
	    private BewertungsKategorieItem getKategorieFromRS(ResultSet rs) {
	    	try {
	    		return(new BewertungsKategorieItem(
	    				rz,
	    				rs.getInt("id"),
	    				rs.getString("bezeichnung"),
	    				rs.getDouble("gewichtung"),
	    				rs.getString("unterkategorien"),
	    				db.getDateFromString(rs.getString("erstellt")),
	    				rs.getString("erstellt_user"),
	    				db.getDateFromString(rs.getString("geaendert")),
	    				rs.getString("geaendert_user")
	    			));
	    		
	    	}
	    	catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.getKategorieFromRS", e.getLocalizedMessage());
	        }
	    	return null;
	    }
	    
	    public int saveKategorie(BewertungsKategorieItem bki) {
	    	int ret = 0;
	    	try {
	    		PreparedStatement stm = null;
	    		if(bki.getId() == 0) {
	    			stm = saveKategorie;
	    		}else {
	    			stm = updateKategorie;
	    			stm.setInt(8, bki.getId());
	    		}
	    		stm.setString(1, bki.getBezeichnung());
	    		stm.setDouble(2, bki.getGewichtung());
	    		stm.setString(3, bki.getRawListe());
	    		stm.setString(4, db.dbGetDateFormatString(bki.getErstellt()));
	    		stm.setString(5, bki.getErstellt_user());
	    		stm.setString(6, db.dbGetDateFormatString(db.getServerTimestamp()));
	    		stm.setString(7,db.dbGetUser());
	    		stm.executeUpdate();
	    		if(bki.getId() == 0) {
	    			bki.setId(db.dbGetLastInsertID(DBFactory.TABLE_BEWERTUNGEN_KATEGORIEN));
	    		}
	    		ret = bki.getId();
	    	}
	    	catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.saveKategorie", e.getLocalizedMessage());
	        }
	    	
	    	return ret;
	    }
	    
	    private String getBewertungenWhereClause(BewertungsAbfrageItem bai) {
	    	String ret = "";
	    	switch(bai.getDateMode()) {
	    		case MischungsAbfrageItem.DATE_NONE:
	    			break;
	    		case MischungsAbfrageItem.DATE_ERSTELLT:
	    			ret += " erstellt BETWEEN '" + String.valueOf(bai.getVonJahr()) + "-" + String.valueOf(bai.getVonMonat()+1) + "-" + String.valueOf(bai.getVonTag()) +
	    				" 0:00:00' AND '" + String.valueOf(bai.getBisJahr()) + "-" + String.valueOf(bai.getBisMonat()+1) + "-" + String.valueOf(bai.getBisTag()) + " 23:59:59' AND";
	    			break;
	    		case MischungsAbfrageItem.DATE_GEAENDERT:
	    			ret += " geaendert BETWEEN '" + String.valueOf(bai.getVonJahr()) + "-" + String.valueOf(bai.getVonMonat()+1) + "-" + String.valueOf(bai.getVonTag()) +
	    				" 0:00:00' AND '" + String.valueOf(bai.getBisJahr()) + "-" + String.valueOf(bai.getBisMonat()+1) + "-" + String.valueOf(bai.getBisTag()) + " 23:59:59' AND";
	    			break;
	    	}
	    	if(!bai.getMischungNummer().equals("")) {
	    		ret += " id IN(";
	    		String[] liste = bai.getMischungNummer().split(" |,|;");
	    		for(String item:liste) {
	    			if(!item.trim().equals("")) {
	    				ret += item + ",";
	    			}
	    		}
	    		if(ret.endsWith(","))ret = ret.substring(0,ret.length()-1);
	    		ret += ") AND";
	    	}
	    	if(!bai.getMischungBezeichnung().equals("")) {
	    		ret += " bezeichnung regexp '" + bai.getMischungBezeichnung().trim().replaceAll("\\s+", ".*") + "' AND"; 
	    				
	    	}
	    	if(!bai.getLosnummer().equals("")) {
	    		ret += " losnummer regexp '" + bai.getLosnummer().trim() + "' AND";
	    	}
	    	if(ret.endsWith("AND"))ret = ret.substring(0, ret.length()-3);
	    	return !ret.trim().equals("")?"WHERE " + ret:"";
	    }
	    
	    public BewertungsListe getBewertungen(BewertungsAbfrageItem bai) {
	    	BewertungsListe ret = new BewertungsListe(rz);
	    	try {
	    		Statement stm=null;
	    		if(bai != null) {
	                stm = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
	    			String sql = "SELECT * FROM " +DBFactory.TABLE_BEWERTUNGEN + " ";
	    			sql += getBewertungenWhereClause(bai) + " ORDER BY id ASC";
	    			final ResultSet rs = stm.executeQuery(sql);
	    			while(rs.next()) {
	    				ret.addItem(getBewertungFromRS(rs));
	    			}
	    		}
	    	}catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.getbewertungen", e.getLocalizedMessage());
	        }
	    	return ret;
	    }

	    private BewertungsShortItem getBewertungFromRS(ResultSet rs) {
	    	BewertungsShortItem ret = null;
	    	try {
	    		ret = new BewertungsShortItem(
	    				rz,
	    				rs.getInt("id"),
	    				rs.getString("bezeichnung"),
	    				rs.getString("losnummer"),
	    				rs.getDouble("bewertung"),
	    				rs.getString("comment"),
	    				db.getDateFromString(rs.getString("erstellt")),
	    				rs.getString("erstellt_user"),
	    				db.getDateFromString(rs.getString("geaendert")),
	    				rs.getString("geaendert_user")
	    				);
	    	}catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.getbewertungFromRS", e.getLocalizedMessage());
	        }
	    	return ret;
	    }
	    
	    /*
	     * 
	     * Bewertungen get/save/update/delete
	     */

	    
	    public void saveBewertungFromHerstellung(BewertungsItem bwi) {
	    		if(bwi.getLosnummer()!= null && !bwi.getLosnummer().trim().equals("")) {
	    			saveBewertung(bwi);
	    		}
	    }
	    
	    public void deleteBewertung(int i) {
	    	try {
		    	if(i != 0) {
		    		BewertungsItem bwi = getBewertung(i);
		    		if(bwi != null) {
		    			DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
		      	       	dlgItem.setTyp(DialogControl.FRAGE_DIALOG);
		                dlgItem.setCaption(rz.getLocale().getString("dbbewertung.delete_bewertung"));
		                dlgItem.setTitel(rz.getLocale().getString("dbbewertung.delete_bewertung"));
		                dlgItem.setMessage(rz.getLocale().getString("dbbwertung.delete_bewertung.message")
		                		.replaceAll("%i", String.valueOf(bwi.getId()))
		                		.replaceAll("%b", bwi.getBezeichnung())
		                		.replaceAll("%l", bwi.getLosnummer())
		                		);
		                dlgItem.setIcon("frage.png");
		                dlgItem.setOk(rz.getLocale().getString("string_ja"));
		                dlgItem.setCancel(rz.getLocale().getString("string_nein"));
		                rz.getDialogFactory().getDialog(dlgItem);
		                if((dlgItem.getReplyCode() == DialogControl.DIALOG_OK) || (dlgItem.getReplyCode()==DialogControl.DIALOG_YES)) {
			    			con.setAutoCommit(false);
			    			deleteBewertungBlock.setInt(1,bwi.getId());
			    			deleteBewertungBlock.executeUpdate();
			    			deleteBewertung.setInt(1, bwi.getId());
			    			deleteBewertung.executeUpdate();
			    			con.commit();
		                }
		    		}
		    	}
	    	}catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.deletebewertung", e.getLocalizedMessage());
	            try {
	            	con.rollback();
	            }catch(Exception e1) {}
	        }
	    	try {
	    		con.setAutoCommit(true);
	    	}catch(Exception e1) {}
	    }
	    
	    public BewertungsItem getBewertung(int id) {
	    	BewertungsItem bi = null;
	    	try {
	    		getBewertung.setInt(1, id);
	    		final ResultSet rs = getBewertung.executeQuery();
    			bi = new BewertungsItem(rz);
	    		while(rs.next()) {
	    			bi.setId(rs.getInt("bewertungen.id"));
	    			bi.setBezeichnung(rs.getString("bewertungen.bezeichnung"));
	    			bi.setLosnummer(rs.getString("bewertungen.losnummer"));
	    			bi.setComment(rs.getString("bewertungen.comment"));
	    			bi.setBewertung(rs.getDouble("bewertungen.bewertung"));
	    			bi.setErstellt(db.getDateFromString(rs.getString("bewertungen.erstellt")));
	    			bi.setErstellt_user(rs.getString("bewertungen.erstellt_user"));
	    			bi.setGeaendert(db.getDateFromString(rs.getString("bewertungen.geaendert")));
	    			bi.setGeaendert_user(rs.getString("bewertungen.geaendert_user"));
	    			bi.getKategorienListe().add(new KategorieItem(
	    					rz,
	    					rs.getInt("bewertungen_block.id"),
	    					rs.getString("bewertungen_block.bezeichnung"),
	    					rs.getDouble("bewertungen_block.gewichtung"),
	    					rs.getDouble("bewertungen_block.punkte"),
	    					rs.getString("bewertungen_block.bewertungsliste")
	    					));
	    			bi.setKontrolle(rs.getString("bewertungen.kontrolle"));
	    			bi.setKontrolle_datum(db.getDateFromString(rs.getString("bewertungen.kontrolle_datum")));
	    		}
	    	}catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.getBewertung(bi)", e.getLocalizedMessage());
	        }
	    	
	    	return bi;
	    }
	    
	    private boolean saveBewertungenBlock(KategorieItem ki,int bewertung){
	    	boolean ret = true;
	    	try {
	    		PreparedStatement stm = null;
	    		if(bewertung != 0) {
	    			if(ki.getId() == 0) {
	    				stm = saveKategorieBlock;
	    			}else {
	    				stm = updateKategorieBlock;
	    				stm.setInt(7, ki.getId());
	    			}
	    			stm.setInt(1,bewertung);
	    			stm.setString(2,ki.getBezeichnung());
	    			stm.setDouble(3, ki.getGewichtung());
	    			stm.setDouble(4, ki.getBewertung());
	    			stm.setString(5, ki.getOriginalListe().getErgebnisseListe());
	    			stm.setString(6, "");
	    			int r = stm.executeUpdate();
	    			if(r > 0) {
	    				ki.setId(db.dbGetLastInsertID(DBFactory.TABLE_BEWERTUNGEN));
	    			} else {
	    				ret = false;
	    			}
	    		}else {
	    			ret = false;
	    		}
	    	}catch(final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.saveBewertungenBlock(ki)", e.getLocalizedMessage());
	            ret = false;
	    	}
	    	return ret;
	    }
	    
	    public int saveBewertung(BewertungsItem bi) {
	    	int ret = 0;
	    	Date now = new Date();
	    	PreparedStatement stm = null;
	    	try {
	    		if(bi != null) {
	    			if(bi.getId() == 0) {
	    				stm = saveBewertung;
		    			stm.setString(5,db.dbGetDateFormatString(now));
		    			stm.setString(6,db.dbGetUser());
		    			stm.setString(7,db.dbGetDateFormatString(now));
		    			stm.setString(8,db.dbGetUser());
		    			stm.setString(9, bi.getKontrolle());
		    			stm.setString(10, db.dbGetDateFormatString(bi.getKontrolle_datum()));
		    			
	    			}else {
	    				stm = updateBewertung;
		    			stm.setString(5, db.dbGetDateFormatString(bi.getErstellt()));
		    			stm.setString(6, bi.getErstellt_user());
		    			stm.setString(7, db.dbGetDateFormatString(now));
		    			stm.setString(8,db.dbGetUser());
		    			stm.setString(9, bi.getKontrolle());
		    			stm.setString(10, db.dbGetDateFormatString(bi.getKontrolle_datum()));
	    				stm.setInt(11, bi.getId());
	    			}
	    			stm.setString(1,bi.getBezeichnung().trim());
	    			stm.setString(2, bi.getLosnummer().trim());
	    			stm.setDouble(3, bi.getBewertung());
	    			stm.setString(4, bi.getComment().trim());
	    			con.setAutoCommit(false);
	    			int v =stm.executeUpdate();
	    			if(v > 0) {
		    			if(bi.getId() == 0) {
		    				ret = db.dbGetLastInsertID(DBFactory.TABLE_BEWERTUNGEN);
		    				bi.setId(ret);
		    			} else {
		    				ret = bi.getId();
		    			}
		    			for(KategorieItem ki:bi.getKategorienListe()) {
		    				if(!saveBewertungenBlock(ki,bi.getId())) {
		    					ret = 0;
		    					con.rollback();
		    					break;
		    				}
		    			}
	    			}
	    		}
	    	
	    	}catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBewertungen.saveBewertung(bi)", e.getLocalizedMessage());
	        }
	    	try {
	    		con.setAutoCommit(true);
	    	} catch(Exception e1) {}
	    	return ret;
	    }
	    
}
