/*
 *  Copyright (C) database.stichwort_loeschen4 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.container.ContainerItem;
import de.lunqual.rzpro.items.container.ContainerListe;
import de.lunqual.rzpro.items.container.ContainerOrdnerItem;
import de.lunqual.rzpro.items.container.ContainerOrdnerListe;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.log.LogFactory;

/**
 *
 * @author  lunqual
 */
public class DBContainer {

    RzPro           				rz;
    Connection      			con;
    DBFactory       			db;

    PreparedStatement    getOrdnerListe;
    PreparedStatement		getOrdner;
    PreparedStatement   	getContainerListe;
    PreparedStatement   	getContainerListeAdresse;
    PreparedStatement   	getContainerListeOut;
    PreparedStatement   	getContainerListeAdresseOut;
    PreparedStatement   	getContainer;
    PreparedStatement   	setContainerOut;
    PreparedStatement		getContainerString;
    PreparedStatement	    checkOrdnerExist;
    PreparedStatement		saveOrdner;
    PreparedStatement		updateOrdner;
    PreparedStatement		deleteOrdner;
    PreparedStatement   	saveContainer;
    PreparedStatement   	updateContainer;
    PreparedStatement   	deleteContainer;
    PreparedStatement    	checkContainerExist;
    PreparedStatement    	checkOrdnerContents;
    PreparedStatement    	getExtendedData;
    PreparedStatement		setOut;
    PreparedStatement 		getStatus;
    PreparedStatement		setStatusNummer;

    CurrencyItem		   	euro;
    DialogItem					dlgItem;
    /** Creates a new instance of DBCurrency */
    public DBContainer(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
    }

    private void setStatements(){
        try{
            getContainerListe   = con.prepareStatement("SELECT  lieferschein.geaendert,container.ordner,container.erstellt,container.geaendert,container.user_1,container.user_2,container.bezeichnung,container.tara,container.comment,container.id,container.c_out,container.comment,container.ordner,container.bezeichnung,lieferschein.geaendert as letztesDatum,lieferschein_zeile.containerS,lieferschein_zeile.bezeichnung,lieferschein_zeile.losnummer,lieferschein.adresse_string from container left join lieferschein_zeile on container.bezeichnung = lieferschein_zeile.containerS left join lieferschein on lieferschein.id = lieferschein_zeile.lieferschein where container.ordner regexp ?  order by container.nummer asc;",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getContainerListeAdresse   = con.prepareStatement("SELECT  lieferschein.geaendert,container.ordner,container.erstellt,container.geaendert,container.user_1,container.user_2,container.bezeichnung,container.tara,container.comment,container.id,container.c_out,container.comment,container.ordner,container.bezeichnung,lieferschein.geaendert as letztesDatum,lieferschein_zeile.containerS,lieferschein_zeile.bezeichnung,lieferschein_zeile.losnummer,lieferschein.adresse_string from container left join lieferschein_zeile on container.bezeichnung = lieferschein_zeile.containerS left join lieferschein on lieferschein.id = lieferschein_zeile.lieferschein where container.ordner regexp ? and lieferschein.adresse_string regexp ?  order by container.nummer asc;",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getContainerListeAdresseOut   = con.prepareStatement("SELECT  lieferschein.geaendert,container.ordner,container.erstellt,container.geaendert,container.user_1,container.user_2,container.bezeichnung,container.tara,container.comment,container.id,container.c_out,container.comment,container.ordner,container.bezeichnung,lieferschein.geaendert as letztesDatum,lieferschein_zeile.containerS,lieferschein_zeile.bezeichnung,lieferschein_zeile.losnummer,lieferschein.adresse_string from container left join lieferschein_zeile on container.bezeichnung = lieferschein_zeile.containerS left join lieferschein on lieferschein.id = lieferschein_zeile.lieferschein where container.ordner regexp ? and lieferschein.adresse_string regexp ? and container.c_out = 1  order by container.nummer asc;",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getContainerListeOut   = con.prepareStatement("SELECT  lieferschein.geaendert,container.ordner,container.erstellt,container.geaendert,container.user_1,container.user_2,container.bezeichnung,container.tara,container.comment,container.id,container.c_out,container.comment,container.ordner,container.bezeichnung,lieferschein.geaendert as letztesDatum,lieferschein_zeile.containerS,lieferschein_zeile.bezeichnung,lieferschein_zeile.losnummer,lieferschein.adresse_string from container left join lieferschein_zeile on container.bezeichnung = lieferschein_zeile.containerS left join lieferschein on lieferschein.id = lieferschein_zeile.lieferschein where container.ordner regexp ? and container.c_out = 1  order by container.nummer asc;",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            getContainer   = con.prepareStatement("SELECT  lieferschein.geaendert,container.ordner,container.erstellt,container.geaendert,container.user_1,container.user_2,container.bezeichnung,container.tara,container.comment,container.id,container.c_out,container.comment,container.ordner,container.bezeichnung,lieferschein.geaendert as letztesDatum,lieferschein_zeile.containerS,lieferschein_zeile.bezeichnung,lieferschein_zeile.losnummer,lieferschein.adresse_string from container left join lieferschein_zeile on container.bezeichnung = lieferschein_zeile.containerS left join lieferschein on lieferschein.id = lieferschein_zeile.lieferschein where container.id=?  order by container.nummer asc;",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

           // getContainer          = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_CONTAINER + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getContainerString  = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_CONTAINER + " WHERE bezeichnung=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            updateContainer     = con.prepareStatement("UPDATE " + DBFactory.TABLE_CONTAINER + " SET ordner=?,bezeichnung=?,nummer=?,tara=?,comment=?,erstellt=?,geaendert=?,user_1=?,user_2=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            saveContainer        = con.prepareStatement("INSERT INTO " + DBFactory.TABLE_CONTAINER + " (ordner,bezeichnung,nummer,tara,comment,erstellt,geaendert,user_1,user_2) VALUES(?,?,?,?,?,?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteContainer      = con.prepareStatement("DELETE FROM " + DBFactory.TABLE_CONTAINER + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getOrdnerListe        = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_CONTAINER_ORDNER + " ORDER BY bezeichnung",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getOrdner              = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_CONTAINER_ORDNER + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            checkOrdnerContents = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_CONTAINER + " WHERE ordner=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            updateOrdner     = con.prepareStatement("UPDATE " + DBFactory.TABLE_CONTAINER_ORDNER + " SET id=?, bezeichnung=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            saveOrdner        = con.prepareStatement("INSERT INTO " + DBFactory.TABLE_CONTAINER_ORDNER + " (id,bezeichnung) VALUES(?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteOrdner      = con.prepareStatement("DELETE FROM " + DBFactory.TABLE_CONTAINER_ORDNER + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            checkContainerExist     = con.prepareStatement("SELECT bezeichnung FROM " + DBFactory.TABLE_CONTAINER + " WHERE bezeichnung=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            checkOrdnerExist     = con.prepareStatement("SELECT bezeichnung FROM " + DBFactory.TABLE_CONTAINER_ORDNER + " WHERE bezeichnung=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getExtendedData     = con.prepareStatement(" select lieferschein.id,lieferschein_zeile.bezeichnung,lieferschein.adresse_string,lieferschein.erstellt,lieferschein_zeile.containerS from  " + DBFactory.TABLE_LIEFERSCHEIN + "  left join " + DBFactory.TABLE_LIEFERSCHEIN_ZEILE + "  on lieferschein.id=lieferschein_zeile.lieferschein where  container=? order by erstellt desc limit 1",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            setOut        = con.prepareStatement("UPDATE " + DBFactory.TABLE_CONTAINER + " set c_out=? where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getStatus     = con.prepareStatement(" select c_out from  " + DBFactory.TABLE_CONTAINER + " WHERE nummer=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            setStatusNummer        = con.prepareStatement("UPDATE " + DBFactory.TABLE_CONTAINER + " set c_out=0 where nummer=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);

        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBBehaelter.setStatements", e.getLocalizedMessage());
        }
    }

    /**
     *
     */
    public int getStatus(int id) {
    	int ret = -1;
        try {
        	getStatus.setInt(1,id);
            final ResultSet rs = getStatus.executeQuery();
            while (rs.next()) {
            	ret=rs.getInt("c_out");
            }
        } catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.out",e.getLocalizedMessage());
            ret=-1;
        }
        return ret;
    }


    public void setStatusBack(int nummer) {
        try {
        	setStatusNummer.setInt(1,nummer);
            setStatusNummer.executeUpdate();

        } catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.setStatusNummer",e.getLocalizedMessage());
        }
    }

    /**
     *
     */
    public void setStatus(int id,int o) {
        try {
        	setOut.setInt(1,o);
            setOut.setInt(2,id);
            setOut.executeUpdate();

        } catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.out",e.getLocalizedMessage());
        }
    }

    /**
     * prüft ob der Ordner mit der Bezeichnung schon vorhanden ist
     * @param bezeichnung
     * @return true, wenn vorhanden
     */
    public boolean checkOrdnerExists(String bezeichnung) {
        boolean ret = false;
        try {
            checkOrdnerExist.setString(1,bezeichnung);
            final ResultSet rs = checkOrdnerExist.executeQuery();
            ret = rs.next();
            if(rs != null) {
				rs.close();
			}
        } catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.GetOrdner",e.getLocalizedMessage());
            ret = false;
        }
        return ret;
    }

    /**
     * prüft, ob ein ordner Behälter enthält
     * @param id    ordner, der geprüft werden soll
     */
    public boolean checkOrdnerContent(int id) {
        final String sid="<" + String.valueOf(id) + ">";
        boolean ret = true;
        try {
            checkOrdnerContents.setString(1,sid);
            final ResultSet rs = checkOrdnerContents.executeQuery();
            ret = rs.next();
            if(rs != null) {
				rs.close();
			}
        } catch (final SQLException e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.checkOrdnerContent",e.getLocalizedMessage());
            ret = true;
        }
        return ret;
    }
    public ContainerOrdnerItem getOrdner(int id) {
        try {
            if(id==0) {
                return (new ContainerOrdnerItem(0,rz.getLocale().getString("database.containerordner_neu")));
            }
			getOrdner.setInt(1,id);
			final ResultSet rs = getOrdner.executeQuery();
			if (rs.next()) {
			    return new ContainerOrdnerItem(rs.getInt("id"),rs.getString("bezeichnung"));
			}
        } catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.GetOrdner",e.getLocalizedMessage());
        }
        return null;
    }
    /** die Ordnerliste holen
     *
     * @author labor
     */
    public ContainerOrdnerListe getOrdnerListe() {
        final ContainerOrdnerListe bl = new ContainerOrdnerListe();
        try {
            final ResultSet rs = getOrdnerListe.executeQuery();
            while (rs.next()) {
                bl.addItem(new ContainerOrdnerItem(rs.getInt("id"),rs.getString("bezeichnung")));
            }
        } catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.GetOrdnerListe",e.getLocalizedMessage());
        }
        return bl;
    }

    /**
     * speichert einen neuen Containerordner oder
     * ändert einen Containerordner  in der Datenbank ab
     */
    public int saveOrdner(ContainerOrdnerItem ci){
        int ret = 0;
        PreparedStatement stm;
        try {
            if (ci.getID() == 0){
                stm = saveOrdner;
            }
            else
            {
                stm = updateOrdner;
                stm.setInt(3,ci.getID());
                if (!db.idExists(DBFactory.TABLE_CONTAINER_ORDNER,ci.getID(),true)) {
                	stm = saveOrdner;
                	ci.setId(0);
                }
            }
            stm.setInt(1,ci.getID());
            stm.setString(2,ci.getBezeichnung());
            stm.executeUpdate();
            if (ci.getID() == 0){
                ret = db.dbGetLastInsertID("container_ordner");
            } else {
				ret = ci.getID();
			}
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.SaveOrdner", e.getLocalizedMessage());
            ret = 0;
        }
        return ret;
    }

    public void deleteContainerOrdner(int id) {
        try {
            if(db.idExists(DBFactory.TABLE_CONTAINER_ORDNER,id,false)) {
                if(!checkOrdnerContent(id)) {
	                deleteOrdner.setInt(1,id);
	                deleteOrdner.executeUpdate();
                } else {
            		dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                    dlgItem.setCaption(rz.getLocale().getString("database.containerordner_in_use"));
                    dlgItem.setTitel(rz.getLocale().getString("database.containerordner_in_use"));
                    dlgItem.setMessage(rz.getLocale().getString("database.containerordner_in_use_message"));
                    dlgItem.setIcon("warnung.png");
                    dlgItem.setOk(rz.getLocale().getString("string_ok"));
                    rz.getDialogFactory().getDialog(dlgItem);
                }
            }
        } catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.GetContainerListe",e.getLocalizedMessage());
        }
    }

    public ContainerItem getContainerString(String c) {
        ContainerItem ci=null;
        try {
            getContainerString.setString(1,c);
            final ResultSet rs = getContainerString.executeQuery();
            if(rs.next()) {
                ci = getContainer(rs.getInt("id"),true);
            }
        } catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.GetContainerString",e.getLocalizedMessage());
        }
        return ci;
    }

    public ContainerItem getContainer(int id,boolean quiet) {
        ContainerItem ci=null;
        try {
            if(id == 0) {
                ci = new ContainerItem(
                		rz,
                        0,
                        0,
                        "<1>",
                        getOrdner(1).getBezeichnung(),
                        rz.getLocale().getString("database.container_neu"),
                        0.0,
                        "",
                        db.getServerTimestamp(),
                        db.getServerTimestamp(),
                        db.dbGetUser(),
                        db.dbGetUser(),
                        "",
                        "",
                        null
                );
            } else {
            	if(db.idExists(DBFactory.TABLE_CONTAINER,id,quiet)) {
		            getContainer.setInt(1,id);
		            final ResultSet rs = getContainer.executeQuery();
		            if (rs.next()) {
		            	ci = new ContainerItem(
		                		rz,
		                        rs.getInt("container.id"),
		                        rs.getInt("container.c_out"),
		                        rs.getString("ordner"),
		                        getOrdner(Integer.parseInt(rs.getString("ordner").substring(1,rs.getString("ordner").indexOf(">")))).getBezeichnung(),
		                        rs.getString("container.bezeichnung"),
		                        rs.getDouble("container.tara"),
		                        rs.getString("container.comment"),
		                        db.getDateFromString(rs.getString("container.erstellt")),
		                        db.getDateFromString(rs.getString("container.geaendert")),
		                        rs.getString("container.user_1"),
		                        rs.getString("container.user_2"),
		                        rs.getString("lieferschein.adresse_string"),
		                        rs.getString("lieferschein_zeile.bezeichnung"),
		                        rs.getString("letztesDatum") != null?db.getDateFromString(rs.getString("letztesDatum")):null
		                );
		            	} else {
		            		dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
		                    dlgItem.setCaption(rz.getLocale().getString("database.container_key_not_found"));
		                    dlgItem.setTitel(rz.getLocale().getString("database.container_key_not_found"));
		                    dlgItem.setMessage(rz.getLocale().getString("database.container_key_not_found_message"));
		                    dlgItem.setIcon("warnung.png");
		                    dlgItem.setOk(rz.getLocale().getString("string_ok"));
		                    rz.getDialogFactory().getDialog(dlgItem);
		                    ci=null;;

		            	}
		            if(rs != null) {
						rs.close();
					}
	            }
            }
        } catch ( final SQLException e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBcontainer.GetContainer",e.getLocalizedMessage());
        	// nicht gefunden
        }
        return ci;
    }


    /**
     * speichert einen neuen" + DbControl.TABLE_CONTAINER + "oder
     * ändert einen" + DbControl.TABLE_CONTAINER + " in der Datenbank ab
     */
    public int saveContainer(ContainerItem ci){
        int ret = 0;
        PreparedStatement stm;
        try {
            if (ci.getID() == 0){
                stm = saveContainer;
                ci.setUser_2(db.dbGetUser());
            }
            else
            {
                stm = updateContainer;
                stm.setInt(10,ci.getID());
                if(!db.idExists(DBFactory.TABLE_CONTAINER,ci.getID(),true)) {
                	stm=saveContainer;
                	ci.setID(0);
                }
            }
            stm.setString(1,ci.getOrdner());
            stm.setString(2,ci.getName());
            stm.setInt(3,ci.getNummer());
            stm.setDouble(4,ci.getTara());
            stm.setString(5,ci.getComment());
            stm.setString(6,db.dbGetDateFormatString(ci.getErstellt()));
            stm.setString(7,db.dbGetDateFormatString(ci.getGeaendert()));
            stm.setString(8,ci.getUser_1());
            stm.setString(9,ci.getUser_2());
            stm.executeUpdate();
            if (ci.getID() == 0){
                ret = db.dbGetLastInsertID("container");
            } else {
				ret = ci.getID();
			}
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.SaveContainer", e.getLocalizedMessage());
            ret = 0;
        }
        return ret;
    }

    public ContainerListe getContainerListe(String filter, String adresse,boolean out){
        final ContainerListe cl = new ContainerListe();
        try {
        	PreparedStatement stm;
        	if(!adresse.trim().equals("") && out == true) {
        		stm = getContainerListeAdresseOut;
        		stm.setString(2, adresse);
        	} else if (!adresse.trim().equals("") && out == false){
        		stm = getContainerListeAdresse;
        		stm.setString(2, adresse);
        	} else if(adresse.trim().equals("") && out == true) {
        		stm = getContainerListeOut;
        	} else {
        		stm = getContainerListe;
        	}
            stm.setString(1,filter);
            final ResultSet rs = stm.executeQuery();
            while (rs.next()) {
            	
            	ContainerItem ci = new ContainerItem(
				                		rz,
				                        rs.getInt("container.id"),
				                        rs.getInt("container.c_out"),
				                        rs.getString("ordner"),
				                        getOrdner(Integer.parseInt(rs.getString("ordner").substring(1,rs.getString("ordner").indexOf(">")))).getBezeichnung(),
				                        rs.getString("container.bezeichnung"),
				                        rs.getDouble("container.tara"),
				                        rs.getString("container.comment"),
				                        db.getDateFromString(rs.getString("container.erstellt")),
				                        db.getDateFromString(rs.getString("container.geaendert")),
				                        rs.getString("container.user_1"),
				                        rs.getString("container.user_2"),
				                        rs.getString("lieferschein.adresse_string"),
				                        rs.getString("lieferschein_zeile.bezeichnung"),
				                        rs.getString("letztesDatum") != null?db.getDateFromString(rs.getString("letztesDatum")):null
				                );
            	ContainerItem ci1=cl.hasNummer(rs.getString("container.bezeichnung"));
            	if(ci1 != null) {
            		if (ci.getLetztesDatum().after(ci1.getLetztesDatum()) || ci.getLetztesDatum().equals(ci1.getLetztesDatum())) {
            			ci1.setLetztesDatum(ci.getLetztesDatum());
            			ci1.setLetzteFuellung(ci.getLetzteFuellung());
            			ci1.setLetzteAdresse(ci.getLetzteAdresse());
            		}
            	} else {
            		cl.addItem(ci);
            	}
            }
            if(rs != null) {
				rs.close();
			}
        } catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.GetContainerListe",e.getLocalizedMessage());
        }
        return cl;
    }

    public void deleteContainer(int id) {
        try {
            if(db.idExists(DBFactory.TABLE_CONTAINER,id,false)) {
                deleteContainer.setInt(1,id);
                deleteContainer.executeUpdate();
            }
        } catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBContainer.GetContainerListe",e.getLocalizedMessage());
        }
    }

}
