/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.datenblatt.DatenblattItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.log.LogFactory;



/**
 *
 * @author  lunqual
 */
public class DBDatenblatt{

    RzPro           		rz;
    Connection      	con;
    DBFactory       	db;
    DialogItem			dlgItem;

    PreparedStatement getDatenblatt;
    PreparedStatement saveDatenblatt;
    PreparedStatement updateDatenblatt;
    PreparedStatement getFormulare;
    PreparedStatement saveDefault;
    PreparedStatement updateDefault;
    PreparedStatement checkDefault;

    /** Creates a new instance of DBLager */
    public DBDatenblatt(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }

    private void setStatements(){
        try{
        		getDatenblatt = con.prepareStatement("select * from " + DBFactory.TABLE_DATENBLATT + " where rezeptur=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        		saveDatenblatt = con.prepareStatement("insert into datenblatt (rezeptur,name,staerke,datenblatt) values (?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
        		updateDatenblatt = con.prepareStatement("update datenblatt set rezeptur=?, name=?,staerke=?,datenblatt=? where rezeptur=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
           		updateDefault = con.prepareStatement("update datenblatt set datenblatt=? where rezeptur=0",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
           		saveDefault = con.prepareStatement("insert into datenblatt (rezeptur,datenblatt) values (0,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
           		checkDefault= con.prepareStatement("select id from " + DBFactory.TABLE_DATENBLATT + " where rezeptur=0",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDatenblatt.setStatements", e.getLocalizedMessage());
        }
    }

    private boolean checkDefault() {
    	boolean ret = false;
    	try {
    		ResultSet rs = checkDefault.executeQuery();
    		if(rs.next()) {
    			ret = true;
    		}
    	}
		catch (final SQLException e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDatenblatt.checkDefault", e.getLocalizedMessage());
        }
    	return ret;
    }
    
    
    public String getDatenblattDefault() {
    	String ret = "";
    	try {
			getDatenblatt.setInt(1,0);
			final ResultSet rs = getDatenblatt.executeQuery();
			if(rs.next()) {
				 ret = rs.getString("datenblatt");
			}else {
	    			ret = "";
			}
		}
		catch (final SQLException e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDatenblatt.getDatenblattDefault", e.getLocalizedMessage());
        }
    	return ret;
    }
    
    public int saveDatenBlattDefault(DatenblattItem di) {
    	int ret = 0;
    	PreparedStatement stm;
		try {
			if(checkDefault()) {
				stm = updateDefault;
			} else {
				stm = saveDefault;
			}
			stm.setString(1,di.getText());
			stm.executeUpdate();
			ret = 0;
		   }
		catch (final SQLException e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDatenblatt.saveDatenblattDefault", e.getLocalizedMessage());
     	}
		return ret;
    }
    
    public DatenblattItem getDatenblatt(int rezeptur,String name) {
    		DatenblattItem di=null;
    		try {
    				getDatenblatt.setInt(1,rezeptur);
    				final ResultSet rs = getDatenblatt.executeQuery();
    				if(rs.next()) {
    					di = new DatenblattItem(
    							rz,
    							rs.getInt("id"),
    							rs.getInt("rezeptur"),
    							rs.getString("name"),
    							rs.getDouble("staerke"),
    							rs.getString("datenblatt")
    					);
    				}else {
    		    			di = new DatenblattItem(
    		    					rz,0,rezeptur,name,rz.getDatabase().getRezeptur().getStaerke(rezeptur),rz.getOptionFactory().getOption("datenblatt.default")
    		    			);
    				}
    			}
    			catch (final SQLException e){
    				rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDatenblatt.getDatenblatt", e.getLocalizedMessage());
    	        }
    		return di;
    }


    
    public int saveDatenblatt(DatenblattItem di) {
    		int ret = 0;
    		PreparedStatement stm;
    		try {
    			if(di.getId() == 0) {
    				stm=saveDatenblatt;
    			} else {
    				stm=updateDatenblatt;
    				stm.setInt(5,di.getRezeptur());
    			}
    			stm.setInt(1,di.getRezeptur());
    			stm.setString(2,di.getName());
    			stm.setDouble(3,di.getStaerke());
    			stm.setString(4,di.getText());
    			stm.executeUpdate();
    			if(stm == saveDatenblatt) {
    				ret = db.dbGetLastInsertID(DBFactory.TABLE_DATENBLATT);
    			} else {
    				ret = di.getId();
    			}
    		}
		catch (final SQLException e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDatenblatt.saveDatenblatt", e.getLocalizedMessage());
	     }
    		return ret;
    }

}
