/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.deklarationen.DeklarationsItem;
import de.lunqual.rzpro.items.deklarationen.DeklarationsListe;
import de.lunqual.rzpro.items.deklarationen.FormBlattItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.rezeptur.SPFormblattItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  lunqual
 */
public class DBDeklarationen{

    RzPro           		rz;
    Connection      	con;
    DBFactory       	db;
    DialogItem			dlgItem;

    PreparedStatement   getDeklarationenListe;
    PreparedStatement   getDeklaration;
    PreparedStatement   saveDeklaration;
    PreparedStatement   updateDeklaration;
    PreparedStatement   deleteDeklaration;
    PreparedStatement   checkDeklarationUsed;
    PreparedStatement   getFormText;
    PreparedStatement   getFormTextActive;
    PreparedStatement   updateFormblatt;
    PreparedStatement	   getFormblattFormular;
    PreparedStatement	   getFormblattFormular1;
    PreparedStatement    getFormblattListe;
    PreparedStatement		updateFormblattBezeichnung;
    PreparedStatement		addFormblatt;
    PreparedStatement		deleteFormblatt;
    PreparedStatement		getFormblatt;
    PreparedStatement		setActiveFormblatt;
    PreparedStatement		setInActiveFormblatt;

    /** Creates a new instance of DBLager */
    public DBDeklarationen(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
    }

    private void setStatements(){
        try{
            getDeklarationenListe    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_DEKLARATIONEN + " ORDER BY name",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getDeklaration          = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_DEKLARATIONEN + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            updateDeklaration		= con.prepareStatement("UPDATE " +DBFactory.TABLE_DEKLARATIONEN + " SET name=?,deklaration=?,user_1=?,user_2=?,erstellt=?,geaendert=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            saveDeklaration        = con.prepareStatement("INSERT INTO " +DBFactory.TABLE_DEKLARATIONEN + " (name,deklaration,user_1,user_2,erstellt,geaendert) VALUES(?,?,?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteDeklaration    	= con.prepareStatement("DELETE FROM " +DBFactory.TABLE_DEKLARATIONEN + "  WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            checkDeklarationUsed             = con.prepareStatement("SELECT id FROM " +DBFactory.TABLE_REZEPTLISTE + " WHERE " + DBFactory.TABLE_DEKLARATIONEN + " like ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getFormText             = con.prepareStatement("SELECT formtext FROM " +DBFactory.TABLE_DEKLARATION_TEXT + " WHERE id =?" , ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getFormTextActive             = con.prepareStatement("SELECT formtext FROM " +DBFactory.TABLE_DEKLARATION_TEXT + " WHERE active =1 LIMIT 1",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getFormblatt             = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_DEKLARATION_TEXT + " WHERE id =?" , ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            updateFormblatt		= con.prepareStatement("UPDATE " +DBFactory.TABLE_DEKLARATION_TEXT + " SET formtext=? where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            setActiveFormblatt		= con.prepareStatement("UPDATE " +DBFactory.TABLE_DEKLARATION_TEXT + " SET active=1 where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            setInActiveFormblatt		= con.prepareStatement("UPDATE " +DBFactory.TABLE_DEKLARATION_TEXT + " SET active=0 ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);

            updateFormblattBezeichnung	= con.prepareStatement("UPDATE " +DBFactory.TABLE_DEKLARATION_TEXT + " SET bezeichnung=? where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            addFormblatt	= con.prepareStatement("INSERT INTO " +DBFactory.TABLE_DEKLARATION_TEXT + " (bezeichnung,formtext) VALUES ('-','') " ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteFormblatt		= con.prepareStatement("DELETE FROM " +DBFactory.TABLE_DEKLARATION_TEXT + "  where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            
            
            getFormblattFormular      = con.prepareStatement("SELECT id FROM " +DBFactory.TABLE_FORMULARE + " where id=? and typ=" +ReportFactory.REPORT_TYPE_SPEZIFIKATION_FORMBLATT ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getFormblattFormular1      = con.prepareStatement("SELECT id FROM " +DBFactory.TABLE_FORMULARE + " where typ=" +ReportFactory.REPORT_TYPE_SPEZIFIKATION_FORMBLATT + " order by id limit 1" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getFormblattListe    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_DEKLARATION_TEXT + " ORDER BY bezeichnung ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAcid.setStatements", e.getLocalizedMessage());
        }
    }

    /**
     * FormblattListe
     */
    public ArrayList<FormBlattItem> getFormblattListe() {
    	ArrayList<FormBlattItem> ret = new ArrayList<FormBlattItem>();
    	try {
    		ResultSet rs = getFormblattListe.executeQuery();
    		while(rs.next()) {
    			ret.add(getFormblattFromRS(rs));
    		}
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.getFormblattListe", e.getLocalizedMessage());
         }
    	return ret;
    }
    
    public FormBlattItem getFormblatt(int id) {
    	try {
    		getFormblatt.setInt(1, id);
    		ResultSet rs = getFormblatt.executeQuery();
    		if(rs.next()) {
    			return getFormblattFromRS(rs);
    		}
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.getFormblatt(id)", e.getLocalizedMessage());
         }
    	return null;
    }
    
    private FormBlattItem getFormblattFromRS(ResultSet rs) {
    	try {
    		return new FormBlattItem(
					rz,
				    rs.getInt("id"),
				    rs.getString("bezeichnung"),
				    rs.getString("formtext"),
					rs.getInt("active") != 0?true:false);
    	}
		catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.getFormblattFromRS", e.getLocalizedMessage());
         }
		return null;
    }
    
    /**
     * Formblatt-formular
     */
    public int getFormBlattFormular() {
    	int formular=0;
    	try {
    		int id=rz.getOptionFactory().getOption("auswahl.formular_deckblatt_spezifikation",OptionFactory.AUSWAHL_FORMULAR_DECKBLATT_SPEZIFIKATION);
			ResultSet rs=null;
    		if (id == -1) {
    			rs= getFormblattFormular1.executeQuery();	
    		} else {
    			getFormblattFormular.setInt(1,id);
    			rs = getFormblattFormular.executeQuery();
    		}
    		if(rs.next()) {
    			formular = rs.getInt("id");
    		}
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.getFormblattFormular", e.getLocalizedMessage());
         }
    	return formular;
    }

    /**
     * Formblatt aktivieren
     */
    public void setActiveFormBlatt(int id) {
    	try {
    		setInActiveFormblatt.executeUpdate();
    		setActiveFormblatt.setInt(1, id);
    		setActiveFormblatt.executeUpdate();
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.setActiveFormblatt", e.getLocalizedMessage());
         }
    }
    
    /**
     * Formblatt löschen
     */
    public void deleteFormBlatt(int id) {
    	try {
    		FormBlattItem fi = getFormblatt(id);
    		if(fi != null && !fi.isActive()) {
    			deleteFormblatt.setInt(1,id);
    			deleteFormblatt.executeUpdate();
    		}
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.deleteFormblatt", e.getLocalizedMessage());
         }
    }
    
    /**
     * Formblatt einfügen
     */
    public String addFormBlatt() {
    	final String ret = "";
    	try {
    			addFormblatt.executeUpdate();
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.addFormblatt", e.getLocalizedMessage());
         }
    	return ret;
    }
    
    /**
     * Formblatt-Bezeichnung updaten
     */
    public String setFormBlattBezeichnung(String bezeichnung,int id) {
    	final String ret = "";
    	try {
    		if(!bezeichnung.trim().equals("") ) {
    			updateFormblattBezeichnung.setString(1,bezeichnung);
    			updateFormblattBezeichnung.setInt(2, id);
    			updateFormblattBezeichnung.executeUpdate();
    		}
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.setFormblattBezeichnung", e.getLocalizedMessage());
         }
    	return ret;
    }

    
    /**
     * Formblatt-Text updaten
     */
    public String setFormBlattText(String text,int id) {
    	final String ret = "";
    	try {
    		updateFormblatt.setString(1,text);
    		updateFormblatt.setInt(2, id);
    		updateFormblatt.executeUpdate();
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.getFormblattText", e.getLocalizedMessage());
         }
    	return ret;
    }

    /**
     * Formblatt-Text zurückgeben
     */
    public String getFormBlattText(int id) {
    	String ret = "";
    	try {
    		getFormText.setInt(1, id);
      		final ResultSet rs = getFormText.executeQuery();
    		if(rs.next()) {
    			ret = rs.getString("formtext");
    		}
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.getFormblattText", e.getLocalizedMessage());
         }
    	return ret;
    }
    
    /**
     * den aktiven Formblatt-Text zurückgeben
     */
    public String getFormBlattText() {
    	String ret = "";
    	try {
    		final ResultSet rs = getFormTextActive.executeQuery();
    		if(rs.next()) {
    			ret = rs.getString("formtext");
    		}
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.getFormblattTextActive", e.getLocalizedMessage());
         }
    	return ret;
    }
    
    /**
     * Das Formblatt als Item zurückgeben
     */
    public SPFormblattItem getFormBlatt(String titel) {
    	SPFormblattItem spf = null;
    		spf=new SPFormblattItem(titel,this.getFormBlattText());
    	return spf;
    }
   /**
    * Die Liste der Deklarationen holen
    */
    public DeklarationsListe getDeklarationsListe() {
    	final DeklarationsListe ret = new DeklarationsListe(rz);
    	try {
    		final ResultSet rs = getDeklarationenListe.executeQuery();
    		while(rs.next()) {
    			ret.addItem(new DeklarationsItem(
    					rs.getInt("id"),
    					rs.getString("name"),
    					rs.getString("deklaration"),
    					rs.getString("user_1"),
    					rs.getString("user_2"),
    					rs.getDate("erstellt"),
    					rs.getDate("geaendert")
    			));
    		}
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.getDeklarationsListe", e.getLocalizedMessage());
         }
    	return ret;
    }

    /**
     * Prüfen, ob eine Deklaration verwendet wird
     */
    public boolean checkDeklarationUsed(DeklarationsItem di) {
    	boolean ret = true;
        final String  check = "%<" + String.valueOf(di.getId()) + ">%";
        try{
        	checkDeklarationUsed.setString(1,check);
        	final ResultSet rs = checkDeklarationUsed.executeQuery();
        	ret = rs.next();
        }
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.checkDeklarationUsed", e.getLocalizedMessage());
         }
    	return ret;
    }

    /**
     * eine Deklaration löschen
     */
    public boolean deleteDeklaration(DeklarationsItem di) {
    	boolean ret = false;
    	try {
    		if(!checkDeklarationUsed(di)) {
    			deleteDeklaration.setInt(1,di.getId());
    			deleteDeklaration.executeUpdate();
    			ret = true;
    		} else {
                dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                dlgItem.setCaption(rz.getLocale().getString("database.deklaration_loeschen"));
                dlgItem.setTitel(rz.getLocale().getString("database.deklaration_loeschen"));
                dlgItem.setMessage(rz.getLocale().getString("database.error_deklaration_existiert").replaceAll("%s",di.getName()));
                dlgItem.setIcon("warnung.png");
                dlgItem.setOk(rz.getLocale().getString("string_ok"));
                rz.getDialogFactory().getDialog(dlgItem);
    			ret =false;
    		}
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.deleteDeklaration", e.getLocalizedMessage());
        	ret = false;
         }
    	return ret;
    }

    /**
     * eine Deklaration holen
     * @param id
     * @return DeklarationsItem
     */
    public DeklarationsItem getDeklaration(int id) {
    	DeklarationsItem ret = null;
    	try {
    		if(id == 0) {
    			ret = new DeklarationsItem(
    					0,
    					rz.getLocale().getString("deklarationseingabe.neu"),
    					"",
    					db.dbGetUser(),
    					db.dbGetUser(),
    					new Date(),
    					new Date()
    			);
    		} else {
	    		getDeklaration.setInt(1,id);
	    		final ResultSet rs= getDeklaration.executeQuery();
	    		if(rs.next()) {
	    			ret = new DeklarationsItem(
	    					rs.getInt("id"),
	    					rs.getString("name"),
	    					rs.getString("deklaration"),
	    					rs.getString("user_1"),
	    					rs.getString("user_2"),
	    					rs.getDate("erstellt"),
	    					rs.getDate("geaendert")
	    			);
	    		}
	    	}
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.getDeklaration", e.getLocalizedMessage());
         }
    	return ret;
    }
    /**
     * DeklarationsItem speichern /updaten
     * @param di
     */
    public int saveDeklaration(DeklarationsItem di) {
    	int ret = -1;
    	PreparedStatement stm;
    	try {
	    	if(di.getId()==0) {
	    		stm=saveDeklaration;
		    	stm.setString(5,db.dbGetDateFormatString(di.getErstellt()));
		    	stm.setString(6,db.dbGetDateFormatString(di.getGeaendert()));
	    	} else {
	    		stm=updateDeklaration;
		    	stm.setString(5,db.dbGetDateFormatString(di.getErstellt()));
		    	stm.setString(6,db.dbGetDateFormatString(new Date()));
	    		stm.setInt(7,di.getId());
	    	}
	    	stm.setString(1,di.getName());
	    	stm.setString(2,di.getDeklaration());
	    	stm.setString(3,di.getUser_1());
	    	stm.setString(4, di.getUser_2());

	   	 	stm.executeUpdate();
	   	 	if(di.getId() == 0) {
	   	 		ret = db.dbGetLastInsertID(DBFactory.TABLE_DEKLARATIONEN);
	   	 		di.setId(ret);
	   	 	}
    	}
        catch (final SQLException e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.saveDeklaration", e.getLocalizedMessage());
         }
        return ret;
    }

    /**
     * gibt eine Deklarationsliste aus einem String zurück
     * @param muster
     * @return
     */
    public DeklarationsListe getDeklarationenListe(String muster) {
    	final DeklarationsListe ret = new DeklarationsListe(rz);
        muster = muster.replaceAll("[<|>]"," ").replaceAll("%","");
        try {
            final StringTokenizer stt = new StringTokenizer(muster);
            while (stt.hasMoreTokens()){
                final int k = Integer.parseInt( stt.nextToken());
                ret.addItem(getDeklaration(k));
            }
        }
        catch (final Exception e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"DBDeklarationen.getDeklarationenListe:String", e.getLocalizedMessage());
         }
    	return ret;
    }



    /**
     * Die komplette Deklarationsliste einer Rezeptur ermitteln
     *
     */
    public DeklarationsListe getDeklarationsListeAlle(int id) {
    	final DeklarationsListe ret = new DeklarationsListe(rz);
		final ArrayList deklarationen = db.getRezeptur().getZutatenListe(id);
		for(int i =0;i <deklarationen.size();i++) {
			ret.mergeListe(db.getRezeptur().getDeklarationen(((Integer)deklarationen.get(i)).intValue()));
		}
		ret.sortItemsAlpha();
    	return ret;
    }
}
