/*
  *  Copyright (C) database.stichwort_loeschen4 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.DependencyItem;
import de.lunqual.rzpro.items.ergebnis.DependencyListe;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisListe;
import de.lunqual.rzpro.items.ergebnis.ErgebnisListenItem;
import de.lunqual.rzpro.items.rezeptur.BestandswarnungsListe;
import de.lunqual.rzpro.items.rezeptur.SteuerDatenItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class DBErgebnis {


	private final static int			RECURSION_COUNT=12;

    RzPro           rz;
    Connection      con;
    DBFactory       db;

    DialogItem		dlgItem;

    PreparedStatement  getErgebnisListe[];
    private static final int		ERG_NAME_NAME_ASC 								= 0;
    private static final int		ERG_NAME_NAME_DESC 								= 1;
    private static final int		ERG_NAME_DATE_ASC 								= 2;
    private static final int		ERG_NAME_DATE_DESC 								= 3;
    private static final int		ERG_NAME_NAME_ADR_ASC 						= 4;
    private static final int		ERG_NAME_NAME_ADR_DESC						= 5;
    private static final int		ERG_NAME_DATE_ADR_ASC 						= 6;
    private static final int		ERG_NAME_DATE_ADR_DESC 						= 7;
    private static final int		ERG_NAME_NAME_STW_ASC 						= 8;
    private static final int		ERG_NAME_NAME_STW_DESC						= 9;
    private static final int		ERG_NAME_DATE_STW_ASC 						= 10;
    private static final int		ERG_NAME_DATE_STW_DESC 						= 11;
    private static final int		ERG_NAME_NAME_ADR_STW_ASC 				= 12;
    private static final int		ERG_NAME_NAME_ADR_STW_DESC				= 13;
    private static final int		ERG_NAME_DATE_ADR_STW_ASC 				= 14;
    private static final int		ERG_NAME_DATE_ADR_STW_DESC 				= 15;

    private static final int		ERG_V_NAME_ASC		= 0;
    private static final int		ERG_V_NAME_DESC		= 1;
    private static final int		ERG_V_DATE_ASC		= 2;
    private static final int		ERG_V_DATE_DESC		= 3;


    PreparedStatement	  getErgebnisListeVerwendung[];
    PreparedStatement 	  getErgebnisListeEinzeln;
    PreparedStatement		getErgebnisListeTank;

    PreparedStatement   getLastRzInsertID;

    PreparedStatement	  getErgebnisListeByID;
   
    PreparedStatement    getAblageFilter;
    PreparedStatement    updateAblageFilter;
    PreparedStatement	 checkSpezifikation;
    
    
    /** Creates a new instance of DBAbfrage */
    public DBErgebnis(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
        dlgItem= new DialogItem(0,"",0.0,"","","","","","",null);
    }

    private void setStatements(){
        try{
        	String one = "SELECT rezeptliste.konform,rezeptliste.konformDatum,rezeptliste.konformComment,rezeptliste.id,typ,name,staerke,rezeptliste.geaendert,stichworte,adressen,litergewicht,acid,bestand,meldebestand,vorschlagsbestand,bestandseinheit,staerke,sum(bestellung.rest) as menge,rezeptliste.artikelnummer,spezifikation,tempvon,tempbis,at.erledigt,at.anfrage,at.id,at.inarbeit FROM " + DBFactory.TABLE_REZEPTLISTE + " left join bestellung on rezeptliste.id=bestellung.rezeptur left join (select id,rezeptur_id,erledigt,anfrage,inarbeit from auftragsliste where erledigt=0 and anfrage=0) as at on at.rezeptur_id=rezeptliste.id WHERE name REGEXP ? ";
        	String two = "SELECT  rezeptliste.konform,rezeptliste.konformDatum,rezeptliste.konformComment,rezeptliste.id,typ,name,staerke,rezeptliste.geaendert,stichworte,adressen,litergewicht,acid,bestand,meldebestand,vorschlagsbestand,bestandseinheit,staerke,sum(bestellung.rest) as menge,rezeptliste.artikelnummer,spezifikation,tempvon,tempbis,at.erledigt,at.anfrage,at.id,at.inarbeit FROM " + DBFactory.TABLE_REZEPTLISTE + " left join bestellung on rezeptliste.id=bestellung.rezeptur  left join(select id,rezeptur_id,erledigt,anfrage,inarbeit from auftragsliste where erledigt=0 and anfrage=0) as at on at.rezeptur_id=rezeptliste.id  WHERE rezeptliste.id=? ";

        	String three = "SELECT rezeptliste.konform,rezeptliste.konformDatum,rezeptliste.konformComment,rezeptliste.id,typ,name,staerke,rezeptliste.geaendert,stichworte,adressen,litergewicht,acid,bestand,meldebestand,vorschlagsbestand,bestandseinheit,staerke,sum(bestellung.rest) as menge,rezeptliste.artikelnummer,spezifikation,tempvon,tempbis,at.erledigt,at.anfrage,at.id,at.inarbeit FROM " + DBFactory.TABLE_REZEPTLISTE + " left join bestellung on rezeptliste.id=bestellung.rezeptur left join (select id,rezeptur_id,erledigt,anfrage,inarbeit from auftragsliste where erledigt=0 and anfrage=0) as at on at.rezeptur_id=rezeptliste.id WHERE rezeptliste.id in ($x) ";

        	
        	String group = " group by rezeptliste.id ";
        	getErgebnisListeEinzeln = con.prepareStatement(two+group ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	getErgebnisListeTank = con.prepareStatement(three + group + " ORDER BY name ASC", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	getErgebnisListe = new PreparedStatement[16];
        	getErgebnisListe[ERG_NAME_NAME_ASC ] = con.prepareStatement(one + group + " ORDER BY name ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	getErgebnisListe[ERG_NAME_NAME_DESC ] = con.prepareStatement(one +  group +" ORDER BY name DESC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	getErgebnisListe[ERG_NAME_DATE_ASC ] = con.prepareStatement(one +  group +" ORDER BY geaendert ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	getErgebnisListe[ERG_NAME_DATE_DESC ] = con.prepareStatement(one +  group +" ORDER BY geaendert DESC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	getErgebnisListe[ERG_NAME_NAME_ADR_ASC] = con.prepareStatement(one + " AND adressen REGEXP ? "  + group +" ORDER BY name ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	getErgebnisListe[ERG_NAME_NAME_ADR_DESC] = con.prepareStatement(one + " AND adressen REGEXP ? "  + group +"  ORDER BY name DESC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	getErgebnisListe[ERG_NAME_DATE_ADR_ASC] = con.prepareStatement(one + " AND adressen REGEXP ? "  + group +"  ORDER BY geaendert ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	getErgebnisListe[ERG_NAME_DATE_ADR_DESC] = con.prepareStatement(one + " AND adressen REGEXP ?  "  + group +" ORDER BY geaendert DESC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	getErgebnisListe[ERG_NAME_NAME_STW_ASC] = con.prepareStatement(one + " AND stichworte REGEXP ?  "  + group +" ORDER BY name ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	getErgebnisListe[ERG_NAME_NAME_STW_DESC] = con.prepareStatement(one + " AND stichworte REGEXP ? "  + group +"  ORDER BY name DESC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	getErgebnisListe[ERG_NAME_DATE_STW_ASC] = con.prepareStatement(one + " AND stichworte REGEXP ?  "  + group +" ORDER BY geaendert ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	getErgebnisListe[ERG_NAME_DATE_STW_DESC] = con.prepareStatement(one + " AND stichworte REGEXP ?  "  + group +" ORDER BY geaendert DESC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	getErgebnisListe[ERG_NAME_NAME_ADR_STW_ASC] = con.prepareStatement(one + " AND adressen REGEXP ? AND stichworte REGEXP ?  "  + group +" ORDER BY name ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	getErgebnisListe[ERG_NAME_NAME_ADR_STW_DESC] = con.prepareStatement(one + " AND adressen REGEXP ? AND stichworte REGEXP ?  "  + group +" ORDER BY name DESC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	getErgebnisListe[ERG_NAME_DATE_ADR_STW_ASC] = con.prepareStatement(one + " AND adressen REGEXP  ? AND stichworte REGEXP ?  "  + group +" ORDER BY geaendert ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	getErgebnisListe[ERG_NAME_DATE_ADR_STW_DESC] = con.prepareStatement(one + " AND adressen REGEXP  ? AND stichworte REGEXP ?  "  + group +" ORDER BY geaendert DESC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

        	one =  "SELECT  rezeptliste.konform,rezeptliste.konformDatum,rezeptliste.konformComment,rezeptliste.id,typ,name,rezeptliste.comment,rezeptliste.geaendert,stichworte,adressen,litergewicht,acid,bestand,meldebestand,vorschlagsbestand,bestandseinheit,staerke,bestellung.menge,rezeptliste.artikelnummer,spezifikation,tempvon,tempbis,at.erledigt,at.anfrage,at.id,at.inarbeit  FROM " + DBFactory.TABLE_REZEPTLISTE + " left join bestellung on rezeptliste.id=bestellung.rezeptur  left join (select id,rezeptur_id,erledigt,anfrage,inarbeit from auftragsliste where erledigt=0 and anfrage=0) as at on at.rezeptur_id=rezeptliste.id   WHERE rezeptliste.comment like ? and (bestellung.rest is null or (bestellung.rest is not null and bestellung.rest <> 0))  ";
        	getErgebnisListeVerwendung = new PreparedStatement[4];
            getErgebnisListeVerwendung[ERG_V_NAME_ASC]  = con.prepareStatement(one + group + " ORDER BY name ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getErgebnisListeVerwendung[ERG_V_NAME_DESC]  = con.prepareStatement(one + group+ " ORDER BY name DESC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getErgebnisListeVerwendung[ERG_V_DATE_ASC]  = con.prepareStatement(one + group + " ORDER BY geaendert ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getErgebnisListeVerwendung[ERG_V_DATE_DESC]  = con.prepareStatement(one + group + " ORDER BY geaendert DESC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);


            getErgebnisListeByID   = con.prepareStatement("SELECT id,deklarationen FROM " + DBFactory.TABLE_REZEPTLISTE + " WHERE comment  like ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            getAblageFilter =  con.prepareStatement("SELECT stichworte FROM " + DBFactory.TABLE_ABLAGEFILTER ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            updateAblageFilter =  con.prepareStatement("UPDATE  " + DBFactory.TABLE_ABLAGEFILTER + " set stichworte=? " ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);

            
            checkSpezifikation =con.prepareStatement("SELECT id FROM " + DBFactory.TABLE_REZEPTLISTE + " WHERE spezifikation=? and id <> ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB.setStatements", e.getLocalizedMessage());
        }
    }

    public String getErweitertSQLPrefix(){
    	return 	"SELECT  rezeptliste.konform,rezeptliste.konformDatum,rezeptliste.konformComment,"+
    					" rezeptliste.id,rezeptliste.typ,name,rezeptliste.staerke,rezeptliste.geaendert,"+
    					" stichworte,adressen,rezeptliste.litergewicht,acid,bestand,meldebestand,vorschlagsbestand,bestandseinheit," + 
    					" spezifikation,rezeptliste.staerke,sum(bestellung.rest)  as menge,rezeptliste.artikelnummer,tempvon,tempbis," + 
    					" steuer_lager.bezeichnung, sorten.bezeichnung,  rezeptliste.steuerlager, rezeptliste.sorte, rezeptliste.steuer_artikel, " +
    					" at.id,at.erledigt,at.anfrage,at.inarbeit FROM " + DBFactory.TABLE_REZEPTLISTE +
    					" left join bestellung on rezeptliste.id=bestellung.rezeptur "+
    					" left join (select id,rezeptur_id,erledigt,anfrage,inarbeit from auftragsliste where erledigt=0 and anfrage=0)  as at on at.rezeptur_id=rezeptliste.id" +
    					" left join steuer_lager on rezeptliste.steuerlager = steuer_lager.id " +
    					" left join sorten on rezeptliste.sorte = sorten.id " +
    					" where  ";
    }
    
    public String getMusterString(String in) {
    	final String ret = "^"+in+"$";
		return ret.replaceAll(" ",".");
    }

    public boolean checkSpezifikation(String spezifikation,int id) {
    	//return true wenn die spezifikation existiert, false wenn nicht
    	boolean ret=false;
//    	if(!spezifikation.trim().equals("")) {
//	        try {
//	        	checkSpezifikation.setString(1,spezifikation);
//	        	checkSpezifikation.setInt(2,id);
//	        	ResultSet rs = checkSpezifikation.executeQuery();
//	        	if(rs.next()) {
//	        		ret = true;
//	        	}
//	        } catch (final SQLException e) {
//	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.getAblageFilter", e.getLocalizedMessage());
//	            ret = false;
//	        }
//    	}
        return ret;
    }
    
    public String getAblageFilter() {
    	String ret = "";
        try {
        	ResultSet rs = getAblageFilter.executeQuery();
        	if(rs.next()) {
        		ret = rs.getString("stichworte");
        	}
        } catch (final SQLException e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.getAblageFilter", e.getLocalizedMessage());
            ret = "";
        }
        return ret;
    }
    
    public void updateAblageFilter(StichwortListe filter) {
        try {
        	updateAblageFilter.setString(1,filter.toString());
        	updateAblageFilter.executeUpdate();
        } catch (final SQLException e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.updateAblageFilter", e.getLocalizedMessage());
        }
    }
    
  
    
    public ArrayList getErgebnisListeDruck(ErgebnisListe in) {
    	ArrayList<ErgebnisListenItem> out = new ArrayList<ErgebnisListenItem>();
        try {
        	for(int i=0;i< in.size();i++) {
        		out.add(new ErgebnisListenItem(
        				in.getItem(i).getBezeichnung(),
        				in.getItem(i).getArtikelnummer(),
        				rz.getDatabase().getRezeptur().getAdressen(in.getItem(i).getID()).toVerboseString(),
        				in.getItem(i).getSpezifikation())
        		);
        	}
        } catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.getErgebnisListeDruck", e.getLocalizedMessage());
        }
    	
    	return out;
    }
    
    public ErgebnisListe dbGetErgebnisListe(AbfrageItem ai) {
    	rz.getDatabase().getSTW().getHGArray();
    	ErgebnisListe el = new ErgebnisListe();
    	if(ai != null) {
	    	switch(ai.getTyp()) {
	    		case DBAbfrage.ABFRAGE_TYP_NORMAL:
	    	    	switch (ai.getMode()) {
	    	    		case DBAbfrage.ABFRAGE_MODE_MUSTER :
	    	    			el = dbGetErgebnisListeMuster(ai);
	    	    			break;
	    	    		case DBAbfrage.ABFRAGE_MODE_VERWENDUNG :
	    	    			el = dbGetErgebnisListeVerwendung(ai);
	    	    			break;
	    	    		case DBAbfrage.ABFRAGE_MODE_TANK:
	    	    			el = dbGetErgebnisListeTank(ai);
	    	    			break;
	    	    		case DBAbfrage.ABFRAGE_MODE_EAN:
	    	    			el = dbGetErgebnisListeEan(ai);
	    	    			break;
	    	    		case DBAbfrage.ABFRAGE_MODE_ARTIKEL:
	    	    			el = dbGetErgebnisListeArtikel(ai);
	    	    			break;
	    	    	}
	    	    	break;
	    		case DBAbfrage.ABFRAGE_TYP_SQL:
	    			el = dbGetErgebnisListeErweitert(ai);
	    			break;
	    	}
    	}
    	return el;
    }
    /**
     * Alle Abhängigkeiten einer Rezeptur ermitteln
     * @param id
     * @return
     */
    public DependencyListe dbGetErgebnisListeByID(int id,boolean ablage) {
    	rz.getDatabase().getSTW().getHGArray();
         final ArrayList el = new ArrayList();
         final DependencyListe ret = new DependencyListe(rz,id);
         el.add(Integer.valueOf(id));
         boolean ende= false;
         int count = 0;
         int order = 1;
         while (!ende) {
        	 final ArrayList al = getErgebnisListeInstance(el);
        	 count++;
        	 for(int i = 0;i < al.size();i++) {
        		 if(ret.indexOf(al.get(i)) == -1) {
        			 try {
        				 int rezeptur = ((Integer)al.get(i)).intValue();
        				 SteuerDatenItem sdi = rz.getDatabase().getRezeptur().getSteuerDaten(rezeptur);
        				 boolean ok = true;
        				 if (!ablage) {
        					 if(!rz.getDatabase().getSTW().getAblageFilter().toString().isEmpty()) {
	        					 if(rz.getDatabase().getRezeptur().getStichworte(rezeptur).contains(rz.getDatabase().getSTW().getAblageFilter().toString())){
	        						 ok=false;
	        					 }
        					 }
        				 }
        				 if(ok) {
	        				 ret.add(new DependencyItem(rz,rezeptur,
	        						 rz.getDatabase().getRezeptur().dbGetRezepturName(rezeptur),
	        						 rz.getDatabase().getRezeptur().getTyp(rezeptur),rz.getLocale().getString("dependency.ok"),
	        						 rz.getLocale().getString("dependency.not_ok"),
	        						 rz.getDatabase().getRezeptur().getLagerName(rezeptur),
	        						 sdi.getStrSteuerlager(),
	        						 sdi.getSteuer_artikel(),
	        						 order
	        						 ));
	        				 order++;
        				 }
        			 }catch(final Exception e) {}
        		 }
        	 }
        	 if ((count > RECURSION_COUNT) || (al.size() == 0)) {
        		 ende = true;
        	 }
        	 el.clear();
        	 el.addAll(al);
         }
        return ret;
    }

    
  
    private ArrayList getErgebnisListeInstance(ArrayList al) {
    	rz.getDatabase().getSTW().getHGArray();
    	final ArrayList el = new ArrayList();
        try {
        	for(int i = 0;i < al.size();i++) {
	        	getErgebnisListeByID.setString(1,"%[[" + String.valueOf(((Integer)al.get(i)).intValue()) + "]]%");
	        	final ResultSet rs = getErgebnisListeByID.executeQuery();
	        	while(rs.next()) {
	        		el.add(Integer.valueOf(rs.getInt("id")));
	        	}
        	}
        } catch (final SQLException e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.dbGetErgebnisListeByID", e.getLocalizedMessage());
        }
        return el;
    }

    private ErgebnisListe dbGetErgebnisListeTank(AbfrageItem ai) {
        final ErgebnisListe el = new ErgebnisListe();
    	try {
    		String liste ="";
    		HashMap<Integer,Integer> rezepturen = rz.getDatabase().getTank().getRezepturenFromTankNummer(ai.getMuster());
    		for (Map.Entry<Integer,Integer> entry  : rezepturen.entrySet())
    		{
    				liste += String.valueOf(entry.getKey()) + ",";
    		}
    		if(liste.endsWith(","))liste = liste.substring(0, liste.length()-1);
    		if(!liste.trim().equals("")) {
	    		String sql = "SELECT rezeptliste.konform,rezeptliste.konformDatum,rezeptliste.konformComment,rezeptliste.id,typ,name,staerke,rezeptliste.geaendert,stichworte,adressen,litergewicht,acid,bestand,meldebestand,vorschlagsbestand,bestandseinheit,staerke,sum(bestellung.rest) as menge,rezeptliste.artikelnummer,spezifikation,tempvon,tempbis,at.erledigt,at.anfrage,at.id,at.inarbeit FROM " + DBFactory.TABLE_REZEPTLISTE + " left join bestellung on rezeptliste.id=bestellung.rezeptur left join (select id,rezeptur_id,erledigt,anfrage,inarbeit from auftragsliste where erledigt=0 and anfrage=0) as at on at.rezeptur_id=rezeptliste.id WHERE rezeptliste.id in (" + liste +") group by rezeptliste.id order by name asc";
	    		final Statement stm = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
	    		final ResultSet rs = stm.executeQuery(sql);
	    		while(rs.next()) {
	                el.addItem(new ErgebnisItem(
	                		rz,
	                		rs.getInt("id"),
							rs.getInt("typ"),
							rs.getString("name"),
							rs.getDouble("litergewicht"),
							rs.getDouble("acid"),
							db.getDateFromString(rs.getString("geaendert")),
							rs.getString("stichworte"),
							rs.getString("adressen"),
							rs.getDouble("vorschlagsbestand"),
							rs.getDouble("bestand"),
							rs.getDouble("meldebestand"),
							(rz.isZero(rs.getDouble("menge"))?false:true),
							rs.getInt("bestandseinheit"),
							rs.getDouble("staerke"),
							rs.getString("artikelnummer"),
							rs.getString("spezifikation"),
							rs.getInt("tempvon"),
							rs.getInt("tempbis"),
							rs.getInt("at.id")==0?false:true,
							rs.getInt("at.inarbeit")==0?false:true,
							rs.getInt("rezeptliste.konform") == 0?false:true,
							rs.getString("rezeptliste.konformDatum") == null?null:db.getDateFromString(rs.getString("rezeptliste.konformDatum")),
							rs.getString("rezeptliste.konformComment")
					));
	    		}
    		}
       	}
    	catch (final Exception e) {
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.dbGetErgebnisListeTank", e.getLocalizedMessage());
    	}
    	return el;
    }
    private ErgebnisListe dbGetErgebnisListeArtikel(AbfrageItem ai) {
        final ErgebnisListe el = new ErgebnisListe();
    	try {
    		String artikel = ai.getMuster().replaceAll("\\s", " ").replaceAll(" ", ".*");
    		if(artikel.endsWith("|"))artikel = artikel.substring(0,artikel.length()-1);
    		if(!artikel.trim().equals("")) {
	    		String sql = "SELECT rezeptliste.konform,rezeptliste.konformDatum,rezeptliste.konformComment,rezeptliste.id,typ,name,staerke,rezeptliste.geaendert,stichworte,adressen,litergewicht,acid,bestand,meldebestand,vorschlagsbestand,bestandseinheit,staerke,ean,sum(bestellung.rest) as menge,rezeptliste.artikelnummer,spezifikation,tempvon,tempbis,at.erledigt,at.anfrage,at.id,at.inarbeit FROM " + DBFactory.TABLE_REZEPTLISTE + " left join bestellung on rezeptliste.id=bestellung.rezeptur left join (select id,rezeptur_id,erledigt,anfrage,inarbeit from auftragsliste where erledigt=0 and anfrage=0) as at on at.rezeptur_id=rezeptliste.id WHERE rezeptliste.artikelnummer REGEXP ? group by rezeptliste.id order by name asc";
	    		final PreparedStatement stm = con.prepareStatement(sql,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
	    		stm.setString(1, artikel);
	    		final ResultSet rs = stm.executeQuery();
	    		while(rs.next()) {
	                el.addItem(new ErgebnisItem(
	                		rz,
	                		rs.getInt("id"),
							rs.getInt("typ"),
							rs.getString("name"),
							rs.getDouble("litergewicht"),
							rs.getDouble("acid"),
							db.getDateFromString(rs.getString("geaendert")),
							rs.getString("stichworte"),
							rs.getString("adressen"),
							rs.getDouble("vorschlagsbestand"),
							rs.getDouble("bestand"),
							rs.getDouble("meldebestand"),
							(rz.isZero(rs.getDouble("menge"))?false:true),
							rs.getInt("bestandseinheit"),
							rs.getDouble("staerke"),
							rs.getString("artikelnummer"),
							rs.getString("spezifikation"),
							rs.getInt("tempvon"),
							rs.getInt("tempbis"),
							rs.getInt("at.id")==0?false:true,
							rs.getInt("at.inarbeit")==0?false:true,
							rs.getInt("rezeptliste.konform") == 0?false:true,
							rs.getString("rezeptliste.konformDatum") == null?null:db.getDateFromString(rs.getString("rezeptliste.konformDatum")),
							rs.getString("rezeptliste.konformComment")
					));
	    		}
    		}
       	}
    	catch (final Exception e) {
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.dbGetErgebnisListeEan", e.getLocalizedMessage());
    	}
    	return el;
    }
    
    
    private ErgebnisListe dbGetErgebnisListeEan(AbfrageItem ai) {
        final ErgebnisListe el = new ErgebnisListe();
    	try {
    		String ean = ai.getMuster().replaceAll("\\s", " ").replaceAll(" ", ".*");
    		if(ean.endsWith("|"))ean = ean.substring(0,ean.length()-1);
    		if(!ean.trim().equals("")) {
	    		String sql = "SELECT rezeptliste.konform,rezeptliste.konformDatum,rezeptliste.konformComment,rezeptliste.id,typ,name,staerke,rezeptliste.geaendert,stichworte,adressen,litergewicht,acid,bestand,meldebestand,vorschlagsbestand,bestandseinheit,staerke,ean,sum(bestellung.rest) as menge,rezeptliste.artikelnummer,spezifikation,tempvon,tempbis,at.erledigt,at.anfrage,at.id,at.inarbeit FROM " + DBFactory.TABLE_REZEPTLISTE + " left join bestellung on rezeptliste.id=bestellung.rezeptur left join (select id,rezeptur_id,erledigt,anfrage,inarbeit from auftragsliste where erledigt=0 and anfrage=0) as at on at.rezeptur_id=rezeptliste.id WHERE ean REGEXP ? group by rezeptliste.id order by name asc";
	    		final PreparedStatement stm = con.prepareStatement(sql,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
	    		stm.setString(1, ean);
	    		final ResultSet rs = stm.executeQuery();
	    		while(rs.next()) {
	                el.addItem(new ErgebnisItem(
	                		rz,
	                		rs.getInt("id"),
							rs.getInt("typ"),
							rs.getString("name"),
							rs.getDouble("litergewicht"),
							rs.getDouble("acid"),
							db.getDateFromString(rs.getString("geaendert")),
							rs.getString("stichworte"),
							rs.getString("adressen"),
							rs.getDouble("vorschlagsbestand"),
							rs.getDouble("bestand"),
							rs.getDouble("meldebestand"),
							(rz.isZero(rs.getDouble("menge"))?false:true),
							rs.getInt("bestandseinheit"),
							rs.getDouble("staerke"),
							rs.getString("artikelnummer"),
							rs.getString("spezifikation"),
							rs.getInt("tempvon"),
							rs.getInt("tempbis"),
							rs.getInt("at.id")==0?false:true,
							rs.getInt("at.inarbeit")==0?false:true,
							rs.getInt("rezeptliste.konform") == 0?false:true,
							rs.getString("rezeptliste.konformDatum") == null?null:db.getDateFromString(rs.getString("rezeptliste.konformDatum")),
							rs.getString("rezeptliste.konformComment")
					));
	    		}
    		}
       	}
    	catch (final Exception e) {
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.dbGetErgebnisListeEan", e.getLocalizedMessage());
    	}
    	return el;
    }
    
    private ErgebnisListe dbGetErgebnisListeVerwendung(AbfrageItem ai){
    	rz.getDatabase().getSTW().getHGArray();
        ResultSet rs;
        final ErgebnisListe el = new ErgebnisListe();
        final String muster = ai.getMuster().trim();
        PreparedStatement stm=null;
        int dbKey;
        switch (ai.getOrder()){
            case DBAbfrage.ABFRAGE_ORDER_AA:stm=getErgebnisListeVerwendung[ERG_V_NAME_ASC] ;break;
            case DBAbfrage.ABFRAGE_ORDER_AD:stm=getErgebnisListeVerwendung[ERG_V_NAME_DESC]  ;break;
            case DBAbfrage.ABFRAGE_ORDER_DA:stm=getErgebnisListeVerwendung[ERG_V_DATE_DESC]  ;break;
            case DBAbfrage.ABFRAGE_ORDER_DD:stm=getErgebnisListeVerwendung[ERG_V_DATE_DESC]  ;break;
        }
        dbKey = db.getRezeptur().dbGetRezepturID(muster);
        if(dbKey != 0 && stm!=null)
			try {
	            StichwortListe ablage=rz.getDatabase().getSTW().getAblageFilter();
	            String filter = ablage.toSQLAndString().trim();
	            String m = filter.isEmpty()?"": ".*"+filter+".*";
        		stm.setString(1,"%[[" + dbKey + "]]%");
        		rs = stm.executeQuery();
        		while(rs.next()) {
        			boolean read=true;
        			if(!m.isEmpty()) {
        				 if(rs.getString("stichworte").matches(m)){
        					 read =false;
        				 }
        			}
        			if (read) {
                    el.addItem(new ErgebnisItem(
                    		rz,
                    		rs.getInt("id"),
							rs.getInt("typ"),
							rs.getString("name"),
							rs.getDouble("litergewicht"),
							rs.getDouble("acid"),
							db.getDateFromString(rs.getString("geaendert")),
							rs.getString("stichworte"),
							rs.getString("adressen"),
							rs.getDouble("vorschlagsbestand"),
							rs.getDouble("bestand"),
							rs.getDouble("meldebestand"),
							(rz.isZero(rs.getDouble("bestellung.menge"))?false:true),
							rs.getInt("bestandseinheit"),
							rs.getDouble("staerke"),
							rs.getString("artikelnummer"),
							rs.getString("spezifikation"),
							rs.getInt("tempvon"),
							rs.getInt("tempbis"),
							rs.getInt("at.id")==0?false:true,
							rs.getInt("at.inarbeit")==0?false:true,
							rs.getInt("rezeptliste.konform") == 0?false:true,
							rs.getString("rezeptliste.konformDatum") == null?null:db.getDateFromString(rs.getString("rezeptliste.konformDatum")),
							rs.getString("rezeptliste.konformComment")
					));
        		}
        		}
        		if(rs != null) {
					rs.close();
				}
        	}
        	catch (final Exception e) {
                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.dbGetErgebnisListeVerwendung", e.getLocalizedMessage());
        	}
		else {
        	final String txt = rz.getLocale().getString("ergebnisliste.verwendung_not_found").replaceAll("%s", muster);
            dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("ergebnisliste.verwendung_titel"));
            dlgItem.setTitel(rz.getLocale().getString("ergebnisliste.verwendung_titel"));
            dlgItem.setMessage(txt);
            dlgItem.setIcon("warnung.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            rz.getDialogFactory().getDialog(dlgItem);
        }
        return el;
    }
    
     /**
      * dbGetErgebnisListeMuster gibt eine ErgebnisListe zurück, wobei die
      * Funktion immer auf eine optimale Abfrage zurückzugreifen versucht
      *
      */
    private ErgebnisListe dbGetErgebnisListeMuster(AbfrageItem ai){
        rz.getDatabase().getSTW().getHGArray();
        ResultSet rs;
        PreparedStatement stm  = null;
        String m = "";
        final ErgebnisListe el = new ErgebnisListe();
        ErgebnisItem ei = null;
        String muster = ai.getMuster();
        switch (ai.getOrder()){
            case DBAbfrage.ABFRAGE_ORDER_AA: break;
            case DBAbfrage.ABFRAGE_ORDER_AD: break;
            case DBAbfrage.ABFRAGE_ORDER_DA: break;
            case DBAbfrage.ABFRAGE_ORDER_DD: break;
        }
        muster = muster.replaceAll("[ ]+", ".*").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)");
        if (muster.equals("")) {
            muster = ".*";
        }
        if(ai.getAdressListe() == null) {
            ai.setAdressListe(new StichwortListe());
        }
        if(ai.getStichwortListe() == null) {
            ai.setStichwortListe(new StichwortListe());
        }
        final String adressMuster    = (ai.getAMode() == DBAbfrage.ABFRAGE_MODE_AND) ? ai.getAdressListe().toSQLAndString(): ai.getAdressListe().toSQLOrString() ;
        final String stichwortMuster = (ai.getSMode() == DBAbfrage.ABFRAGE_MODE_AND) ? ai.getStichwortListe().toSQLAndString(): ai.getStichwortListe().toSQLOrString() ;
        try{
            if( !ai.getStichwortListe().isEmpty() && !ai.getAdressListe().isEmpty()){
                switch (ai.getOrder()){
                    case DBAbfrage.ABFRAGE_ORDER_AA: stm=getErgebnisListe[ERG_NAME_NAME_ADR_STW_ASC];break;
                    case DBAbfrage.ABFRAGE_ORDER_AD: stm=getErgebnisListe[ERG_NAME_NAME_ADR_STW_DESC];break;
                    case DBAbfrage.ABFRAGE_ORDER_DA: stm=getErgebnisListe[ERG_NAME_DATE_ADR_STW_ASC];break;
                    case DBAbfrage.ABFRAGE_ORDER_DD:stm=getErgebnisListe[ERG_NAME_DATE_ADR_STW_DESC] ;break;
                }
                stm.setString(2, adressMuster);
                stm.setString(3, stichwortMuster);
            } else if (!ai.getStichwortListe().isEmpty() && ai.getAdressListe().isEmpty()){
                switch (ai.getOrder()){
                    case DBAbfrage.ABFRAGE_ORDER_AA: stm=getErgebnisListe[ERG_NAME_NAME_STW_ASC];break;
                    case DBAbfrage.ABFRAGE_ORDER_AD: stm=getErgebnisListe[ERG_NAME_NAME_STW_DESC];break;
                    case DBAbfrage.ABFRAGE_ORDER_DA: stm=getErgebnisListe[ERG_NAME_DATE_STW_ASC];break;
                    case DBAbfrage.ABFRAGE_ORDER_DD:stm=getErgebnisListe[ERG_NAME_DATE_STW_DESC] ;break;
                }
                stm.setString(2,stichwortMuster);
                    } else  if (ai.getStichwortListe().isEmpty() && !ai.getAdressListe().isEmpty()){
                        switch (ai.getOrder()){
                            case DBAbfrage.ABFRAGE_ORDER_AA: stm=getErgebnisListe[ERG_NAME_NAME_ADR_ASC];break;
                            case DBAbfrage.ABFRAGE_ORDER_AD: stm=getErgebnisListe[ERG_NAME_NAME_ADR_DESC];break;
                            case DBAbfrage.ABFRAGE_ORDER_DA: stm=getErgebnisListe[ERG_NAME_DATE_ADR_ASC];break;
                            case DBAbfrage.ABFRAGE_ORDER_DD:stm=getErgebnisListe[ERG_NAME_DATE_ADR_DESC] ;break;
                        }
                            stm.setString(2, adressMuster);
                        } else {
                            switch (ai.getOrder()){
                                case DBAbfrage.ABFRAGE_ORDER_AA: stm=getErgebnisListe[ERG_NAME_NAME_ASC];break;
                                case DBAbfrage.ABFRAGE_ORDER_AD: stm=getErgebnisListe[ERG_NAME_NAME_DESC];break;
                                case DBAbfrage.ABFRAGE_ORDER_DA: stm=getErgebnisListe[ERG_NAME_DATE_ASC];break;
                                case DBAbfrage.ABFRAGE_ORDER_DD:stm=getErgebnisListe[ERG_NAME_DATE_DESC] ;break;
                            }
                            }
            stm.setString(1, muster);
            rs = stm.executeQuery();
            StichwortListe ablage=rz.getDatabase().getSTW().getAblageFilter();
            m = ".*"+ablage.toSQLAndString()+".*";
            while(rs.next()){
                String stw = rs.getString("stichworte");
                ei = new ErgebnisItem(
                        rz,
                        rs.getInt("id"),
                        rs.getInt("typ"),
                        rs.getString("name"),
                        rs.getDouble("litergewicht"),
                        rs.getDouble("acid"),
                        db.getDateFromString(rs.getString("geaendert")),
                        stw,
                        rs.getString("adressen"),
                        rs.getDouble("vorschlagsbestand"),
                        rs.getDouble("bestand"),
                        rs.getDouble("meldebestand"),
						(rz.isZero(rs.getDouble("menge"))?false:true),
						rs.getInt("bestandseinheit"),
						rs.getDouble("staerke"),
						rs.getString("rezeptliste.artikelnummer"),
						rs.getString("spezifikation"),
						rs.getInt("tempvon"),
						rs.getInt("tempbis"),
						rs.getInt("at.id")==0?false:true,
						rs.getInt("at.inarbeit")==0?false:true,
						rs.getInt("rezeptliste.konform") == 0?false:true,
						rs.getString("rezeptliste.konformDatum") == null?null:db.getDateFromString(rs.getString("rezeptliste.konformDatum")),
						rs.getString("rezeptliste.konformComment")
                );
                 if(ablage.size() == 0) {
                    el.addItem(ei);
                } else
                    if(ai.isAblage()) {
                        el.addItem(ei);
                    } else {
                        if(!stw.matches(m)) {
                                el.addItem(ei);
                        }
                    }
            }
            if(rs != null) {
                rs.close();
            }
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.dbGetErgebnisListeMuster", e.getLocalizedMessage());
        }
        return el;
    } 
    
    public ErgebnisItem getErgebnisItem(int id) {
    	ErgebnisItem ret=null;
    	try {
    		getErgebnisListeEinzeln.setInt(1,id);
    		ResultSet rs=getErgebnisListeEinzeln.executeQuery();
    		if(rs.next()) {
    			 String stw = rs.getString("stichworte");
    			 ret=new ErgebnisItem(
                        rz,
                        rs.getInt("id"),
                        rs.getInt("typ"),
                        rs.getString("name"),
                        rs.getDouble("litergewicht"),
                        rs.getDouble("acid"),
                        db.getDateFromString(rs.getString("geaendert")),
                        stw,
                        rs.getString("adressen"),
                        rs.getDouble("vorschlagsbestand"),
                        rs.getDouble("bestand"),
                        rs.getDouble("meldebestand"),
						(rz.isZero(rs.getDouble("menge"))?false:true),
						rs.getInt("bestandseinheit"),
						rs.getDouble("staerke"),
						rs.getString("rezeptliste.artikelnummer"),
						rs.getString("spezifikation"),
						rs.getInt("tempvon"),
						rs.getInt("tempbis"),
						rs.getInt("at.id")==0?false:true,
						rs.getInt("at.inarbeit")==0?false:true,
						rs.getInt("rezeptliste.konform") == 0?false:true,
						rs.getString("rezeptliste.konformDatum") == null?null:db.getDateFromString(rs.getString("rezeptliste.konformDatum")),
						rs.getString("rezeptliste.konformComment")
                );
    		}
    	}catch (final Exception e){
                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.getErgebnisItem", e.getLocalizedMessage());
        }
    	return ret;
    }
    
    /**
     * ErgebnisListe aus erweiterter Abfrage
     */
    public ErgebnisListe dbGetErgebnisListeErweitert(AbfrageItem ai) {
    	rz.getDatabase().getSTW().getHGArray();
    	final ErgebnisListe el = new ErgebnisListe();
    	try {
    		ResultSet rs;
    		final Statement stm = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
    		rs = stm.executeQuery(ai.getMuster());
    		while (rs.next()) {
                el.addItem(new ErgebnisItem(
	        		rz,
	        		rs.getInt("id"),
					rs.getInt("typ"),
					rs.getString("name"),
					rs.getDouble("litergewicht"),
					rs.getDouble("acid"),
					db.getDateFromString(rs.getString("rezeptliste.geaendert")),
					rs.getString("stichworte"),
					rs.getString("adressen"),
					rs.getDouble("vorschlagsbestand"),
					rs.getDouble("bestand"),
					rs.getDouble("meldebestand"),
					(rz.isZero(rs.getDouble("menge"))?false:true),
					rs.getInt("bestandseinheit"),
					rs.getDouble("staerke"),
					rs.getString("rezeptliste.artikelnummer"),
					rs.getString("spezifikation"),
					rs.getInt("tempvon"),
					rs.getInt("tempbis"),
					rs.getInt("at.id")==0?false:true,
					rs.getInt("at.inarbeit")==0?false:true,
					rs.getInt("rezeptliste.konform") == 0?false:true,
					rs.getString("rezeptliste.konformDatum") == null?null:db.getDateFromString(rs.getString("rezeptliste.konformDatum")),
					rs.getString("rezeptliste.konformComment")
				));
    		}
    	}
    	catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.dbGetErgebnisListeErweitert", e.getLocalizedMessage());
        }
    	return el;
    }
    
    public ErgebnisListe dbGetErgebnisListeBW() {
    	rz.getDatabase().getSTW().getHGArray();
    	final ErgebnisListe el = new ErgebnisListe();
    	try {
        	final BestandswarnungsListe bl = rz.getDatabase().getRezeptur().getBestandswarnungen(false,false);
        	if(bl!= null && bl.size()>0) {
        		for(int i=0;i<bl.size();i++) {
        			el.addItem(this.getErgebnisItem(bl.getItem(i).getID()));
        		}
	    	}
    	}
    	catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBErgebnis.dbGetErgebnisListeErweitert", e.getLocalizedMessage());
        }
    	return el;
    }
    
    
    
}
