/*
 *  Copyright (C) Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.swing.JComboBox;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.etiketten.EtikettenBogenItem;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class DBEtiketten {

    RzPro           		rz;
    Connection      	con;
    DBFactory       	db;

    PreparedStatement   getEtikettenListe;
    PreparedStatement	   getEtikettenBogen;

    /** Creates a new instance of DBAbfrage */
    public DBEtiketten(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }

    private void setStatements(){
        try{
            getEtikettenListe  = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_ETIKETTENBOGEN + " ORDER BY name",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getEtikettenBogen  = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_ETIKETTENBOGEN + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBEtiketten.setStatements", e.getLocalizedMessage());
        }
    }

    public EtikettenBogenItem getBogen(int id) {
    	EtikettenBogenItem bi = null;
        try{
        	getEtikettenBogen.setInt(1,id);
            final ResultSet rs = getEtikettenBogen.executeQuery();
            while(rs.next()) {
                bi = new EtikettenBogenItem(
                        rz,
                        rs.getInt("id"),
                        rs.getString("name"),
						rs.getString("image"),
                        rs.getInt("num_columns"),
                        rs.getInt("num_rows"),
                        rs.getDouble("width"),
                        rs.getDouble("height"),
                        rs.getInt("report")
                );
            }
        }
        catch (final SQLException e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_ETIKETTENBOGEN + ".getEtikettenBogen" ,e.getLocalizedMessage());
        }
    	return bi;
    }

    public ArrayList getEtikettenListe() {
        final ArrayList al = new ArrayList();
        try{
            final ResultSet rs = getEtikettenListe.executeQuery();
            while(rs.next()) {
                al.add(new EtikettenBogenItem(
                        rz,
                        rs.getInt("id"),
                        rs.getString("name"),
						rs.getString("image"),
                        rs.getInt("num_columns"),
                        rs.getInt("num_rows"),
                        rs.getDouble("width"),
                        rs.getDouble("height"),
                        rs.getInt("report")
                ));
            }
        }
        catch (final SQLException e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_ETIKETTENBOGEN + ".getEtikettenListe" ,e.getLocalizedMessage());
        }
        return al;
    }

    /**  füllt die angegebene JComboBox mit einer
     * Liste der Etikettenbögen  und markiert einen Bogen
     * @param cmb  die Combobox
     * @param aDefault   Die id des zu selektierenden Bogens oder -1 für Default
     */
    public void getEtikettenListeCombo(JComboBox cmb,int aDefault){
        int sel;
        final ArrayList al = getEtikettenListe();
        cmb.removeAllItems();
        for(int i = 0 ; i < al.size();i++){
            cmb.addItem(al.get(i));
        }
        if(aDefault == -1) {
            sel =  rz.getOptionFactory().getOption("etiketten.bogen",1);
        } else {
            sel = aDefault;
        }
        for(int i = 0 ;i < cmb.getModel().getSize();i++){
            if(((EtikettenBogenItem)cmb.getModel().getElementAt(i)).getId() == sel){
                cmb.setSelectedIndex(i);
                break;
            }
        }
    }
}
