/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen �ber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenst�ndige
 * Verbindungen zur Datenbank auf
 *
 */
package de.lunqual.rzpro.database;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.log.LogFactory;

public class DBFactory {

	// DataBase
	public static final String      DefaultDataBaseDriver = "org.mariadb.jdbc.Driver";
	public static final String      DefaultDataBaseURL  = "jdbc:mariadb://127.0.0.1:3306/rzpro";
	public static final int          DB_CLOSE            = 0;
	public static final int          DB_OPEN             = 1;

	// Tabellen
	public static final String TABLE_ABFRAGEN 					= "abfragen";
	public static final String TABLE_ADRESSEN 					= "adressen";
	public static final String TABLE_CONTAINER 					= "container";
	public static final String TABLE_CONTAINER_ORDNER			= "container_ordner";
	public static final String TABLE_CURRENCIES					= "currencies";
	public static final String TABLE_EINHEITEN					= "einheiten";
	public static final String TABLE_FORMULARE					= "formulare";
	public static final String TABLE_GRUNDEINHEITEN				= "grundeinheiten";
	public static final String TABLE_LAGER 						= "lager";
	public static final String TABLE_REZEPTLISTE				= "rezeptliste";
	public static final String TABLE_STICHWORTE					= "stichworte";
	public static final String TABLE_LIEFERSCHEIN				= "lieferschein";
	public static final String TABLE_LIEFERSCHEIN_ZEILE		    = "lieferschein_zeile";
	public static final String TABLE_ETIKETTENBOGEN				= "etikettenbogen";
	public static final String TABLE_BUCHUNG					= "buchungen";
	public static final String TABLE_HERSTELLUNG				= "herstellungen";
	public static final String TABLE_CLIENTFILTER				= "clientfilter";
	public static final String TABLE_AUSBEUTE					= "ausbeute";
	public static final String TABLE_PALETTEN					= "paletten";
	public static final String TABLE_LOSNUMMER					= "losnummer";
	public static final String TABLE_INVENTUREN					= "inventuren";
	public static final String TABLE_INVENTURZEILE				= "inventurzeile";
	public static final String TABLE_RAUMLISTE					= "raumliste";
	public static final String TABLE_ACID						= "acid";
	public static final String TABLE_DEKLARATIONEN		    	= "deklarationen";
	public static final String TABLE_DEKLARATION_TEXT	    	= "deklaration_text";
	public static final String TABLE_DATENBLATT					= "datenblatt";
	public static final String TABLE_BESTELLUNG					= "bestellung";
	public static final String TABLE_LABORWERTE					= "laborwerte";
	public static final String TABLE_LABORWERTE_WERTE  			= "laborwerte_werte";
	public static final String TABLE_PROBEN						= "proben";
	public static final String TABLE_ZUTATENVERZEICHNIS			= "zutatenverzeichnis";
	public static final String TABLE_MESSAGES					= "messages";
	public static final String TABLE_HISTORY					= "history";
	public static final String TABLE_LAST_ACTIVE				= "last_active";
	public static final String TABLE_ABLAGEFILTER          		= "ablagefilter";
	public static final String TABLE_OPTIONS					= "optionen";
	public static final String TABLE_MUSTERNUMMER				= "musternummer";
	public static final String TABLE_VERSIONEN					= "versionen";
	public static final String TABLE_PLAN						= "plan";
	public static final String TABLE_LOSNUMMER_VORLAGE 			= "losnummer_vorlage";
	public static final String TABLE_AUFTRAG					= "auftrag";
	public static final String TABLE_CHANGES					= "changes";
	public static final String TABLE_LIEFERSCHEIN_L_MUSTER 		= "lieferschein_l_muster";
	public static final String TABLE_TEMPERATURZONEN			= "temperaturzonen";
	public static final String TABLE_AUFTRAEGE					= "auftraege";
	public static final String TABLE_AUFTRAGSLISTE				= "auftragsliste";
	public static final String TABLE_KALENDER					= "kalender";
	public static final String TABLE_TERMINE					= "termine";
	public static final String TABLE_DM							= "dm";
	public static final String TABLE_ORTE						= "orte";
	public static final String TABLE_TANKS						= "tanks";
	public static final String TABLE_AUFTRAG_BENUTZER 			= "auftragbenutzer";
	public static final String TABLE_SORTEN			 			= "sorten";
	public static final String TABLE_MISCHUNGEN		 			= "mischungen";
	public static final String TABLE_TICKETS		  			= "tickets";
	public static final String TABLE_TICKETS_TRANSAKTIONEN		= "tickets_transaktionen";
	public static final String TABLE_BEWERTUNGEN_KATEGORIEN		= "bewertungen_kategorien";
	public static final String TABLE_BEWERTUNGEN				= "bewertungen";
	public static final String TABLE_BEWERTUNGEN_BLOCK			= "bewertungen_block";
	public static final String TABLE_BEWERTUNGEN_DEFAULTS		= "bewertungen_defaults";
	public static final String TABLE_MISCHUNGSABFRAGE			= "mischungsabfragen";
	public static final String TABLE_ICONS						= "icons";
	public static final String TABLE_ACCESS						= "access";
	public static final String TABLE_LOSNUMMER_LISTE			= "losnummer_liste";
	public static final String TABLE_STEUERLAGER				= "steuer_lager";
	public static final String TABLE_PROPERTIES					= "properties";
	public static final String TABLE_DOCUMENTS					= "documents";
	public static final String TABLE_KONTRAKTE					= "kontrakte";
	public static final String TABLE_FILTERSCHICHTEN			= "filterschichten";
	public static final String TABLE_FILTERSCHICHTEN_BUCHUNGEN  = "filterschichten_buchungen";
	
	
	
	PreparedStatement getFieldExists;
	PreparedStatement getFormExists;
  
	// Update-Tabellen und SQL
	// VERsion 1.0.6
	private static final String FIELD_106								="hinweis";
	private static final String SQL_106 = "ALTER TABLE rezeptliste ADD COLUMN (hinweis text NOT NULL,hinweis_datum datetime NOT NULL DEFAULT '2004-08-01 00:00:00',hinweis_user varchar(255) NOT NULL DEFAULT '')";

	// Update-Tabellen und SQL
	// VERsion 1.0.8
	private static final String FIELD_108								="brennwert";
	private static final String SQL_108 = "ALTER TABLE rezeptliste ADD COLUMN (brennwert double NOT NULL DEFAULT '0',brennwert_af double NOT NULL DEFAULT '0')";

	// Update-Tabellen und SQL
	// VERsion 1.1.4
	private static final String FIELD_1104								="paletten";
	private static final String SQL_1104 = "CREATE TABLE paletten( " +
	" id                    int unsigned not null auto_increment," +
	" bezeichnung           varchar(255) not null default '',"+
	" inhalt                double not null default '0',"+
	" flaschen_per_karton   int unsigned not null default '6',"+
	" karton_per_palette    int unsigned not null default '1'," +
	" PRIMARY KEY idx(id)" +
	") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";


	// Update-Tabellen und SQL
	// VERsion 1.1.5
	private static final String FIELD_115								="vtemplate";
	private static final String SQL_115 = "ALTER TABLE losnummer ADD COLUMN vtemplate text  NOT NULL";

	//Update-Tabellen und SQL
	// VErsion 1.1.7
	private static final String FIELD_117								= DBFactory.TABLE_INVENTUREN;
	private static final String SQL_117 = "CREATE TABLE if not exists " + DBFactory.TABLE_INVENTUREN + "(" +
	" id int unsigned not null auto_increment," +
	" bezeichnung text not null ," +
	" bemerkungen text not null ,"+
	" erstellt datetime not null default '2004-01-01 00:00:00'," +
	" geaendert datetime not null default '2004-01-01 00:00:00'," +
	" user_1 varchar(255) not null default 'system'," +
	" user_2 varchar(255) not null default 'system'," +
	" PRIMARY KEY idx(id)" +
	" ) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	private static final String FIELD_117_1								= DBFactory.TABLE_INVENTURZEILE;
	private static final String SQL_117_1 = "CREATE TABLE if not exists " + DBFactory.TABLE_INVENTURZEILE + "(" +
	" id int unsigned not null auto_increment," +
	" inventur int unsigned not null default '0',"+
	" tanknummer varchar(255) not null default ''," +
	" tanknummer_num int not null default '0',"+
	" bezeichnung text not null," +
	" dbkey int unsigned not null default '0',"+
	" staerke double not null default '0.0'," +
	" extrakt int not null default '0',"+
	" raum int not null default 0,"+
	" typ int unsigned not null default '0',"+
	" uebernommen int unsigned not null default '0',"+
	" liter double not null default '0.0'," +
	" liter20 double not null default '0.0',"+
	" tanktemperatur double not null default '20.0'," +
	" kg double not null default '0.0',"+
	" la double not null default '0.0'," +
	" brutto double not null default '0.0',"+
	" tara double not null default '0.0'," +
	" litergewicht double not null default '1',"+
	" tafel2 double not null default '0.0',"+
	" tafel3 double not null default '0.0'," +
	" erstellt datetime not null default '2004-01-01 00:00:00'," +
	" user_1 varchar(255) not null default 'system'," +
	" PRIMARY KEY idx(id)," +
	" INDEX idx1(dbkey)," +
	" INDEX idx2(raum)," +
	" INDEX idc3(inventur),"+
	" INDEX idx4(bezeichnung(40))"  +
	" ) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	private static final String FIELD_117_2								= DBFactory.TABLE_RAUMLISTE;
	private static final String SQL_117_2 = "CREATE TABLE if not exists " + DBFactory.TABLE_RAUMLISTE + "(" +
	" r_id int unsigned not null auto_increment," +
	" r_inventur int unsigned not null default '0',"+
	" r_bezeichnung varchar(255) not null default ''," +
	" PRIMARY KEY idx(r_id)" +
	" ) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	private static final String FIELD_117_3						= "Inventur (nach Raum)";
	private static final String FILE_117_3						= "inventur.txt";

	private static final String FIELD_117_4						= "Inventur (nach Inhalt)";
	private static final String FILE_117_4						= "inventur_1.txt";

	//Update-Tabellen und SQL
	// VErsion 1.1.7_5
	private static final String FIELD_117_5								= DBFactory.TABLE_ACID;
	private static final String SQL_117_5 = "CREATE TABLE if not exists " + DBFactory.TABLE_ACID + "(" +
	" id int unsigned not null auto_increment," +
	" `system` int unsigned not null default '0',"+
	" name varchar(255) not null default ''," +
	" factor double not null default '0.0',"+
	" PRIMARY KEY idx(id)" +
	" ) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	private static final String SQL_117_5_1="INSERT INTO acid (id,`system`,name,factor) values(1,1,'Weinsäure',1.0)";
	private static final String SQL_117_5_2="INSERT INTO acid (id,`system`,name,factor) values(2,1,'Äpfelsäure',0.893)";
	private static final String SQL_117_5_3="INSERT INTO acid (id,`system`,name,factor) values(3,1,'Citronensäure',0.853)";
	private static final String SQL_117_5_4="INSERT INTO acid (id,`system`,name,factor) values(4,1,'Milchsäure',1.2)";
	private static final String SQL_117_5_5="INSERT INTO acid (id,`system`,name,factor) values(5,1,'Schwefelsäure',0.653)";
	private static final String SQL_117_5_6="INSERT INTO acid (id,`system`,name,factor) values(6,1,'Essigsäure',0.8)";

	// VERsion 1.1.7_6
	private static final String FIELD_117_6								="acid";
	private static final String SQL_117_6 = "ALTER TABLE rezeptliste ADD COLUMN acid double NOT NULL DEFAULT '0.0'";

	// VERsion 1.2.1
	private static final String FIELD_121								="deklarationen";
	private static final String SQL_121 = "ALTER TABLE rezeptliste ADD COLUMN deklarationen text NOT NULL";

	// VERsion 1.2.1_1
	private static final String FIELD_121_1							="deklarationen_alle";
	private static final String SQL_121_1 = "ALTER TABLE rezeptliste ADD COLUMN deklarationen_alle text NOT NULL ";


	// Version 1.2.1_2
	private static final String FIELD_121_2							= DBFactory.TABLE_DEKLARATIONEN;
	private static final String SQL_121_2 = "CREATE TABLE deklarationen ( " +
			  "id            int unsigned NOT NULL auto_increment, "+
			  "name          varchar(255) NOT NULL DEFAULT '', "+
			  "deklaration   text NOT NULL , "+
			  "user_1        varchar(255) NOT NULL DEFAULT 'system', "+
			  "user_2        varchar(255) NOT NULL DEFAULT 'system', "+
			  "erstellt      datetime NOT NULL DEFAULT '2004-05-01 00:00:00', "+
			  "geaendert     datetime NOT NULL DEFAULT '2004-05-01 00:00:00', "+
			  "PRIMARY KEY  idx (id), "+
			  "KEY idx1 (name) "+
			") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	//Version 1.2.1_3 Das Formular rechnen_5.txt muss enthalten sein

	private static final String FIELD_121_3						= "Produktspezifikation/Deklarationen";
	private static final String FILE_121_3						= "rechnen_5.txt";

	private static final String FIELD_122_1								= DBFactory.TABLE_DEKLARATION_TEXT;
	private static final String SQL_122_1 = "CREATE TABLE if not exists " + DBFactory.TABLE_DEKLARATION_TEXT+ "(" +
		"formtext      text NOT NULL" +
	") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	private static final String FIELD_122_2						= "Produktspezifikation Formblatt";
	private static final String FILE_122_2						= "spezifikation_form.txt";

	private static final String FIELD_124							= "vg";
	private static final String SQL_124 = "ALTER TABLE lager ADD COLUMN (vg varchar(12) NOT NULL DEFAULT '000000',hg varchar(12) NOT NULL DEFAULT 'ffffff')";

	//Version 1.4.0 _1 Das Formular ausstattung_raw.txt muss enthalten sein
	private static final String FIELD_140_1						= "Ausstattung/Text";
	private static final String FILE_140_1						= "ausstattung_raw.txt";

	//Version 1.4.0 _2 Das Formular ausstattung_calc.txt muss enthalten sein
	private static final String FIELD_140_2						= "Ausstattung/Kalkulation";
	private static final String FILE_140_2						= "ausstattung_calc.txt";

	//Version 1.4.0_3 Die Tabelle datenblatt muss vorhanden sein
	private static final String FIELD_140_3	=DBFactory.TABLE_DATENBLATT;
	private static final String SQL_140_3 = "create table datenblatt(" +
		"id int unsigned not null auto_increment," +
		"rezeptur int not null default '0',"+
		"name varchar(255) not null default ''," +
		"staerke double not null default '0.0'," +
		"datenblatt mediumtext not null,"+
		"primary key idx(id),"+
		"index idx2(rezeptur)"+
		" ) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	//Version 1.5.0 Bestellungen
	private static final String FIELD_1_5_0	=DBFactory.TABLE_BESTELLUNG;
	private static final String SQL_1_5_0= "create table if not exists bestellung(" +
		"id int unsigned not null auto_increment,"+
		"rezeptur int unsigned not null default '0',"+
		"adresse int unsigned not null default '0',"+
		"bezeichnung text not null,"+
		"artikelnummer text not null,"+
		"firma text not null ,"+
		"einheit int unsigned not null default '0',"+
		"menge double not null default '0.0',"+
		"rest double not null default '0.0',"+
		"comment text not null,"+
		"losnummer text not null,"+
		"erstellt datetime not null default '2004-01-01 00:00:00',"+
		"geaendert datetime not null default '2004-01-01 00:00:00',"+
		"erledigt datetime not null default '2004-01-01 00:00:00',"+
		"user_1 varchar(255) not null default 'system',"+
		"user_2 varchar(255) not null default 'system',"+
		"PRIMARY KEY idx(id) "+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	//Version 1.5.0 Vorschlagsbestand
	private static final String FIELD_1_5_0_1								="vorschlagsbestand";
	private static final String SQL_1_5_0_1 = "ALTER TABLE rezeptliste ADD COLUMN vorschlagsbestand double NOT NULL DEFAULT '0'";

	//Version 1.5.3 Laborwerte
	private static final String FIELD_1_5_3_1  = DBFactory.TABLE_LABORWERTE;
	private static final String SQL_1_5_3_1 ="CREATE  TABLE if not exists laborwerte ("+
		"id int unsigned not null auto_increment,"+
		"bezeichnung varchar(255) not null default '',"+
		"bemerkungen text not null,"+
		"einheit1 int not null default '11',"+
		"einheit2 int not null default '3',"+
		"PRIMARY KEY idx(id)"+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	private static final String FIELD_1_5_3_2  = DBFactory.TABLE_LABORWERTE_WERTE;
	private static final String SQL_1_5_3_2 ="CREATE  TABLE if not exists laborwerte_werte ("+
	  "id int unsigned not null auto_increment,"+
	  "laborwert int unsigned not null default '0',"+
	  "rezeptur int unsigned not null default '0',"+
	  "wert double not null default '0.0',"+
	  "PRIMARY KEY idx(id),"+
	  "INDEX idx1(rezeptur),"+
	  "INDEX idx2(laborwert)  "+
	  ") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";


	private static final String FIELD_1_5_8_1						= "Statistikliste";
	private static final String FILE_1_5_8_1						= "statistikliste.txt";

	private static final String FIELD_1_5_9_1						= DBFactory.TABLE_PROBEN;
	private static final String SQL_1_5_9_1 = "CREATE TABLE if not exists proben ("+
			  "id int unsigned not null auto_increment,"+
			  "bezeichnung text not null ,"+
			  "rezeptur int unsigned not null default '0',"+
			  "rezeptur_bezeichnung text not null,"+
			  "adressen text not null ,"+
			  "losnummer text not null ,"+
			  "bemerkungen text not null ,"+
			  "erstellt datetime not null default '2004-01-01 00:00:00',"+
			  "user_1 varchar(255) not null default 'system',"+
			  "PRIMARY KEY idx(id),"+
			  "INDEX idx1(bezeichnung(40)),"+
			  "INDEX idx2(rezeptur),"+
			  "INDEX idx3(erstellt),"+
			  "INDEX idx4(losnummer(40))"+
			  ") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	//Version 1.5.9.1 Das Formular proben1.txt muss enthalten sein
	private static final String FIELD_1_5_9_2						= "Probe";
	private static final String FILE_1_5_9_2						= "proben1.txt";

	//Version 1.6.0 Die Tabelle "Zutatenverzeichnis" muss vorhanden sein

	private static final String FIELD_1_6_0  = DBFactory.TABLE_ZUTATENVERZEICHNIS;
	private static final String SQL_1_6_0 ="CREATE  TABLE if not exists zutatenverzeichnis ("+
	  "id int unsigned not null auto_increment,"+
	  "priority int unsigned not null default '0',"+
	  "stichwort int unsigned not null default '0',"+
	  "einheit int unsigned not null default '0',"+
	  "wert double not null default '0.0',"+
	  "bezeichnung text not null," +
	  "PRIMARY KEY idx(id)"+
	  ") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	//Version 1.6.0 Die Tabelle "messages" muss vorhanden sein

	private static final String FIELD_1_6_0_1  = DBFactory.TABLE_MESSAGES;
	private static final String SQL_1_6_0_1 ="CREATE  TABLE if not exists messages ("+
	  "id int unsigned not null auto_increment,"+
	  "typ int unsigned not null default '0',"+
	  "message text not null," +
	  "PRIMARY KEY idx(id)"+
	  ") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	//Version 1.6_0_2 Das Formular zutatenverzeichnis.txt muss enthalten sein
	private static final String FIELD_1_6_0_2					= "Zutatenverzeichnis";
	private static final String FILE_1_6_0_2						= "zutatenverzeichnis.txt";


	// Update-Tabellen und SQL
	// VERsion _6_0_3
	private static final String FIELD_1_6_0_3								="c_out";
	private static final String SQL_1_6_0_3 = "ALTER TABLE container ADD COLUMN (c_out int not null default 0)";

	// Update-Tabellen und SQL
	// VERsion  1.6.9
	private static final String FIELD_1_6_9_0								="comment";
	private static final String SQL_1_6_9_0 = "ALTER TABLE lieferschein ADD COLUMN comment varchar(255)  NOT NULL default ''";
	
	private static final String FIELD_1_6_9_1								="comment";
	private static final String SQL_1_6_9_1 = "ALTER TABLE lieferschein_zeile ADD COLUMN comment varchar(255)  NOT NULL default ''";

	// Update-Tabellen und SQL
	// VERsion 1.6.9-2
	private static final String FIELD_1_6_9_2							="tank";
	private static final String SQL_1_6_9_2 = "ALTER TABLE rezeptliste ADD COLUMN tank varchar(255)NOT NULL DEFAULT '' ";

	private static final String FIELD_1_6_9_3							="tank";
	private static final String SQL_1_6_9_3 = "ALTER TABLE herstellungen ADD COLUMN tank varchar(255) NOT NULL DEFAULT '' ";
	
	//Version 1.7.0
	//Die Tabelle History muss vorhanden sein
	
	private static final String FIELD_1_7_0  = DBFactory.TABLE_HISTORY;
	private static final String SQL_1_7_0 = "	CREATE TABLE if not exists history ("+ 
			  "id                int unsigned NOT NULL auto_increment,"+
			  "typ              int NOT NULL DEFAULT '1',"+
			  "ordering       int unsigned NOT NULL DEFAULT 0,"+
			  "a_mode       int unsigned NOT NULL DEFAULT 0,"+
			  "s_mode       int unsigned NOT NULL DEFAULT 0,"+
			  "name          varchar(255) DEFAULT NULL,"+
			  "muster        varchar(255) DEFAULT NULL,"+
			  "mode          int unsigned NOT NULL DEFAULT '0',"+
			  "stichworte    text NOT NULL,"+
			  "adressen     text NOT NULL ,"+
			  "rank			int NOT NULL DEFAULT '0', " +
			  "user_1        varchar(255) NOT NULL DEFAULT 'system', "+
			  "PRIMARY KEY  idx (id) "+
			 ") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	private static final String FIELD_1_7_1  = DBFactory.TABLE_LAST_ACTIVE;
	private static final String SQL_1_7_1 = "	CREATE TABLE if not exists last_active ("+ 
			" id 					int  unsigned not null auto_increment," +
			" user			 	varchar(255) not null default 'system',"+
			" value 			int not null default '0', "+
			"PRIMARY KEY idx(id)"+
			") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	private static final String FIELD_1_7_3_1							="ablage";
	private static final String SQL_1_7_3_1 = "ALTER TABLE abfragen ADD COLUMN ablage int  NOT NULL DEFAULT 0 ";
	
	private static final String FIELD_1_7_3_2  = DBFactory.TABLE_ABLAGEFILTER;
	private static final String SQL_1_7_3_2 = "	CREATE TABLE ablagefilter ("+ 
		"stichworte varchar(255) NOT NULL DEFAULT ''"+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	private static final String SQL_1_7_3_3 = "INSERT INTO ablagefilter (stichworte) VALUES ('')";	
	
	private static final String FIELD_1_7_3_4							="ablage";
	private static final String SQL_1_7_3_4 = "ALTER TABLE history ADD COLUMN ablage int  NOT NULL DEFAULT 0 ";
	
	private static final String FIELD_1_8_1_1  = DBFactory.TABLE_OPTIONS;
	private static final String SQL_1_8_1_1 = "	CREATE TABLE "+ TABLE_OPTIONS + " ("+ 
	"id int unsigned NOT NULL auto_increment,"+
	"typ int unsigned NOT NULL default '0'," +
	"user varchar(255),"+
	"options text,"+
	"PRIMARY KEY idx(id)"+
	") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	// Version 1.8_5_1
	private static final String FIELD_1_8_5_1							= DBFactory.TABLE_MUSTERNUMMER;
	private static final String SQL_1_8_5_1 = "CREATE TABLE " +DBFactory.TABLE_MUSTERNUMMER+ "  ( " +
			  "muster          varchar(255) NOT NULL DEFAULT \"M$d$m$y-$X\""+
			") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	//
	
	private static final String SQL_1_8_5_2="INSERT INTO musternummer (muster) values('M$d$m$y-$X')";
	
	private static final String FIELD_1_8_5_3								="versionen";
	private static final String SQL_1_8_5_3 = "CREATE TABLE versionen ( " +
	" id                    int unsigned not null auto_increment," +
	" rezeptur  		 int unsigned not null default 0,"+
	" user           	varchar(255) not null default '',"+
    " erstellt datetime not null default '2004-01-01 00:00:00',"+
    " version text, " +
    " bezeichnung varchar(255) not null default '', "+
	" PRIMARY KEY idx(id)," +
	" KEY idx1(rezeptur)"+
	") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	
	// VERsion 1.8.8-1
	//Die Tabelle Abfrage muss die Spalte "privat" enthalten
	private static final String FIELD_1_8_8_1						="privat";
	private static final String SQL_1_8_8_1 = "ALTER TABLE abfragen ADD COLUMN privat INT NOT NULL DEFAULT 0";
	
	//Version 1.8.8.2
	// Die Spalte "muster" in der Tabelle Abfrage muss 1024 Bytes
	private static final String FIELD_1_8_8_2						= "SELECT muster FROM abfragen";
	private static final int SIZE_1_8_8_2								= 8192;
	private static final String SQL_1_8_8_2 = "ALTER TABLE abfragen modify COLUMN muster varchar(8192) NOT NULL DEFAULT ''";	

	//Version 1.8.8.3
	// Die Spalte "muster" in der Tabelle history muss 1024 Bytes
	private static final String FIELD_1_8_8_3						= "SELECT muster FROM history";
	private static final int SIZE_1_8_8_3								= 8192;
	private static final String SQL_1_8_8_3 = "ALTER TABLE history modify COLUMN muster varchar(8192) NOT NULL DEFAULT ''";	
	
	//Version 1.8.8.4
	//Das Formular "ergebnisliste.txt" muss vorhanden sein
	private static final String FIELD_1_8_8_4						= "Ergebnisliste";
	private static final String FILE_1_8_8_4							= "ergebnisliste.txt";
	
	//Version 1.8.8.5
	//Das Formular "kalkulation_3.txt" muss vorhanden sein
	private static final String FIELD_1_8_8_5						= "Kalkulation/AS (Kurzform)";
	private static final String FILE_1_8_8_5							= "kalkulation_3.txt";
	
	//Version 1.8.8.6
	//Das Formular "kalkulation_3.txt" muss vorhanden sein
	private static final String FIELD_1_8_8_6						= "Kalkulation/AS";
	private static final String FILE_1_8_8_6							= "kalkulation_4.txt";
	

	private static final String FIELD_1_8_9_1						= "Bestandswarnungsliste";
	private static final String FILE_1_8_9_1						= "bestandswarnungsliste.txt";
	
	
	private static final String FIELD_1_8_9_2								="spezifikation";
	private static final String SQL_1_8_9_2 = "ALTER TABLE rezeptliste ADD COLUMN spezifikation text NOT NULL default ''";

	private static final String FIELD_1_8_9_3								="typ";
	private static final String SQL_1_8_9_3 = "ALTER TABLE adressen ADD COLUMN typ int NOT NULL";
	
	//Version 1.9.5
	// Die Tabelle Losnummer_vorkage muss erstellt werden
	private static final String FIELD_1_9_5								= DBFactory.TABLE_LOSNUMMER_VORLAGE;
	private static final String SQL_1_9_5 = "CREATE TABLE "+ DBFactory.TABLE_LOSNUMMER_VORLAGE + "  ( " +
	" id                    int unsigned not null auto_increment," +
	" bezeichnung	varchar(255) not null default '',"+
	" value         		varchar(255) not null default '',"+
    " erstellt datetime not null default '2012-01-01 00:00:00',"+
    " user varchar(255) not null default 'system',"+
	" PRIMARY KEY idx(id)" +
	") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	private static final String FIELD_2_0_0_1								="r_probe";
	private static final String SQL_2_0_0_1 = "ALTER TABLE rezeptliste ADD COLUMN r_probe int NOT NULL default 0";

	private static final String FIELD_2_0_0_2								="r_probe";
	private static final String SQL_2_0_0_2 = "ALTER TABLE herstellungen ADD COLUMN r_probe int NOT NULL default 0";

	private static final String FIELD_2_0_0_3								="entsorgt";
	private static final String SQL_2_0_0_3 = "ALTER TABLE proben ADD COLUMN entsorgt datetime NOT NULL default '2012-01-01 00:00:00'";

	private static final String FIELD_2_0_0_4								="user_2";
	private static final String SQL_2_0_0_4 = "ALTER TABLE proben ADD COLUMN user_2 varchar(1024) NOT NULL default 'system'";

	private static final String FIELD_2_0_0_5								="deleted";
	private static final String SQL_2_0_0_5 = "ALTER TABLE proben ADD COLUMN deleted int NOT NULL default 0";
	
	private static final String FIELD_2_0_0_6						= "Probenliste";
	private static final String FILE_2_0_0_6						= "probenliste.txt";
	
		
	//Version 2.0.1
	// Die Tabelle Losnummer_vorkage muss erstellt werden
	private static final String FIELD_2_0_0_8								= DBFactory.TABLE_CHANGES;
	private static final String SQL_2_0_0_8 = "CREATE TABLE "+ DBFactory.TABLE_CHANGES + "  ( " +
	" id                    int unsigned not null auto_increment," +
	" rezeptur_id      int unsigned not null default 0,"+
	" bezeichnung	 varchar(255) not null default '',"+
	" alt	         		 text not null,"+
	" neu                 text not null," +
    " erstellt datetime not null default '2012-01-01 00:00:00',"+
    " user varchar(255) not null default 'system',"+
    " relevant			int unsigned not null default 0, " +
	" PRIMARY KEY idx(id)," +
	" KEY idx1(rezeptur_id)"+
	") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	
	//Version 2_0_1 Das Formular changes.txt muss enthalten sein
	private static final String FIELD_2_0_0_9						= "Aenderungen";
	private static final String FILE_2_0_0_9					= "changes.txt";

	//Version 2_0_1 Das Formular laborwerte.txt muss enthalten sein
	private static final String FIELD_2_0_0_10						= "Laborwerte";
	private static final String FILE_2_0_0_10					= "laborwerte.txt";
	
	// VERsion 2_0_1
	//Die Einheiten müssen den Wert milligram enthalten
	private static final String FIELD_2_0_0_11 = "mg";
	private static final String SQL_2_0_0_11="INSERT INTO einheiten (name,typ,faktor) values('" +FIELD_2_0_0_11+  "',2,0.000001)";
	
	private static final String FIELD_2_0_2_1								="spezifikation";
	private static final String SQL_2_0_2_1 = "ALTER TABLE laborwerte_werte ADD COLUMN spezifikation int NOT NULL default 0";
	
	
	private static final String FIELD_2_0_2_2 = "100gr";
	private static final String SQL_2_0_2_2="INSERT INTO einheiten (name,typ,faktor) values('" +FIELD_2_0_2_2+  "',2,0.1)";
	
	
	private static final String FIELD_2_0_2_3 = "100ml";
	private static final String SQL_2_0_2_3="INSERT INTO einheiten (name,typ,faktor) values('" +FIELD_2_0_2_3+  "',1,0.1)";
	
	private static final String FIELD_2_0_2_4								="ausgabeeinheit";
	private static final String SQL_2_0_2_4 = "ALTER TABLE laborwerte_werte ADD COLUMN ausgabeeinheit int NOT NULL default 1";
	
	
	// Die Tabelle lieferschein_l_muster muss erstellt werden
	private static final String FIELD_2_0_2_5								= DBFactory.TABLE_LIEFERSCHEIN_L_MUSTER;
	private static final String SQL_2_0_2_5 = "CREATE TABLE "+ DBFactory.TABLE_LIEFERSCHEIN_L_MUSTER + "  ( " +
	" id                    int unsigned not null auto_increment," +
	" remove      		 text not null,"+
	" muster            text not null," +
	"PRIMARY KEY idx(id) "+
	") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	private static final String FIELD_2_0_2_6								="mhd";
	private static final String SQL_2_0_2_6 = "ALTER TABLE buchungen ADD COLUMN mhd bigint NOT NULL default 0";
	
	private static final String FIELD_2_0_2_7					= "MHD-Liste";
	private static final String FILE_2_0_2_7						= "mhd.txt";
	
	//Das Formular Ergebnisliste-Bestand muss vorhanden sein
	private static final String FIELD_2_0_2_8						= "Ergebnisliste-Bestand";
	private static final String FILE_2_0_2_8					= "ergebnislistebestand.txt";
	
	//Das Formular bestelluingen muss vorhanden sein
	private static final String FIELD_2_0_2_9						= "Bestellungen";
	private static final String FILE_2_0_2_9					= "bestellungsliste.txt";
	
	private static final String FIELD_2_0_2_10								="tempvon";
	private static final String SQL_2_0_2_10 = "ALTER TABLE rezeptliste ADD COLUMN tempvon int NOT NULL default 20";
	
	private static final String FIELD_2_0_2_11								="tempbis";
	private static final String SQL_2_0_2_11 = "ALTER TABLE rezeptliste ADD COLUMN tempbis int NOT NULL default 20";
	
	private static final String FIELD_2_0_2_12								= DBFactory.TABLE_TEMPERATURZONEN;
	private static final String SQL_2_0_2_12 = "CREATE TABLE "+ DBFactory.TABLE_TEMPERATURZONEN + "  ( " +
	" id                    int unsigned not null auto_increment," +
	" bezeichnung	varchar(255) not null default '',"+
	" vg				 varchar(64) not null default ''," +
	" hg				 varchar(64) not null default ''," +
	" min             int not null default -20,"+ 
	" max            int not null default 30,"+
	" PRIMARY KEY idx(id)" +
	") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	private static final String SQL_2_0_2_12_1="INSERT INTO " + DBFactory.TABLE_TEMPERATURZONEN + " (id,bezeichnung,vg,hg,min,max) VALUES (1,'Zone 1','#000000','#ffffff',-20,0)";
	private static final String SQL_2_0_2_12_2="INSERT INTO " + DBFactory.TABLE_TEMPERATURZONEN + " (id,bezeichnung,vg,hg,min,max) VALUES (2,'Zone 2','#000000','#ffffff',1,10)";
	private static final String SQL_2_0_2_12_3="INSERT INTO " + DBFactory.TABLE_TEMPERATURZONEN + " (id,bezeichnung,vg,hg,min,max) VALUES (3,'Zone 3','#000000','#ffffff',11,30)";

	private static final String FIELD_2_0_2_13						= "Temperaturzonen-Liste";
	private static final String FILE_2_0_2_13						= "temperaturzonen.txt";
	
	
	private static final String FIELD_2_0_2_14	=DBFactory.TABLE_AUFTRAEGE;
	private static final String SQL_2_0_2_14= "create table if not exists " +DBFactory.TABLE_AUFTRAEGE+ "(" +
		"id int unsigned not null auto_increment,"+
		"level_0_fg varchar(6) not null default 'ffffff'," +
		"level_0_bg varchar(6) not null default 'ff0000'," +
		"level_0_value int not null default 0,"+
		"level_1_fg varchar(6) not null default '000000'," +
		"level_1_bg varchar(6) not null default 'ffba00'," +
		"level_1_value int not null default 2,"+
		"level_2_fg varchar(6) not null default '000000'," +
		"level_2_bg varchar(6) not null default 'fff600'," +
		"level_2_value int not null default 4,"+
		"level_3_fg varchar(6) not null default '000000'," +
		"level_3_bg varchar(6) not null default '00ff00'," +
		"level_3_value int not null default 8,"+
		"PRIMARY KEY idx(id) "+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	
	private static final String SQL_2_0_2_15="INSERT INTO " + DBFactory.TABLE_AUFTRAEGE + " (id) VALUES (1)";

	
	private static final String FIELD_2_0_2_16	=DBFactory.TABLE_AUFTRAGSLISTE;
	private static final String SQL_2_0_2_16= "create table if not exists " +DBFactory.TABLE_AUFTRAGSLISTE+ "(" +
		"id int unsigned not null auto_increment,"+
		"liter double not null default 0.0," +
		"bezeichnung varchar(256) not null," +
		"rezeptur_id int not null default 0,"+
		"faellig bigint not null default 0,"+
		"comment varchar(512) not null default '',"+
		"erstellt_datum datetime not null default '2012-01-01 00:00:00',"+
		"erstellt_user varchar(256) not null default 'system',"+
		"geaendert_datum datetime not null default '2012-01-01 00:00:00',"+
		"geaendert_user varchar(256) not null default 'system',"+
		"erledigt_datum datetime not null default '2012-01-01 00:00:00',"+
		"erledigt_user varchar(256) not null default 'system',"+
		"arbeit_user varchar(256) not null default '',"+
		"erledigt int not null default 0,"+
		"KEY idx1(erstellt_datum),"+
		"KEY idx2(geaendert_datum),"+
		"KEY idx3(erledigt_datum),"+
		"KEY idx4(bezeichnung),"+
		"KEY idx5(rezeptur_id),"+
		"KEY idx6(erledigt),"+
		"PRIMARY KEY idx(id) "+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	private static final String FIELD_2_0_2_17					= "Auftragsliste";
	private static final String FILE_2_0_2_17					= "auftragsliste.txt";

	
	private static final String FIELD_2_0_2_18	=DBFactory.TABLE_KALENDER;
	private static final String SQL_2_0_2_18= "create table if not exists " +DBFactory.TABLE_KALENDER+ "(" +
		"id int unsigned not null auto_increment,"+
		"saturday int not null default 0,"+
		"feiertage text not null," +
		"PRIMARY KEY idx(id) "+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	

	private static final String SQL_2_0_2_19="INSERT INTO " + DBFactory.TABLE_KALENDER + " (id,saturday,feiertage) VALUES (1,0,'')";
	
	private static final String FIELD_2_0_2_20	=DBFactory.TABLE_TERMINE;
	private static final String SQL_2_0_2_20= "create table if not exists " +DBFactory.TABLE_TERMINE + "(" +
		"id int unsigned not null auto_increment,"+
		"bezeichnung varchar(256) not null," +
		"comment text not null,"+
		"vg varchar(6) not null default '000000',"+
		"hg varchar(6) not null default '5dddff',"+
		"faellig bigint not null default 0,"+
		"erstellt_datum datetime not null default '2012-01-01 00:00:00',"+
		"erstellt_user varchar(256) not null default 'system',"+
		"geaendert_datum datetime not null default '2012-01-01 00:00:00',"+
		"geaendert_user varchar(256) not null default 'system',"+
		"KEY idx1(faellig),"+
		"PRIMARY KEY idx(id) "+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	
	private static final String FIELD_2_0_2_21								="anfrage";
	private static final String SQL_2_0_2_21 = "ALTER TABLE " + DBFactory.TABLE_AUFTRAEGE + " ADD COLUMN anfrage int NOT NULL default 0";

	private static final String FIELD_2_0_2_22								="level_e_fg";
	private static final String SQL_2_0_2_22 = "ALTER TABLE " + DBFactory.TABLE_AUFTRAEGE + " ADD COLUMN level_e_fg varchar(6) not null default '000000',add column level_e_bg varchar(6) not null default 'cccccc',add column level_a_fg varchar(6) not null default '000000',add column level_a_bg varchar(6) not null default 'ffffff'";
	
	
	private static final String FIELD_2_0_2_23								="inarbeit_datum";
	private static final String SQL_2_0_2_23 = "ALTER TABLE " + DBFactory.TABLE_AUFTRAGSLISTE + " ADD COLUMN inarbeit_datum datetime NOT NULL default '2012-01-01 00:00:00',add column inarbeit int not null default 0";
	
	private static final String FIELD_2_0_2_24								="erledigt";
	private static final String SQL_2_0_2_24 = "ALTER TABLE " + DBFactory.TABLE_TERMINE + " ADD COLUMN erledigt_datum datetime NOT NULL default '2012-01-01 00:00:00',add column erledigt int not null default 0,add column erledigt_user varchar(256) not null default ''";
	
	//Version 2.0.2.25
	//Das Formular "dm.txt" muss vorhanden sein
	private static final String FIELD_2_0_2_25						= "DMListe";
	private static final String FILE_2_0_2_25						= "dm.txt";
	
	//Version 2.0.2.26
	//Die Tabelle laborwerte muss das Feld "fix" enthalten
	private static final String FIELD_2_0_2_26								="fix";
	private static final String SQL_2_0_2_26 = "ALTER TABLE laborwerte ADD COLUMN fix int NOT NULL default 0";
	
	//2.0.2.27 die "Auftragsliste mus das feld Tank enthalten
	private static final String FIELD_2_0_2_27								="tank";
	private static final String SQL_2_0_2_27 = "ALTER TABLE " + DBFactory.TABLE_AUFTRAGSLISTE + " ADD COLUMN tank varchar(256) NOT NULL default ''";
	
	//2.0.2.28 die Tabelle "Orte" wird angelegt
	private static final String FIELD_2_0_2_28	=DBFactory.TABLE_ORTE;
	private static final String SQL_2_0_2_28= "create table if not exists " +DBFactory.TABLE_ORTE + "(" +
		"id int unsigned not null auto_increment,"+
		"bezeichnung varchar(256) not null," +
		"comment text not null,"+
		"shape text not null,"+
		"PRIMARY KEY idx(id) "+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	//2.0.2.29 Die Tabelle "tanks" wird angelegt
	private static final String FIELD_2_0_2_29	=DBFactory.TABLE_TANKS;
	private static final String SQL_2_0_2_29= "create table if not exists " +DBFactory.TABLE_TANKS + "(" +
		"id int unsigned not null auto_increment,"+
		"nummer varchar(256) not null," +
		"comment text not null,"+
		"liter double not null default 0.0,"+
		"ort int unsigned not null default 0,"+
		"px int unsigned not null default 0," +
		"py int unsigned not null default 0,"+
		"pr int unsigned not null default 50,"+
		"PRIMARY KEY idx(id), "+
		"KEY idx1(nummer)"+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	
	//20.0.2.30 Konformitätserklärung in Rezeptliste
	private static final String FIELD_2_0_2_30								="konformDatum";
	private static final String SQL_2_0_2_30 = "ALTER TABLE rezeptliste ADD COLUMN konformDatum datetime,add column konformComment varchar(256) not null default ''";
	
	private static final String FIELD_2_0_2_31								="konform";
	private static final String SQL_2_0_2_31 = "ALTER TABLE rezeptliste ADD COLUMN konform int not null default 0";
	
	private static final String FIELD_2_0_2_32						= "Konformitaetserklaerungen";
	private static final String FILE_2_0_2_32						= "konform.txt";
	
	//20.0.2.30 liefertermin für bestellungen
	private static final String FIELD_2_0_2_33								="lieferung";
	private static final String SQL_2_0_2_33 = "ALTER TABLE " + DBFactory.TABLE_BESTELLUNG + " ADD COLUMN lieferung_datum datetime not null default '2012-01-01',add column lieferung int not null default '0'";
	
	//2.0.2.34 Das Formular containerliste_2 muss vorhanden sein
	private static final String FIELD_2_0_2_34						= "Containerliste 2";
	private static final String FILE_2_0_2_34						= "containerliste_2.txt";
	
	//2.0.2.35 Das Formular statistik_6 muss vorhanden sein
	private static final String FIELD_2_0_2_35						= "Statistik/Adressen";
	private static final String FILE_2_0_2_35						= "statistik_6.txt";
	
	//2.0.2.36 Die Tabelle "auftragbenutzer" wird angelegt
	private static final String FIELD_2_0_2_36	=DBFactory.TABLE_AUFTRAG_BENUTZER;
	private static final String SQL_2_0_2_36= "create table if not exists " +DBFactory.TABLE_AUFTRAG_BENUTZER + "(" +
		"id int unsigned not null auto_increment,"+
		"user text not null,"+
		"PRIMARY KEY idx(id) "+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	private static final String SQL_2_0_2_37="INSERT INTO " + DBFactory.TABLE_AUFTRAG_BENUTZER+"  (user) values('%s')";
	
	
	//2.0.2.38 Die Tabelle "sorten" wird angelegt
	private static final String FIELD_2_0_2_38	=DBFactory.TABLE_SORTEN;
	private static final String SQL_2_0_2_38= "create table if not exists " +DBFactory.TABLE_SORTEN + "(" +
		"id int unsigned not null auto_increment,"+
		"`system` int not null default 0,"+
		"bezeichnung text not null,"+
		"regeln text not null,"+
		"PRIMARY KEY idx(id), "+
		"KEY idx1(bezeichnung(50)) " +
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	private static final String SQL_2_0_2_39="INSERT INTO " + DBFactory.TABLE_SORTEN + "  (`system`,bezeichnung,regeln) values(1,'%s','')";
	
	//20.02.40 Die Tabelle Auftraege wird erweitert
	private static final String FIELD_2_0_2_40								="level_aa_fg";
	private static final String SQL_2_0_2_41 = "ALTER TABLE " + TABLE_AUFTRAEGE + " ADD COLUMN level_aa_fg varchar(6)  NOT NULL DEFAULT '000000' ";
	private static final String SQL_2_0_2_42 = "ALTER TABLE " + TABLE_AUFTRAEGE + " ADD COLUMN level_aa_bg varchar(6)  NOT NULL DEFAULT '66ccff' ";

	//Die Tabelle auftrag wird auf Daueraufträge erweitert
	private static final String FIELD_2_0_2_43								="rep";
	private static final String SQL_2_0_2_44 = "ALTER TABLE " + TABLE_AUFTRAGSLISTE + " ADD COLUMN rep int  NOT NULL DEFAULT 1 ";
	private static final String SQL_2_0_2_45 = "ALTER TABLE " + TABLE_AUFTRAGSLISTE + " ADD COLUMN rep_days int  NOT NULL DEFAULT 1 ";
	private static final String SQL_2_0_2_46 = "ALTER TABLE " + TABLE_AUFTRAGSLISTE + " ADD COLUMN magic varchar(256)  NOT NULL DEFAULT '' ";
	private static final String SQL_2_0_2_47 = "ALTER TABLE " + TABLE_AUFTRAGSLISTE + " ADD index idxR(magic) ";
	
	//Die Tabelle auftrag wird auf Daueraufträge erweitert
	private static final String FIELD_2_0_2_48								="rep_mode";
	private static final String SQL_2_0_2_49 = "ALTER TABLE " + TABLE_AUFTRAGSLISTE + " ADD COLUMN rep_mode int  NOT NULL DEFAULT 0 ";
	
	//Die Tabelle auftrag wird auf Daueraufträge erweitert
	private static final String FIELD_2_0_2_50								="rep_span";
	private static final String SQL_2_0_2_51 = "ALTER TABLE " + TABLE_AUFTRAGSLISTE + " ADD COLUMN rep_span int  NOT NULL DEFAULT 0 ";
	
	//Das Formular rechnen_6.txt muss in die Datenbank aufgenommen werden
	private static final String FIELD_2_0_2_52						= "Berechnung normal 2";
	private static final String FILE_2_0_2_52						= "rechnen_6.txt";
	
	//Das Formular tankbelegung_1.txt muss in die Datenbank aufgenommen werden
	private static final String FIELD_2_0_2_53						= "Tankbelegung";
	private static final String FILE_2_0_2_53						= "tankbelegung_1.txt";
	
	
	//2.2.0.1 Die Tabelle "mischungen" wird angelegt
	// die Spalte "comment" in der buchungstabelle wird indiziert
	
	private static final String FIELD_2_2_0_1	=DBFactory.TABLE_MISCHUNGEN;
	private static final String SQL_2_2_0_1= "create table if not exists " +DBFactory.TABLE_MISCHUNGEN + "(" +
		"id int unsigned not null auto_increment,"+
		"bezeichnung text not null," +
		"bemerkungen text not null," +
		"sorte int not null default 0," +
		"tank varchar(256) not null default ''," + 
		"active int not null default 0,"+
		"rezeptur_id int not null default 0," +
		"la double not null default 0.0," +
		"erstellt datetime NOT NULL default '2013-12-25'," +
		"erstellt_user varchar(256) not null default ''," +
		"geaendert datetime NOT NULL default '2013-12-25'," +
		"geaendert_user varchar(256) not null default ''," +
		"abgeschlossen datetime NOT NULL default '2013-12-25'," +
		"abgeschlossen_user varchar(256) not null default ''," +
		"PRIMARY KEY idx(id), "+
		"KEY idx1(bezeichnung(50)), " +
		"KEY idx2(tank)," +
		"KEY idx3(erstellt)," +
		"KEY idx4(geaendert)," +
		"KEY idx5(abgeschlossen)," +
		"KEY idx6(active)," + 
		"KEY idx7(rezeptur_id) " +
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";

	private static final String SQL_2_2_0_1_2= "alter table buchungen add index idxB(comment) ";
	
	//20.0.2.30 zusätzliche Spezifikationen in Rezeptliste
	private static final String FIELD_2_2_0_2								="spezifikation_text";
	private static final String SQL_2_2_0_2 = "ALTER TABLE rezeptliste ADD COLUMN spezifikation_text text not null ";

	//2.2.0.3 Die Tabelle "tickets" wird angelegt
	
	private static final String FIELD_2_2_0_3	=DBFactory.TABLE_TICKETS;
	private static final String SQL_2_2_0_3= "create table if not exists " +DBFactory.TABLE_TICKETS + "(" +
		"id int unsigned not null auto_increment,"+
		"transaktion int unsigned not null default 0, " +
		"typ int unsigned not null default 0," + 
		"mischung int not null default 0," +
		"bezeichnung text not null," +
		"rezeptur_id int not null default 0," + 
		"bemerkungen text not null," +
		"sorte int not null default 0," +
		"la double not null default 0.0," +
		"staerke double not null default 0.0," +
		"erstellt datetime NOT NULL default '2013-12-25'," +
		"erstellt_user varchar(256) not null default ''," +
		"geaendert datetime NOT NULL default '2013-12-25'," +
		"geaendert_user varchar(256) not null default ''," +
		"PRIMARY KEY idx(id), "+
		"KEY idx1(bezeichnung(50)), " +
		"KEY idx3(erstellt)," +
		"KEY idx4(geaendert)," +
		"KEY idx5(rezeptur_id) " +
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	//2.2.0.4 Die Tabelle "tickets" wird angelegt
	
	private static final String FIELD_2_2_0_4	=DBFactory.TABLE_TICKETS_TRANSAKTIONEN;
	private static final String SQL_2_2_0_4= "create table if not exists " +DBFactory.TABLE_TICKETS_TRANSAKTIONEN + "(" +
		"id int unsigned not null auto_increment,"+
		"typ int unsigned not null default 0," + 
		"bemerkungen text not null," +
		"mischung int not null default 0," +
		"mischung_dest int not null default 0," +		
		"erstellt datetime NOT NULL default '2013-12-25'," +
		"erstellt_user varchar(256) not null default ''," +
		"PRIMARY KEY idx(id), "+
		"KEY idx1(bemerkungen(50)), " +
		"KEY idx2(mischung_dest)," +
		"KEY idx3(mischung)," +
		"KEY idx4(typ) " +
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	//2.2.0.5 Die Tabelle "bewertungen_kategorien" wird angelegt
	
	private static final String FIELD_2_2_0_5	=DBFactory.TABLE_BEWERTUNGEN_KATEGORIEN;
	private static final String SQL_2_2_0_5= "create table if not exists " +DBFactory.TABLE_BEWERTUNGEN_KATEGORIEN + "(" +
		"id int unsigned not null auto_increment,"+
		"bezeichnung varchar(256) not null default ''," +
		"gewichtung double not null default 1.0," +
		"unterkategorien text not null," +
		"erstellt datetime NOT NULL default '2013-12-25'," +
		"erstellt_user varchar(256) not null default ''," +
		"geaendert datetime NOT NULL default '2013-12-25'," +
		"geaendert_user varchar(256) not null default ''," +
		"PRIMARY KEY idx(id), "+
		"KEY idx1(bezeichnung) " +
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	private static final String SQL_2_2_0_5_1="INSERT INTO " + DBFactory.TABLE_BEWERTUNGEN_KATEGORIEN + " (id,bezeichnung,gewichtung,unterkategorien,erstellt_user,geaendert_user) VALUES " +
			"(1,'Farbe',3.0," +
			"'1255 abweichend\n3015 hochfarbig\n2555 farbarm\n3591 mißfarben\n2880 hell\n5820 untypisch\n7411 Sonstige Mängel\n'," +
			"'system','system')";
	
	private static final String SQL_2_2_0_5_2="INSERT INTO " + DBFactory.TABLE_BEWERTUNGEN_KATEGORIEN + " (id,bezeichnung,gewichtung,unterkategorien,erstellt_user,geaendert_user) VALUES " +
			"(2,'Klarheit',3.0," +
			"'1350 Ausscheidungen\n4085 Opaleszenz\n3975 nicht gießfähig\n1260 abgesetzt\n5405 trüb\n5490 Verunreinigung\n2200 flockig\n1776 dünnflüssig\n1875 dickflüssig\n4711 Sonstige Mängel\n'," +
			"'system','system')";
	
	private static final String SQL_2_2_0_5_3="INSERT INTO " + DBFactory.TABLE_BEWERTUNGEN_KATEGORIEN + " (id,bezeichnung,gewichtung,unterkategorien,erstellt_user,geaendert_user) VALUES " +
			"(3,'Geruch',5.0," +
			"'1366 Bittermandel\n1874 Diacetyl\n1387 Buttersäure\n1005 alt\n1210 aromaarm\n1214 aldehydig\n3795 maischig\n1680 brotig\n1700 blumig\n1731 deftig\n" +
			"1750 dumpf\n1960 einseitig\n4520 scharf\n1981 estrig\n2135 fehlerhaft\n2190 Fremdgeruch\n2536 Fruchtnote untypisch\n2550 fruchtarm\n2560 fuselig\n3530 muffig\n" +
			"3911 nicht abgerundet\n3938 nicht reintönig\n4105 parfümig\n4595 süßlich\n5080 stechend\n5820 untypisch\n5830 unharmonisch\n5840 überaromatisiert\n4711 sonstige Mängel\n',"+
			"'system','system')";
	
	private static final String SQL_2_2_0_5_4="INSERT INTO " + DBFactory.TABLE_BEWERTUNGEN_KATEGORIEN + " (id,bezeichnung,gewichtung,unterkategorien,erstellt_user,geaendert_user) VALUES " +
			"(4,'Geschmack',9.0," +
			"'1874 Diacetyl\n1387 Buttersäure\n1005 alt\n1110 ausdruckslos\n1210 aromaarm\n1214 aldehydig\n1235 aufdringlich\n1265 adstringierend\n1365 bitter\n1685 Blasengeschmack\n1690 brennend\n1695 brenzlig\n1710 citralartig\n1750 dumpf\n1960 einseitig\n2051 Essigester\n1995 erdig\n2050 essigstichig\n2135 fehlerhaft\n" +
			"2195 Fremdgeschmack\n2536 Fruchtnote untypisch\n2550 fruchtarm\n2560 fuselig\n2850 grasig\n2855 grün\n2920 hefig\n3035 holzig\n3081 kampferig\n3106 kratzig\n3155 Kochgeschmack\n3161 Kopfnote\n1366 Bittermandel\n3571 Milchsäurestich\n3795 maischig\n3911 nicht abgerundet\n3938 nicht reintönig\n3964 Nachgeschmack\n3965 Nachlaufgeschmack\n" +
			"3930 nachhängend\n4105 parfümig\n1731 deftig\n4520 scharf\n4525 sauer\n4640 schimmelig\n1405 beißend\n5095 stielig\n5380 teerartig\n5820 untypisch\n5835 unausgeglichen\n5830 unharmonisch\n5845 überdecktes Aroma\n5090 süß\n3151 krautig\n3573 muffig\n4711 Sonstige Mängel\n'," +
			"'system','system')";
	
	//2.2.0.6 Die Tabelle "bewertungen" wird angelegt
	
	private static final String FIELD_2_2_0_6	=DBFactory.TABLE_BEWERTUNGEN;
	private static final String SQL_2_2_0_6= "create table if not exists " +DBFactory.TABLE_BEWERTUNGEN + "(" +
		"id int unsigned not null auto_increment,"+
		"bezeichnung varchar(256) not null default ''," +
		"losnummer varchar(256) not null default ''," +
		"bewertung double not null default 0.0," +
		"comment text not null,"+
		"erstellt datetime NOT NULL default '2013-12-25'," +
		"erstellt_user varchar(256) not null default ''," +
		"geaendert datetime NOT NULL default '2013-12-25'," +
		"geaendert_user varchar(256) not null default ''," +
		"PRIMARY KEY idx(id), "+
		"KEY idx2(bezeichnung)," +
		"KEY idx3(losnummer) " +
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	//2.2.0.7 Die Tabelle "bewertungen_block" wird angelegt
	
	private static final String FIELD_2_2_0_7	=DBFactory.TABLE_BEWERTUNGEN_BLOCK;
	private static final String SQL_2_2_0_7= "create table if not exists " +DBFactory.TABLE_BEWERTUNGEN_BLOCK + "(" +
		"id int unsigned not null auto_increment,"+
		"bewertung int not null default 0,"+
	    "bezeichnung varchar(256) not null default ''," +
		"gewichtung double not null default 1," +
	    "punkte double not null default 0.0," +
		"bewertungsliste text not null," +
		"comment text not null,"+
		"PRIMARY KEY idx(id), "+
		"KEY idx1(bewertung) "+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	//2.2.0.8 Die Tabelle "bewertungen_defaults" wird angelegt
	
	private static final String FIELD_2_2_0_8	=DBFactory.TABLE_BEWERTUNGEN_DEFAULTS;
	private static final String SQL_2_2_0_8= "create table if not exists " +DBFactory.TABLE_BEWERTUNGEN_DEFAULTS + "(" +
		"id int unsigned not null auto_increment,"+
		"gold_text varchar(12) not null default 'Gold',"+
		"gold_value double not null default 4.7, "+
		"gold_fg varchar(6) not null default '000000',"+
		"gold_bg varchar(6) not null default 'ffff00',"+
		"silber_text varchar(12) not null default 'Silber',"+
		"silber_value double not null default 4.2, "+
		"silber_fg varchar(6) not null default '000000',"+
		"silber_bg varchar(6) not null default 'd0ebff',"+
		"bronze_text varchar(12) not null default 'Bronze',"+
		"bronze_value double not null default 3.7, "+
		"bronze_fg varchar(6) not null default 'ffffff',"+
		"bronze_bg varchar(6) not null default 'c9770c',"+
		"none_text varchar(12) not null default '-',"+
		"none_fg varchar(6) not null default '000000',"+
		"none_bg varchar(6) not null default 'ffffff',"+
		"PRIMARY KEY idx(id) "+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	private static final String SQL_2_2_0_8_1="INSERT INTO " + DBFactory.TABLE_BEWERTUNGEN_DEFAULTS + " (id,gold_text,gold_value,gold_fg,gold_bg,silber_text,silber_value,silber_fg,silber_bg,bronze_text,bronze_value,bronze_fg,bronze_bg,none_text,none_fg,none_bg) " +
		" VALUES (1,'Gold',4.7,'000000','ffff00','Silber',4.2,'000000','d0ebff','Bronze',3.7,'ffffff','c9770c','-','000000','ffffff')";
	
	private static final String FIELD_2_2_0_9						= "Bewertung";
	private static final String FILE_2_2_0_9						= "bewertung.txt";
			
	//Die Tabelle rezeptliste muss das Feld "bewertung" enthalten
	private static final String FIELD_2_2_0_10								="bewertung";
	private static final String SQL_2_2_0_10 = "ALTER TABLE " + TABLE_REZEPTLISTE + " ADD COLUMN bewertung int  NOT NULL DEFAULT 0 ";		
	
	//2_2_0_11 textbausteine in defaults
	private static final String FIELD_2_2_0_11								="bausteine";
	private static final String SQL_2_2_0_11 = "ALTER TABLE bewertungen_defaults ADD COLUMN bausteine text not null ";
	
	//2_2_0_12 Die Tabelle Tickets muss das Feld nummer enthalten
	private static final String FIELD_2_2_0_12								="nummer";
	private static final String SQL_2_2_0_12= "ALTER TABLE " + TABLE_TICKETS + " ADD COLUMN nummer text not null ";
	
	//2_2_0_13 Die Tabelle ticket_transaktionen muss felder für tanks enthalten
	private static final String FIELD_2_2_0_13								= "tank";
	private static final String SQL_2_2_0_13 = "ALTER TABLE " + TABLE_TICKETS_TRANSAKTIONEN + " ADD COLUMN tank text NOT NULL,ADD COLUMN tank_dest text NOT NULL";	
	
	//2_2_0_14 Die Tabelle tickets muss felder für losnummer enthalten
	private static final String FIELD_2_2_0_14								= "losnummer";
	private static final String SQL_2_2_0_14 = "ALTER TABLE " + TABLE_TICKETS + " ADD COLUMN losnummer text NOT NULL";	

	//2_2_0_16 Die Tabelle Mischungen muss felder für losnummer enthalten
	private static final String FIELD_2_2_0_16								= "losnummer";
	private static final String SQL_2_2_0_16 = "ALTER TABLE " + TABLE_MISCHUNGEN + " ADD COLUMN losnummer text NOT NULL,ADD index idxLosnummer(losnummer(30))";	
	
	//2_2_0_17 Die Tabelle tickets muss felder für die original-losnummer enthalten
	private static final String FIELD_2_2_0_17								= "losnummer_original";
	private static final String SQL_2_2_0_17 = "ALTER TABLE " + TABLE_TICKETS + " ADD COLUMN losnummer_original text NOT NULL,ADD index idxLosnummerOriginal(losnummer_original(30))";	
	
	//2_2_0_18 Die Tabelle tickets muss felder für die Adresse enthalten
	private static final String FIELD_2_2_0_18								= "adresse";
	private static final String SQL_2_2_0_18 = "ALTER TABLE " + TABLE_TICKETS + " ADD COLUMN adresse text NOT NULL,ADD COLUMN adresse_id int not null DEFAULT 0,ADD index idxAdresse(adresse(30)),ADD index idxAdresseID(adresse_id)";	
	
	//Mischung Druckformular
	//Mischung Druckformular
	private static final String FIELD_2_2_0_19						= "Mischung Detail";
	private static final String FILE_2_2_0_19							= "mischung_detail.txt";
	private static final String FIELD_2_2_0_20						= "Mischung Kurzfassung";
	private static final String FILE_2_2_0_20							= "mischung_kurz.txt";
	private static final String FIELD_2_2_0_21						= "Mischungsliste";
	private static final String FILE_2_2_0_21							= "mischungsliste.txt";
	public static final String FIELD_2_2_0_22						= "Mischungsliste nach Sorten";
	private static final String FILE_2_2_0_22							= "mischungsliste_1.txt";
	
	//2_2_0_18 Die Tabelle tickets muss felder für die Adresse enthalten
	private static final String FIELD_2_2_0_23								= "probe";
	private static final String SQL_2_2_0_23 = "ALTER TABLE " + TABLE_TICKETS + " ADD COLUMN probe int not null default 0";	
	
	//3_0_0_1 Die Tabelle mischungsabfragen wird angelegt
	private static final String FIELD_3_0_0_1	=DBFactory.TABLE_MISCHUNGSABFRAGE;
	private static final String SQL_3_0_0_1= "create table if not exists " +DBFactory.TABLE_MISCHUNGSABFRAGE + "(" +
		"id int unsigned not null auto_increment,"+
		"user varchar(256) not null default 'system',"+
		"sequence int not null default 0,"+
		"display int not null default 0,"+
		"datemode int not null default 0,"+
		"von_jahr int not null default 2014,"+
		"von_monat int not null default 0,"+
		"von_tag int not null default 1,"+
		"bis_jahr int not null default 2014,"+
		"bis_monat int not null default 0,"+
		"bis_tag int not null default 1,"+
		"mischung_nummer varchar(2048) not null default '',"+
		"mischung_bezeichnung varchar(1024) not null default '',"+
		"tank varchar(256) not null default '',"+
		"ticket_nummer varchar(256) not null default '',"+
		"active int not null default 0,"+
		"losnummer varchar(1024) not null default '',"+
		"rezeptur int not null default 0,"+
		"PRIMARY KEY idx(id), "+
		"KEY idx2(user) " +
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	//3_0_0_2 Die Tabelle "icons" wird angelegt
	private static final String FIELD_3_0_0_2	=DBFactory.TABLE_ICONS;
	private static final String SQL_3_0_0_2= "create table if not exists " +DBFactory.TABLE_ICONS + "(" +
		"id int unsigned not null auto_increment,"+
		"filename varchar(1024) not null default ''," +
		"icon BLOB,"+
		"PRIMARY KEY idx(id), "+
		"KEY idx2(filename) " +
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	//2_2_0_18 Die Tabelle tickets muss felder für die Bewertung enthalten
	private static final String FIELD_3_0_0_3								= "bewertung";
	private static final String SQL_3_0_0_3= "ALTER TABLE " + TABLE_TICKETS + " ADD COLUMN bewertung int not null default 0";	

	
	//3.0.0.4 Die Tabelle mischungsabfragen muss feld für aktionen enthalten
	private static final String FIELD_3_0_0_4								= "aktionen";
	private static final String SQL_3_0_0_4= "ALTER TABLE " + TABLE_MISCHUNGSABFRAGE + " ADD COLUMN  aktionen varchar(2014) not null default ''";	

	//3.0.2.0 Die Tabelle "auftraege" muss ein feld für gruppen enthalten
	private static final String FIELD_3_0_2_0								= "gruppe";
	private static final String SQL_3_0_2_0= "ALTER TABLE " + TABLE_AUFTRAGSLISTE + " ADD COLUMN  gruppe varchar(256) not null default ''";	
	
	//3.0.2.0 Die Tabelle "auftraege" muss ein feld für priorität enthalten
	private static final String FIELD_3_0_2_1								= "wichtig";
	private static final String SQL_3_0_2_1= "ALTER TABLE " + TABLE_AUFTRAGSLISTE + " ADD COLUMN  wichtig int not null default '0'";	

	//3.0.2.0 Die Tabelle "auftraege" muss ein feld für darker enthalten
	private static final String FIELD_3_0_2_2								= "darker";
	private static final String SQL_3_0_2_2= "ALTER TABLE " + TABLE_AUFTRAEGE + " ADD COLUMN  darker int not null default '35'";	
	
	//3.0.2.3 Das Formular lagerbestand_ohne_preis muss vorhanden sein
	private static final String FIELD_3_0_2_3						= "Lagerbestand ohne Preise";
	private static final String FILE_3_0_2_3						= "lagerbestand_ohne_preis.txt";
	
	//3.0.3.1 Das Formular ergebnislistebestand2.txt muss vorhanden sein
	private static final String FIELD_3_0_3_1							=	"Ergebnisliste-Bestand 2";
	private static final String FILE_3_0_3_1 								= 	"ergebnislistebestand2.txt";
	
	//Version 3.0.3.2
	//Die Tabelle bestellung muss das Feld "bestellt" enthalten
	private static final String FIELD_3_0_3_2								="bestellt";
	private static final String SQL_3_0_3_2 = "ALTER TABLE bestellung ADD COLUMN bestellt int NOT NULL default 0,ADD COLUMN bestellt_user varchar(256) not null default ''";
	
	private static final String FIELD_3_0_3_3								="id";
	private static final String SQL_3_0_3_3 = "ALTER TABLE " + TABLE_DEKLARATION_TEXT + " ADD column bezeichnung varchar(256) not null default '-', ADD COLUMN id int unsigned not null auto_increment, ADD COLUMN active int not null default 0,add primary key(id)";
	private static final String SQL_3_0_3_4 = "update  " + TABLE_DEKLARATION_TEXT + " set active=1";
	
	//Version 3.0.3.5
	//Die Tabelle tickets muss die Felder  "kontrolle" und "kontrolle_datum" enthalten
	private static final String FIELD_3_0_3_5								="kontrolle";
	private static final String SQL_3_0_3_5 = "ALTER TABLE tickets ADD COLUMN kontrolle VARCHAR(256) NOT NULL default '',ADD COLUMN kontrolle_datum datetime not null default '2000-01-01' ";

	//Version 3.0.6.1
	//Die Tabelle Bewertungen muss die Felder  "kontrolle" und "kontrolle_datum" enthalten
	private static final String FIELD_3_0_6_1								="kontrolle";
	private static final String SQL_3_0_6_1 = "ALTER TABLE bewertungen ADD COLUMN kontrolle VARCHAR(256) NOT NULL default '',ADD COLUMN kontrolle_datum datetime not null default '2000-01-01' ";

	//3_0_0_2 Die Tabelle "access" wird angelegt
	private static final String FIELD_3_0_6_2	=DBFactory.TABLE_ACCESS;
	private static final String SQL_3_0_6_2= "create table if not exists " +DBFactory.TABLE_ACCESS + "(" +
		"id int unsigned not null auto_increment,"+
		"user varchar(256) not null default ''," +
		"clientOnly int not null default 0,"+
		"privileges bigint unsigned not null default 0," +
		"PRIMARY KEY idx(id) "+
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	private static final String FIELD_3_0_7_1					= "Zutatenliste";
	private static final String FILE_3_0_7_1					= "zutatenliste.txt";
	
	private static final String FIELD_3_0_9_1							= "ean";
	private static final String SQL_3_0_9_1 = "ALTER TABLE lieferschein_zeile ADD COLUMN ean varchar(256) NOT NULL DEFAULT ''";
	private static final String FIELD_3_0_9_2							= "ean";
	private static final String SQL_3_0_9_2 = "ALTER TABLE rezeptliste ADD COLUMN ean text NOT NULL";
	
	
	//3_0_9_3 Das Formular lieferschein_2.txt muss vorhanden sein
	private static final String FIELD_3_0_9_3							=	"Lieferschein/EAN";
	private static final String FILE_3_0_9_3 								= 	"lieferschein_2.txt";
	
	//3_0_9_4 Die Tabelle mischungen muss das Feld "adresse" enthalten
	private static final String FIELD_3_0_9_4							= "adresse";
	private static final String SQL_3_0_9_4 = "ALTER TABLE mischungen ADD COLUMN adresse text NOT NULL";
	private static final String SQL_3_0_9_5 = "ALTER TABLE " + TABLE_AUFTRAGSLISTE + " ADD index idxAdr(adresse) ";
	
	//3_0_9_4 Die Tabelle mischungsabfragen muss das Feld "adressen" enthalten
	private static final String FIELD_3_0_9_6							= "adressen";
	private static final String SQL_3_0_9_6 = "ALTER TABLE mischungsabfragen ADD COLUMN adressen text NOT NULL";
	
	//Trace report
	private static final String FIELD_3_1_0_0 = "Rückverfolgung";
	private static final String FILE_3_1_0_0 = "trace_1.txt";
	

	
	//Losnummervorlagenliste
	private static final String FIELD_3_1_0_1	=DBFactory.TABLE_LOSNUMMER_LISTE;
	private static final String SQL_3_1_0_1= "create table if not exists " +DBFactory.TABLE_LOSNUMMER_LISTE + "(" +
		"id int unsigned not null auto_increment,"+
		"value varchar(512) not null default '',"+
		"vorlage int not null default 0," +
		"user varchar(256) not null default 'system',"+
		"datum datetime not null default '2018-01-01',"+
		"PRIMARY KEY idx(id), "+
		"KEY dt(datum), "+
		"KEY idv(vorlage) " +
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	//steuerlager
	//3_2_0_0 Die Tabelle "steuerlager" wird angelegt
	private static final String FIELD_3_2_0_0	=DBFactory.TABLE_STEUERLAGER;
	private static final String SQL_3_2_0_0= "create table if not exists " +DBFactory.TABLE_STEUERLAGER+ "(" +
		"id int unsigned not null auto_increment,"+
		"`system` int not null default 0,"+
		"bezeichnung varchar(256) not null default '', "+
		"PRIMARY KEY idx(id) " +
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	private static final String SQL_3_2_0_0_1 = "INSERT INTO " + DBFactory.TABLE_STEUERLAGER + " (id,`system`,bezeichnung) VALUES (1,1,%s)";
	
	//3_2_0_1 Die Tabelle rezeptliste muss die Felder "steuer_artikel","sorte" und "steuerlager" enthalten
	private static final String FIELD_3_2_0_1							= "steuer_artikel";
	private static final String SQL_3_2_0_1 = "ALTER TABLE rezeptliste ADD COLUMN steuer_artikel varchar(256) NOT NULL default '',add column sorte int unsigned not null default 1,add column steuerlager int unsigned not null default 1"; 
	
	//3_2_0_2 Die Tabelle buchungen muss die Felder "steuer_artikel","sorte" und "steuerlager" enthalten
	private static final String FIELD_3_2_0_2							= "sorte";
	private static final String SQL_3_2_0_2 = "ALTER TABLE buchungen ADD COLUMN steuer_artikel varchar(256) NOT NULL default '',add column sorte int unsigned not null default 1,add column steuerlager int unsigned not null default 1"; 
	
	
	//3_2_0_3 Das Formular lagerliste_steuer.txt muss vorhanden sein
	private static final String FIELD_3_2_0_3							=	"Zoll-Liste (mit Steuerlager)";
	private static final String FILE_3_2_0_3							= 	"lagerliste_steuer.txt";
	
	//3_2_0_4 Die Tabelle inventurzeile muss die Felder "lager" "steuer_artikel","sorte" und "steuerlager" enthalten
	private static final String FIELD_3_2_0_4							= "steuer_artikel";
	private static final String SQL_3_2_0_4 = "ALTER TABLE inventurzeile ADD COLUMN lager int not null default 1, add column steuer_artikel varchar(256) NOT NULL default '',add column sorte int unsigned not null default 1,add column steuerlager int unsigned not null default 1"; 

	//3_2_0_5 Das Formular inventur_inhalt_steuer.txt muss vorhanden sein
	private static final String FIELD_3_2_0_5							=	"Inventur (nach Inhalt-mit Steuerdaten)";
	private static final String FILE_3_2_0_5							= 	"inventur_inhalt_steuer.txt";

	//3_2_0_6 Das Formular inventur_raum_steuer.txt muss vorhanden sein
	private static final String FIELD_3_2_0_6							=	"Inventur (nach Raum-mit Steuerdaten)";
	private static final String FILE_3_2_0_6							= 	"inventur_raum_steuer.txt";

	//3_2_0_7 Das Formular inventur_lager_steuer.txt muss vorhanden sein
	private static final String FIELD_3_2_0_7							=	"Inventur (nach Lager-mit Steuerdaten)";
	private static final String FILE_3_2_0_7							= 	"inventur_lager_steuer.txt";
	
	//3_2_0_8 Das Formular inventur_sorte_steuer.txt muss vorhanden sein
	private static final String FIELD_3_2_0_8							=	"Inventur (nach Sorte-mit Steuerdaten)";
	private static final String FILE_3_2_0_8							= 	"inventur_sorte_steuer.txt";
	
	//3_2_0_9 Das Formular inventur_steuer_artikel_steuer.txt muss vorhanden sein
	private static final String FIELD_3_2_0_9							=	"Inventur (nach Steuer-Artikel-mit Steuerdaten)";
	private static final String FILE_3_2_0_9							= 	"inventur_steuer_artikel_steuer.txt";
	
	//3_2_0_10 Das Formular inventur_steuerlager_steuer.txt muss vorhanden sein
	private static final String FIELD_3_2_0_10							=	"Inventur (nach Steuerlager-mit Steuerdaten)";
	private static final String FILE_3_2_0_10							= 	"inventur_steuerlager_steuer.txt";
	
	//3_2_0_11 Die Tabelle rezeptliste muss das Feld "auto_anfrage" enthalten
	private static final String FIELD_3_2_0_11							= "auto_anfrage";
	private static final String SQL_3_2_0_11 = "ALTER TABLE rezeptliste ADD COLUMN auto_anfrage int unsigned not null default 0"; 
	
	private static final String FIELD_3_2_0_12								="properties";
	private static final String SQL_3_2_0_12 = "CREATE TABLE properties( " +
	" id                   int unsigned not null auto_increment," +
	" p_key		           varchar(255) not null default '',"+
	" p_value	           varchar(255) not null default '',"+	
	" PRIMARY KEY idx(id) " +
	") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	private static final String SQL_3_2_0_12_1 = "INSERT INTO " + DBFactory.TABLE_PROPERTIES + " (id,p_key,p_value) VALUES (1,'global_tankliste_show_history','1')";
	
	
	//3_0_9_3 Das Formular ergebnisliste_bestand 3.txt muss vorhanden sein
	private static final String FIELD_3_2_0_13							=	"Ergebnisliste-Bestand 3";
	private static final String FILE_3_2_0_13 								= 	"ergebnislistebestand3.txt";
	
	//3_3_0_1 Das Formular mischungsliste_l1.txt muss vorhanden sein
	private static final String FIELD_3_3_0_1							=	"Mischungsliste/Tickets";
	private static final String FILE_3_3_0_1 								= 	"mischungsliste_l1.txt";
	
	//3_3_0_2 Das Formular dependencyliste1.txt muss vorhanden sein
	private static final String FIELD_3_3_0_2							="Abhaengige Rezepturen";
	private static final String FILE_3_3_0_2 								= 	"dependencyliste1.txt";
	
	//3_3_0_3 Die Tabelle mischungen muss das Feld "lager" enthalten
	private static final String FIELD_3_3_0_3							= "lager";
	private static final String SQL_3_3_0_3 = "ALTER TABLE mischungen ADD COLUMN lager int unsigned not null default 0"; 
	
	
	//3_3_6_1 Das Formular inventur_steuerlager_steuer.txt muss vorhanden sein
	private static final String FIELD_3_3_6_1							=	"Bogen A4";
	private static final String FILE_3_3_6_1								= 	"Bogen_a4.txt";
	
	//3_3_6_1 Das Formular inventur_steuerlager_steuer.txt muss vorhanden sein
	private static final String FIELD_3_3_6_2							=	"Bogen A4 / 2 Etiketten";
	private static final String FILE_3_3_6_2								= 	"Bogen_a4_2.txt";
	
	
	private static final String FIELD_4_0_0_1	=DBFactory.TABLE_DOCUMENTS;
	private static final String SQL_4_0_0_1= "create table if not exists " +DBFactory.TABLE_DOCUMENTS+ "(" +
		"id int unsigned not null auto_increment,"+
		"rezeptur int unsigned not null default 0," +
		"name varchar(1024) not null default ''," +
		"bemerkungen text not null," + 
		"filename varchar(1024) not null default ''," +
		"daten MEDIUMBLOB,"+
		"erstellt datetime not null default '2020-01-01'," + 
		"geaendert datetime not null default '2020-01-01'," +
		"user1 varchar(256) not null default 'system',"+
		"user2 varchar(256) not null default 'system'," +
		"typ int unsigned not null default 0,"+
		"pages int unsigned not null default 0,"+
		"zoom int unsigned not null default 100," +
		"PRIMARY KEY idx(id), "+
		"KEY idx2(rezeptur) " +
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	//4_0_1_1 Die Tabelle mischungen muss das Feld "lager" enthalten
	private static final String FIELD_4_0_1_1							= "fertig";
	private static final String SQL_4_0_1_1 = "ALTER TABLE auftragsliste ADD COLUMN fertig int unsigned not null default 0"; 
	
	//4_0_1_2 Die Tabelle auftraege muss die Felder "level_f_bg" und "level_f_hg" enthalten
	private static final String FIELD_4_0_1_2							= "level_f_bg";
	private static final String SQL_4_0_1_2 = "ALTER TABLE auftraege ADD COLUMN level_f_bg varchar(6) not null default '93ff93'"; 
	private static final String SQL_4_0_1_3 = "ALTER TABLE auftraege ADD COLUMN level_f_fg varchar(6) not null default '000000'";
	
	//4_0_1_4 Die Tabelle auftraege muss die Felder "fertig_user" und "fertig_datum" enthalten
	private static final String FIELD_4_0_1_4							= "fertig_user";
	private static final String SQL_4_0_1_4 = "ALTER TABLE auftragsliste ADD COLUMN fertig_user varchar(256) not null default 'system'"; 
	private static final String SQL_4_0_1_5 = "ALTER TABLE auftragsliste ADD COLUMN fertig_datum datetime not null default '2022-01-01'";
	
	//4.1 Tabelle kontrakte
	private static final String FIELD_4_1_0_0	=DBFactory.TABLE_KONTRAKTE;
	private static final String SQL_4_1_0_0= "create table if not exists " +DBFactory.TABLE_KONTRAKTE+ "(" +
		"id int unsigned not null auto_increment,"+
		"typ int unsigned default 0, " +
		"name varchar(1024) not null default ''," +
		"adresse_text varchar(1024) not null default ''," +
		"adresse_id int unsigned not null default 0," +
		"rezeptur int unsigned not null default 0," +
		"menge double not null default 0.0,"+
		"einheit int unsigned not null default 0," +
		"bemerkungen text not null," + 
		"start datetime not null default '2020-01-01'," + 
		"ende datetime not null default '2020-01-01'," +
		"aktiv int unsigned not null default 1,"+
		"erstellt datetime not null default '2020-01-01'," + 
		"geaendert datetime not null default '2020-01-01'," +
		"user1 varchar(256) not null default 'system',"+
		"user2 varchar(256) not null default 'system'," +
		"PRIMARY KEY idx(id),"+
		"KEY idx2(rezeptur)," +
		"KEY idx3(adresse_id)," +
		"KEY idx4(start)," +
		"KEY idx5(ende) " +
		") ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;";
	
	//4_1_2_0 Die Tabelle rezeptliste muss das feld 'proben_anzahl' enthalten
	private static final String FIELD_4_1_2_0							= "proben_anzahl";
	private static final String SQL_4_1_2_0 = "ALTER TABLE rezeptliste ADD COLUMN proben_anzahl int unsigned not null default 1"; 
	

	
	
	
	RzPro               		rz;
	Connection        			con;
	int                  		dbStatus;
	String              		user; // der aktuelle Benutzername
	SimpleDateFormat    		df;
	DialogItem					dlgItem;

	// Statements
	Statement           	getReadOnly;
	Statement           	getLastInsertID;
	PreparedStatement   	getTimestamp;

	static final String LAST_INSERT_QUERY = "SELECT LAST_INSERT_ID() AS id FROM ";

	static final int		LOGIN_TIMEOUT = 8; // Timeout für Login in Sekunden

	// Hilfsklassen
	DBAbfrage           	dbAbfrage;
	DBAdressen          	dbAdressen;
	DBNotizen           	dbNotizen;
	DBSTWListe          	dbStw;
	DBErgebnis          	dbErgebnis;
	DBReport            	dbReport;
	DBCurrency          	dbCurrency;
	DBLager             	dbLager;
	DBRezeptur          	dbRezeptur;
	DBEinheiten				dbEinheiten;
	DBContainer				dbContainer;
	DBLieferschein			dbLieferschein;
	DBEtiketten				dbEtiketten;
	DBBuchung				dbBuchungen;
	DBAusbeute				dbAusbeute;
	DBPaletten				dbPaletten;
	DBInventur				dbInventur;
	DBAcid					dbAcid;
	DBDeklarationen			dbDeklarationen;
	DBAusstattung			dbAusstattung;
	DBDatenblatt			dbDatenblatt;
	DBBestellung			dbBestellung;
	DBLaborwerte			dbLaborwerte;
	DBProben				dbProben;
	DBZutatenverzeichnis 	dbZutatenverzeichnis;
	DBMessages				dbMessages;
	DBOptionen				dbOptionen;
	DBLosnummerVorlage 		dbLosnummerVorlage;
	DBAuftrag				dbAuftrag;
	DBChanges				dbChanges;
	DBTemperatur			dbTemperatur;
	DBKalender				dbKalender;
	DBDM					dbDM;
	DBTank					dbTank;
	DBMischungen			dbMischungen;
	DBBewertungen			dbBewertungen;
	DBIcons					dbIcons;
	DBAccess				dbAccess;
	DBProperties			dbProperties;
	DBDocuments				dbDocuments;
	DBKontrakte				dbKontrakte;
	

	public DBFactory(RzPro r){
		rz = r;
		dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
		df = new SimpleDateFormat("yyyy-MM-dd H:mm:ss");
		dbStatus = DB_CLOSE;
	}

	/**
	 * checks if Field exists
	 */
	private boolean checkFieldExists(String table,String field) {
		boolean ret = true;
		try {
			getFieldExists.setString(1, con.getCatalog().toString());
			getFieldExists.setString(2, table);
			getFieldExists.setString(3, field);
			ResultSet rs = getFieldExists.executeQuery();
			if(!rs.next()) {
				ret = false;
			}
		}catch(Exception e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.checkFieldExists", e.getLocalizedMessage());
		}
		return ret;
	}
	
	/*
	 * 
	 * Check if Table exists
	 */
	private boolean checkTableExists(String table) {
		boolean ret = true;
		try {
			final ResultSet rs = con.getMetaData().getTables(null, null, table, null);
			if(rs != null) {
				if(!rs.next()) {
					ret = false;
				}
			}
		}catch (SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.checkTableExists", e.getLocalizedMessage());
		}
		return ret;
	}
	
	/*
	 * Check if Formular exists
	 * 
	 * 
	 */
	private boolean checkFormExists(String form) {
		boolean ret = true;
		try {
			getFormExists.setString(1, form);
			ResultSet rs = getFormExists.executeQuery();
			if(!rs.next()) {
				ret = false;
			}
		}catch(Exception e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.checkFormExists", e.getLocalizedMessage());
		}
		return ret;
	}
	
	
	/**
	 * dbLogin verbindet mit der Datenbank
	 * @param aDriver
	 * @param aUrl
	 * @param aUser
	 * @param aPwd
	 * @return
	 */

	public boolean dbTryLogin(String aDriver,String aUrl,String aUser, String aPwd,String parameter) {
		boolean ret = false;
		if(parameter != null && !parameter.trim().isEmpty()) {
			aUrl += "?" + parameter.trim();
		}
		try {
			Class.forName(aDriver);
		}
		catch (final ClassNotFoundException e) {
			ret = false;
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.dbLogin", e.getLocalizedMessage());
		}
		try {
			DriverManager.setLoginTimeout(LOGIN_TIMEOUT);
			Connection c  = DriverManager.getConnection(aUrl ,aUser,aPwd);
			if(c != null) {
				ret = true;
				c.close();
			}
		} catch(Exception e) {}
		return ret;
	}
	
	/* dbLogin verbindet mit der Datenbank  */
	public boolean dbLogin(String aDriver,String aUrl,String aUser, String aPwd,String parameter) {
		boolean ret = false;
		if(parameter != null && !parameter.trim().isEmpty()) {
			aUrl += "?" + parameter.trim();
		}
		try {
			Class.forName(aDriver);
		}
		catch (final ClassNotFoundException e) {
			ret = false;
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.dbLogin", e.getLocalizedMessage());
		}
		try {
			DriverManager.setLoginTimeout(LOGIN_TIMEOUT);
			con = DriverManager.getConnection(aUrl ,aUser,aPwd);
			getFieldExists = con.prepareStatement("SELECT * FROM information_schema.COLUMNS  WHERE TABLE_SCHEMA = ?  AND TABLE_NAME = ?  AND COLUMN_NAME = ?;",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			getFormExists = con.prepareStatement("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name = ?;",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			user = aUser;
			if(this.checkDatabaseVersion(con) == false) {
				/*
				 * Datenbank schliessen und neu öffnen um Metadaten neu einzulesen
				 */
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.dbLogin","Database Metadata-Refresh");
				con.close();
				con=null;
				con = DriverManager.getConnection(aUrl ,aUser,aPwd);
			} else {
				rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "db.dbLogin","Database Metadata-Refresh nicht nötig");
			}
			dbStatus = DB_OPEN;
			ret = dbOpen();
			if(ret == true && rz.isMain()) {
				boolean r = rz.getDatabase().getAccess().isClientOnly();
				if (r == true) {
					DialogItem di  = new DialogItem(
							DialogControl.HINWEIS_DIALOG,
							"",0.0,
							rz.getLocale().getString("login.fail"),
							rz.getLocale().getString("login.fail"),
							rz.getLocale().getString("login.fail_message.1045"),
							"fehler.png",
							rz.getLocale().getString("string_ok"),
							"",
							null
					);
					if(di != null) {
						rz.getDialogFactory().getDialog(di);
						di =null;
					}
					ret = false;
				}
			}
		}
		catch (final SQLException e){
			DialogItem  di = null;
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.dbLogin", e.getErrorCode() + ":" + e.getLocalizedMessage());
			switch (e.getErrorCode()) {
				case 1045: // Benutzername oder Passwort flasch
					di  = new DialogItem(
							DialogControl.HINWEIS_DIALOG,
							"",0.0,
							rz.getLocale().getString("login.fail"),
							rz.getLocale().getString("login.fail"),
							rz.getLocale().getString("login.fail_message.1045"),
							"fehler.png",
							rz.getLocale().getString("string_ok"),
							"",
							null
					);
					break;
				case 1130: //Host hat keine Zugriffsberechtigung
					di  = new DialogItem(
							DialogControl.HINWEIS_DIALOG,
							"",0.0,
							rz.getLocale().getString("login.fail"),
							rz.getLocale().getString("login.fail"),
							rz.getLocale().getString("login.fail_message.1130"),
							"fehler.png",
							rz.getLocale().getString("string_ok"),
							"",
							null
					);
					break;
				default : // alle anderen Fehler (MySQL-Server tot, Rechner nicht erreichbar usw...
					di  = new DialogItem(
							DialogControl.HINWEIS_DIALOG,
							"",0.0,
							rz.getLocale().getString("login.fail"),
							rz.getLocale().getString("login.fail"),
							rz.getLocale().getString("login.fail_message.default"),
							"fehler.png",
							rz.getLocale().getString("string_ok"),
							"",
							null
					);
				break;
			}
			if(di != null) {
				rz.getDialogFactory().getDialog(di);
				di =null;
			}
			ret = false;
		}
		return ret;
	}


	public Connection getConnection() {
		return con;
	}
	/**--------------------------------------------------------------------
	 * Datenbank öffnen und schliessen
	 *---------------------------------------------------------------------
	 */

	/** dbClose() schließt die Datenbank  *
	 */
	public void dbClose() {
		try {
			if (dbStatus == DB_OPEN){
				//Hilfsklassen wechschmeissen
				dbAbfrage = null;
				dbAdressen = null;
				dbNotizen = null;
				dbStw = null;
				dbErgebnis = null;
				dbReport = null;
				dbCurrency = null;
				dbLager = null;
				dbRezeptur = null;
				dbEinheiten = null;
				dbContainer=null;
				dbLieferschein=null;
				dbEtiketten	= null;
				dbBuchungen = null;
				dbAusbeute = null;
				dbPaletten=null;
				dbInventur=null;
				dbAcid=null;
				dbDeklarationen=null;
				dbAusstattung=null;
				dbDatenblatt = null;
				dbBestellung = null;
				dbLaborwerte= null;
				dbProben=null;
				dbZutatenverzeichnis=null;
				dbMessages=null;
				dbOptionen=null;
				dbLosnummerVorlage = null;
				dbAuftrag  = null;
				dbChanges = null;
				dbTemperatur=null;
				dbKalender=null;
				dbDM = null;
				dbTank = null;
				dbMischungen = null;
				dbBewertungen = null;
				dbIcons = null;
				dbAccess = null;
				dbProperties = null;
				dbDocuments = null; 
				dbKontrakte = null;
				con.close();
				dbStatus = DB_CLOSE;
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.dbClose", "OK");
			}
		}
		catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.dbClose", e.getLocalizedMessage());
		}
	}

	private boolean dbOpen(){
		boolean ret = false;
		try{
			getReadOnly     = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			getLastInsertID = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			getTimestamp = con.prepareStatement("SELECT NOW() as datum", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			// Hilfsklassen
			dbKalender = new DBKalender(rz,this,con);
			dbAbfrage = new DBAbfrage(rz,this,con);
			dbAdressen = new DBAdressen(rz,this,con);
			dbNotizen = new DBNotizen(rz,this,con);
			dbStw = new DBSTWListe(rz,this,con);
			dbErgebnis = new DBErgebnis(rz,this,con);
			dbCurrency = new DBCurrency(rz,this,con);
			dbReport = new DBReport(rz,this,con);
			dbLager = new DBLager(rz,this,con);
			dbRezeptur = new DBRezeptur(rz,this,con);
			dbEinheiten = new DBEinheiten(rz,this,con);
			dbContainer = new DBContainer(rz,this,con);
			dbLieferschein = new DBLieferschein(rz,this,con);
			dbEtiketten = new DBEtiketten(rz,this,con);
			dbBuchungen = new DBBuchung(rz,this,con);
			dbAusbeute = new DBAusbeute(rz,this,con);
			dbPaletten = new DBPaletten(rz,this,con);
			dbInventur = new DBInventur(rz,this,con);
			dbAcid = new DBAcid(rz,this,con);
			dbDeklarationen = new DBDeklarationen(rz,this,con);
			dbAusstattung = new DBAusstattung(rz,this,con);
			dbDatenblatt = new DBDatenblatt(rz,this,con);
			dbBestellung = new DBBestellung(rz,this,con);
			dbLaborwerte = new DBLaborwerte(rz,this,con);
			dbProben = new DBProben(rz,this,con);
			dbZutatenverzeichnis = new DBZutatenverzeichnis(rz,this,con);
			dbMessages=new DBMessages(rz,this,con);
			dbOptionen =new DBOptionen(rz,this,con);
			dbLosnummerVorlage =new DBLosnummerVorlage(rz,this,con);
			dbAuftrag =new DBAuftrag(rz,this,con);			
			dbChanges =new DBChanges(rz,this,con);		
			dbTemperatur = new DBTemperatur(rz,this,con);
			dbDM = new DBDM(rz,this,con);
			dbTank = new DBTank(rz,this,con);
			dbMischungen = new DBMischungen(rz,this,con);
			dbBewertungen = new DBBewertungen(rz,this,con);
			dbIcons = new DBIcons(rz,this,con);			
			dbAccess = new DBAccess(rz,this,con);
			dbProperties = new DBProperties(rz,this,con);
			dbDocuments = new DBDocuments(rz,this,con);
			dbKontrakte = new DBKontrakte(rz,this,con);
			//Benutzerbezogene Optionsdatei laden
			ret = true;
			try {
				rz.getOptionFactory().readOptions();
				rz.getFensterFactory().readOptions();
				rz.getFontFactory().readOptions();
			}catch(Exception e) {}
		}
		catch (final Exception e){
			ret = false;
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.dbOpen", e.getLocalizedMessage());
		}

		return ret;
	}

	/** Hilfsklassen zurückgeben */
	public DBAbfrage getAbfrage(){return dbAbfrage;}
	public DBAdressen getAdressen(){return dbAdressen;}
	public DBNotizen getNotizen(){return dbNotizen;}
	public DBSTWListe getSTW(){return dbStw;}
	public DBErgebnis getErgebnis(){return dbErgebnis;}
	public DBReport getReport(){return dbReport;}
	public DBCurrency getCurrency(){return dbCurrency;}
	public DBLager getLager(){return dbLager;}
	public DBRezeptur getRezeptur(){return dbRezeptur;}
	public DBEinheiten getEinheiten(){return dbEinheiten;}
	public DBContainer getContainer() {return dbContainer;}
	public DBLieferschein getLieferschein() {return dbLieferschein;}
	public DBEtiketten getEtiketten() {return dbEtiketten;}
	public DBBuchung getBuchungen() {return dbBuchungen;}
	public DBAusbeute getAusbeute() {return dbAusbeute;}
	public DBPaletten getPaletten() {return dbPaletten;}
	public DBInventur getInventur() { return dbInventur;}
	public DBAcid getAcid() { return dbAcid;}
	public DBDeklarationen getDeklarationen() { return dbDeklarationen;}
	public DBAusstattung getAusstattung() { return dbAusstattung;}
	public DBDatenblatt getDatenblatt() {return dbDatenblatt;}
	public DBBestellung getBestellung() {return dbBestellung;}
	public DBLaborwerte getLaborwerte() {return dbLaborwerte;}
	public DBProben getProben() {return dbProben;}
	public DBZutatenverzeichnis getZutatenverzeichnis() {return dbZutatenverzeichnis;}
	public DBMessages getMessages() {return dbMessages;}
	public DBOptionen getOptionen() {return dbOptionen;}
	public DBLosnummerVorlage getLosnummerVorlage() {return dbLosnummerVorlage;}
	public DBAuftrag getAuftrag() {return dbAuftrag;}
	public DBChanges getChanges() {return dbChanges;}
	public DBTemperatur getTemperatur() {return dbTemperatur;}
	public DBKalender getKalender() {return dbKalender;}
	public DBDM getDM() {return dbDM;};
	public DBTank getTank() {return dbTank;};
	public DBMischungen getMischungen() {return dbMischungen;};
	public DBBewertungen getBewertungen() {return dbBewertungen;};
	public DBIcons getIcons() {return dbIcons;};	
	public DBAccess getAccess() {return dbAccess;}
	public DBProperties getProperties() {return dbProperties;}
	public DBDocuments getDocuments() {return dbDocuments;}
	public DBKontrakte getKontrakte() {return dbKontrakte;}	
	/**
	 * prüft den Versionsstand der Datenbank und fügt, wenn notwendig
	 * zusätzliche Tabellen/Felder ein
	 * gibt false zurück, wenn etwas geändert werden musste
	 */
	private boolean checkDatabaseVersion(Connection con) {

		boolean ret = true;
		/**
		 * Auf Version 1.0.6 prüfen.
		 * Die Tabelle "rezeptliste" muss die Felder "hinweis" ("hinweis_datum","hinweis_user")
		 * enthalten, geprüft wird nur auf "hinweis"
		 */
		try {
		//	final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_106);
			if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_106)) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.0.6 FAILED-CREATING FIELDS");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_106);
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.0.6 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.0.6 EXCEPTION");
		}

		/**
		 * Auf Version 1.0.8 prüfen.
		 * Die Tabelle "rezeptliste" muss die Felder  "brennwert" und "brennwert_af"
		 * enthalten, geprüft wird nur auf "brennwert"
		 */
		try {
		//	final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_108);
			if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_108)) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.0.8 FAILED-CREATING FIELDS");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_108);
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.0.8 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.0.8 EXCEPTION");
		}

		/**
		 * Auf Version 1.1.4 prüfen.
		 * Die Tabelle "paletten" muss vorhanden sein
		 */
		try {
			//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1104, null);
			if(!checkTableExists(FIELD_1104)){
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.1.4 FAILED-CREATING TABLE");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_1104);
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.1.4 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.1.4 EXCEPTION");
		}
		/**
		 * Auf Version 1.1.5 prüfen.
		 * Die Tabelle "losnummer" muss das Feld "vtemplate" enthalten
		 */
		try {
	//		rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_LOSNUMMER,FIELD_115);
			if(!checkFieldExists(DBFactory.TABLE_LOSNUMMER,FIELD_115)) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.1.5 FAILED-CREATING FIELDS");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_115);
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.1.5 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.1.5 EXCEPTION");
		}

		/**
		 * Auf Version 1.1.7 prüfen.
		 * Die Tabelle "inventuren" muss enthalten sein
		 */
		try {
			// Prüfen auf inventuren
			//rs = con.getMetaData().getTables(null, null, FIELD_117, null);
			if(!checkTableExists(FIELD_117)){
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.1.7 FAILED-CREATING TABLE");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_117);
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.1.7 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.1.7 EXCEPTION");
		}

		/**
		 * Auf Version 1.1.7_1 prüfen.
		 * Die Tabelle "inventurzeile" muss enthalten sein
		 */
		try {
			// Prüfen auf inventurzeile
			//rs = con.getMetaData().getTables(null, null, FIELD_117_1, null);
			if(!checkTableExists(FIELD_117_1)){
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.1.7_1 FAILED-CREATING TABLE");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_117_1);
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.1.7_1 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.1.7_1 EXCEPTION");
		}

		/**
		 * Auf Version 1.1.7_2 prüfen.
		 * Die Tabelle "raumliste" muss enthalten sein
		 */
		try {
			// Prüfen auf inventurzeile
		//	rs = con.getMetaData().getTables(null, null, FIELD_117_2, null);
			if(!checkTableExists(FIELD_117_2)){
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.1.7_2 FAILED-CREATING TABLE");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_117_2);
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.1.7_2 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.1.7_2 EXCEPTION");
		}

		/**
		 * Auf Version 1.1.7_3 prüfen.
		 * Das Formular "inventur" muss vorhanden sein
		 */
		try {
			//rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_117_3 + "'");
			if(!checkFormExists(FIELD_117_3)) {
				rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.1.7_3 INSERT 'inventur' FORM");
				final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_117_3);
				final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
				try {
					final URLConnection connect = datei.openConnection();
					final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
					String sql="";
					String zeile;
					while ((zeile = din.readLine()) != null) {
						sql += zeile;
					}
					din.close();
					ret = false;
					stmt.executeUpdate(sql);
				} catch (final Exception e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.1.7_3 FAILED");
				}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.1.7_3 EXCEPTION");
		}

		/**
		 * Auf Version 1.1.7_4 prüfen.
		 * Das Formular "inventur_1" muss vorhanden sein
		 */
		try {
//			rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_117_4 + "'");
			if(!checkFormExists(FIELD_117_4))  {
				rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.1.7_4 INSERT 'inventur' FORM");
				final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_117_4);
				final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
				try {
					final URLConnection connect = datei.openConnection();
					final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
					String sql="";
					String zeile;
					while ((zeile = din.readLine()) != null) {
						sql += zeile;
					}
					din.close();
					ret = false;
					stmt.executeUpdate(sql);
				} catch (final Exception e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.1.7_4 FAILED");
				}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.1.7_4 EXCEPTION");
		}

		/**
		 * Auf Version 1.1.7_5 prüfen.
		 * Die Tabelle "acid" muss vorhanden sein
		 */
		try {
			//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_117_5, null);
			if(!checkTableExists(FIELD_117_5)){
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.1.7_5 FAILED-CREATING TABLE");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_117_5);
						stmt.executeUpdate(SQL_117_5_1);
						stmt.executeUpdate(SQL_117_5_2);
						stmt.executeUpdate(SQL_117_5_3);
						stmt.executeUpdate(SQL_117_5_4);
						stmt.executeUpdate(SQL_117_5_5);
						stmt.executeUpdate(SQL_117_5_6);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.1.7_5 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.1.7_5 EXCEPTION");
		}

		/**
		 * Auf Version 1.1.7_6 prüfen.
		 * Die Tabelle "rezeptliste" muss das Feld "acid"
		 * enthalten
		 */
		try {
			//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_117_6);
			if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_117_6)) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.0.6 FAILED-CREATING FIELD");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_117_6);
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.1.7_6 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.1.7_6 EXCEPTION");
		}

		/**
		 * Auf Version 1.2.1 prüfen.
		 * Die Tabelle "rezeptliste" muss das Feld "deklarationen"
		 * enthalten
		 */
		try {
		//	final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_121);
			if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_121)) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.2.1 FAILED-CREATING FIELD");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_121);
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.2.1 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.2.1 EXCEPTION");
		}

		/**
		 * Auf Version 1.2.1_1 prüfen.
		 * Die Tabelle "rezeptliste" muss das Feld "deklarationen_alle"
		 * enthalten
		 */
		try {
			//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_121_1);
			if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_121_1)) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.2.1_1 FAILED-CREATING FIELD");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_121_1);
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.2.1_1 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.2.1 EXCEPTION");
		}

		/**
		 * Auf Version 1.1.2_2 prüfen.
		 * Die Tabelle "deklarationen" muss vorhanden sein
		 */
		try {
			//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_121_2, null);
			if(!checkTableExists(FIELD_121_2)){
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.2.1_1 FAILED-CREATING TABLE");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_121_2);
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.2.1_1 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.2.1_1 EXCEPTION");
		}

		/**
		 * Auf Version 1.2.2_2 prüfen.
		 * Das Formular "spezifikation_form" muss vorhanden sein
		 */
		try {
			ResultSet rs;
			// Prüfen auf inventurzeile
			final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_122_2 + "'");
			if(!rs.first()) {
				rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.2.2_2 INSERT 'spezifikation_form' FORM");
				final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_122_2);
				final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
				try {
					final URLConnection connect = datei.openConnection();
					final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
					String sql="";
					String zeile;
					while ((zeile = din.readLine()) != null) {
						sql += zeile;
					}
					din.close();
					ret = false;
					stmt.executeUpdate(sql);
					rs = stm1.executeQuery("select id from formulare where typ=" + ReportFactory.REPORT_TYPE_SPEZIFIKATION_FORMBLATT);
					if(rs.next()) {
						rz.getOptionFactory().setOption("report.spf_formblatt", rs.getInt("id"));
						rz.getOptionFactory().saveOptions();
					}
				} catch (final Exception e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.2.2_2 FAILED");
				}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.2.2_2 EXCEPTION");
		}


		/**
		 * Auf Version 1.2.1_3 prüfen.
		 * Das Formular "rechnen_5" muss vorhanden sein
		 */
		try {
			ResultSet rs;
			// Prüfen auf Produktspezifikation/Deklarationen
			final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_121_3 + "'");
			if(!rs.first()) {
				rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.2.1_3 INSERT 'Produktpezifikation/Deklarationen' FORM");
				final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_121_3);
				final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
				try {
					final URLConnection connect = datei.openConnection();
					final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
					String sql="";
					String zeile;
					while ((zeile = din.readLine()) != null) {
						sql += zeile;
					}
					din.close();
					ret = false;
					stmt.executeUpdate(sql);
				} catch (final Exception e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.2.1_3 FAILED");
				}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.2.1_3 EXCEPTION");
		}
		/**
		 * Auf Version 1.2.2_1 prüfen.
		 * Die Tabelle "deklaration_text" muss enthalten sein
		 */
		try {
			// Prüfen auf tabelle "deklaration_text"
		//	rs = con.getMetaData().getTables(null, null, FIELD_122_1, null);
			if(!checkTableExists(FIELD_122_1)){
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.2.2_1 FAILED-CREATING TABLE");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_122_1);
						stmt.executeUpdate("insert into " + DBFactory.TABLE_DEKLARATION_TEXT + " (formtext) values ('!Deckblatt\nDieses Blatt wird zusätzlich zur Produktspezifikation ausgedruckt,\nwenn Sie die Funktion zum Drucken derselben im Auswahlfenster anwenden.\n\nMenü->Bearbeiten->Produktspezifikation drucken')");
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.2.2_1 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.2.2_1 EXCEPTION");
		}


		/**
		 * Auf Version 1.2.4 prüfen.
		 * Die Tabelle "lager" muss das Feld "vg" (und "hg") enthalten
		 * enthalten
		 */
		try {
			//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_LAGER,FIELD_124);
			if(!checkFieldExists(DBFactory.TABLE_LAGER,FIELD_124)) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.2.4 FAILED-CREATING FIELD");
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						ret = false;
						stmt.executeUpdate(SQL_124);
					} catch (final SQLException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.2.4 FAILED");
					}
			}
		} catch (final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.2.4 EXCEPTION");
		}


		/**
		 * Auf Version 1.4.0_1 prüfen.
		 * Das Formular "ausstattung_raw.txt" muss vorhanden sein
		 */
		try {
			ResultSet rs;
			// Prüfen auf ausstattung_raw
			final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_140_1 + "'");
			if(!rs.first()) {
				rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.4.0_1 INSERT 'ausstattung_raw' FORM");
				final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_140_1);
				final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.4_0_1 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.4.0_1 EXCEPTION");
			}

			/**
			 * Auf Version 1.4.0_2 prüfen.
			 * Das Formular "ausstattung_calc.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				// Prüfen auf ausstattung_raw
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_140_2 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.4.0_2 INSERT 'ausstattung_calc'  FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_140_2);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							final URLConnection connect = datei.openConnection();
							final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
							String sql="";
							String zeile;
							while ((zeile = din.readLine()) != null) {
								sql += zeile;
							}
							din.close();
							ret = false;
							stmt.executeUpdate(sql);
						} catch (final Exception e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.4_0_2 FAILED");
						}
					}
				} catch (final SQLException e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.4.0_2 EXCEPTION");
				}

				/**
				 * Auf Version 1.4.0_3 prüfen.
				 * Die Tabelle "datenblatt" muss vorhanden sein
				 */
				try {
					//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_140_3, null);
					if(!checkTableExists(FIELD_140_3)){
							rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.4.0_3 FAILED-CREATING TABLE");
							final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
							try {
								ret = false;
								stmt.executeUpdate(SQL_140_3);
							} catch (final SQLException e) {
								rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.4.0-3 FAILED");
							}
					}
				} catch (final SQLException e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.4.0-3 EXCEPTION");
				}

				/**
				 * Auf Version 1.5.0 prüfen.
				 * Die Tabelle "bestellung" muss vorhanden sein
				 */
				try {
					//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_5_0, null);
					if(!checkTableExists(FIELD_1_5_0)){
							rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.5 FAILED-CREATING TABLE");
							final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
							try {
								ret = false;
								stmt.executeUpdate(SQL_1_5_0);
							} catch (final SQLException e) {
								rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.5 FAILED");
							}
					}
				} catch (final SQLException e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.5 EXCEPTION");
				}

				/**
				 * Auf Version 1.5.0_1 prüfen.
				 * Die Tabelle "rezeptliste" muss das Feld "vorschlagsbestand"
				 * enthalten
				 */
				try {
					//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_1_5_0_1);
					if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_1_5_0_1)) {
							rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.5.0_1 FAILED-CREATING FIELD");
							final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
							try {
								ret = false;
								stmt.executeUpdate(SQL_1_5_0_1);
							} catch (final SQLException e) {
								rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.5.0._1 FAILED");
							}
					}
				} catch (final SQLException e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.5.0_1 EXCEPTION");
				}


			/**
			 * Auf Version 1.5.3 prüfen.
			 * Die Tabelle "laborwerte" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_5_3_1, null);
				if(!checkTableExists(FIELD_1_5_3_1)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.5.3.1 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_5_3_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.5.3.1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.5.3.1 EXCEPTION");
			}

			/**
			 * Auf Version 1.5.3 prüfen.
			 * Die Tabelle "laborwerte_werte" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_5_3_2, null);
				if(!checkTableExists(FIELD_1_5_3_2)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.5.3_2 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_5_3_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.5.3.2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.5.3.2 EXCEPTION");
			}
			/**
			 * Auf Version 1.5.8_1 prüfen.
			 * Das Formular "statistikliste" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				// Prüfen auf Produktspezifikation/Deklarationen
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_1_5_8_1 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.2.1_3 INSERT 'Produktpezifikation/Deklarationen' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_1_5_8_1);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.5.8_1 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.5.8_1 EXCEPTION");
			}

			/**
			 * Auf Version 1.5.9 prüfen.
			 * Die Tabelle "proben" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_5_9_1, null);
				if(!checkTableExists(FIELD_1_5_9_1)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.5.9.1 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_5_9_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.5.9.1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.5.9.1 EXCEPTION");
			}

			/**
			 * Auf Version 1.5.9-1 prüfen.
			 * Das Formular "proben1.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				// Prüfen auf inventurzeile
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_1_5_9_2 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.1.7_4 INSERT 'inventur' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_1_5_9_2);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.5.9-2 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.5.9_2 EXCEPTION");
			}

			/**
			 * Auf Version 1.6.0 prüfen.
			 * Die Tabelle "zutatenverzeichnis" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_6_0, null);
				if(!checkTableExists(FIELD_1_6_0)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.6.0 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_6_0);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.6.0 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.6.0 EXCEPTION");
			}
			/**
			 * Auf Version 1.6.0_1 prüfen.
			 * Die Tabelle "messages" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_6_0_1, null);
				if(!checkTableExists(FIELD_1_6_0_1)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.6.0_1 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_6_0_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.6.0_1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.6.0_1 EXCEPTION");
			}

			/**
			 * Auf Version 1_6_0_2 prüfen.
			 * Das Formular "zutatenverzeichnis.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				// Prüfen zutatenverzeichnis.txt
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_1_6_0_2 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_6_0_2 INSERT 'zutatenverzeichnis' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_1_6_0_2);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1_6_0_2 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1_6_0_2 EXCEPTION");
			}

			/**
			 * Auf Version 1.6_0 prüfen.
			 * Die Tabelle "container" muss das Feld "c_out"
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_CONTAINER,FIELD_1_6_0_3);
				if(!checkFieldExists(DBFactory.TABLE_CONTAINER,FIELD_1_6_0_3)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_6_0_3 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_6_0_3);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.6.0.3 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.6.0.3 EXCEPTION");
			}
			
			/**
			 * Auf Version 1.6.9 prüfen.
			 * Die Tabelle "lieferschein" muss das Feld "comment"
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_LIEFERSCHEIN,FIELD_1_6_9_0);
				if(!checkFieldExists(DBFactory.TABLE_LIEFERSCHEIN,FIELD_1_6_9_0)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_6_9_0_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_6_9_0);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.6.9.0 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.6.9.0 EXCEPTION");
			}
			
			/**
			 * Auf Version 1.6.9 prüfen.
			 * Die Tabelle "lieferschein_zeile" muss das Feld "comment"
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_LIEFERSCHEIN_ZEILE,FIELD_1_6_9_1);
				if(!checkFieldExists(DBFactory.TABLE_LIEFERSCHEIN_ZEILE,FIELD_1_6_9_1)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_6_9_1_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_6_9_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.6.9.1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.6.9.1 EXCEPTION");
			}
			
			/**
			 * Auf Version 1.6.9 prüfen.
			 * Die Tabelle "rezeptliste" muss das Feld "tank" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_1_6_9_2);
				if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_1_6_9_2)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_6_9_2_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_6_9_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.6.9.2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.6.9.2 EXCEPTION");
			}
			
			/**
			 * Auf Version 1.6.9 prüfen.
			 * Die Tabelle "rezeptliste" muss das Feld "tank" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_HERSTELLUNG,FIELD_1_6_9_3);
				if(!checkFieldExists(DBFactory.TABLE_HERSTELLUNG,FIELD_1_6_9_3)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_6_9_3_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_6_9_3);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.6.9.3 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.6.9.3 EXCEPTION");
			}
			

			/**
			 * Auf Version 1.7.0 prüfen.
			 * Die Tabelle "history" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_7_0, null);
				if(!checkTableExists(FIELD_1_7_0)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.7.0 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_7_0);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.7.0 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.7.0 EXCEPTION");
			}
			
			/**
			 * Auf Version 1.7.1 prüfen.
			 * Die Tabelle "last_active" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_7_1, null);
				if(!checkTableExists(FIELD_1_7_1)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.7.1 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_7_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.7.1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.7.1 EXCEPTION");
			}
			
			/**
			 * Auf Version 1.7.3 prüfen.
			 * Die Tabelle "abfragen" muss das Feld "ablage"
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_ABFRAGEN,FIELD_1_7_3_1);
				if(!checkFieldExists(DBFactory.TABLE_ABFRAGEN,FIELD_1_7_3_1)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_7_3_1 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_7_3_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.7_3_1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.7.3.1 EXCEPTION");
			}
			
			/**
			 * Auf Version 1.7.3 prüfen.
			 * Die Tabelle "history" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_7_3_2, null);
				if(!checkTableExists(FIELD_1_7_3_2)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.7.3.2 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_7_3_2);
							stmt.executeUpdate(SQL_1_7_3_3);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.7.3.2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.7.0 EXCEPTION");
			}
			
			/**
			 * Auf Version 1.7.3_4 prüfen.
			 * Die Tabelle "history" muss das feld ablage enthalten "
			 *
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_HISTORY,FIELD_1_7_3_4);
				if(!checkFieldExists(DBFactory.TABLE_HISTORY,FIELD_1_7_3_4)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_7_3_4 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_7_3_4);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.7_3_4 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.7.3.4 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 1.8.1 prüfen.
			 * Die Tabelle "optionen" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_8_1_1, null);
				if(!checkTableExists(FIELD_1_8_1_1)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.8.1.1 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_8_1_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.8.1.1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.8.1.1 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 1.8.5 prüfen.
			 * Die Tabelle "musternummer" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_8_5_1, null);
				if(!checkTableExists(FIELD_1_8_5_1)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.8.5.1 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_8_5_1);
							stmt.executeUpdate(SQL_1_8_5_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.8.5.1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.8.5.1 EXCEPTION");
			}
			
			/**
			 * Auf Version 1.8.5_3 prüfen.
			 * Die Tabelle "versionen" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_8_5_3, null);
				if(!checkTableExists(FIELD_1_8_5_3)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.8.5.3 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_8_5_3);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.8.5.3 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.8.5.3 EXCEPTION");
			}
			
			
			
			/**
			 * Auf Version 1.8.8-1 prüfen.
			 * Die Tabelle "abfragen" muss das Feld "privat" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_ABFRAGEN,FIELD_1_8_8_1);
				if(!checkFieldExists(DBFactory.TABLE_ABFRAGEN,FIELD_1_8_8_1)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_8_8_1_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_8_8_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.8.8.1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.8.8.1 EXCEPTION");
			}
			
			/*
			 * Version 1.8.8.2 Die Spalte "muster" der Tabelle "abfragen" muss 8192 Bytes umfassen;
			 */
			
			try{
				final ResultSet rs = con.createStatement().executeQuery(FIELD_1_8_8_2);
				if(rs != null) {
					ResultSetMetaData meta = rs.getMetaData();
					if(meta.getColumnDisplaySize(1) != SIZE_1_8_8_2) {
						ret = false;
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_8_8_2 (abfragen.muster) Column Size is:" + meta.getColumnDisplaySize(1) + " Bytes -> will be altered to:" + SIZE_1_8_8_2 + " Bytes !");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						stmt.executeUpdate(SQL_1_8_8_2);
					}
				}
				 
			}catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.8.8.2 EXCEPTION "+ e.getLocalizedMessage());
			}
			
			/*
			 * Version 1.8.8.3 Die Spalte "muster" der Tabelle "history" muss 8192 Bytes umfassen;
			 */
			
			try{
				final ResultSet rs = con.createStatement().executeQuery(FIELD_1_8_8_3);
				if(rs != null) {
					ResultSetMetaData meta = rs.getMetaData();
					if(meta.getColumnDisplaySize(1) != SIZE_1_8_8_3) {
						ret = false;
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_8_8_3 (history.muster) Column Size is:" + meta.getColumnDisplaySize(1) + " Bytes -> will be altered to:" + SIZE_1_8_8_3 + " Bytes !");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						stmt.executeUpdate(SQL_1_8_8_3);
					}
				}
			 
			}catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.8.8.3 EXCEPTION "+ e.getLocalizedMessage());
			}
			
			/**
			 * Auf Version 1.8.8.4 prüfen.
			 * Das Formular "ergebnisliste" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_1_8_8_4 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_8_8_4 INSERT 'ergebnisliste' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_1_8_8_4);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
						rs = stm1.executeQuery("select id from formulare where typ=" + ReportFactory.REPORT_TYPE_ERGEBNISLISTE);
						if(rs.next()) {
							rz.getOptionFactory().setOption("report.ergebnisliste", rs.getInt("id"));
							rz.getOptionFactory().saveOptions();
						}
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1_8_8_4");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1_8_8_4 EXCEPTION");
			}

			/**
			 * Auf Version 1.8.8.5 prüfen.
			 * Das Formular "kalkulation_3" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_1_8_8_5 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_8_8_5 INSERT 'kalkulation_3' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_1_8_8_5);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1_8_8_5");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1_8_8_5 EXCEPTION");
			}			
			
			
			/**
			 * Auf Version 1.8.8.6 prüfen.
			 * Das Formular "kalkulation_4" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_1_8_8_6 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_8_8_6 INSERT 'kalkulation_4' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_1_8_8_6);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1_8_8_6");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1_8_8_6 EXCEPTION");
			}		
			
			/**
			 * Auf Version 1_8_9_1 prüfen.
			 * Das Formular "bestandswarnungsliste.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				// Prüfen zutatenverzeichnis.txt
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_1_8_9_1 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1_8_9_1 INSERT 'bestandswarnungsliste' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_1_8_9_1);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1_8_9_1 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1_6_0_2 EXCEPTION");
			}
	
			/**
			 * Auf Version 1.8.9.2 prüfen.
			 * Die Tabelle "rezeptliste" muss das Feld "spezifikation"
			 * enthalten,
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_1_8_9_2);
				if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_1_8_9_2)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.8.9.2 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_8_9_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.8_9_2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.8_9_2 EXCEPTION");
			}

			
			/**
			 * Auf Version 1.8.9.3 prüfen.
			 * Die Tabelle "adressen" muss das Feld "typ"
			 * enthalten,
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_ADRESSEN,FIELD_1_8_9_3);
				if(!checkFieldExists(DBFactory.TABLE_ADRESSEN,FIELD_1_8_9_3)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.8.9.3 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_8_9_3);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.8_9_3 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.8_9_3 EXCEPTION");
			}

			/**
			 * Auf Version 1.9.5 prüfen.
			 * Die Tabelle "losnummer_vorlage" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_1_9_5, null);
				if(!checkTableExists(FIELD_1_9_5)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 1.9.5 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_1_9_5);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 1.9.5 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 1.9.5 EXCEPTION");
			}
			
			
			/**
			 * alle last_acive==0 entfernen
			 */
			try {
				final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
				try {
					stmt.executeUpdate("delete from last_active where value =0");
				} catch (final SQLException e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.delete_last_active" , e.getLocalizedMessage());
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "DELETE last_active");
			}

			
			/**
			 * Auf Version 2.0.0 prüfen.
			 * Die Tabelle "rezeptliste" muss das Feld "r_probe"
			 * enthalten,
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_2_0_0_1);
				if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_2_0_0_1)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2.0.0.1 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_0_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.0.1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.0.1 EXCEPTION");
			}

			
			
			/**
			 * Auf Version 2.0.0 prüfen.
			 * Die Tabelle "herstellungen" muss das Feld "r_probe"
			 * enthalten,
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_HERSTELLUNG,FIELD_2_0_0_2);
				if(!checkFieldExists(DBFactory.TABLE_HERSTELLUNG,FIELD_2_0_0_2)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2.0.0.2 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_0_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.0.2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.0.2 EXCEPTION");
			}

			
			/**
			 * Auf Version 2.0.0 prüfen.
			 * Die Tabelle "proben" muss das Feld "entsorgt"
			 * enthalten,
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_PROBEN,FIELD_2_0_0_3);
				if(!checkFieldExists(DBFactory.TABLE_PROBEN,FIELD_2_0_0_3)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2.0.0.3 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_0_3);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.0.3 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.0.3 EXCEPTION");
			}

			/**
			 * Auf Version 2.0.0 prüfen.
			 * Die Tabelle "proben" muss das Feld "user_2"
			 * enthalten,
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_PROBEN,FIELD_2_0_0_4);
				if(!checkFieldExists(DBFactory.TABLE_PROBEN,FIELD_2_0_0_4)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2.0.0.4 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_0_4);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.0.4 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.0.4 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2.0.0 prüfen.
			 * Die Tabelle "proben" muss das Feld "deleted"
			 * enthalten,
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_PROBEN,FIELD_2_0_0_5);
				if(!checkFieldExists(DBFactory.TABLE_PROBEN,FIELD_2_0_0_5)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2.0.0.5 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_0_5);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.0.5 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.0.5 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_0_6 prüfen.
			 * Das Formular "probenliste" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_0_6 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_0_6 INSERT 'probenliste' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_0_6);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
						rs = stm1.executeQuery("select id from formulare where typ=" + ReportFactory.REPORT_TYPE_PROBENLISTE);
						if(rs.next()) {
							rz.getOptionFactory().setOption("report.probenliste", rs.getInt("id"));
							rz.getOptionFactory().saveOptions();
						}
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_0_6 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_0_6 EXCEPTION");
			}
			
			
			
			/**
			 * Auf Version 2.0.0.8 prüfen.
			 * Die Tabelle "changes" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_0_0_8, null);
				if(!checkTableExists(FIELD_2_0_0_8)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_0_8 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_0_8);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_0_8 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_0_8 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_0_9 prüfen.
			 * Das Formular "Änderungen" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_0_9 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_0_9 INSERT 'changes' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_0_9);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
						rs = stm1.executeQuery("select id from formulare where typ=" + ReportFactory.REPORT_TYPE_CHANGES);
						if(rs.next()) {
							rz.getOptionFactory().setOption("report.changes", rs.getInt("id"));
							rz.getOptionFactory().setOption("report.changesliste", rs.getInt("id"));
							rz.getOptionFactory().saveOptions();
						}
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_0_9 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_0_9 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_0_10 prüfen.
			 * Das Formular "Änderungen" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_0_10 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_0_10 INSERT 'laborwerte' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_0_10);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
						rs = stm1.executeQuery("select id from formulare where typ=" + ReportFactory.REPORT_TYPE_LABORWERT);
						if(rs.next()) {
							rz.getOptionFactory().setOption("report.laborwerte", rs.getInt("id"));
							rz.getOptionFactory().saveOptions();
						}
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_0_10 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_0_10 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_0_11 prüfen.
			 * Milligramm - Einheit einfügen
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT name FROM " + TABLE_EINHEITEN + " WHERE name='" + FIELD_2_0_0_11 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_0_11 INSERT 'mg'  INTO Einheiten");
							rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_0_11 INSERTING mg");
							final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
							try {

								ret = false;
								stmt.executeUpdate(SQL_2_0_0_11);
							} catch (final SQLException e) {
								rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_0_11 FAILED");
							}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_0_11 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_2_1 prüfen.
			 * Die Tabelle "laborwerte_werte" muss das Feld "spezifikation" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_LABORWERTE_WERTE,FIELD_2_0_2_1);
				if(!checkFieldExists(DBFactory.TABLE_LABORWERTE_WERTE,FIELD_2_0_2_1)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_1_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.1 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_0_2 prüfen.
			 * 100gr- Einheit einfügen
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT name FROM " + TABLE_EINHEITEN + " WHERE name='" + FIELD_2_0_2_2 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_2 INSERT '100g'  INTO Einheiten");
							rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_2 INSERTING 200gr");
							final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
							try {

								ret = false;
								stmt.executeUpdate(SQL_2_0_2_2);
							} catch (final SQLException e) {
								rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_2 FAILED");
							}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_2 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_0_3 prüfen.
			 * 100ml- Einheit einfügen
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT name FROM " + TABLE_EINHEITEN + " WHERE name='" + FIELD_2_0_2_3 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_3 INSERT '100ml'  INTO Einheiten");
							rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_3 INSERTING 200gr");
							final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
							try {

								ret = false;
								stmt.executeUpdate(SQL_2_0_2_3);
							} catch (final SQLException e) {
								rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_3 FAILED");
							}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_3 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_2_3 prüfen.
			 * Die Tabelle "laborwerte_werte" muss das Feld "ausgabeeinheit" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_LABORWERTE_WERTE,FIELD_2_0_2_4);
				if(!checkFieldExists(DBFactory.TABLE_LABORWERTE_WERTE,FIELD_2_0_2_4)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_4_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_4);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.4 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.4 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2.0.2.5 prüfen.
			 * Die Tabelle "lieferschein_l_muster" muss vorhanden sein
			 */
			try {
				final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_0_2_5, null);
				if(rs != null) {
					if(!rs.next())
					{
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_5 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_5);
							stmt.executeUpdate("INSERT INTO " + DBFactory.TABLE_LIEFERSCHEIN_L_MUSTER +" (id,remove,muster)  VALUES (1,\"L\",\"L$J$W$l\")");
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_5 FAILED");
						}
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_5 EXCEPTION");
			}
						
			
			/**
			 * Auf Version 2_0_2_6 prüfen.
			 * Die Tabelle "buchungen" muss das Feld "mhd" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_BUCHUNG,FIELD_2_0_2_6);
				if(!checkFieldExists(DBFactory.TABLE_BUCHUNG,FIELD_2_0_2_6)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_6_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_6);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.6 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.6 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_2_7 prüfen.
			 * Das Formular "mhd.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				// Prüfen auf Produktspezifikation/Deklarationen
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_2_7 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_7 INSERT 'mhd-liste' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_2_7);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_7 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_7 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_2_8 prüfen.
			 * Das Formular "Ergebnisliste_bestand" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_2_8 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_8 INSERT 'ergebnisliste_bestand' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_2_8);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
						rs = stm1.executeQuery("select id from formulare where typ=" + ReportFactory.REPORT_TYPE_ERGEBNISLISTE_BESTAND);
						if(rs.next()) {
							rz.getOptionFactory().setOption("report.ergebnisliste_bestand", rs.getInt("id"));
							rz.getOptionFactory().saveOptions();
						}
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_8 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_8 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_0_2_9 prüfen.
			 * Das Formular "bestellungen" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_2_9 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_9 INSERT 'bestellungen' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_2_9);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
						rs = stm1.executeQuery("select id from formulare where typ=" + ReportFactory.REPORT_TYPE_BESTELLUNGEN);
						if(rs.next()) {
							rz.getOptionFactory().setOption("report.bestellungsliste", rs.getInt("id"));
							rz.getOptionFactory().saveOptions();
						}
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_9 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_9 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_0_2_10 prüfen.
			 * Die Tabelle "rezeptliste" muss das Feld "tempvon" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_2_0_2_10);
				if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_2_0_2_10)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_10_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_10);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.10 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.10 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_0_2_11 prüfen.
			 * Die Tabelle "rezeptliste" muss das Feld "tempbis" enthalten
			 *
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_2_0_2_11);
				if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_2_0_2_11)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_11_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_11);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.11 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.11 EXCEPTION");
			}
			
			/**
			 * Auf Version 2.0.2.12 prüfen.
			 * Die Tabelle "temperaturzonen" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_0_2_12, null);
				if(!checkTableExists(FIELD_2_0_2_12)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_12 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_12);
							stmt.executeUpdate(SQL_2_0_2_12_1);
							stmt.executeUpdate(SQL_2_0_2_12_2);
							stmt.executeUpdate(SQL_2_0_2_12_3);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_12 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_12 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_2_13 prüfen.
			 * Das Formular "temperaturzonen-liste" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_2_13 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_13 INSERT 'temperaturzonen-liste' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_2_13);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
						rs = stm1.executeQuery("select id from formulare where typ=" + ReportFactory.REPORT_TYPE_TEMPERATURZONEN);
						if(rs.next()) {
							rz.getOptionFactory().setOption("report.tzone", rs.getInt("id"));
							rz.getOptionFactory().saveOptions();
						}
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_13 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_13 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2.0.2.14 prüfen.
			 * Die Tabelle "auftraege" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_0_2_14, null);
				if(!checkTableExists(FIELD_2_0_2_14)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_14 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_14);
							stmt.executeUpdate(SQL_2_0_2_15);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_14 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_14 EXCEPTION");
			}
			
			
			
			/**
			 * Auf Version 2.0.2.16 prüfen.
			 * Die Tabelle "auftragsliste" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_0_2_16, null);
				if(!checkTableExists(FIELD_2_0_2_16)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_16 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_16);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_16 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_16 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_2_17 prüfen.
			 * Das Formular "auftragsliste" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_2_17 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_17 INSERT 'auftragsliste' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_2_17);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
						rs = stm1.executeQuery("select id from formulare where typ=" + ReportFactory.REPORT_TYPE_BESTELLUNGEN);
						if(rs.next()) {
							rz.getOptionFactory().setOption("report.auftragsliste", rs.getInt("id"));
							rz.getOptionFactory().saveOptions();
						}
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_17 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_17 EXCEPTION");
			}
				
			
			/**
			 * Auf Version 2.0.2.18 prüfen.
			 * Die Tabelle "kalender" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_0_2_18, null);
				if(!checkTableExists(FIELD_2_0_2_18)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_18 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_18);
							stmt.executeUpdate(SQL_2_0_2_19);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_18 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_18 EXCEPTION");
			}
			

			
			/**
			 * Auf Version 2.0.2.20 prüfen.
			 * Die Tabelle "termine" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_0_2_20, null);
				if(!checkTableExists(FIELD_2_0_2_20)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_20 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_20);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_20 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_20 EXCEPTION");
			}
			
			
			
			/**
			 * Auf Version 2_0_2_21 prüfen.
			 * Die Tabelle "auftragslist" muss das Feld "anfrage" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_AUFTRAGSLISTE,FIELD_2_0_2_21);
				if(!checkFieldExists(DBFactory.TABLE_AUFTRAGSLISTE,FIELD_2_0_2_21)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_21_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_21);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.21 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.21 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_0_2_22 prüfen.
			 * Die Tabelle "auftraege" muss die Felder für Erledigte/Anfragen- Farben  enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_AUFTRAEGE,FIELD_2_0_2_22);
				if(!checkFieldExists(DBFactory.TABLE_AUFTRAEGE,FIELD_2_0_2_22)) {{
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_22_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_22);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.22 FAILED");
						}
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.22 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_2_23 prüfen.
			 * Die Tabelle "auftragsliste" muss das feld "inarbeit_datum"  enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_AUFTRAGSLISTE,FIELD_2_0_2_23);
				if(!checkFieldExists(DBFactory.TABLE_AUFTRAGSLISTE,FIELD_2_0_2_23)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_23_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_23);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.23 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.23 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_2_24 prüfen.
			 * Die Tabelle "termine" muss das feld "erledigt"  enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_TERMINE,FIELD_2_0_2_24);
				if(!checkFieldExists(DBFactory.TABLE_TERMINE,FIELD_2_0_2_24)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_24_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_24);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.24 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.24 EXCEPTION");
			}
			
			
			

			/**
			 * Auf Version 2_0_2_25 prüfen.
			 * Das Formular "dm.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_2_25 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_25 INSERT 'dm' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_2_25);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_25 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_25 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_2_26 prüfen.
			 * Die Tabelle "laborwerte" muss das Feld "fix" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_LABORWERTE,FIELD_2_0_2_26);
				if(!checkFieldExists(DBFactory.TABLE_LABORWERTE,FIELD_2_0_2_26)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_26_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_26);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.26 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.10 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_0_2_27 prüfen.
			 * Die Tabelle "auftragsliste" muss das Feld "tank" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_AUFTRAGSLISTE,FIELD_2_0_2_27);
				if(!checkFieldExists(DBFactory.TABLE_AUFTRAGSLISTE,FIELD_2_0_2_27)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_27_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_27);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.27 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.27 EXCEPTION");
			}
		
			
			/**
			 * Auf Version 2.0.2.28 prüfen.
			 * Die Tabelle "orter" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_0_2_28, null);
				if(!checkTableExists(FIELD_2_0_2_28)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_28 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_28);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_28 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_28 EXCEPTION");
			}
			
			/**
			 * Auf Version 2.0.2.29 prüfen.
			 * Die Tabelle "tanks" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_0_2_29, null);
				if(!checkTableExists(FIELD_2_0_2_29)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_29 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_29);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_29 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_29 EXCEPTION");
			}
			
			

			/**
			 * Auf Version 2_0_2_30 prüfen.
			 * Die Tabelle "rezeptliste" muss die Felder für die Konformitätserklärung enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_2_0_2_30);
				if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_2_0_2_30)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_30_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_30);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.30 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.30 EXCEPTION");
			}
			// konformitätserklärung
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_2_0_2_31);
				if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_2_0_2_31)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_31_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_31);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.31 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.31 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_0_2_32 prüfen.
			 * Das Formular "konformitätserklärungen" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_2_32 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_32 INSERT 'konform' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_2_32);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
						if(rs.next()) {
							rz.getOptionFactory().setOption("report.konform", rs.getInt("id"));
							rz.getOptionFactory().saveOptions();
						}
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_32 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_32 EXCEPTION");
			}
				
			
			/**
			 * Auf Version 2_0_2_33 prüfen.
			 * Die Tabelle "bestellung" muss die Felder für das lieferdatum enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_BESTELLUNG,FIELD_2_0_2_33);
				if(!checkFieldExists(DBFactory.TABLE_BESTELLUNG,FIELD_2_0_2_33)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_33_ FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_33);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.33 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.33 EXCEPTION");
			}
			

			/**
			 * Auf Version 2_0_2_34 prüfen.
			 * Das Formular "containerliste_2.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_2_34 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_34 INSERT 'containerliste_2' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_2_34);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
						rs = stm1.executeQuery("select id from formulare where typ=" + ReportFactory.REPORT_TYPE_CONTAINERLISTE + " order by id desc limit 1");
						if(rs.next()) {
							rz.getOptionFactory().setOption("report.containerliste", rs.getInt("id"));
							rz.getOptionFactory().saveOptions();
						}
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_34 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_34 EXCEPTION");
			}
			
			

			
			
			/**
			 * Auf Version 2_0_2_34a prüfen.
			 * indexe  für bezeichnung und containerS in lieferschein_zeile
			 * und geaendert in lieferschein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				final Statement stm2 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
				rs = stm1.executeQuery("SELECT count(index_name) as i FROM INFORMATION_SCHEMA.STATISTICS WHERE table_schema='rzpro' AND table_name='lieferschein_zeile' and column_name='bezeichnung'");
				if(rs.next()) {
					if(rs.getInt("i") == 0) {
						stm2.executeUpdate("alter table lieferschein_zeile add index idx1(bezeichnung)");
					}
				}
				rs = stm1.executeQuery("SELECT count(index_name) as i FROM INFORMATION_SCHEMA.STATISTICS WHERE table_schema='rzpro' AND table_name='lieferschein_zeile' and column_name='containerS'");
				if(rs.next()) {
					if(rs.getInt("i") == 0) {
						stm2.executeUpdate("alter table lieferschein_zeile add index idx2(containerS)");
					}
				}
				rs = stm1.executeQuery("SELECT count(index_name) as i FROM INFORMATION_SCHEMA.STATISTICS WHERE table_schema='rzpro' AND table_name='lieferschein' and column_name='geaendert'");
				if(rs.next()) {
					if(rs.getInt("i") == 0) {
						stm2.executeUpdate("alter table lieferschein add index idxg(geaendert)");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_35 EXCEPTION" + e.getLocalizedMessage());
			}
			
			
			/**
			 * Auf Version 2_0_2_35 prüfen.
			 * Das Formular "containerliste_2.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_2_35 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_35 INSERT 'statistik_6' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_2_35);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_35 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_35 EXCEPTION");
			}
			
			/**
			 * Auf Version 2.0.2.36 prüfen.
			 * Die Tabelle "auftragbenutzer" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_0_2_36, null);
				if(!checkTableExists(FIELD_2_0_2_36)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_36 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_36);
							String insert = SQL_2_0_2_37.replaceAll("%s",this.dbGetUser());
							stmt.executeUpdate(insert);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_36 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_36 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2.0.2.38 prüfen.
			 * Die Tabelle "sorten" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_0_2_38, null);
				if(!checkTableExists(FIELD_2_0_2_38)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_38 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_38);
							String insert = SQL_2_0_2_39.replaceAll("%s",rz.getLocale().getString("dbfactory.keine_sorte"));
							stmt.executeUpdate(insert);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_38 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_38 EXCEPTION");
			}
			
			
			
			/**
			 * Auf Version 2_0_2_40 prüfen.
			 * Die Tabelle "auftraege" muss die Felder für das die erweiterten aufträge enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_AUFTRAEGE,FIELD_2_0_2_40);
				if(!checkFieldExists(DBFactory.TABLE_AUFTRAEGE,FIELD_2_0_2_40)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_40 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_41);
							stmt.executeUpdate(SQL_2_0_2_42);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.40 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.40 EXCEPTION");
			}
			
			
			
			/**
			 * Auf Version 2_0_2_43 prüfen.
			 * Die Tabelle "auftrag" muss die Felder für Daueraufträge enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_AUFTRAGSLISTE,FIELD_2_0_2_43);
				if(!checkFieldExists(DBFactory.TABLE_AUFTRAGSLISTE,FIELD_2_0_2_43)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_43 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_44);
							stmt.executeUpdate(SQL_2_0_2_45);
							stmt.executeUpdate(SQL_2_0_2_46);
							stmt.executeUpdate(SQL_2_0_2_47);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.43 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.43 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_2_48 prüfen.
			 * Die Tabelle "auftrag" muss die Felder für Daueraufträge enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_AUFTRAGSLISTE,FIELD_2_0_2_48);
				if(!checkFieldExists(DBFactory.TABLE_AUFTRAGSLISTE,FIELD_2_0_2_48)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_48 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_49);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.48 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.48 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_0_2_50 prüfen.
			 * Die Tabelle "auftrag" muss die Felder für Daueraufträge enthalten
			 *
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_AUFTRAGSLISTE,FIELD_2_0_2_50);
				if(!checkFieldExists(DBFactory.TABLE_AUFTRAGSLISTE,FIELD_2_0_2_50)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_50 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_0_2_51);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.0.2.50 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.0.2.50 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_0_2_52 prüfen.
			 * Das Formular "rechnen_6.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_2_52 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_52 INSERT 'rechnen_6' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_2_52);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_52 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_52 EXCEPTION");
			}
			
			
			
			/**
			 * Auf Version 2_0_2_53 prüfen.
			 * Das Formular "tankbelegung_1.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_0_2_53 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_53 INSERT 'tankbelegung_1' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_0_2_53);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_0_2_53 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_0_2_53 EXCEPTION");
			}
			
			/**
			 * Auf Version 2.2.0.1 prüfen.
			 * Die Tabelle "mischungen" muss vorhanden sein
			 * Die Spalte "comment" in den buchungen wird indiziert
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_2_0_1, null);
				if(!checkTableExists(FIELD_2_2_0_1)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_1 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_1);
							stmt.executeUpdate(SQL_2_2_0_1_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_1 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_2_0_2 prüfen.
			 * Die Tabelle "rezeptliste" muss das Feld "spezifikation_text" enthalten
			 * 
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_2_2_0_2);
				if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_2_2_0_2)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_2 FAILED-CREATING FIELDS");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2.2.0.2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2.2.0.2 EXCEPTION");
			}
			
			
			
			/**
			 * Auf Version 2.2.0.3 prüfen.
			 * Die Tabelle "tickets" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_2_0_3, null);
				if(!checkTableExists(FIELD_2_2_0_3)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_3 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_3);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_3 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_3 EXCEPTION");
			}
			
			
			
			/**
			 * Auf Version 2.2.0.4 prüfen.
			 * Die Tabelle "tickets_transaktionen" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_2_0_4, null);
				if(!checkTableExists(FIELD_2_2_0_4)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_4 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_4);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_4 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_4 EXCEPTION");
			}
			
			/**
			 * Auf Version 2.2.0.5 prüfen.
			 * Die Tabelle "bewertungen_kategorien" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_2_0_5, null);
				if(!checkTableExists(FIELD_2_2_0_5)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_5 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_5);
							stmt.executeUpdate(SQL_2_2_0_5_1);
							stmt.executeUpdate(SQL_2_2_0_5_2);
							stmt.executeUpdate(SQL_2_2_0_5_3);
							stmt.executeUpdate(SQL_2_2_0_5_4);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_5 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_5 EXCEPTION");
			}
			
			/**
			 * Auf Version 2.2.0.6 prüfen.
			 * Die Tabelle "bewertungen" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_2_0_6, null);
				if(!checkTableExists(FIELD_2_2_0_6)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_6 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_6);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_6 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_6 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2.2.0.7 prüfen.
			 * Die Tabelle "bewertungen_block" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_2_0_7, null);
				if(!checkTableExists(FIELD_2_2_0_7)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_7 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_7);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_7 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_7 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2.2.0.8 prüfen.
			 * Die Tabelle "bewertungen_defaults" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_2_2_0_8, null);
				if(!checkTableExists(FIELD_2_2_0_8)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_8 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_8);
							stmt.executeUpdate(SQL_2_2_0_8_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_8 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_8 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_2_0_9 prüfen.
			 * Das Formular "bewertung.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_2_0_9 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_9 INSERT 'bewertung' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_2_0_9);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile;
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_9 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_9 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_2_0_10 prüfen.
			 * Die Tabelle "rezeptliste" muss das Feld "bewertung" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_2_2_0_10);
				if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_2_2_0_10)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_10 FAILED-CREATING FIELDS Bewertung");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_10);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_10 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_10 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_2_0_11 prüfen.
			 * Die Tabelle "bewertungen_defaults" muss das Feld "bausteine" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_BEWERTUNGEN_DEFAULTS,FIELD_2_2_0_11);
				if(!checkFieldExists(DBFactory.TABLE_BEWERTUNGEN_DEFAULTS,FIELD_2_2_0_11)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_11 FAILED-CREATING FIELDS Bewertung");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_11);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_11 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_11 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_2_0_12 prüfen.
			 * Die Tabelle "tickets" muss das Feld "nummer" enthalten
			 *
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_TICKETS,FIELD_2_2_0_12);
				if(!checkFieldExists(DBFactory.TABLE_TICKETS,FIELD_2_2_0_12)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_12 FAILED-CREATING FIELD nummer");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_12);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_12 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_12 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 2_2_0_13 prüfen.
			 * Die Tabelle "tickets_transaktionen" muss  Felder für tanks enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_TICKETS_TRANSAKTIONEN,FIELD_2_2_0_13);
				if(!checkFieldExists(DBFactory.TABLE_TICKETS_TRANSAKTIONEN,FIELD_2_2_0_13)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_13 FAILED-CREATING FIELDS tank,tank_dest");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_13);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_13 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_13 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_2_0_14 prüfen.
			 * Die Tabelle "tickets" muss  Felder für losnummer enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_TICKETS,FIELD_2_2_0_14);
				if(!checkFieldExists(DBFactory.TABLE_TICKETS,FIELD_2_2_0_14)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_14 FAILED-CREATING FIELD losnummer");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_14);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_14 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_14 EXCEPTION");
			}
			
		
			/**
			 * Auf Version 2_2_0_16 prüfen.
			 * Die Tabelle "mischungen" muss  Felder für losnummer enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_MISCHUNGEN,FIELD_2_2_0_16);
				if(!checkFieldExists(DBFactory.TABLE_MISCHUNGEN,FIELD_2_2_0_16)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_16 FAILED-CREATING FIELD losnummer");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_16);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_16 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_16 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_2_0_17 prüfen.
			 * Die Tabelle "tickets" muss  Felder für die original_losnummer enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_TICKETS,FIELD_2_2_0_17);
				if(!checkFieldExists(DBFactory.TABLE_TICKETS,FIELD_2_2_0_17)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_17 FAILED-CREATING FIELD losnummer_original");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_17);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_17 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_17 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_2_0_18 prüfen.
			 * Die Tabelle "tickets" muss  Felder für die adresse
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_TICKETS,FIELD_2_2_0_18);
				if(!checkFieldExists(DBFactory.TABLE_TICKETS,FIELD_2_2_0_18)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_18 FAILED-CREATING FIELD adresse");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_18);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_18 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_18 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_2_0_19 prüfen.
			 * Das Formular "mischung_tank.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_2_0_19 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_19 INSERT 'mischung detail' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_2_0_19);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_19FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_19 EXCEPTION");
			}
			
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_2_0_20 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_20 INSERT 'mischung kurzfassung' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_2_0_20);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_20FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_20 EXCEPTION");
			}
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_2_0_21 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_21 INSERT 'mischungsliste' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_2_0_21);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_21 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_21 EXCEPTION");
			}
			
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_2_2_0_22 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_22 INSERT 'mischungsliste nach sorten' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_2_2_0_22);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_22 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_22 EXCEPTION");
			}
			
			/**
			 * Auf Version 2_2_0_23 prüfen.
			 * Die Tabelle "tickets" muss das Feld "probe" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_TICKETS,FIELD_2_2_0_23);
				if(!checkFieldExists(DBFactory.TABLE_TICKETS,FIELD_2_2_0_23)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_23 FAILED-CREATING FIELD probe");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_2_2_0_23);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 2_2_0_23 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 2_2_0_23 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_0_0_1 prüfen.
			 * Die Tabelle "mischungsabfragen" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_3_0_0_1, null);
				if(!checkTableExists(FIELD_3_0_0_1)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_0_1 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_0_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_0_1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_0_1 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_0_0_2 prüfen.
			 * Die Tabelle "icons" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_3_0_0_2, null);
				if(!checkTableExists(FIELD_3_0_0_2)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_0_2 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_0_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_0_2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_0_2 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_0_0_3 prüfen.
			 * Die Tabelle "tickets" muss das Feld "bewertung" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_TICKETS,FIELD_3_0_0_3);
				if(!checkFieldExists(DBFactory.TABLE_TICKETS,FIELD_3_0_0_3)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_0_3 FAILED-CREATING FIELD bewertung");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_0_3);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_0_3 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_0_3 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_0_0_4 prüfen.
			 * Die Tabelle "mischungsabfragen" muss das Feld "aktionen" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_MISCHUNGSABFRAGE,FIELD_3_0_0_4);
				if(!checkFieldExists(DBFactory.TABLE_MISCHUNGSABFRAGE,FIELD_3_0_0_4)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_0_4 FAILED-CREATING FIELD aktionen");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_0_4);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_0_4 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_0_4 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_0_2_0 prüfen.
			 * Die Tabelle "auftraege" muss das Feld "gruppe" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_AUFTRAGSLISTE,FIELD_3_0_2_0);
				if(!checkFieldExists(DBFactory.TABLE_AUFTRAGSLISTE,FIELD_3_0_2_0)) {{
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_2_0 FAILED-CREATING FIELD gruppe");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_2_0);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_2_0 FAILED");
						}
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_2_0 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_0_2_1 prüfen.
			 * Die Tabelle "auftraege" muss das Feld "wichtig" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_AUFTRAGSLISTE,FIELD_3_0_2_1);
				if(!checkFieldExists(DBFactory.TABLE_AUFTRAGSLISTE,FIELD_3_0_2_1)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_2_1 FAILED-CREATING FIELD wichtig");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_2_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_2_1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_2_1 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_0_2_1 prüfen.
			 * Die Tabelle "auftraege" muss das Feld "darker" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_AUFTRAEGE,FIELD_3_0_2_2);
				if(!checkFieldExists(DBFactory.TABLE_AUFTRAEGE,FIELD_3_0_2_2)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_2_1 FAILED-CREATING FIELD darker");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_2_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_2_2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_2_2 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_0_2_3 prüfen.
			 * Das Formular "lagerbestand_ohne_peis.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_0_2_3 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_2_3 INSERT 'lagerbestand ohne preis' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_0_2_3);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_2_3 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_2_3 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_0_3_1 prüfen.
			 * Das Formular "ergebnislikstebestand2.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_0_3_1 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_3_1 INSERT 'ergebnislistebestand2' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_0_3_1);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile  + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_3_1 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_3_1 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_0_3_2 prüfen.
			 * Die Tabelle Bestellung muss das Feld "bestellt" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_BESTELLUNG,FIELD_3_0_3_2);
				if(!checkFieldExists(DBFactory.TABLE_BESTELLUNG,FIELD_3_0_3_2)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_3_2 FAILED-CREATING FIELD bestellt");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_3_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_3_2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_3_2 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_0_3_3 prüfen.
			 * Die Tabelle deklaration_text muss das Feld "id" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_DEKLARATION_TEXT,FIELD_3_0_3_3);
				if(!checkFieldExists(DBFactory.TABLE_DEKLARATION_TEXT,FIELD_3_0_3_3)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_3_3 FAILED-CREATING FIELD id,active");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_3_3);
							stmt.executeUpdate(SQL_3_0_3_4);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_3_3 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_3_3 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_0_3_5 prüfen.
			 * Die Tabelle tickets muss die felder "kontrolle" und "kontrolle_datum" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_TICKETS,FIELD_3_0_3_5);
				if(!checkFieldExists(DBFactory.TABLE_TICKETS,FIELD_3_0_3_5)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_3_5 FAILED-CREATING FIELD kontrolle");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_3_5);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_3_5 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_3_5 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_0_6_1 prüfen.
			 * Die Tabelle bewertungen muss die felder "kontrolle" und "kontrolle_datum" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_BEWERTUNGEN,FIELD_3_0_6_1);
				if(!checkFieldExists(DBFactory.TABLE_BEWERTUNGEN,FIELD_3_0_6_1)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_6_1 FAILED-CREATING FIELD kontrolle");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_6_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_6_1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_6_1 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_0_6_2 prüfen.
			 * Die Tabelle "icons" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_3_0_6_2, null);
				if(!checkTableExists(FIELD_3_0_6_2)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_6_2 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_6_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_6_2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_6_2 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_0_7_1 prüfen.
			 * Das Formular "zutatenliste.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_0_7_1 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_7_1 INSERT 'zutatenliste' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_0_7_1);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile  + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_7_1 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_7_1 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_0_9_1 prüfen.
			 * Die Tabelle lieferschein_zeile muss das felde "ean" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_LIEFERSCHEIN_ZEILE,FIELD_3_0_9_1);
				if(!checkFieldExists(DBFactory.TABLE_LIEFERSCHEIN_ZEILE,FIELD_3_0_9_1)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_9_1 FAILED-CREATING FIELD ean");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_9_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_9_1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_9_1 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_0_9_2 prüfen.
			 * Die Tabelle rezeptliste muss das feld "ean" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_REZEPTLISTE,FIELD_3_0_9_2);
				if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_3_0_9_2)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_9_2 FAILED-CREATING FIELD ean");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_9_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_9_2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_9_2 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_0_9_3 prüfen.
			 * Das Formular "lieferschein_2.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_0_9_3 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_9_1 INSERT 'lieferschein_2' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_0_9_3);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_9_3 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_9_3 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_0_9_4 prüfen.
			 * Die Tabelle mischungen muss das feld "adresse" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_MISCHUNGEN,FIELD_3_0_9_4);
				if(!checkFieldExists(DBFactory.TABLE_MISCHUNGEN,FIELD_3_0_9_4)) {{
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_9_4 FAILED-CREATING FIELD adresse");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_9_4);
							stmt.executeUpdate(SQL_3_0_9_5);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_9_4 FAILED");
						}
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_9_4 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_0_9_6 prüfen.
			 * Die Tabelle mischungsabfragen muss das feld "adresse" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,TABLE_MISCHUNGSABFRAGE,FIELD_3_0_9_6);
				if(!checkFieldExists(DBFactory.TABLE_MISCHUNGSABFRAGE,FIELD_3_0_9_6)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_0_9_6 FAILED-CREATING FIELD adresse");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_0_9_6);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_0_9_6 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_0_9_6 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_1_0_0 prüfen.
			 * Das Formular "trace_1.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_1_0_0 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_1_0_0 INSERT 'trace_1' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_1_0_0);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_1_0_0 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_1_0_0 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_1_0_0 prüfen.
			 * Die Tabelle "losnummer_liste" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_3_1_0_1, null);
				if(!checkTableExists(FIELD_3_1_0_1)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_1_0_1 FAILED-CREATING TABLE");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_1_0_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_1_0_1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_1_0_1 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_2_0_0 prüfen.
			 * Die Tabelle "steuerlager" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_3_2_0_0, null);
				if(!checkTableExists(FIELD_3_2_0_0)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_0 FAILED-CREATING TABLE steuerlager");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_2_0_0);
							stmt.executeUpdate(SQL_3_2_0_0_1.replaceAll("%s", rz.getLocale().getString("database.steuerlager.default")));
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_0 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_0 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_2_0_1 prüfen.
			 * Die Tabelle rezetpliste muss die Felder "sorte","steuer_artikel" und "steuerlager" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,DBFactory.TABLE_REZEPTLISTE,FIELD_3_2_0_1);
				if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE,FIELD_3_2_0_1)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_1 FAILED-CREATING FIELDS sorte,steuer_artikel,steuerlager");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_2_0_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_1 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_2_0_2 prüfen.
			 * Die Tabelle buchungen muss die Felder "sorte","steuer_artikel" und "steuerlager" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,DBFactory.TABLE_BUCHUNG,FIELD_3_2_0_2);
				if(!checkFieldExists(DBFactory.TABLE_BUCHUNG,FIELD_3_2_0_2)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_2 FAILED-CREATING FIELDS sorte,steuer_artikel,steuerlager");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_2_0_2);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_2 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_2_0_3 prüfen.
			 * Das Formular "lagerliste_steuer.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_2_0_3 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_3 INSERT 'lagerliste_steuer' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_2_0_3);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile +"\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_3 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_3 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_2_0_4 prüfen.
			 * Die Tabelle inventurzeile muss die Felder "lager" "sorte","steuer_artikel" und "steuerlager" enthalten
			 * 
			 */
			try {
				//final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,DBFactory.TABLE_INVENTURZEILE,FIELD_3_2_0_4);
				if(!checkFieldExists(DBFactory.TABLE_INVENTURZEILE,FIELD_3_2_0_4)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_2 FAILED-CREATING FIELDS lager,sorte,steuer_artikel,steuerlager");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_2_0_4);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_4 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_4 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_2_0_5 prüfen.
			 * Das Formular "inventur_inhalt_steuer.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_2_0_5 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_5 INSERT 'inventur_inhalt_steuer' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_2_0_5);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_5 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_5 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_2_0_6 prüfen.
			 * Das Formular "inventur_raum_steuer.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_2_0_6 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_6 INSERT 'inventur_raum_steuer' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_2_0_6);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_6 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_6 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_2_0_7 prüfen.
			 * Das Formular "inventur_lager_steuer.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_2_0_7 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_7 INSERT 'inventur_lager_steuer' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_2_0_7);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_7 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_7 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_2_0_8 prüfen.
			 * Das Formular "inventur_sorte_steuer.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_2_0_8 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_8 INSERT 'inventur_sorte_steuer' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_2_0_8);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_8 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_8 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_2_0_9 prüfen.
			 * Das Formular "inventur_steuer_artikel_steuer.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_2_0_9 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_9 INSERT 'inventur_steuer_artikel_steuer' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_2_0_9);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_9 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_9 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_2_0_10 prüfen.
			 * Das Formular "inventur_steuerlager_steuer.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_2_0_10 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_10 INSERT 'inventur_steuerlager_steuer' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_2_0_10);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_10 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_10 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_2_0_11 prüfen.
			 * Die Tabelle rezetpliste muss das Feld "auto_anfrage" enthalten
			 * 
			 */
			try {
//				final ResultSet rs = con.getMetaData().getColumns(con.getCatalog(),null,DBFactory.TABLE_REZEPTLISTE,FIELD_3_2_0_11);
					if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE, FIELD_3_2_0_11)) {
					{
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_11 FAILED-CREATING FIELD auto_anfrage");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_2_0_11);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_11 FAILED");
						}
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_11 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_2_0_12 prüfen.
			 * Die Tabelle "properties" muss vorhanden sein
			 */
			try {
			//	final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_3_2_0_12, null);
				if(!checkTableExists(FIELD_3_2_0_12)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_12 FAILED-CREATING TABLE properties");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_2_0_12);
							stmt.executeUpdate(SQL_3_2_0_12_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_12 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_12 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_2_0_13 prüfen.
			 * Das Formular "ergebnislistebestand3.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_2_0_13 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_13 INSERT 'ergebnislistebestand3' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_2_0_13);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_2_0_13 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_2_0_13 EXCEPTION");
			}
			
			
			
			/**
			 * Auf Version 3_3_0_1 prüfen.
			 * Das Formular "mischungsliste_l1.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_3_0_1 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_3_0_1 INSERT 'mischungsliste/tickets' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_3_0_1);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_3_0_1 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_3_0_1 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_3_0_2  prüfen.
			 * Das Formular "dependencyliste1.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_3_0_2 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_3_0_2 INSERT 'abhängige rezepturen' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_3_0_2);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
					} catch (final Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_3_0_2 FAILED");
					}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_3_0_2 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_3_0_3 prüfen.
			 * Die Tabelle mischungen muss das Feld "lager" enthalten
			 * 
			 */
			try {
					if(!checkFieldExists(DBFactory.TABLE_MISCHUNGEN, FIELD_3_3_0_3)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_3_0_3 FAILED-CREATING FIELD lager");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_3_3_0_3);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_3_0_3 FAILED");
						}
					//}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_3_0_3 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 3_3_6_1  prüfen.
			 * Das Formular "Bogen_A4.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_3_6_1 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_3_6_1 INSERT 'Bogen A4' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_3_6_1);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
						final ResultSet r1 = stm1.executeQuery("SELECT LAST_INSERT_ID()");
						if(r1.next()) {
							int insert = r1.getInt("LAST_INSERT_ID()");
							if (insert > 0) {
								final Statement stm2 = con.createStatement(ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_UPDATABLE);
								try {
									String sql1 = "insert into etikettenbogen ( name,image,num_columns,num_rows,width,height,report) values ('" + FIELD_3_3_6_1 +"','',1,1,210,297,"   +  String.valueOf(insert) +  " )";
									stm2.executeUpdate(sql1);
								} catch (final Exception e) {
									rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.3_3_6_1 ", e.getLocalizedMessage() + ": CREATING 3_3_6_1 - insert bogen FAILED");
								}
							}
						}
						} catch (final Exception e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_3_6_1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_3_6_1 EXCEPTION");
			}
			
			/**
			 * Auf Version 3_3_6_1  prüfen.
			 * Das Formular "Bogen_A4_2.txt" muss vorhanden sein
			 */
			try {
				ResultSet rs;
				final Statement stm1 = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				rs = stm1.executeQuery("SELECT id,name FROM " + TABLE_FORMULARE + " WHERE name='" + FIELD_3_3_6_2 + "'");
				if(!rs.first()) {
					rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 3_3_6_2 INSERT 'Bogen A4 / 2 Etiketten' FORM");
					final URL datei = getClass().getResource("/de/lunqual/rzpro/database/"+FILE_3_3_6_2);
					final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
					try {
						final URLConnection connect = datei.openConnection();
						final BufferedReader din =new  BufferedReader(new InputStreamReader(connect.getInputStream()));
						String sql="";
						String zeile;
						while ((zeile = din.readLine()) != null) {
							sql += zeile + "\n";
						}
						din.close();
						ret = false;
						stmt.executeUpdate(sql);
						final ResultSet r1 = stm1.executeQuery("SELECT LAST_INSERT_ID()");
						if(r1.next()) {
							int insert = r1.getInt("LAST_INSERT_ID()");
							if (insert > 0) {
								final Statement stm2 = con.createStatement(ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_UPDATABLE);
								try {
									String sql1 = "insert into etikettenbogen ( name,image,num_columns,num_rows,width,height,report) values ('" + FIELD_3_3_6_2 +"','',1,2,210,297,"   +  String.valueOf(insert) +  " )";
									stm2.executeUpdate(sql1);
								} catch (final Exception e) {
									rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.3_3_6_1", e.getLocalizedMessage() + ": CREATING 3_3_6_2 - insert bogen2 FAILED");
								}
							}
						}
						} catch (final Exception e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 3_3_6_2 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 3_3_6_1 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 4_0_0_0 prüfen.
			 * Die Tabelle "properties" muss vorhanden sein
			 */
			try {
				//final ResultSet rs = con.getMetaData().getTables(null, null, FIELD_4_0_0_1, null);
				if(!checkTableExists(FIELD_4_0_0_1)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 4_0_0_1 FAILED-CREATING TABLE documents");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_4_0_0_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 4_0_0_1 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 4_0_0_1 EXCEPTION");
			}
			
			/**
			 * Auf Version 4_0_1_1 prüfen.
			 * Die Tabelle auftragsliste muss das Feld "fertig" enthalten
			 * 
			 */
			try {
					if(!checkFieldExists(DBFactory.TABLE_AUFTRAGSLISTE, FIELD_4_0_1_1)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 4_0_1_1 FAILED-CREATING FIELD fertig");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_4_0_1_1);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 4_0_1_1 FAILED");
						}
					//}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 4_0_1_1 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 4_0_1_2 prüfen.
			 * 4_0_1_2 Die Tabelle auftraege muss die Felder "level_f_bg" und "level_f_hg" enthalten
			 * 
			 */
			try {
					if(!checkFieldExists(DBFactory.TABLE_AUFTRAEGE, FIELD_4_0_1_2)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 4_0_1_2 FAILED-CREATING FIELDS level_f_bg level_f_hg");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_4_0_1_2);
							stmt.executeUpdate(SQL_4_0_1_3);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 4_0_1_2 FAILED");
						}
					//}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 4_0_1_2 EXCEPTION");
			}
			
			/**
			 * Auf Version 4_0_1_4 prüfen.
			 * 4_0_1_2 Die Tabelle auftragsliste muss die Felder "fertig_user" und "fertig_datum" enthalten
			 * 
			 */
			try {
					if(!checkFieldExists(DBFactory.TABLE_AUFTRAGSLISTE, FIELD_4_0_1_4)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 4_0_1_4 FAILED-CREATING FIELDS fertig_datum fertig_user");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_4_0_1_4);
							stmt.executeUpdate(SQL_4_0_1_5);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 4_0_1_4 FAILED");
						}
					//}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 4_0_1_4 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 4_1_0_0 prüfen.
			 * Die Tabelle "kontrakte" muss vorhanden sein
			 */
			try {
				if(!checkTableExists(FIELD_4_1_0_0)){
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 4_1_0_0 FAILED-CREATING TABLE kontrakte");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_4_1_0_0);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 4_1_0_0 FAILED");
						}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 4_1_0_0 EXCEPTION");
			}
			
			
			/**
			 * Auf Version 4_1_2_0 prüfen.
			 * 4_0_1_2 Die Tabelle rezeptliste muss die Feld 'proben_anzahl enthalten
			 * 
			 */
			try {
					if(!checkFieldExists(DBFactory.TABLE_REZEPTLISTE, FIELD_4_1_2_0)) {
						rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "dbControl.CheckDatabaseVersion" , "Check 4_1_2_0 FAILED-CREATING FIELD proben_anzahl");
						final Statement stmt = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
						try {
							ret = false;
							stmt.executeUpdate(SQL_4_1_2_0);
						} catch (final SQLException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , e.getLocalizedMessage() + ": CREATING 4_1_2_0 FAILED");
						}
					//}
				}
			} catch (final SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR, "dbControl.CheckDatabaseVersion" , "Check 4_0_1_4 EXCEPTION");
			}
			


			
			//-------------------------------------------------------------
			// return
			//-------------------------------------------------------------
			return ret;

	}


	/**
	 * holt den Timestamp vom Server, bei Fehler wird die lokalzeit zurückgegeben
	 * @return
	 */
	public Date getServerTimestamp() {
		Date ret = null;
		try {
			ResultSet rs = getTimestamp.executeQuery();
			if(rs.next()) {
				ret = getDateFromString(rs.getString(1));
			}
			rs = null;
		} catch(final SQLException e) {
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "dbControl.getServerTimestamp" , e.getLocalizedMessage());
			ret = new Date();
		}
		return ret;
	}

	/**
	 * gibt die Version der Datenbank zurück
	 * @return String
	 */
	public String dbGetDatabaseVersion() {
		String ret = "";
		try {
			ret =  con.getMetaData().getDatabaseProductName() + " " +
			con.getMetaData().getDatabaseProductVersion() ;
		} catch(final Exception e) { }
		return ret.replaceAll("\\$","");
	}

	/**
	 * gibt die Version der Datenbanktreiber zurück
	 * @return String
	 */
	public String dbGetDriverVersion() {
		String ret = "";
		try {
			ret = con.getMetaData().getDriverName() + " " +
			con.getMetaData().getDriverVersion();
		} catch(final Exception e) { }
		return ret.replaceAll("\\$","");
	}

	/** dbGetUser() gibt den aktuellen Benutzernamen zurück */
	public String dbGetUser(){
		return user;
	}

	/** Datumsformat der Datenbank    */
	public String dbGetDateFormatString(java.util.Date d){
		return df.format(d);
	}

	public Date getDateFromString(String datum) {
		try {
			return df.parse(datum);
		} catch(final ParseException p) {
			return new Date();
		}
	}


	/**
	 * int dbGetLastInsertID(String) gibt die letzte InsertID für eine
	 * bestimmte Tabelle zurück */
	public int dbGetLastInsertID(String aTable){
		ResultSet rs = null;
		int ret = -1;
		try {
			getLastInsertID.executeQuery(LAST_INSERT_QUERY + aTable);
			rs = getLastInsertID.getResultSet();
			if(rs.next()){
				ret = rs.getInt("id");
			}
			if(rs != null) {
				rs.close();
			}
		}
		catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.dbGetLastInsertID-" + aTable, e.getLocalizedMessage());
			ret = -1;
		}
		return ret;
	}

	public boolean idExists(String tabelle,int id,boolean quiet) {
		boolean ret;
		try {
			final ResultSet rs = getReadOnly.executeQuery("SELECT id FROM "+ tabelle + " WHERE id=" + String.valueOf(id));
			ret= rs.next();
			if(!ret && !quiet) {
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.idExists" , "Datensatz " + tabelle + ":" + String.valueOf(id) + " nicht gefunden");
				dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
				dlgItem.setCaption(rz.getLocale().getString("database.key_not_found"));
				dlgItem.setTitel(rz.getLocale().getString("database.key_not_found"));
				dlgItem.setMessage(rz.getLocale().getString("database.key_not_found_message"));
				dlgItem.setIcon("warnung.png");
				dlgItem.setOk(rz.getLocale().getString("string_ok"));
				rz.getDialogFactory().getDialog(dlgItem);
			}
			if(rs != null) {
				rs.close();
			}
		} catch(final SQLException se) {
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.idExists" , se.getLocalizedMessage());
			ret = false;
		}
		return ret;
	}

	
	
	
}
