/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;

import javax.swing.JComboBox;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.inventur.InventurItem;
import de.lunqual.rzpro.items.inventur.InventurListe;
import de.lunqual.rzpro.items.inventur.InventurSummenItem;
import de.lunqual.rzpro.items.inventur.InventurZeilenItem;
import de.lunqual.rzpro.items.inventur.InventurZeilenliste;
import de.lunqual.rzpro.items.inventur.RaumItem;
import de.lunqual.rzpro.items.inventur.Raumliste;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class DBInventur {

    RzPro           		rz;
    Connection      	con;
    DBFactory       	db;

    // Statements
    PreparedStatement   	getInventurliste;
    PreparedStatement		getInventur;
    PreparedStatement		saveInventur;
    PreparedStatement		updateInventur;
    PreparedStatement		deleteInventur3;
    PreparedStatement		deleteInventur2;
    PreparedStatement		deleteInventur1;
    PreparedStatement		checkDeleteInventur;
    PreparedStatement		checkDeleteRaum;

    PreparedStatement		getZeilenListe[];
    PreparedStatement		getZeilenListeFilter[];
    private static final int ZL_ERSTELLT 		= 0;
    private static final int ZL_RAUM 		 	= 1;
    private static final int ZL_TANKNUMMER		= 2;
    private static final int ZL_BEZEICHNUNG		= 3;
    private static final int ZL_LAGER			= 4;    
    private static final int ZL_STEUER_ARTIKEL	= 5;
    private static final int ZL_SORTE			= 6;
    private static final int ZL_STEUERLAGER		= 7;

    PreparedStatement		saveZeile;
    PreparedStatement		updateZeile;
    PreparedStatement		deleteZeile;
    PreparedStatement		checkTankExist;
    PreparedStatement		checkTankExistID;

    PreparedStatement		getRaumliste;
    PreparedStatement		saveRaum;
    PreparedStatement		updateRaum;
    PreparedStatement		checkRaum;
    PreparedStatement		deleteRaum;

    PreparedStatement		getSumme;

    // Abfragen
    public static final int       	ZEILE_TYP_LITER   = 0;
    public static final int			ZEILE_TYP_KG		= 1;


    /** Creates a new instance of DBInventur */
    public DBInventur(RzPro r,DBFactory aDb,Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }

    private void setStatements(){
        try{
        		String INVENTURZEILE_FIELDS = " inventurzeile.id,inventurzeile.raum,inventurzeile.bezeichnung,inventurzeile.sorte,inventurzeile.lager,inventurzeile.steuerlager,inventurzeile.erstellt,typ,inventur,tanknummer,tanknummer_num,dbkey,staerke,extrakt,uebernommen," +
        				" liter,liter20,tanktemperatur,kg,la,brutto,tara,litergewicht,tafel2,tafel3,inventurzeile.user_1, " +
        				" raumliste.r_id,r_bezeichnung,lager.id,lager.name,sorten.id,sorten.bezeichnung,steuer_lager.id,steuer_lager.bezeichnung ,steuer_artikel ";
            getInventurliste          = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_INVENTUREN + " ORDER BY erstellt DESC" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getInventur		        = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_INVENTUREN +" WHERE id=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveInventur		        = con.prepareStatement("INSERT INTO " + DBFactory.TABLE_INVENTUREN +" (bezeichnung,bemerkungen,erstellt,geaendert,user_1,user_2) values (?,?,?,?,?,?)" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateInventur		    = con.prepareStatement("UPDATE " + DBFactory.TABLE_INVENTUREN +" set bezeichnung=?,bemerkungen=?,geaendert=?,user_2=? where id=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            checkDeleteInventur   = con.prepareStatement("SELECT count(*) as anzahl FROM " + DBFactory.TABLE_INVENTURZEILE +" WHERE inventur=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            deleteInventur3		    = con.prepareStatement("DELETE FROM " + DBFactory.TABLE_INVENTUREN +" where id=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteInventur2		    = con.prepareStatement("DELETE FROM " + DBFactory.TABLE_INVENTURZEILE +" where inventur=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteInventur1			= con.prepareStatement("DELETE FROM   " + DBFactory.TABLE_RAUMLISTE + " where r_inventur=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            checkDeleteInventur   = con.prepareStatement("SELECT count(*) as anzahl FROM " + DBFactory.TABLE_INVENTURZEILE +" WHERE inventur=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            getZeilenListe = new PreparedStatement[8];
            getZeilenListe[ZL_ERSTELLT]      		= con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id WHERE inventur=? and r_inventur=? order by inventurzeile.erstellt,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListe[ZL_RAUM]		        	= con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id WHERE inventur=? and r_inventur=? order by raum,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListe[ZL_TANKNUMMER] 	= con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id WHERE inventur=? and r_inventur=? order by tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListe[ZL_BEZEICHNUNG]   = con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id WHERE inventur=? and r_inventur=? order by inventurzeile.bezeichnung,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListe[ZL_LAGER]   = con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id WHERE inventur=? and r_inventur=? order by lager.name,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListe[ZL_STEUER_ARTIKEL]   = con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id WHERE inventur=? and r_inventur=? order by inventurzeile.steuer_artikel,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListe[ZL_SORTE]   = con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id WHERE inventur=? and r_inventur=? order by sorten.bezeichnung,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListe[ZL_STEUERLAGER]   = con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id WHERE inventur=? and r_inventur=? order by steuer_lager.bezeichnung,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            
            
            getZeilenListeFilter = new PreparedStatement[8];
            getZeilenListeFilter[ZL_ERSTELLT]      		= con.prepareStatement("SELECT "+ INVENTURZEILE_FIELDS +  " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id  left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id  WHERE inventur=? and r_inventur=? and inventurzeile.erstellt regexp(?) order by inventurzeile.erstellt,inventurzeile.erstellt,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListeFilter[ZL_RAUM]		        	= con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id  left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id  WHERE inventur=? and r_inventur=? and r_bezeichnung regexp(?) order by r_bezeichnung,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListeFilter[ZL_TANKNUMMER] 	= con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id  left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id  WHERE inventur=? and r_inventur=? and tanknummer regexp(?) order by tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListeFilter[ZL_BEZEICHNUNG]   = con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id  left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id  WHERE inventur=? and r_inventur=? and inventurzeile.bezeichnung regexp(?) order by inventurzeile.bezeichnung,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListeFilter[ZL_LAGER]   = con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id WHERE inventur=? and r_inventur=? and lager.name regexp(?)order by lager.name,inventurzeile.lager,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListeFilter[ZL_STEUER_ARTIKEL]   = con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id WHERE inventur=? and r_inventur=? and steuer_artikel regexp(?) order by steuer_artikel,inventurzeile.steuer_artikel,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListeFilter[ZL_SORTE]   = con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id WHERE inventur=? and r_inventur=? and sorten.bezeichnung regexp(?) order by sorten.bezeichnung,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getZeilenListeFilter[ZL_STEUERLAGER]   = con.prepareStatement("SELECT " + INVENTURZEILE_FIELDS + " FROM " + DBFactory.TABLE_INVENTURZEILE +" JOIN " + DBFactory.TABLE_RAUMLISTE  + " on " + DBFactory.TABLE_INVENTURZEILE +".raum=" + DBFactory.TABLE_RAUMLISTE + ".r_id left join lager on inventurzeile.lager=lager.id left join sorten on inventurzeile.sorte=sorten.id left join steuer_lager on inventurzeile.steuerlager=steuer_lager.id WHERE inventur=? and r_inventur=? and steuer_lager.bezeichnung regexp(?)order by steuer_lager.bezeichnung,tanknummer_num" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            
            
            saveZeile			        = con.prepareStatement("INSERT INTO " + DBFactory.TABLE_INVENTURZEILE +" (inventur,tanknummer,tanknummer_num,bezeichnung,dbkey,staerke,extrakt,raum,typ,uebernommen,liter,liter20,tanktemperatur,kg,la,brutto,tara,litergewicht,tafel2,tafel3,erstellt,user_1,lager,steuer_artikel,sorte,steuerlager) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateZeile		        = con.prepareStatement("UPDATE " + DBFactory.TABLE_INVENTURZEILE +" set inventur=?,tanknummer=?,tanknummer_num=?,bezeichnung=?,dbkey=?,staerke=?,extrakt=?,raum=?,typ=?,uebernommen=?,liter=?,liter20=?,tanktemperatur=?,kg=?,la=?,brutto=?,tara=?,litergewicht=?,tafel2=?,tafel3=?,erstellt=?,user_1=?,lager=?,steuer_artikel=?,sorte=?,steuerlager=? where id=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteZeile				    = con.prepareStatement("DELETE FROM " + DBFactory.TABLE_INVENTURZEILE +" where id=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            checkTankExist	        = con.prepareStatement("SELECT id FROM " + DBFactory.TABLE_INVENTURZEILE +" WHERE inventur=? and tanknummer=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            checkTankExistID       = con.prepareStatement("SELECT id FROM " + DBFactory.TABLE_INVENTURZEILE +" WHERE id=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getRaumliste		        = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_RAUMLISTE +" WHERE r_inventur=? order by r_bezeichnung" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveRaum 					= con.prepareStatement("INSERT INTO  " + DBFactory.TABLE_RAUMLISTE + " (r_inventur,r_bezeichnung)values(?,?) ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateRaum				= con.prepareStatement("UPDATE   " + DBFactory.TABLE_RAUMLISTE + " set r_bezeichnung=? where r_id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            checkRaum		        = con.prepareStatement("SELECT r_id FROM " + DBFactory.TABLE_RAUMLISTE +" WHERE r_id=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getSumme			        = con.prepareStatement("SELECT sum(liter20) as summe_liter_20,sum(la) as summe_la FROM " + DBFactory.TABLE_INVENTURZEILE +" WHERE inventur=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            deleteInventur1			= con.prepareStatement("DELETE FROM   " + DBFactory.TABLE_RAUMLISTE + " where r_inventur=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            checkDeleteRaum       = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_INVENTURZEILE +" WHERE raum=? LIMIT 1" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            deleteRaum				= con.prepareStatement("DELETE FROM   " + DBFactory.TABLE_RAUMLISTE + " where r_id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);

        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.setStatements", e.getLocalizedMessage());
        }
    }

    /**
     * Die Summe der Inventur ermitteln
     */
    public void getInventurSumme(int inventur,InventurSummenItem summe) {
    	try {
    		getSumme.setInt(1,inventur);
    		final ResultSet rs = getSumme.executeQuery();
    		if(rs.next()) {
    			summe.setSummeLa(rs.getDouble("summe_la"));
    			summe.setSummeLiter20(rs.getDouble("summe_liter_20"));
    		}
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.getInventurSumme", e.getLocalizedMessage());
    	}
    }
    /**
     * Wird ein Raum gerade verwendet ?
     */
    public boolean checkDeleteRaum(int id) {
    	boolean ret = true;
    	try {
    		checkDeleteRaum.setInt(1,id);
    		final ResultSet rs = checkDeleteRaum.executeQuery();
    		if(rs.first()) {
    			ret = true;
    		} else {
    			ret =false;
    		}
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.checkDeleteRaum", e.getLocalizedMessage());
            ret = true;
    	}
    	return ret;
    }
    /**
     * Existiert ein bestimmter Raum schon ?
     */
    private boolean checkRaumExist(int raum) {
    	boolean ret=true;
    	try {
    		checkRaum.setInt(1,raum);
    		final ResultSet rs = checkRaum.executeQuery();
    		if(rs.next()) {
    			ret = true;
    		}else {
    			ret = false;
    		}
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.chekcRaum", e.getLocalizedMessage());
            ret = true;
    	}
    	return ret;
    }

    /**
     * einen Raum löschen
     */
    public boolean deleteRaum(int id) {
    	boolean ret = false;
    	try {
    		deleteRaum.setInt(1,id);
    		if(deleteRaum.executeUpdate() != 0) {
    			ret = true;
    		}
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.saveRaumListe", e.getLocalizedMessage());
    	}
    	return ret;
    }

    /**
     * Die Raumliste einer Inventur speichern
     */
    public void saveRaumListe(int inventur,Raumliste rl) {
    	try {
    		for(int i = 0;i < rl.size();i++) {
    			if(rl.getItem(i).getId() == 0) {
    				//Neu
	    			saveRaum.setInt(1,inventur);
	    			rl.getItem(i).setInventur(inventur);
	    			saveRaum.setString(2,rl.getItem(i).getBezeichnung());
	    			saveRaum.executeUpdate();
	    			rl.getItem(i).setId(db.dbGetLastInsertID(DBFactory.TABLE_RAUMLISTE));
    			} else {
	    			if(checkRaumExist(rl.getItem(i).getId())) {
	    				//Update
	    				updateRaum.setString(1,rl.getItem(i).getBezeichnung());
	    				updateRaum.setInt(2,rl.getItem(i).getId());
	    				updateRaum.executeUpdate();
	    			}
    			}
    		}
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.saveRaumListe", e.getLocalizedMessage());
    	}
    }

    public void setRaumlisteCombo(InventurItem ii,JComboBox cmbListe) {
    	cmbListe.removeAllItems();
    	for(int i=0;i < ii.getRaumliste().size();i++) {
    		cmbListe.addItem(ii.getRaumliste().getItem(i));
    	}
    	try {
    		cmbListe.setSelectedIndex(0);
    	} catch(final Exception e) {

    	}
    }

    /**
     * Die Raumliste einer Inventur holen
     */
    public Raumliste getRaumListe(int inventur) {
    	final Raumliste rl = new Raumliste();
    	try {
    		getRaumliste.setInt(1,inventur);
    		final ResultSet rs = getRaumliste.executeQuery();
    		while (rs.next()) {
    			if(!rs.getString("r_bezeichnung").equals(rz.getLocale().getString("inventurfenster.raumliste_ka"))) {
	    			rl.addItem(new RaumItem(
	    					rs.getInt("r_id"),
	    					rs.getInt("r_inventur"),
	    					rs.getString("r_bezeichnung")
	    					));
	    		}
    		}
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.getRaumListe", e.getLocalizedMessage());
    	}
    	return rl;
    }

    /**
     * prüfen, ob eine Tanknummer schon existiert
     * @param inventur int
     * @param tanknummer String
     * @return 0, wenn nicht existent oder id des gefundenen Tanks
     */
    public int checkTankExists(int inventur,String tanknummer) {
    	int ret = 0;
    	try {
    		checkTankExist.setInt(1,inventur);
    		checkTankExist.setString(2,tanknummer);
    		final ResultSet rs = checkTankExist.executeQuery();
    		if(rs.next()) {
    			ret = rs.getInt("id");
    		}
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.checkTankExist", e.getLocalizedMessage());
    		ret = 0;
    	}
    	return ret;
    }

    /**
     * prüfen, ob eine Tank-ID schon existiert
     * @param inventur int
     * @param tanknummer String
     * @return 0, wenn nicht existent oder id des gefundenen Tanks
     */
    public boolean checkTankExists(int id) {
    	boolean ret = false;
    	try {
    		checkTankExistID.setInt(1,id);
    		final ResultSet rs = checkTankExistID.executeQuery();
    		if(rs.next()) {
    			ret = true;
    		} else {
    			ret = false;
    		}
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.checkTankExist", e.getLocalizedMessage());
    		ret = true;
    	}
    	return ret;
    }

    /**
     * einen Behälter aus der Liste entfernen
     * @return true, wenn gelöscht werden konnte
     */
    public boolean deleteZeilenItem(int id) {
    	boolean ret = false;
    	try {
    		deleteZeile.setInt(1,id);
    		if(deleteZeile.executeUpdate() != 0) {
    			ret = true;
    		}
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.deleteZeilenItemt", e.getLocalizedMessage());
            ret = false;
    	}
    	return ret;
    }
    /**
     * einen einzelnen Behälter speichern
     */
    public int saveZeilenItem(InventurZeilenItem iz) {
    	int ret = 0;
    	try {
    		PreparedStatement stm;
    		if(iz.getId() == 0) {
    			stm=saveZeile;
    		} else {
    			stm=updateZeile;
    			if(this.checkTankExists(iz.getId())) {
    				stm.setInt(27,iz.getId());
    			} else {
    				stm = saveZeile;
    				iz.setId(0);
    			}
    		}
    		stm.setInt(1,iz.getInventur());
    		stm.setString(2,iz.getTanknummer());
    		stm.setInt(3,iz.getTankNummerNum());
    		stm.setString(4,iz.getInhalt());
    		stm.setInt(5,iz.getDbkey());
    		stm.setDouble(6,iz.getStaerke());
    		stm.setInt(7,iz.getExtrakt());
    		stm.setInt(8,iz.getRaum());
    		stm.setInt(9,iz.getTyp());
    		stm.setInt(10,iz.getUebernommen());
    		stm.setDouble(11,iz.getLiter());
    		stm.setDouble(12,iz.getLiter20());
    		stm.setDouble(13,iz.getTanktemperatur());
    		stm.setDouble(14,iz.getNetto());
    		stm.setDouble(15,iz.getLa());
    		stm.setDouble(16,iz.getBrutto());
    		stm.setDouble(17,iz.getTara());
    		stm.setDouble(18,iz.getLitergewicht());
    		stm.setDouble(19,iz.getTafel2());
    		stm.setDouble(20,iz.getTafel3());
    		stm.setString(21,db.dbGetDateFormatString(iz.getErstellt()));
    		stm.setString(22,db.dbGetUser());
    		stm.setInt(23, iz.getLager());
    		stm.setString(24, iz.getSteuer_artikel());
    		stm.setInt(25, iz.getSorte());
    		stm.setInt(26, iz.getSteuerlager());
    		stm.executeUpdate();
    		ret = db.dbGetLastInsertID(DBFactory.TABLE_INVENTURZEILE);
    		if(iz.getId()==0) {
    			iz.setId(ret);
    		}
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.saveZeile", e.getLocalizedMessage());
    		ret = 0;
    	}
    	return ret;
    }
    /**
     * Inventurzeilenliste holen
     */
    public InventurZeilenliste getZeilenListe(InventurItem ii,String sort_order) {
    	final InventurZeilenliste zl = new InventurZeilenliste();
    	try {
    		PreparedStatement stm=null;
    		if(sort_order.equals("erstellt")) {
    			stm=getZeilenListe[ZL_ERSTELLT];
    		} else 	if(sort_order.equals("raum")) {
    			stm=getZeilenListe[ZL_RAUM];
    		}  else	if(sort_order.equals("tanknummer_num")) {
    			stm=getZeilenListe[ZL_TANKNUMMER];
    		} else 	if(sort_order.equals("bezeichnung")) {
    			stm=getZeilenListe[ZL_BEZEICHNUNG];
    		}else 	if(sort_order.equals("lager")) {
    			stm=getZeilenListe[ZL_LAGER];
    		}else 	if(sort_order.equals("steuer_artikel")) {
    			stm=getZeilenListe[ZL_STEUER_ARTIKEL];
    		}else 	if(sort_order.equals("sorte")) {
    			stm=getZeilenListe[ZL_SORTE];
    		}else 	if(sort_order.equals("steuerlager")) {
    			stm=getZeilenListe[ZL_STEUERLAGER];
    		}
    		stm.setInt(1,ii.getId());
    		stm.setInt(2,ii.getId());
    		final ResultSet rs = stm.executeQuery();
    		while (rs.next()) {
    			zl.add(new InventurZeilenItem(
    					rz,
    					rs.getInt("inventurzeile.id"),
    					rs.getInt("typ"),
    					rs.getInt("uebernommen"),
    					rs.getInt("inventur"),
    					rs.getInt("raum"),
    					rs.getString("r_bezeichnung"),
    					rs.getString("tanknummer"),
    					rs.getString("inventurzeile.bezeichnung"),
    					rs.getDouble("staerke"),
    					rs.getInt("extrakt"),
    					rs.getInt("dbkey"),
    					rs.getDouble("liter"),
    					rs.getDouble("liter20"),
    					rs.getDouble("tanktemperatur"),
    					rs.getDouble("la"),
    					rs.getDouble("brutto"),
    					rs.getDouble("tara"),
    					rs.getDouble("litergewicht"),
    					rs.getDouble("kg"),
    					rs.getDouble("tafel2"),
    					rs.getDouble("tafel3"),
    					db.getDateFromString(rs.getString("erstellt")),
    					rs.getString("user_1"),
    					rs.getInt("inventurzeile.lager"),
    					rs.getString("lager.name"),
    					rs.getString("steuer_artikel"),
    					rs.getInt("inventurzeile.sorte"),
    					rs.getString("sorten.bezeichnung"),
    					rs.getInt("inventurzeile.steuerlager"),
    					rs.getString("steuer_lager.bezeichnung")
    			));
    		}
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.getZeilenliste", e.getLocalizedMessage());
    	}
    	return zl;
    }

    public InventurZeilenliste getZeilenListe(InventurItem ii,String sort_order,String filter) {
    	final InventurZeilenliste zl = new InventurZeilenliste();
    	filter=filter.replaceAll("[ ]+",".*");
    	try {
    		PreparedStatement stm=null;
    		if(sort_order.equals("erstellt")) {
    			stm=getZeilenListeFilter[ZL_ERSTELLT];
    		} else 	if(sort_order.equals("raum")) {
    			stm=getZeilenListeFilter[ZL_RAUM];
    		}  else	if(sort_order.equals("tanknummer_num")) {
    			stm=getZeilenListeFilter[ZL_TANKNUMMER];
    		} else 	if(sort_order.equals("bezeichnung")) {
    			stm=getZeilenListeFilter[ZL_BEZEICHNUNG];
    		}else 	if(sort_order.equals("lager")) {
    			stm=getZeilenListeFilter[ZL_LAGER];
    		}else 	if(sort_order.equals("steuer_artikel")) {
    			stm=getZeilenListeFilter[ZL_STEUER_ARTIKEL];
    		}else 	if(sort_order.equals("sorte")) {
    			stm=getZeilenListeFilter[ZL_SORTE];
    		}else 	if(sort_order.equals("steuerlager")) {
    			stm=getZeilenListeFilter[ZL_STEUERLAGER];
    		}
    		stm.setInt(1,ii.getId());
    		stm.setInt(2,ii.getId());
    		stm.setString(3,filter);
    		final ResultSet rs = stm.executeQuery();
    		while (rs.next()) {
    			zl.add(new InventurZeilenItem(
    					rz,
    					rs.getInt("id"),
    					rs.getInt("typ"),
    					rs.getInt("uebernommen"),
    					rs.getInt("inventur"),
    					rs.getInt("raum"),
    					rs.getString("r_bezeichnung"),
    					rs.getString("tanknummer"),
    					rs.getString("inventurzeile.bezeichnung"),
    					rs.getDouble("staerke"),
    					rs.getInt("extrakt"),
    					rs.getInt("dbkey"),
    					rs.getDouble("liter"),
    					rs.getDouble("liter20"),
    					rs.getDouble("tanktemperatur"),
    					rs.getDouble("la"),
    					rs.getDouble("brutto"),
    					rs.getDouble("tara"),
    					rs.getDouble("litergewicht"),
    					rs.getDouble("kg"),
    					rs.getDouble("tafel2"),
    					rs.getDouble("tafel3"),
    					db.getDateFromString(rs.getString("erstellt")),
    					rs.getString("user_1"),
    					rs.getInt("inventurzeile.lager"),
    					rs.getString("lager.name"),
    					rs.getString("steuer_artikel"),
    					rs.getInt("inventurzeile.sorte"),
    					rs.getString("sorten.bezeichnung"),
    					rs.getInt("inventurzeile.steuerlager"),
    					rs.getString("steuer_lager.bezeichnung")
    			));
    		}
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.getZeilenlisteFilter", e.getLocalizedMessage());
    	}
    	return zl;
    }
    
    /**
     * inventur löschen
     * teil 1, die Raumliste
     */
    private boolean deleteInventurRaumliste(InventurItem ii) {
    	boolean ret=false;
    	try {
    		deleteInventur1.setInt(1,ii.getId());
    		deleteInventur1.executeUpdate();
    		ret = true;
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.deleteInventurRaumliste", e.getLocalizedMessage());
    		ret = false;
    	}
    	return ret;
    }

    /**
     * inventurzeilen löschen
     * Teil 2, inventurzeilen
     */
    private boolean deleteZeilen(InventurItem ii) {
    	boolean ret=false;
    	try {
    		deleteInventur2.setInt(1,ii.getId());
    		deleteInventur2.executeUpdate();
    		ret=true;
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.deleteZeilen", e.getLocalizedMessage());
    		ret = false;
    	}
    	return ret;
    }


    /**
     * inventur löschen
     * teil 3 die inventur selbst
     */
    private boolean deleteInventurHeader(InventurItem ii) {
    	boolean ret=false;
    	try {
    		deleteInventur3.setInt(1,ii.getId());
    		deleteInventur3.executeUpdate();
    		ret = true;
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.deleteInventurHeader", e.getLocalizedMessage());
    		ret = false;
    	}
    	return ret;
    }


    /**
     * prüfen, ob das Löschen einer Inventur auch Inventurzeilen betrifft
     * @return die Anzahl de
     */
    private int checkDelete(InventurItem ii) {
    	int ret = 1;
    	try {
    		checkDeleteInventur.setInt(1,ii.getId());
    		final ResultSet rs=checkDeleteInventur.executeQuery();
    		if(rs.next()) {
    			ret = rs.getInt("anzahl");
    		}
    	}catch (final Exception e) {
          rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.checkDelete", e.getLocalizedMessage());
          ret = 1;
    	}
    	return ret;
    }

    /**
     * Eine Inventur löschen
     * @return boolean, wenn gelöscht werden konnte
     */
    public boolean deleteInventur(InventurItem ii) {
    	boolean ret = false;
    	boolean do_it = false;
    	try {
    		final int anzahl = checkDelete(ii);
    		if (anzahl > 0) {
    			final DialogItem di = new DialogItem(
	                    DialogControl.FRAGE_DIALOG,
	                    "",0.0,
	                    rz.getLocale().getString("inventur.question_delete"),
	                    rz.getLocale().getString("inventur.question_delete"),
	                    rz.getLocale().getString("inventur.question_delete_message")
	                    	.replaceAll("%s",ii.getBezeichnung())
	                    	.replaceAll("%n",String.valueOf(anzahl)),
	                    "frage.png",
	                    rz.getLocale().getString("string_ja"),
	                    rz.getLocale().getString("string_nein"),
	                    null
	            );
	            rz.getDialogFactory().getDialog(di);
	            if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
	            	do_it = true;
	            }
    		} else {
    			do_it=true;
    		}
    		if(do_it) {
    			con.setAutoCommit(false);
    			if(this.deleteInventurRaumliste(ii)) {
	    			if(deleteZeilen(ii)) {
	    				if(deleteInventurHeader(ii)) {
	    					ret = true;
	    				} else  {
	    					con.rollback();
	    					ret = false;
	    				}
	    			}else {
    					con.rollback();
    					ret  = false;
    				}
    			} else {
    				con.rollback();
    				ret=false;
    			}
    			con.setAutoCommit(true);
    		}
    	} catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.deleteInventur", e.getLocalizedMessage());
            ret = false;
    	}
    	return ret;
    }
    /**
     * eine neue Inventur eintragen
     */
    public int saveInventur(InventurItem ii) {
    	int ret = 0;
    	try {
    		PreparedStatement stm;
    		if(ii.getId() == 0) {
    			stm = saveInventur;
    			stm.setString(1,ii.getBezeichnung());
    			stm.setString(2,ii.getBemerkungen());
    			stm.setString(3,db.dbGetDateFormatString(db.getServerTimestamp()));
    			stm.setString(4,db.dbGetDateFormatString(db.getServerTimestamp()));
    			stm.setString(5,db.dbGetUser());
    			stm.setString(6,db.dbGetUser());
        		stm.executeUpdate();
        		ret = db.dbGetLastInsertID("" + DBFactory.TABLE_INVENTUREN + "");
        		ii.setId(ret);
    		} else {
    			stm = updateInventur;
    			stm.setString(1,ii.getBezeichnung());
    			stm.setString(2,ii.getBemerkungen());
    			stm.setString(3,db.dbGetDateFormatString(db.getServerTimestamp()));
    			stm.setString(4,db.dbGetUser());
    			stm.setInt(5,ii.getId());
    			stm.executeUpdate();
    			ret=ii.getId();
    		}
    		saveRaumListe(ii.getId(),ii.getRaumliste());
    	}catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.saveInventur", e.getLocalizedMessage());
            ret = 0;
    	}
    	return ret;
    }

    /**
     * holt die Inventurliste
     * @return
     */
    public InventurListe getInventurliste() {
    	final InventurListe ret = new InventurListe();
    	try {
    		ResultSet rs;
    		rs = getInventurliste.executeQuery();
    		while (rs.next()) {
    			ret.addItem(new InventurItem(
    					rz,
    					rs.getInt("id"),
    					rs.getString("bezeichnung"),
    					rs.getString("bemerkungen"),
    					getRaumListe(rs.getInt("id")),
    					rs.getDate("erstellt"),
    					rs.getDate("geaendert"),
    					rs.getString("user_1"),
    					rs.getString("user_2")
    			));
    		}
    	} catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.getInventurListe", e.getLocalizedMessage());
    	}
    	return ret;
    }

    /**
     * holt eine einzelne Inventur
     * @return
     */
    public InventurItem getInventur(int key) {
    	InventurItem ret = null;
    	try {
    		ResultSet rs;
    		if(key == 0) {
    			ret = new InventurItem(
    					rz,
    					0,
    					rz.getLocale().getString("inventurfenster.neue_inventur"),
    					"",
    			    	new Raumliste(),
    					new Date(),
    					new Date(),
    					db.dbGetUser(),
    					db.dbGetUser()
    			);
    		} else {
	    		getInventur.setInt(1,key);
	    		rs = getInventur.executeQuery();
		    		if (rs.next()) {
		    			ret = new InventurItem(
		    					rz,
		    					rs.getInt("id"),
		    					rs.getString("bezeichnung"),
		    					rs.getString("bemerkungen"),
		    					getRaumListe(key),
		    					rs.getDate("erstellt"),
		    					rs.getDate("geaendert"),
		    					rs.getString("user_1"),
		    					rs.getString("user_2")
		    			);
		    		}
	    		}
    	} catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBInventur.getInventurListe", e.getLocalizedMessage());
    	}
    	return ret;
    }

}

