package de.lunqual.rzpro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.auftrag.TagesListe;
import de.lunqual.rzpro.items.kalender.TerminItem;
import de.lunqual.rzpro.items.kalender.TerminListe;
import de.lunqual.rzpro.log.LogFactory;

public class DBKalender {

	public static final int				KALENDER_MONAT=0;
	public static final int				KALENDER_WOCHE=1;
	public static final int				KALENDER_2WOCHEN=2;
	public static final int				KALENDER_ANZEIGE_TERMIN_DEFAULT=1;	

    RzPro           rz;
    Connection      con;
    DBFactory       db;

    
	char var20[]= {'0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f','p','h','k','x'};
	
    TagesListe		feiertage;
    boolean			saturday;
    Calendar		temp;
    TerminListe		terminliste;
    
    PreparedStatement		getDaten;
    PreparedStatement		setSaturday;
    PreparedStatement		setFeiertage;
    PreparedStatement		getTerminListeAuswahl;
    PreparedStatement		getTerminListeToday;
    PreparedStatement		saveTermin;
    PreparedStatement		updateTermin;
    PreparedStatement		getTermin;
    PreparedStatement		deleteTermin;
    PreparedStatement		terminErledigen;

    
    public DBKalender(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        temp=Calendar.getInstance();
        rz.roundDatum(temp);
        setStatements();
        init();
    }

    private void setStatements(){
        try{
            getDaten = con.prepareStatement("SELECT feiertage,saturday FROM " +DBFactory.TABLE_KALENDER + " WHERE id=1 ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            setSaturday = con.prepareStatement("UPDATE " +DBFactory.TABLE_KALENDER + " set saturday=? WHERE id=1 ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            setFeiertage = con.prepareStatement("UPDATE " +DBFactory.TABLE_KALENDER + " set feiertage=? WHERE id=1 ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getTerminListeAuswahl = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_TERMINE + " WHERE faellig >=? AND faellig <=? order by faellig ASC ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveTermin = con.prepareStatement("INSERT INTO " + DBFactory.TABLE_TERMINE + " (bezeichnung,comment,vg,hg,erstellt_datum,erstellt_user,geaendert_datum,geaendert_user,faellig,erledigt,erledigt_datum,erledigt_user) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateTermin = con.prepareStatement("UPDATE " + DBFactory.TABLE_TERMINE + " set bezeichnung=?,comment=?,vg=?,hg=?,erstellt_datum=?,erstellt_user=?,geaendert_datum=?,geaendert_user=?,faellig=?,erledigt=?,erledigt_datum=?,erledigt_user=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);            
            getTermin = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_TERMINE + " WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            deleteTermin = con.prepareStatement("DELETE FROM " + DBFactory.TABLE_TERMINE + " WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);   
            getTerminListeToday = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_TERMINE + " WHERE faellig = ? AND erledigt = 0 order by faellig ASC ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            terminErledigen = con.prepareStatement("UPDATE " + DBFactory.TABLE_TERMINE + " set erledigt=?,erledigt_datum=?,erledigt_user=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);            
        
        }catch (final Exception e){
               rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKalender.setStatements", e.getLocalizedMessage());
        }
    }
    
    
    
    public void terminErledigen(int id,boolean erledigt) {
    	if(id != 0) {
    		try {
    			terminErledigen.setInt(1,erledigt?1:0);
				terminErledigen.setString(2, db.dbGetDateFormatString(db.getServerTimestamp()));
				terminErledigen.setString(3, db.dbGetUser());
				terminErledigen.setInt(4, id);
				terminErledigen.executeUpdate();
    		}catch (final Exception e){
        		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKalender.terminErledigen", e.getLocalizedMessage());
        	}
    	}
    }
    
    public void deleteTermin(int id) {
    	if(id != 0) {
    		try {
    			deleteTermin.setInt(1,id);
    			deleteTermin.executeUpdate();
    		}catch (final Exception e){
        		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKalender.deleteTermin", e.getLocalizedMessage());
        	}
    	}
    }
    
    
    public int saveTermin(TerminItem ti) {
    	int ret=0;
    	if(ti != null) {
    		try {
    			PreparedStatement stmt=null;
    			if(ti.getId()==0) {
    				stmt = saveTermin;
    			}else {
    				stmt = updateTermin;
    				stmt.setInt(13, ti.getId());
    			}
    			if(stmt != null) {
    				stmt.setString(1, ti.getBezeichnung());
    				stmt.setString(2, ti.getComment());
    				stmt.setString(3, ti.getVg());
    				stmt.setString(4, ti.getHg());
    				stmt.setString(5, db.dbGetDateFormatString(ti.getErstellt()));
    				stmt.setString(6, ti.getErstellt_user());
    				stmt.setString(7, db.dbGetDateFormatString(ti.getGeaendert()));
    				stmt.setString(8, ti.getGeaendert_user());
    				stmt.setLong(9, ti.getFaellig().getTimeInMillis());
    				stmt.setInt(10,ti.isErledigt()?1:0);
    				stmt.setString(11, db.dbGetDateFormatString(ti.getErledigt_datum()));
    				stmt.setString(12, ti.getErledigt_user());
    				stmt.executeUpdate();
    	    		if(ti.getId()==0) {
    	    			ret=db.dbGetLastInsertID(DBFactory.TABLE_TERMINE);
    	    			ti.setId(ret);
    	    		}else {
    	    			ret=ti.getId();
    	    		}
    			}
    		}catch (final Exception e){
        		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKalender.saveTermin", e.getLocalizedMessage());
        	}
    	}
    	return ret;
    }
    
    public TerminItem getTermin(int id) {
    	TerminItem ti=null;
    	try {
    		if(id != 0) {
    		getTermin.setInt(1,id);
    		final ResultSet rs = getTermin.executeQuery();
    		if(rs.next()) {
    			ti = new TerminItem(
    					rz,
    					rs.getInt("id"),
    			 		rs.getString("bezeichnung"),
    					rs.getString("comment"),
    					rs.getString("vg"),
    					rs.getString("hg"),
     	                db.getDateFromString(rs.getString("erstellt_datum")),
    					rs.getString("erstellt_user"),
     	                db.getDateFromString(rs.getString("geaendert_datum")),
    					rs.getString("geaendert_user"),
    					rs.getLong("faellig"),
    					rs.getInt("erledigt")==0?false:true,
    		 	        db.getDateFromString(rs.getString("erledigt_datum")),
    					rs.getString("erledigt_user")
    			);
    			
    		}
    	}
		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKalender.getTerminListe", e.getLocalizedMessage());
		}
    	
    	return ti;
    }
    
    public TerminListe getTerminListe() {
    	Calendar today = Calendar.getInstance();
    	rz.roundDatum(today);
    	TerminListe tl = new TerminListe(rz,today.getTimeInMillis());
    	try {
    		getTerminListeToday.setLong(1,today.getTimeInMillis());
    		final ResultSet rs=getTerminListeToday.executeQuery();
    		while(rs.next()) {
    			tl.addItem(new TerminItem(
    					rz,
    					rs.getInt("id"),
    			 		rs.getString("bezeichnung"),
    					rs.getString("comment"),
    					rs.getString("vg"),
    					rs.getString("hg"),
    					rs.getDate("erstellt_datum"),
    					rs.getString("erstellt_user"),
    					rs.getDate("geaendert_datum"),
    					rs.getString("geaendert_user"),
    					rs.getLong("faellig"),
    					rs.getInt("erledigt")==0?false:true,
    					rs.getDate("erledigt_datum"),
    					rs.getString("erledigt_user")
    			));
    		}
    		
      	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKalender.getTerminListeToday", e.getLocalizedMessage());
    	}
    	return tl;
    }

    public TerminListe getTermine() {
    	return terminliste;
    }
    
    public void refreshTerminListe(long start,long end,long today) {
    	terminliste = new TerminListe(rz,today);
    	try {
    		if(start != 0 && end != 0) {
        		getTerminListeAuswahl.setLong(1, start);
        		getTerminListeAuswahl.setLong(2,end);
	    		final ResultSet rs = getTerminListeAuswahl.executeQuery();
	    		while(rs.next()) {
	    			terminliste.addItem(new TerminItem(
	    					rz,
	    					rs.getInt("id"),
	    			 		rs.getString("bezeichnung"),
	    					rs.getString("comment"),
	    					rs.getString("vg"),
	    					rs.getString("hg"),
	    					rs.getDate("erstellt_datum"),
	    					rs.getString("erstellt_user"),
	    					rs.getDate("geaendert_datum"),
	    					rs.getString("geaendert_user"),
	    					rs.getLong("faellig"),
	    					rs.getInt("erledigt")==0?false:true,
	    	    			rs.getDate("erledigt_datum"),
	    	    			rs.getString("erledigt_user")
	    			));
	    			
	    		}
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKalender.getTerminListe", e.getLocalizedMessage());
    	}
    }
    
    
    public void init() {
    	try {
    		final ResultSet rs=getDaten.executeQuery();
    		if(rs.next()) {
    			saturday=rs.getInt("saturday")==0?false:true;
    			feiertage=new TagesListe(rz,saturday);
    			feiertage.setFeiertagsListe(rs.getString("feiertage"));
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKalender.init", e.getLocalizedMessage());
    	}
    }

    
    
    public void setSaturday(boolean saturday) {
    	try {
    		setSaturday.setInt(1, saturday==true?1:0);
    		setSaturday.executeUpdate();
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKalender.setSaturday", e.getLocalizedMessage());
    	}
    	init();
    }
    
    public void setFeiertage(TagesListe tage) {
    	try {
    		setFeiertage.setString(1,tage.getDatabaseString());
    		setFeiertage.executeUpdate();
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKalender.setFeiertage", e.getLocalizedMessage());
    	}
    	
    	init();
    }
    
	public boolean isFeiertag(Calendar c) {
		boolean ret=false;
		if(feiertage.isInList(c.getTimeInMillis())) {
			ret=true;
		} else if(c.get(Calendar.DAY_OF_WEEK)==Calendar.SUNDAY) {
			ret=true;
		} else if(c.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY) {
			if(saturday==false) {
				ret = true;
			}else {
				ret = false;
			}
		}
		return ret;
	}
    
	public TagesListe getFeiertage() {
		return feiertage;
	}

	public boolean isSaturday() {
		return saturday;
	}
    
    
	
	//20er Kalender
    
    public String getDatum20Now() {
    	Calendar c=Calendar.getInstance();
    	return rz.getLocale().getString("datum20now")
    			.replaceAll("%y",getYear20(c))
				.replaceAll("%d",getDate20(c))
				.replaceAll("%l",String.valueOf(c.get(Calendar.DAY_OF_YEAR)));
    }	
    
    public String getDate20(Calendar c) {
    	int i=c.get(Calendar.DAY_OF_YEAR);
    	String ret = getDate201(i);
    	return (ret.length()==1)?"0"+ret:ret;    	
    }
    
    public String getDate20(int n) {
    	String ret = getDate201(n);
    	return (ret.length()==1)?"0"+ret:ret;    	
    }
    

    public String getYear20(int jahr) {
    	String ret=getDate201(jahr);
    	return ret.substring(ret.length()-1);
    }
    
    public String getYear20(Calendar c) {
    	String ret=getDate201(c.get(Calendar.YEAR));
    	return ret.substring(ret.length()-1);
    }
    
    private String getDate201(int n) {
    	final int factor=20;
    	String ret ="";
    	while(n !=0) {
    		ret += var20[n % factor];
    		n /= factor;
    	}
    	return new StringBuffer(ret).reverse().toString();
    }
    
    
    
    public int getDay20(String value) {
    	int i,ret=-1;
    	char d1=value.charAt(0);
    	char d2=value.charAt(1);
    	for(i=0;i<var20.length;i++) {
    		if(var20[i]==d1) {
    			ret=i*20;
    			break;
    		}
    	}
    	for(i=0;i<var20.length;i++) {
    		if(var20[i] == d2) {
    			ret +=i;;
    			break;
    		}
    	}
    	
    	return ret;
    }
    
   
    public long getMillisecondsFromString(int jahr,String datum20) {
    	Calendar c=Calendar.getInstance();
    	rz.roundDatum(c);
    	c.set(Calendar.YEAR,jahr);
    	c.set(Calendar.DAY_OF_YEAR,getDay20(datum20));
    	return c.getTimeInMillis();
    }
    
    private boolean isValidDate20Char(char c) {
    	boolean ret=false;
    	for(int i=0;i<var20.length;i++) {
    		if(c == var20[i]) {
    			ret=true;
    			break;
    		}
    	}
    	return ret;
    }
    
    private boolean isValidDate20(String datum20) {
    	boolean ret=true;
    	if(datum20.length()==2) {
    		for(int i=0;i<datum20.length();i++) {
    			if(!isValidDate20Char(datum20.charAt(i))) {
    				ret=false;
    				break;
    			}
    		}
    	}else {
    		ret=false;
    	}
    	return ret;
    }
    
    public int getValidDate(String day20,int year,int alt) {
    	int ret=alt;
    	if(isValidDate20(day20)) {
    		ret=getDay20(day20);
    	}
    	return ret;
    }

}
