/*
 *  Copyright (C) database.stichwort_loeschen4 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.JComboBox;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.lager.LagerBestandsItem;
import de.lunqual.rzpro.items.lager.LagerBestandsListe;
import de.lunqual.rzpro.items.lager.LagerDruckListe;
import de.lunqual.rzpro.items.lager.LagerItem;
import de.lunqual.rzpro.items.lager.LagerListe;
import de.lunqual.rzpro.items.lager.LagerListenItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class DBLager{

    RzPro           rz;
    Connection      con;
    DBFactory       db;
    DialogItem		dlgItem;

    PreparedStatement   getLagerListe;
    PreparedStatement   getLager;
    PreparedStatement   saveLager;
    PreparedStatement   updateLager;
    PreparedStatement   deleteLager;
    PreparedStatement   checkLagerUsed;
    PreparedStatement   getLagerBestandsListeAlle;
    PreparedStatement   getLagerBestandsListeBestand;
    PreparedStatement   getLagerBestandsListeBestellliste;
    PreparedStatement		getTanklisteFuellung;

    CurrencyItem 	euro;
    /** Creates a new instance of DBLager */
    public DBLager(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
	    euro = rz.getDatabase().getCurrency().dbGetCurrency(1,true);//Euro !
    }

    private void setStatements(){
        try{
            getLagerListe       = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_LAGER + " ORDER BY name",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getLager            = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_LAGER + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            updateLager         = con.prepareStatement("UPDATE " +DBFactory.TABLE_LAGER + " SET name=?,ersatztext=?,comment=?,liste=?,hg=?,vg=?,erstellt=?,geaendert=?,user_1=?,user_2=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            saveLager           = con.prepareStatement("INSERT INTO " +DBFactory.TABLE_LAGER + " (name,ersatztext,comment,liste,hg,vg,erstellt,geaendert,user_1,user_2) VALUES(?,?,?,?,?,?,?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteLager         = con.prepareStatement("DELETE FROM " +DBFactory.TABLE_LAGER + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            checkLagerUsed      = con.prepareStatement("SELECT " +DBFactory.TABLE_LAGER + " FROM rezeptliste where lager=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getLagerBestandsListeAlle     = con.prepareStatement("SELECT id,name,artikelnummer,typ,staerke,litergewicht,extraktfrei,bestand,meldebestand,bestandseinheit,preis,preismenge,preiseinheit,waehrung from " +DBFactory.TABLE_REZEPTLISTE + " where typ=1 AND lager=? order by name",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getLagerBestandsListeBestand    = con.prepareStatement("SELECT id,name,artikelnummer,typ,staerke,litergewicht,extraktfrei,bestand,meldebestand,bestandseinheit,preis,preismenge,preiseinheit,waehrung from " +DBFactory.TABLE_REZEPTLISTE + " where typ=1 AND lager=? AND bestand <> 0 order by name",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getLagerBestandsListeBestellliste     = con.prepareStatement("SELECT id,name,artikelnummer,typ,staerke,litergewicht,extraktfrei,bestand,meldebestand,bestandseinheit,preis,preismenge,preiseinheit,waehrung from " +DBFactory.TABLE_REZEPTLISTE + " where typ=1 AND lager=?  AND meldebestand <> 0 AND bestand <= meldebestand order by name",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

//            getTanklisteFuellung   = con.prepareStatement("SELECT lager.name,lager.hg,lager.vg,buchungen.comment,buchungen.losnummer,buchungen.datum,bestand,meldebestand, buchungen.bezeichnung,rezeptur_id, rest_liter as restliter,rest_kg FROM buchungen left join rezeptliste on buchungen.rezeptur_id=rezeptliste.id left join lager on buchungen.lager=lager.id where rest <> 0 AND buchungen.comment regexp '[[.left-square-bracket.]]Tank.*[[:<:]].*[[:>:]].*[[.right-square-bracket.]]' order by buchungen.id asc",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getTanklisteFuellung   = con.prepareStatement("SELECT lager.name,lager.hg,lager.vg,buchungen.comment,buchungen.losnummer,buchungen.datum,bestand,meldebestand, buchungen.bezeichnung,rezeptur_id, rest_liter as restliter,rest_kg FROM buchungen left join rezeptliste on buchungen.rezeptur_id=rezeptliste.id left join lager on buchungen.lager=lager.id where rest <> 0 AND buchungen.comment regexp '\\[Tank[^[]]*[[:<:]].*[[:>:]].*\\]' order by buchungen.id asc",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLager.setStatements", e.getLocalizedMessage());
        }
    }

    /** boolean dbCheckLagerUsed(int) prüft ob ein " +DbControl.TABLE_LAGER + " in der
     * Rezeptliste verwendet wird
     * @@return false wenn nicht verwendet, true wenn verwendet
     */
    public boolean dbCheckLagerUsed(int aID){
        boolean ret = false;
        try{
            checkLagerUsed.setInt(1, aID);
            checkLagerUsed.executeQuery();
            final ResultSet rs = checkLagerUsed.getResultSet();
            if(rs.next()){
                ret = true;
            }
            if(rs != null) {
				rs.close();
			}
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLager.dbCheckLagerUsed:", e.getLocalizedMessage());
            ret = true;
        }
        return ret;
    }

    /** void dbDeleteLager(int) löscht ein " +DbControl.TABLE_LAGER + " wenn diese nicht
     * verwendet wird...
     */

    public void dbDeleteLager(int aID){
        try{
            if (aID != 1){ // Default darf nicht gel�scht werden !!!
                if (!dbCheckLagerUsed(aID)){ // wenn nicht in der Rezeptliste verwendet
                    deleteLager.setInt(1, aID);
                    if(deleteLager.executeUpdate() == 0){
                        dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                        dlgItem.setCaption(rz.getLocale().getString("lager.key_not_found"));
                        dlgItem.setTitel(rz.getLocale().getString("lager.key_not_found"));
                        dlgItem.setMessage(rz.getLocale().getString("lager.fehler_not_found"));
                        dlgItem.setIcon("warnung.png");
                        dlgItem.setOk(rz.getLocale().getString("string_ok"));
                        rz.getDialogFactory().getDialog(dlgItem);
                    }
                }
            }
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLager.dbDeleteLager:", e.getLocalizedMessage());
        }
    }

    /**
     * dbSaveLager(LagerItem) speichert eine neues " +DbControl.TABLE_LAGER + " oder
     * �ndert ein " +DbControl.TABLE_LAGER + " in der Datenbank ab
     */
    public int dbSaveLager(LagerItem li){
        int ret = 0;
        PreparedStatement stm;
        try {
            if (li.getID() == 0){
                stm = saveLager;
                stm.setString(7, db.dbGetDateFormatString(db.getServerTimestamp()));//erstellungsdatum
            }
            else
            {
                stm = updateLager;
                stm.setInt(11,li.getID());
                stm.setString(7, db.dbGetDateFormatString(li.getErstellt()));//erstellungsdatum
            	if(!db.idExists(DBFactory.TABLE_LAGER,li.getID(),true)){
            		stm=saveLager;
            		li.setID(0);
            	}
            }
            stm.setString(1,  li.getName());
            stm.setString(2, li.getErsatztext());
            stm.setString(3, li.getComment());
            stm.setInt(4, li.getListe());
            stm.setString(5,li.getHg());
            stm.setString(6, li.getVg());
            // erstellungsdatum wird oben gesetzt
            stm.setString(8, db.dbGetDateFormatString(db.getServerTimestamp()));//�nderungsdatum
            stm.setString(9, li.getUser1());
            stm.setString(10, li.getUser2());
            stm.executeUpdate();
            if (li.getID() == 0){
                    ret = db.dbGetLastInsertID("lager");
            } else {
				ret = li.getID();
			}
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLager.dbSaveLager:", e.getLocalizedMessage());
            ret = 0;
        }
        return ret;
    }

    public String getLagerListenText(int liste) {
        String ret = "";
        final LagerListe ll = dbGetLagerListe();
        for(int i = 0; i < ll.size();i++) {
            if(ll.getItem(i).getListe() == liste) {
                ret += ll.getItem(i).getName() + " ";
            }
        }
        return ret;
    }

    public LagerDruckListe getLagerListenNummern() {
       final LagerDruckListe ld = new LagerDruckListe();
       final LagerListe ll = dbGetLagerListe();
       for(int i = 0; i < ll.size();i++) {
           if(!ld.hasListe(ll.getItem(i).getListe())) {
               ld.addItem(new LagerListenItem(ll.getItem(i)));
           }
       }
       return ld;
    }
    /** LagerListe dbGetLagerListe() gibt die Liste aller Lager
     * zur�ck,
     */
    public LagerListe dbGetLagerListe(){
        final LagerListe ll = new LagerListe(rz);
        ResultSet rs;
        try {
            getLagerListe.executeQuery();
            rs = getLagerListe.getResultSet();
            while (rs.next()){
                ll.addItem(new LagerItem(
                    rs.getInt("id"),
                    rs.getString("name"),
                    rs.getString("ersatztext"),
                    rs.getString("comment"),
                    rs.getInt("liste"),
                    rs.getString("hg"),
                    rs.getString("vg"),
                    false,
                    db.getDateFromString(rs.getString("erstellt")),
                    db.getDateFromString(rs.getString("geaendert")),
                    rs.getString("user_1"),
                    rs.getString("user_2")));
            }
            if(rs != null) {
				rs.close();
			}
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLager.dbGetLagerListe:", e.getLocalizedMessage());
        }
        return ll;
    }
    /**
     * LagerItem dbGetLager(int aKey) gibt ein LagerItem zur�ck
     */

    public LagerItem dbGetLager(int aKey,boolean quiet){
        LagerItem li = null;
        ResultSet rs;
        try {
            if (aKey == 0) {
                li = new LagerItem();
                li.setUser1(rz.getDatabase().dbGetUser());
                li.setUser2(li.getUser1());
            } else {
            	if(db.idExists(DBFactory.TABLE_LAGER,aKey,quiet)) {
		            getLager.setInt(1, aKey);
		            getLager.executeQuery();
		            rs = getLager.getResultSet();
		            if (rs.next()){
		                li = new LagerItem(
		                    rs.getInt("id"),
		                    rs.getString("name"),
		                    rs.getString("ersatztext"),
		                    rs.getString("comment"),
		                    rs.getInt("liste"),
		                    rs.getString("hg"),
		                    rs.getString("vg"),
		                    false,
		                    db.getDateFromString(rs.getString("erstellt")),
		                    db.getDateFromString(rs.getString("geaendert")),
		                    rs.getString("user_1"),
		                    rs.getString("user_2"));
		            }
		            if(rs != null) {
						rs.close();
					}
            	}
            }
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLager.dbGetLager:", e.getLocalizedMessage());
        }
        return li;
    }

    public void setLagerCmb(JComboBox cmb,int value){
        cmb.removeAllItems();
        final LagerListe ll = dbGetLagerListe();
        for(int i = 0 ; i < ll.size();i++){
            cmb.addItem(ll.getItem(i));
        }
        setLagerIndex(cmb,value);
    }
    
    public void setLagerIndex(JComboBox cmb,int value) {
    	 for(int i = 0 ;i < cmb.getModel().getSize();i++){
             if(((LagerItem)cmb.getModel().getElementAt(i)).getID() == value){
                 cmb.setSelectedIndex(i);
                 break;
             }
         }
    }
    

    public LagerBestandsListe getBestandsListe(int lager,int auswahl) {
        final LagerBestandsListe lb = new LagerBestandsListe(db.getLager().dbGetLager(lager, true).getName());
        HashMap<Integer,ArrayList<String>> map = new HashMap<Integer,ArrayList<String>>();
        ResultSet rs;
        int bestandseinheit;
        String name;
        String artikelnummer;
        double liter,kg,la,staerke,litergewicht;
        double bestand;
        boolean extraktfrei;
        boolean meldebestand;
        String grundpreis;
        BigDecimal preis;
        String SPreis="";
        BigDecimal value;
        CurrencyItem c1;
        CurrencyItem c2;
        try {
            PreparedStatement getListe;
            switch(auswahl) {
            case 0: getListe = this.getLagerBestandsListeAlle; break;
            case 1: getListe = this.getLagerBestandsListeBestand; break;
            case 2: getListe = this.getLagerBestandsListeBestellliste; break;
            default :   getListe = this.getLagerBestandsListeAlle; break;
            }
            getListe.setInt(1,lager);
            rs = getListe.executeQuery();
        	c2 = db.getCurrency().dbGetCurrency( rz.getOptionFactory().getOption("kalkulation.currency",1),true);
            while (rs.next()){
            	name = rs.getString("name");
            	bestand = rs.getDouble("bestand");
            	artikelnummer=rs.getString("artikelnummer");
            	if((rs.getDouble("meldebestand") != 0) && ( bestand <= rs.getDouble("meldebestand"))) {
            	    meldebestand = true;
            	} else {
            	    meldebestand=false;
            	}
            	bestandseinheit = rs.getInt("bestandseinheit");
            	extraktfrei = rs.getBoolean("extraktfrei");
            	staerke=rs.getDouble("staerke");
            	preis = rs.getBigDecimal("preis");
            	c1=db.getCurrency().dbGetCurrency(rs.getInt("waehrung"), true);
            	grundpreis = rz.getLocale().formatNumber(rs.getDouble("preismenge"),OptionFactory.NF_NORMAL) + " " +
           	        db.getEinheiten().getGrundeinheit(rs.getInt("preiseinheit")).getName() + "=" +
           	    	rz.getLocale().formatNumber(preis,OptionFactory.NF_NORMAL) + " " +c1.getShortName();
            	if(extraktfrei) {
            		litergewicht = rz.getTafelFactory().Litergewicht(staerke);
            	} else {
            		litergewicht = rs.getDouble("litergewicht");
            	}
            	value=new BigDecimal(0.0);
        		liter = db.getEinheiten().convert(bestand,staerke,litergewicht,db.getEinheiten().getGrundeinheit(bestandseinheit),db.getEinheiten().getLiterItem());
        		kg = db.getEinheiten().convert(bestand,staerke,litergewicht,db.getEinheiten().getGrundeinheit(bestandseinheit),db.getEinheiten().getKgItem());
        		la = db.getEinheiten().convert(bestand,staerke,litergewicht,db.getEinheiten().getGrundeinheit(bestandseinheit),db.getEinheiten().getLaItem());

//            	Kalkulation
            	// Grundpreis darstellen
            	double pMenge;
            	double pFaktor;
            	double betrag;


            	switch(rs.getInt("preiseinheit")) {
            		case RzPro.EINHEIT_KG:
            		    pMenge = kg;
            		    break;
            		case RzPro.EINHEIT_LITER:
            		    pMenge = liter;
            		break;
            		case RzPro.EINHEIT_LA:
            		    pMenge = la;
            		    break;
            		default: pMenge=0;
            	}
            	if((pMenge != 0) && (rs.getDouble("preismenge") != 0)) {
            	    pFaktor = pMenge / rs.getDouble("preismenge");
            	} else {
            	    pFaktor=0;
            	}
            	betrag = Double.parseDouble(preis.toString()) * pFaktor;
            	value = new BigDecimal(betrag);
            	value=db.getCurrency().convert(value, c1, c2).setScale(RzPro.CURRENCY_DEFAULT_SCALE,java.math.BigDecimal.ROUND_HALF_UP);
            	SPreis = value.toString() + " " + c2.getShortName();
        		lb.addItem(new LagerBestandsItem(rs.getInt("id"),name,artikelnummer,liter,kg,la,meldebestand,grundpreis,SPreis));
        		lb.addLiter(liter);
        		lb.addKg(kg);
        		lb.addLa(la);
        		lb.addPreis(value);
            }
            if(rs != null) {
				rs.close();
			}
            rs = getTanklisteFuellung.executeQuery();
            while(rs.next()) {
            	ArrayList<String> tanks= extractTank(rs.getString("buchungen.comment"));
            	int id = rs.getInt("rezeptur_id");
            	if(map.containsKey(id)) {
            		ArrayList<String> t = map.get(id);
            		for(String item:t) {
            			if(!listContainsItem(tanks,item)) {
            				tanks.add(item);
            			}
            		}
            		map.put(id, tanks);
            	} else {
            		map.put(id, tanks);
            	}
            }
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLager.dbGetLagerBestandsListe:", e.getLocalizedMessage());
        }
        for(int i=0;i<lb.size();i++ ) {
        	LagerBestandsItem lbi = lb.getItem(i);
	       	if(lbi!=null) {
	    	ArrayList<String> tankliste = map.get(lbi.getRezeptur_id());
	       		if(tankliste != null) {
	        		String tanks = "";
	        		for(String tank:tankliste) {
	        			tanks += tank + " ";
	        		}
	        		lbi.setOrt(tanks);
	       		}
        	}
        }
        return lb;
    }
  
    private boolean listContainsItem(ArrayList<String> liste,String value) {
    	for(String item:liste) {
    		if(item.equals(value)) {
    			return true;
    		}
    	}
    	return false;
    }
    
    
    public ArrayList<String> extractTank(String in) {
    	String ret = "";
    	ArrayList<String>liste = new ArrayList<String>();
    	String tank_anfang_token=rz.getOptionFactory().getOption("dbbuchung.tank_sb");
        String tank_ende_token=rz.getOptionFactory().getOption("dbbuchung.tank_se");
        int ta = in.indexOf(tank_anfang_token);
    	if(ta != -1) {
    		String t1 = in.substring(ta);
        	int te = t1.indexOf(tank_ende_token);
        	if(te != -1) {
        		ret = in.substring(ta+tank_anfang_token.length(),ta+te);
        	}
    	}
    	if(!ret.trim().equals("")) {
    		try {
    			in = in.replaceAll("\\" + tank_anfang_token+".*"+ret + "\\"+tank_ende_token, "");
    		}catch(Exception e) {}
    	}
    	String[] tanks = ret.split("\\s|,|;|:|-");
    	for(int i =0;i < tanks.length;i++) {
    		liste.add(tanks[i]);
    	}
    	return liste;
    }
    
    
}
