/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.losnummerVorlage.LosnummerHistoryListe;
import de.lunqual.rzpro.items.losnummerVorlage.LosnummerListeItem;
import de.lunqual.rzpro.items.losnummerVorlage.LosnummerVorlageItem;
import de.lunqual.rzpro.items.losnummerVorlage.LosnummerVorlageListe;
import de.lunqual.rzpro.log.LogFactory;

/**
 *
 * @author  lunqual
 */
public class DBLosnummerVorlage{

    RzPro           		rz;
    Connection      	con;
    DBFactory       	db;
    
    public static final int DEFAULT_HISTORY = 10;
    public static final int MAX_HISTORY = 25;
    
    PreparedStatement   getListe;
    PreparedStatement	saveVorlage;
    PreparedStatement	updateVorlage;
    PreparedStatement	deleteVorlage;
    PreparedStatement   pushVorlage;
    PreparedStatement	getLosnummern;
    PreparedStatement	checkLosnummerHistory;
    PreparedStatement	deleteLosnummer;
    
    public DBLosnummerVorlage(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }

    private void setStatements(){
        try{
            getListe    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_LOSNUMMER_VORLAGE+ " ORDER BY bezeichnung",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            updateVorlage = con.prepareStatement("UPDATE " +DBFactory.TABLE_LOSNUMMER_VORLAGE + " set bezeichnung=?,value=?,erstellt=?, user=? where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveVorlage = con.prepareStatement("INSERT INTO " +DBFactory.TABLE_LOSNUMMER_VORLAGE + " (bezeichnung,value,erstellt,user)VALUES(?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            deleteVorlage = con.prepareStatement("DELETE FROM " +DBFactory.TABLE_LOSNUMMER_VORLAGE + " where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            pushVorlage = con.prepareStatement("INSERT INTO  " +DBFactory.TABLE_LOSNUMMER_LISTE + " (value,vorlage,datum,user) VALUES (?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getLosnummern    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_LOSNUMMER_LISTE+  " WHERE vorlage=? and datum <=? " + " ORDER BY id DESC LIMIT ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            checkLosnummerHistory    = con.prepareStatement("SELECT id FROM " +DBFactory.TABLE_LOSNUMMER_LISTE+  " WHERE vorlage=? LIMIT 1",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            deleteLosnummer = con.prepareStatement("DELETE FROM  " +DBFactory.TABLE_LOSNUMMER_LISTE + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLosnummerVorlage.setStatements", e.getLocalizedMessage());
        }
    }

    public void deleteLosnummer(int id) {
    	try {
    		deleteLosnummer.setInt(1, id);
    		deleteLosnummer.executeUpdate();
    	} catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLosnummerVorlage.deleteLosnummer", e.getLocalizedMessage());
        }
    }
    
    public boolean checkLosnummerHistory(LosnummerVorlageItem li) {
    	boolean ret = false;
    	try {
    		checkLosnummerHistory.setInt(1, li.getId());
    		final ResultSet rs = checkLosnummerHistory.executeQuery();
    		if (rs.next()) {
    			ret =true;
    		}
    		
    	} catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLosnummerVorlage.checkLosnummerHistory", e.getLocalizedMessage());
        }
    	return ret;
    }
    
    public LosnummerHistoryListe getLosnummerHistory(LosnummerVorlageItem li,Calendar c,int max) {
    	LosnummerHistoryListe ret = new LosnummerHistoryListe();
    	try {
    		SimpleDateFormat df = new SimpleDateFormat("YYYY-MM-dd 23:59:59");
    		getLosnummern.setInt(1, li.getId());
    		getLosnummern.setString(2,df.format(c.getTimeInMillis()));
    		getLosnummern.setInt(3, max);
    		final ResultSet rs = getLosnummern.executeQuery();
    		while (rs.next()) {
    			ret.add(new LosnummerListeItem(
    					rs.getInt("id"),
    					rs.getString("value"),
                        db.getDateFromString(rs.getString("datum")),
    					rs.getString("user")
    					));
    		}
    		
    	} catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLosnummerVorlage.getLosnummerHistory", e.getLocalizedMessage());
        }
    	return ret;
    }
    
    
    public int pushVorlage(LosnummerVorlageItem li,String value) {
    	int ret = 0;
    	try {
    		if(li != null && !value.trim().equals("")) {
    			pushVorlage.setString(1, value);
    			pushVorlage.setInt(2, li.getId());
    			pushVorlage.setString(3, db.dbGetDateFormatString(db.getServerTimestamp()));
    			pushVorlage.setString(4, db.dbGetUser());
    			pushVorlage.executeUpdate();
    			ret = db.dbGetLastInsertID(DBFactory.TABLE_LOSNUMMER_LISTE);
    		}
    	}  catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLosnummerVorlage.pushVorlage", e.getLocalizedMessage());
        }
    	
    	return ret;
    }
    /**
     * Die Liste der Losnummern aus der DAtenbank holen
     */
    public LosnummerVorlageListe	getListe() {
    	LosnummerVorlageListe l = new LosnummerVorlageListe();
        try{
        	final ResultSet rs = getListe.executeQuery();
        	while(rs.next()) {
        		l.addItem(new LosnummerVorlageItem(
        			rs.getInt("id"),
        			rs.getString("bezeichnung"),
        			rs.getString("value"),
                    db.getDateFromString(rs.getString("erstellt")),
                    rs.getString("user")
        		));
        	}
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLosnummerVorlage.getListe", e.getLocalizedMessage());
        }
    	return l;
    }
    
    public void	delete(int id) {
        try{
        	if(id >0) {
        		deleteVorlage.setInt(1,id);
        		deleteVorlage.executeUpdate();
        	}
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLosnummerVorlage.delete", e.getLocalizedMessage());
        }
    }

    public int	update(LosnummerVorlageItem lv) {
    	int id=-1;
    	PreparedStatement stm;
    	if(lv.getValue().trim().equals("")) {
    		//value ist leer, wir löschen den Eintrag !!!
    		delete(lv.getId());
    	} else {
	        try{
	        	if(lv.getId()==0) {
	        		stm=saveVorlage;
	        	}else
	        	{
	        		stm=updateVorlage;
	        		stm.setInt(5,lv.getId());
	        	}
	        	stm.setString(1,lv.getBezeichnung());
	        	stm.setString(2,lv.getValue());
	            stm.setString(3, db.dbGetDateFormatString(lv.getErstellt()));
	            stm.setString(4,db.dbGetUser());
	            stm.executeUpdate();
	        	id = db.dbGetLastInsertID(DBFactory.TABLE_LOSNUMMER_VORLAGE);
	        }
	        catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLosnummerVorlage.update", e.getLocalizedMessage());
	        }
    	}
        return id;
    }
    
}
