/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.textmessage.TextmessageItem;
import de.lunqual.rzpro.log.LogFactory;


/**
 *
 * @author  lunqual
 */
public class DBMessages{

    RzPro           		rz;
    Connection      	con;
    DBFactory       	db;

    PreparedStatement   getMessage;
    PreparedStatement   updateMessage;
    PreparedStatement   saveMessage;
    PreparedStatement   getCommentID;

    public static final int TEXTMESSAGE_TYP_NONE=0;
    public static final int TEXTMESSAGE_TYP_ZUTATENVERZEICHNIS =1;


    /** Creates a new instance of DBLager */
    public DBMessages(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }

    private void setStatements(){
        try{
            getMessage    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_MESSAGES + " WHERE typ=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            updateMessage		= con.prepareStatement("UPDATE " +DBFactory.TABLE_MESSAGES + " SET typ=?,message=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            saveMessage		= con.prepareStatement("INSERT INTO " +DBFactory.TABLE_MESSAGES + " ( typ,message) VALUES(?,?) ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getCommentID    = con.prepareStatement("SELECT id FROM " +DBFactory.TABLE_MESSAGES + " WHERE typ=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMessages.setStatements", e.getLocalizedMessage());
        }
    }

    /**
     * Die Liste der Säuren aus der DAtenbank holen
     */
    public TextmessageItem	getMessage(int typ) {
    	TextmessageItem ti = null;

        try{
    		getMessage.setInt(1, typ);
    		final ResultSet rs=getMessage.executeQuery();
    		if(rs.next()) {
    			ti=new TextmessageItem(rs.getInt("typ"),rs.getString("message"));
	    	}else {
	        	ti = new TextmessageItem(TEXTMESSAGE_TYP_NONE,"");
	    	}
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMessages.getMessage", e.getLocalizedMessage());
        }
        return ti;
    }

    private int getCommentID(int typ) {
    	int ret = 0;
        try{
    		getCommentID.setInt(1, typ);
    		final ResultSet rs=getCommentID.executeQuery();
    		if(rs.next()) {
    			ret = rs.getInt("id");
	    	}
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMessages.getMessage", e.getLocalizedMessage());
        }
    	return ret;
    }
    public int saveMessage(int typ,String message) {
    	int ret=0;
    	try {
    		PreparedStatement stm;
    		final int id = getCommentID(typ);
	    	if (id==0) {
	    		stm=saveMessage;
	    	}else {
	    		stm=updateMessage;
	    		stm.setInt(3,id);
	    	}
    		stm.setInt(1,typ);
    		stm.setString(2,message);
    		stm.executeUpdate();
            ret = db.dbGetLastInsertID(DBFactory.TABLE_MESSAGES);
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMessages.saveMessage", e.getLocalizedMessage());
        }
    	return ret;
    }

}
