/*
 *  Copyright (C) database.stichwort_loeschen4 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.rezeptur.NotizItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class DBNotizen  {


    RzPro           rz;
    Connection      con;
    DBFactory       db;
    DialogItem		dlgItem;

    PreparedStatement   getNotiz;
    PreparedStatement   saveNotiz;
    PreparedStatement   updateNotiz;
    PreparedStatement   deleteNotiz;

    /** Creates a new instance of DBAbfrage */
    public DBNotizen(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
        setStatements();
    }

    private void setStatements(){
        try{
            getNotiz       = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_REZEPTLISTE + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveNotiz      = con.prepareStatement("INSERT INTO " + DBFactory.TABLE_REZEPTLISTE + " (typ,name,comment,adressen,stichworte,erstellt,geaendert,user_1,user_2,hinweis,deklarationen,deklarationen_alle,spezifikation,spezifikation_text,ean) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateNotiz    = con.prepareStatement("UPDATE " + DBFactory.TABLE_REZEPTLISTE + " SET typ=?,name=?,comment=?,adressen=?,stichworte=?,erstellt=?,geaendert=?,user_1=?,user_2=?,hinweis=?,deklarationen=?,deklarationen_alle=?, spezifikation=?, spezifikation_text=?,ean=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteNotiz    = con.prepareStatement("DELETE FROM " + DBFactory.TABLE_REZEPTLISTE + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBNotizen.setStatements", e.getLocalizedMessage());
        }
    }

        /**---------------------------------------------------------------------
     *  Funktionen für Notizen
     *----------------------------------------------------------------------
     */

    /**
     * dbGetNotiz(int) holt eine bestimmte Notiz aus der Datenbank
     * oder initialisiert eine neue NotizStruktur wenn der übergebene
     * Key==0 ist und gibt diese zurück
     *
     */

    public NotizItem dbGetNotiz(int aKey,boolean quiet){
        NotizItem ret = null;
        ResultSet rs;
        if(aKey == 0){
           ret = new NotizItem(0,rz.getLocale().getString("database.neue_notiz"),"",new StichwortListe(),new StichwortListe(),db.getServerTimestamp(),db.getServerTimestamp(),db.dbGetUser(),db.dbGetUser());
        }
        else {
            try{
            	if(db.idExists(DBFactory.TABLE_REZEPTLISTE,aKey,quiet)){
	                getNotiz.setInt(1, aKey);
	                getNotiz.executeQuery();
	                rs = getNotiz.getResultSet();
	                if (rs.next()){
	                    ret = new NotizItem(aKey,
	                        rs.getString("name"),
	                        rs.getString("comment"),
	                        db.getSTW().dbGetAdressenListe(rs.getString("adressen")),
	                        db.getSTW().dbGetStichwortListe(rs.getString("stichworte")),
	                        db.getDateFromString(rs.getString("erstellt")),
	                        db.getDateFromString(rs.getString("geaendert")),
	                        rs.getString("user_1"),
	                        rs.getString("user_2")
	                        );
	                }
	                if(rs != null) {
						rs.close();
					}
                }
            }
            catch (final SQLException e){
                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBNotizen.dbGetNotiz", e.getLocalizedMessage() + ":" + aKey);
            }
        }
        return ret;
    }

    /**
     * dbSaveNotiz(NotizItem) speichert eine Notiz in der Datenbank oder macht
     * ein Update einer bestehenden Notiz, wenn die ID der Notiz != 0 ist
     * gibt die ID >0 des zuletzt eingef�gten Datensatzes zur�ck oder
     * -1 wenn ein Fehler aufgetreten ist
     * Wenn ein Update auf eine nicht mehr bestehende Zeile gemacht wird, wird
     * einfach eine neue Zeile angelegt....
     *
     */
    public int dbSaveNotiz(NotizItem ni){
        int ret = 0;
        PreparedStatement stm;
        try {
            if (ni.getID() == 0) {
				stm = saveNotiz;
			} else {
                stm = updateNotiz;
                ni.setUser_2(db.dbGetUser());
                stm.setInt(16, ni.getID());
                if(!db.idExists(DBFactory.TABLE_REZEPTLISTE,ni.getID(),true)) {
                	stm=saveNotiz;
                	ni.setID(0);
                }
            }
            stm.setInt(1, RzPro.TYP_ID_NOTIZ);
            stm.setString(2,  ni.getTitel());
            stm.setString(3, ni.getComment());
            stm.setString(4, ni.getAdressListe().toString());
            stm.setString(5, ni.getStichwortListe().toString());
            stm.setString(6, db.dbGetDateFormatString(ni.getErstellt()));
            stm.setString(7, db.dbGetDateFormatString(ni.getGeaendert()));
            stm.setString(8,  ni.getUser1());
            stm.setString(9,  ni.getUser2());
            stm.setString(10, "");
            stm.setString(11, "");
            stm.setString(12, "");
            stm.setString(13,"");
            stm.setString(14, "");
            stm.setString(15, "");
            if(stm.executeUpdate() != 0){
                if(ni.getID() == 0){
                    ret = db.dbGetLastInsertID("rezeptliste");
                }
                else {
                    ret = ni.getID();
                }
            }
        }
        catch (final Exception e){
            ret = -1;
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBNotizen.dbSaveNotiz", e.getLocalizedMessage());
        }
        return ret;
    }


    /** dbDeleteNotiz(int) löscht eine Notiz aus der Datenbank
     */
    public void dbDeleteNotiz(int aKey){
        try{
            deleteNotiz.setInt(1, aKey);
            if(deleteNotiz.executeUpdate() == 0){
                dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                dlgItem.setCaption(rz.getLocale().getString("notiz.key_not_found"));
                dlgItem.setTitel(rz.getLocale().getString("notiz.key_not_found"));
                dlgItem.setMessage(rz.getLocale().getString("notiz.fehler_not_found"));
                dlgItem.setIcon("warnung.png");
                dlgItem.setOk(rz.getLocale().getString("string_ok"));
                rz.getDialogFactory().getDialog(dlgItem);
            }
        }
        catch (final Exception e){
           rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBNotizen.dbDeleteNotiz:", e.getLocalizedMessage());
        }
    }
    /** dupliziert eine Notiz und ändert den Namen der Kopie
     *
     */
    public int dbDuplicateNotiz(int aKey,String aName) {
    	int ret = 0;
    	if(!aName.equals("")) {
	    	final NotizItem ni = dbGetNotiz(aKey,false);
	    	if(ni != null) {
	    		ni.setID(0);
	    		ni.setTitel(aName);
	    		ni.setGeaendert(db.getServerTimestamp());
	    		ni.setUser_2(db.user);
	    		ret = dbSaveNotiz(ni);
	    	}
    	}
    	return ret;
    }
}
