/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.options.SortedProperties;
import de.lunqual.rzpro.log.LogFactory;

/**
 *
 * @author  lunqual
 */
public class DBOptionen{

	public static final int OPTION_TYP_OPTION = 1;
	public static final int	 OPTION_TYP_WINDOW=2;
	public static final int OPTION_TYP_FONT=3;
	
    RzPro           		rz;
    Connection      	con;
    DBFactory       	db;

    PreparedStatement   	getOptionen;
    PreparedStatement	saveOptionen;
    PreparedStatement	updateOptionen;
    PreparedStatement	getUserExists;

    /** Creates a new instance of DBLager */
    public DBOptionen(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }

    private void setStatements(){
        try{
            getOptionen   	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_OPTIONS + " WHERE user=? and typ=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveOptionen 	= con.prepareStatement("INSERT INTO " + DBFactory.TABLE_OPTIONS + " (typ,user,options) VALUES (?,?,?) ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateOptionen 	= con.prepareStatement("UPDATE " + DBFactory.TABLE_OPTIONS + " set typ=?,user=?,options=? WHERE user=? and typ=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getUserExists	= con.prepareStatement("SELECT id FROM " + DBFactory.TABLE_OPTIONS + " WHERE user=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);

        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBOptionen.setStatements", e.getLocalizedMessage());
        }
    }

    public SortedProperties getOptionen(int typ) {
    	SortedProperties ret=null;
    	String user = db.dbGetUser();
    	if(user != null && !user.equals("")) {
	    	try {
	    		if(userExists(user)) {
	    			getOptionen.setString(1,user);
	    			getOptionen.setInt(2,typ);
	    			ResultSet rs=getOptionen.executeQuery();
	    			if(rs.next()) {
	    				StringReader in = new StringReader(rs.getString("options"));
	    				ret=new SortedProperties();
	    				ret.load(in);
	    			}
	    		}
	    	}
	        catch (final Exception e){
	        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBOptionen.getOptionen", e.getLocalizedMessage());
	        }
    	}
    	return ret;
    }
    
    public void saveOptionen(int typ,Properties options,String url) {
    	PreparedStatement stm;
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy-hh.mm");
    	String user= db.dbGetUser();
    	if(user != null && !user.equals("")) {
	    	try {
		    	if(userExists(user)) {
		    		stm=updateOptionen;
		    		stm.setString(4,user);
		    		stm.setInt(5,typ);
		    	}else {
		    		stm=saveOptionen;
		    	}
		    	stm.setInt(1,typ);
		    	stm.setString(2,user);
		    	StringWriter out=new StringWriter();
		    	options.store(out,df.format(new Date()));
		    	stm.setString(3,out.toString());
		    	stm.executeUpdate();
		    }	
	        catch (final Exception e){
	                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBOptionen.saveOptionen", e.getLocalizedMessage());
	        }
    	}
    }
    
    public boolean userExists(String user) {
    	boolean ret=false;
    	try {
    		getUserExists.setString(1,user.trim());
    		ResultSet rs=getUserExists.executeQuery();
    		if(rs.next()) {
    			ret=true;
    		}
    	}	
        catch (final Exception e){
                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBOptionen.userExists", e.getLocalizedMessage());
        }
    	return ret;
    }
}
