/*
 *  Copyright (C)  Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import javax.swing.JComboBox;
import javax.swing.JList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.paletten.PalettenItem;
import de.lunqual.rzpro.items.paletten.PalettenListe;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class DBPaletten {

    RzPro           				rz;
    Connection      			con;
    DBFactory       			db;

    PreparedStatement		getPalettenListe;
    PreparedStatement		getPalette;
    PreparedStatement		savePalette;
    PreparedStatement		updatePalette;
    PreparedStatement		deletePalette;

    DialogItem					dlgItem;
    /** Creates a new instance of DBCurrency */
    public DBPaletten(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
    }

    private void setStatements(){
        try{
            getPalettenListe         	= con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_PALETTEN + " order by bezeichnung", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getPalette 			       	= con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_PALETTEN + " WHERE id=?", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            savePalette 		       	= con.prepareStatement("INSERT INTO  " + DBFactory.TABLE_PALETTEN + " (bezeichnung,inhalt,flaschen_per_karton,karton_per_palette) VALUES (?,?,?,?)", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updatePalette 		   	= con.prepareStatement("UPDATE  " + DBFactory.TABLE_PALETTEN + " set bezeichnung=?,inhalt=?,flaschen_per_karton=?,karton_per_palette=? WHERE id=?", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deletePalette 		   		= con.prepareStatement("DELETE FROM  " + DBFactory.TABLE_PALETTEN + "  WHERE id=?", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);

        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBPaletten.setStatements", e.getLocalizedMessage());
        }
    }
    /**
     * eine einzelne Palette holen
     * @param id
     * @return
     */
    public PalettenItem getPalette(int id) {
    	PalettenItem pi = null;
    	try {
    		if(id==0) {
    			pi = new PalettenItem();
    		}else {
    			getPalette.setInt(1,id);
    			final ResultSet rs=getPalette.executeQuery();
    			if(rs.next()) {
    				pi = new PalettenItem(
        					rs.getInt("id"),
        					rs.getString("bezeichnung"),
        					rs.getDouble("inhalt"),
        					rs.getInt("flaschen_per_karton"),
        					rs.getInt("karton_per_palette")
        			);
    			}
    		}
    	}catch(final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBPaletten.getPalettte", e.getLocalizedMessage());
    	}
    	return pi;
    }

    /**
     * eine einzelne Palette speichern/updaten
     * @param pi PalettenItem
     * @return isnert-id
     */
    public int savePalette(PalettenItem pi) {
    	int ret = -1;
    	try {
    		PreparedStatement save;
    		if(pi.getId() ==0 ) {
    			save=savePalette;
    		}else {
    			save = updatePalette;
    			save.setInt(5,pi.getId());
    		}
    		save.setString(1,pi.getBezeichnung());
    		save.setDouble(2,pi.getInhalt());
    		save.setInt(3,pi.getFlaschen_per_karton());
    		save.setInt(4,pi.getKarton_per_palette());
    		save.executeUpdate();
            if(pi.getId() == 0){
                ret = db.dbGetLastInsertID("paletten");
            }
            else {
                ret = pi.getId();
            }
    	}catch(final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBPaletten.savePalettte", e.getLocalizedMessage());
    	}
    	return ret;
    }

    /**
     * eine einzelne Palette löschen
     * @param id
     * @return
     */
    public void deletePalette(int id) {
    	try {
    		if(id != 0) {
    			deletePalette.setInt(1,id);
    			deletePalette.executeUpdate();
    		}
    	}catch(final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBPaletten.deletePalettte", e.getLocalizedMessage());
    	}
    }

    /**
     * Palettenliste abholen
     * @return
     */
    public PalettenListe getPalettenListe() {
    	final PalettenListe pl = new PalettenListe();
    	try {
    		final ResultSet rs = getPalettenListe.executeQuery();
    		while (rs.next()) {
    			pl.addItem(new PalettenItem(
    					rs.getInt("id"),
    					rs.getString("bezeichnung"),
    					rs.getDouble("inhalt"),
    					rs.getInt("flaschen_per_karton"),
    					rs.getInt("karton_per_palette")
    			));

    		}
    	} catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBPaletten.getPalettenListe", e.getLocalizedMessage());
    	}
    	return pl;
    }

    public void getPalettenCombo(JComboBox cmb){
    	final int sel = rz.getOptionFactory().getOption("palettenrechner.palette",0);
        final PalettenListe pl = getPalettenListe();
        cmb.removeAllItems();
        for(int i = 0 ; i < pl.size();i++){
            cmb.addItem(pl.get(i));
        }
        setComboSelection(cmb,sel);
    }

    public void getPalettenListe(JList liste) {
    	final int sel = rz.getOptionFactory().getOption("palettenrechner.palette",0);
        final PalettenListe pl = getPalettenListe();
        liste.removeAll();
        ArrayList<PalettenItem> l = new ArrayList<PalettenItem>();
        for(int i = 0 ; i < pl.size();i++){
            l.add(pl.getItem(i));
        }
        liste.setListData(l.toArray());
        try {
        	liste.setSelectedIndex(sel);
        } catch(Exception e) {}
    }
    
    public void setComboSelection(JComboBox cmb,int selection) {
    	try {
	        for(int i = 0 ;i < cmb.getModel().getSize();i++){
	            if(((PalettenItem)cmb.getModel().getElementAt(i)).getId() == selection){
	                cmb.setSelectedIndex(i);
	                break;
	            }
	        }
    	}catch(final Exception e) {}
    }
}
