/*
 *  Copyright (C) database.stichwort_loeschen4 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.dbproperties.dbPropertyItem;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class DBProperties {

	public static final String DEFAULT_PROPERTY_VALUE="0";
    RzPro           rz;
    Connection      con;
    DBFactory       db;

    PreparedStatement		getProperty;
    PreparedStatement		saveProperty;
    PreparedStatement		updateProperty;
    
    /** Creates a new instance of DBAbfrage */
    public DBProperties(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }

    private void setStatements(){
        try{
            getProperty	= con.prepareStatement("SELECT id,p_key,p_value FROM " + DBFactory.TABLE_PROPERTIES + " WHERE p_key=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveProperty   	= con.prepareStatement("INSERT INTO " + DBFactory.TABLE_PROPERTIES + " (p_key,p_value) values (?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateProperty   	= con.prepareStatement("UPDATE " + DBFactory.TABLE_PROPERTIES + " set p_value=? where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProperties.setStatements", e.getLocalizedMessage());
        }
    }

    public void saveProperty(dbPropertyItem pi) {
    	try {
    		if(pi.getId()==0) {
    			saveProperty.setString(1, pi.getP_key());
    			saveProperty.setString(2, pi.getP_value());
    			saveProperty.executeUpdate();
    		} else {
    			updateProperty.setString(1, pi.getP_value());
    			updateProperty.setInt(2, pi.getId());
    			updateProperty.executeUpdate();
    		}
    	}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProperties.setProperty", e.getLocalizedMessage());
        }
    }
  
    public void setProperty(String p_key,String p_value) {
    	try {
    		dbPropertyItem pi = getProperty(p_key);
    		if(pi != null) {
    			pi.setP_value(p_value);
    			saveProperty(pi);
    		}
    	}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProperties.setProperty", e.getLocalizedMessage());
        }
    }
    
    public dbPropertyItem getProperty(String p_key) {
    	dbPropertyItem ret = null;
    	try {
    		getProperty.setString(1, p_key);
    		final ResultSet rs = getProperty.executeQuery();
    		if(rs.next()) {
    			ret = new dbPropertyItem(
    					rs.getInt("id"),
    					rs.getString("p_key"),
    					rs.getString("p_value")
    					);
    		}
    	}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProperties.getProperty", e.getLocalizedMessage());
        }
    	if(ret == null) {
    		saveProperty(new dbPropertyItem(0,p_key,DEFAULT_PROPERTY_VALUE));
    		ret = getProperty(p_key);
    	}
    	return ret;
    }

}
