/*
 *  Copyright (C) database.stichwort_loeschen4 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import javax.swing.JComboBox;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.items.formulare.FormularItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.report.ReportListe;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class DBReport {

    RzPro           rz;
    Connection      con;
    DBFactory       db;

    PreparedStatement   getReport;
    PreparedStatement   getReportByName;
    PreparedStatement   getReportListe;
    PreparedStatement   saveReport;
    PreparedStatement   updateReport;
    PreparedStatement   deleteReport;
    PreparedStatement	checkReportType;
    PreparedStatement  	getDefaultReport;
    PreparedStatement	getFormularListe;
    PreparedStatement   updateFormularText;
    PreparedStatement 	addFormular;
    

    /** Creates a new instance of DBReport */
    public DBReport(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();

    }

    private void setStatements(){
        try{
            getReport           = con.prepareStatement("SELECT * FROM formulare WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getReportByName     = con.prepareStatement("SELECT * FROM formulare WHERE name=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getReportListe      = con.prepareStatement("SELECT * FROM formulare WHERE typ=? ORDER BY name",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveReport          = con.prepareStatement("INSERT INTO formulare (typ,`system`,erstellt,geaendert,user_1,user_2,name,formular) values (?,?,?,?,?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateReport        = con.prepareStatement("UPDATE formulare SET typ=?,`system`=?,erstellt=?,geaendert=?,user_1=?,user_2=?,name=?,formular=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteReport        = con.prepareStatement("DELETE FROM formulare WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            checkReportType   	= con.prepareStatement("SELECT * FROM formulare WHERE typ=? LIMIT 1",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getDefaultReport    = con.prepareStatement("SELECT id FROM formulare WHERE typ=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getFormularListe	= con.prepareStatement("SELECT * FROM formulare order by name ASC ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            updateFormularText  = con.prepareStatement("UPDATE formulare SET formular=?,geaendert=?,user_2=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            addFormular 		= con.prepareStatement("INSERT INTO formulare (system,typ,erstellt,geaendert,user_1,user_2,name,formular) VALUES (0,?,?,?,?,?,?,'')",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBReport.setStatements", e.getLocalizedMessage());
        }
    }

   public int addFormular(int typ,String name) {
	   int ret = 0;
	   try {
		   if(name != null && !name.trim().equals("")) {
			   addFormular.setInt(1, typ);
			   addFormular.setString(2,db.dbGetDateFormatString(db.getServerTimestamp()));
			   addFormular.setString(3,db.dbGetDateFormatString(db.getServerTimestamp()));
			   addFormular.setString(4,db.dbGetUser());
			   addFormular.setString(5,db.dbGetUser());
			   addFormular.setString(6,name.trim());
			   addFormular.executeUpdate();
			   ret = db.dbGetLastInsertID("formulare");
		   }
	   } catch (final Exception e){
   			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBReport.addFormular", e.getLocalizedMessage());
	   }
	   return ret;
   }
    
    public ArrayList<FormularItem> getFormularListe(){
    	ArrayList<FormularItem> ret = new ArrayList<FormularItem>();
    	try {
    		ResultSet rs = getFormularListe.executeQuery();
    		while(rs.next()) {
    			ret.add(new FormularItem(
    					rs.getInt("id"),
    					rs.getInt("system"),
    					rs.getInt("typ"),
    					db.getDateFromString(rs.getString("erstellt")),
    					db.getDateFromString(rs.getString("geaendert")),
    					rs.getString("user_1"),
    					rs.getString("user_2"),
    					rs.getString("name"),
    					rs.getString("formular")
    					));
    		}
    	}
   		catch (final Exception e){
   			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBReport.getFormularListe", e.getLocalizedMessage());
	    }
    	return ret;
    }
    
    public void updateFormularText(int id,String text) {
    	try {
    		if(id != 0 && !text.trim().equals("")) {
	    		updateFormularText.setString(1, text);
	    		updateFormularText.setString(2,db.dbGetDateFormatString(db.getServerTimestamp()));
	    		updateFormularText.setString(3,db.dbGetUser());
	    		updateFormularText.setInt(4, id);
	    		updateFormularText.executeUpdate();
    		}
    	}
  		catch (final Exception e){
   			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBReport.getFormularListe", e.getLocalizedMessage());
	    }
    }
   
    /**
     * gibt die ID des ersten gefundenen Reports eines Typs zurück
     * @param typ
     * @return id oder 0, wenn nichts gefunden
     */
    public int getDefaultReport(int typ,String optionKey) {
    	int ret = 0;
        try{
        	if(true) {
        		//if(rz.getOptionFactory().getOption(optionKey,-1) ==-1) {
	            checkReportType.setInt(1,typ);
	            final ResultSet rs = checkReportType.executeQuery();
	            if(rs.first()){
	            	ret = rs.getInt("id");
	            	rz.getOptionFactory().setOption(optionKey,ret);
	            	rz.getOptionFactory().saveOptions();
	            }
	            if(rs != null) {
					rs.close();
				}
        	}
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBReport.checkReportType", e.getLocalizedMessage());
        }
    	return ret;
    }
    /**
     * dbGetReport(String) holt einen einzelnen Report aus der Datenbank
     *
     */
    public ReportItem dbGetReport(int s){
        ReportItem ret = null;
        ResultSet rs;
        try{
            getReport.setInt(1,s);
            getReport.executeQuery();
            rs = getReport.getResultSet();
            if(rs.first()){
                ret = new ReportItem(rz,rs.getInt("id"), rs.getInt("typ"),rs.getInt("system"),
                db.getDateFromString(rs.getString("erstellt")),db.getDateFromString(rs.getString("geaendert")),rs.getString("user_2"),rs.getString("user_2"),
                rs.getString("name"),rs.getString("formular"));
            }
            if(rs != null) {
				rs.close();
			}
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBReport.dbGetReport", e.getLocalizedMessage());
        }
        return ret;
    }

    public ReportItem dbGetReport(String name){
        ReportItem ret = null;
        ResultSet rs;
        try{
            getReportByName.setString(1,name);
            rs = getReportByName.executeQuery();
            if(rs.next()){
                ret = new ReportItem(rz,rs.getInt("id"), rs.getInt("typ"),rs.getInt("system"),
                db.getDateFromString(rs.getString("erstellt")),db.getDateFromString(rs.getString("geaendert")),rs.getString("user_2"),rs.getString("user_2"),
                rs.getString("name"),rs.getString("formular"));
            }
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBReport.dbGetReportByName", e.getLocalizedMessage());
        }
        return ret;
    }

    
    /**-------------------------------------------------------------------
     * dbSaveReport(ReportItem) speichert einen neuen Report oder updated
     * einen alten
     * gibt den Schl�ssel des Items zur�ck
     *--------------------------------------------------------------------
     */

    public int dbSaveReport(ReportItem ri){
        int ret = 0;
        final java.util.Date d = db.getServerTimestamp();
        PreparedStatement stm=null;
        try{
            if (ri.getID() == 0){
                ri.setErstellt(d);
                ri.setGeandert(d);
                ri.setUser1(db.dbGetUser());
                ri.setUser2(db.dbGetUser());
                stm = saveReport;
            }
            else {
                stm = updateReport;
                stm.setInt(9, ri.getID());
                ri.setGeandert(d);
                ri.setUser2(db.dbGetUser());
            }
            stm.setInt(1, ri.getTyp());
            stm.setInt(2, ri.getSystem());
            stm.setString(3, db.dbGetDateFormatString(ri.getErstellt()));
            stm.setString(4, db.dbGetDateFormatString(ri.getGeaendert()));
            stm.setString(5,  ri.getUser1());
            stm.setString(6,  ri.getUser2());
            stm.setString(7,  ri.getName());
            stm.setString(8, ri.getFormular());
            stm.executeUpdate();

            ret = db.dbGetLastInsertID("formulare");
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBReport.dbSaveReport", e.getLocalizedMessage());
        }
        return ret;
    }
    /**-------------------------------------------------------------------
     * dbGetReportListe() holt eine Liste aller Reports aus der Datenbank
     *--------------------------------------------------------------------
     */
    public ReportListe dbGetReportListe(int typ){
        final ReportListe rl = new ReportListe();
        ResultSet rs;
        try{
        	getReportListe.setInt(1,typ);
            rs = getReportListe.executeQuery();
            while(rs.next()){
                rl.addItem(new ReportItem(rz,rs.getInt("id"), rs.getInt("typ"),rs.getInt("system"),
                db.getDateFromString(rs.getString("erstellt")),db.getDateFromString(rs.getString("geaendert")),rs.getString("user_2"),rs.getString("user_2"),
                rs.getString("name"),rs.getString("formular")));
            }
            if(rs != null) {
				rs.close();
			}
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBReport.dbGetReportListe", e.getLocalizedMessage());
        }
        return rl;
    }

    /**-------------------------------------------------------------------
     * dbDeleteReport(ReportItem) löscht einen Report aus der
     * DAtenbank
     *--------------------------------------------------------------------
     */
    public void dbDeleteReport(ReportItem ri){
        try{
	        	if(ri.getSystem() == 0) {
	            deleteReport.setInt(1, ri.getID());
	            deleteReport.executeUpdate();
	        }
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBReport.dbDeleteReport:", e.getLocalizedMessage());
        }
    }
    
    
    public void deleteFormular(FormularItem fi){
        try{
	        	if(fi.getSystem() == 0) {
	            deleteReport.setInt(1, fi.getId());
	            deleteReport.executeUpdate();
	        }
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBReport.dbDeleteReport:", e.getLocalizedMessage());
        }
    }
    
    
    /** void dbGetCurrencyListeCombo(JComboBox) füllt die angegebene JComboBox mit einer
     * Währungsliste und markiert eine Währung
     * @param cmb  die Combobox
     * @param aDefault   Die id der zu selektierenden währung oder -1 für Default
     */
    public void dbGetReportListeCombo(JComboBox cmb,int typ){
        int sel=0;
        switch(typ) {
        	case ReportFactory.REPORT_TYPE_STATISTIK:
        		sel = rz.getOptionFactory().getOption("report.statistik",ReportFactory.REPORT_DEFAULT_ADRESSE);
        		break;
        	case ReportFactory.REPORT_TYPE_ADRESSEN:
        		sel = rz.getOptionFactory().getOption("report.adresse",ReportFactory.REPORT_DEFAULT_ADRESSE);
        		break;
        	case ReportFactory.REPORT_TYPE_NOTIZ:
    			sel = rz.getOptionFactory().getOption("report.notiz",ReportFactory.REPORT_DEFAULT_NOTIZ);
        		break;
        	case ReportFactory.REPORT_TYPE_REZEPTUR:
    			sel = rz.getOptionFactory().getOption("report.rezeptur",ReportFactory.REPORT_DEFAULT_REZEPTUR);
    			break;
        	case ReportFactory.REPORT_TYPE_RECHNEN:
    			sel = rz.getOptionFactory().getOption("report.rechnen",ReportFactory.REPORT_DEFAULT_RECHNEN);
        		break;
        	case ReportFactory.REPORT_TYPE_STAERKE:
    			sel = rz.getOptionFactory().getOption("report.staerke",ReportFactory.REPORT_DEFAULT_RECHNEN);
        		typ=ReportFactory.REPORT_TYPE_RECHNEN;
        		break;
        	case ReportFactory.REPORT_TYPE_HERSTELLUNG:
    			sel = rz.getOptionFactory().getOption("report.herstellung",ReportFactory.REPORT_DEFAULT_HERSTELLUNG);
        		break;
        	case ReportFactory.REPORT_TYPE_LAGERLISTE:
    			sel = rz.getOptionFactory().getOption("report.lagerliste",ReportFactory.REPORT_DEFAULT_LAGERLISTE);
        		break;
        	case ReportFactory.REPORT_TYPE_LAGERBESTAND:
    			sel = rz.getOptionFactory().getOption("report.lagerbestand",ReportFactory.REPORT_DEFAULT_LAGERBESTAND);
        		break;
        	case ReportFactory.REPORT_TYPE_VERLAUF :
    			sel = rz.getOptionFactory().getOption("report.verlauf",ReportFactory.REPORT_DEFAULT_VERLAUF);
        		break;
        	case ReportFactory.REPORT_TYPE_INVENTUR :
	        		if(rz.getOptionFactory().getOption("report.inventur",-1) == -1) {
	        			sel = getDefaultReport(ReportFactory.REPORT_TYPE_INVENTUR,"report.inventur");
	        		} else {
	        			sel = rz.getOptionFactory().getOption("report.inventur",0);
	        		}
    			break;
        	case ReportFactory.REPORT_TYPE_DATENBLATT:
    			//sel = rz.getOptionFactory().getOption("report.datenblatt",getDefaultReport(ReportFactory.REPORT_TYPE_DATENBLATT,"report.datenblatt"));
    			if(rz.getOptionFactory().getOption("report.datenblatt",-1) == -1) {
        			sel = getDefaultReport(ReportFactory.REPORT_TYPE_DM,"report.datenblatt");
        		} else {
        			sel = rz.getOptionFactory().getOption("report.datenblatt",0);
        		}
    			
        		break;
        	case ReportFactory.REPORT_TYPE_STATISTIKLISTE:
    			sel = rz.getOptionFactory().getOption("report.statistikliste",getDefaultReport(ReportFactory.REPORT_TYPE_STATISTIKLISTE,"report.statistikliste"));
        		break;
        	case ReportFactory.REPORT_TYPE_PROBE:
    			sel = rz.getOptionFactory().getOption("report.probe",getDefaultReport(ReportFactory.REPORT_TYPE_PROBE,"report.probe"));
    			break;
        	case ReportFactory.REPORT_TYPE_PROBENLISTE:
    			sel = rz.getOptionFactory().getOption("report.probenliste",getDefaultReport(ReportFactory.REPORT_TYPE_PROBENLISTE,"report.probenliste"));
    			break;
        	case ReportFactory.REPORT_TYPE_ZUTATENVERZEICHNIS:
    			sel = rz.getOptionFactory().getOption("report.zutatenverzeichnis",getDefaultReport(ReportFactory.REPORT_TYPE_ZUTATENVERZEICHNIS,"report.zutatenverzeichnis"));
    			break;
        	case ReportFactory.REPORT_TYPE_CHANGES:
    			sel = rz.getOptionFactory().getOption("report.changes",getDefaultReport(ReportFactory.REPORT_TYPE_CHANGES,"report.changes"));   
    			break;
        	case ReportFactory.REPORT_TYPE_CHANGESLISTE:
    			sel = rz.getOptionFactory().getOption("report.changesliste",getDefaultReport(ReportFactory.REPORT_TYPE_CHANGES,"report.changesliste"));
    			break;
           	case ReportFactory.REPORT_TYPE_LABORWERT:
        			sel = rz.getOptionFactory().getOption("report.laborwerte",getDefaultReport(ReportFactory.REPORT_TYPE_LABORWERT,"report.laborwert" +
        					"e"));
        			break;
        	case ReportFactory.REPORT_TYPE_MHD:
    			sel = rz.getOptionFactory().getOption("report.mhd",getDefaultReport(ReportFactory.REPORT_TYPE_MHD,"report.mhd"));
    			break;
        	case ReportFactory.REPORT_TYPE_AUFTRAGSLISTE:
    			sel = rz.getOptionFactory().getOption("report.auftragsliste",getDefaultReport(ReportFactory.REPORT_TYPE_AUFTRAGSLISTE,"report.auftragsliste"));
    			break;
        	case ReportFactory.REPORT_TYPE_DM:
        		if(rz.getOptionFactory().getOption("report.dm",-1) == -1) {
        			sel = getDefaultReport(ReportFactory.REPORT_TYPE_DM,"report.dm");
        		} else {
        			sel = rz.getOptionFactory().getOption("report.dm",0);
        		}
    			break;
        	case ReportFactory.REPORT_TYPE_KONFORM:
    			sel = rz.getOptionFactory().getOption("report.konform",getDefaultReport(ReportFactory.REPORT_TYPE_DM,"report.konform"));
    			break;
        	case ReportFactory.REPORT_TYPE_CONTAINERLISTE:
        		int r = rz.getOptionFactory().getOption("report.containerliste",0);
        		if(r == 0) {
        			sel = getDefaultReport(ReportFactory.REPORT_TYPE_CONTAINERLISTE,"report.containerliste");
        		} else {
        			sel = r;
        		}
    			break;
        	case ReportFactory.REPORT_TYPE_TANKBELEGUNG:
        		if(rz.getOptionFactory().getOption("report.tankbelegung",-1) == -1) {
        			sel = getDefaultReport(ReportFactory.REPORT_TYPE_TANKBELEGUNG,"report.tankbelegung");
        		} else {
        			sel = rz.getOptionFactory().getOption("report.tankbelegung",0);
        		}
    			break;
        	case ReportFactory.REPORT_TYPE_BEWERTUNG:
    			sel = rz.getOptionFactory().getOption("report.bewertung",getDefaultReport(ReportFactory.REPORT_TYPE_BEWERTUNG,"report.bewertung"));
    			break;
        	case ReportFactory.REPORT_TYPE_MISCHUNG:
        		if(rz.getOptionFactory().getOption("report.mischung",-1) == -1) {
        			sel = getDefaultReport(ReportFactory.REPORT_TYPE_MISCHUNGSLISTE,"report.mischung");
        		} else {
        			sel = rz.getOptionFactory().getOption("report.mischung",0);
        		}
    			break;
        	case ReportFactory.REPORT_TYPE_MISCHUNGSLISTE:
        		if(rz.getOptionFactory().getOption("report.mischungsliste",-1) == -1) {
        			sel = getDefaultReport(ReportFactory.REPORT_TYPE_MISCHUNGSLISTE,"report.mischungsliste");
        		} else {
        			sel = rz.getOptionFactory().getOption("report.mischungsliste",0);
        		}
        		break;
        	case ReportFactory.REPORT_TYPE_ERGEBNISLISTE_BESTAND:
        		if(rz.getOptionFactory().getOption("report.ergebnisliste_bestand",-1) == -1) {
        			sel = getDefaultReport(ReportFactory.REPORT_TYPE_ERGEBNISLISTE_BESTAND,"report.ergebnisliste_bestand");
        		} else {
        			sel = rz.getOptionFactory().getOption("report.ergebnisliste_bestand",0);
        		}
    			break;
        	case ReportFactory.REPORT_TYPE_ZUTATENLISTE:
        		if(rz.getOptionFactory().getOption("report.zutatenliste",-1) == -1) {
        			sel = getDefaultReport(ReportFactory.REPORT_TYPE_ZUTATENLISTE,"report.zutatenliste");
        		} else {
        			sel = rz.getOptionFactory().getOption("report.zutatenliste",0);
        		}
        		break;
        	case ReportFactory.REPORT_TYPE_LIEFERSCHEIN:
        		if(rz.getOptionFactory().getOption("report.lieferschein",-1) == -1) {
        			sel = getDefaultReport(ReportFactory.REPORT_TYPE_LIEFERSCHEIN,"report.lieferschein");
        		} else {
        			sel = rz.getOptionFactory().getOption("report.lieferschein",0);
        		}
        		break;
        	case ReportFactory.REPORT_TYPE_TRACE:
        		if(rz.getOptionFactory().getOption("report.trace",-1) == -1) {
        			sel = getDefaultReport(ReportFactory.REPORT_TYPE_TRACE,"report.trace");
        		} else {
        			sel = rz.getOptionFactory().getOption("report.trace",0);
        		}
        		break;
        	case ReportFactory.REPORT_TYPE_DEPENDENCY:
        		if(rz.getOptionFactory().getOption("report.dependency_liste",-1) == -1) {
        			sel = getDefaultReport(ReportFactory.REPORT_TYPE_DEPENDENCY,"report.dependency_liste");
        		} else {
        			sel = rz.getOptionFactory().getOption("report.dependency_liste",0);
        		}
        		break;
        }
        final ReportListe rl = dbGetReportListe(typ);
        cmb.removeAllItems();
        for(int i = 0 ; i < rl.size();i++){
            cmb.addItem(rl.get(i));
        }
        setComboSelection(cmb,sel);
    }



    public void setComboSelection(JComboBox cmb,int selection) {
        for(int i = 0 ;i < cmb.getModel().getSize();i++){
            if(((ReportItem)cmb.getModel().getElementAt(i)).getID() == selection){
                cmb.setSelectedIndex(i);
                break;
            }
        }
    }
}
