/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.temperaturzone.ZonenItem;
import de.lunqual.rzpro.items.temperaturzone.rezepturZonenItem;
import de.lunqual.rzpro.items.temperaturzone.rezepturZonenListe;
import de.lunqual.rzpro.items.temperaturzone.temperaturZonenItem;
import de.lunqual.rzpro.log.LogFactory;

/**
 *
 * @author  lunqual
 */
public class DBTemperatur{

    RzPro           		rz;
    Connection      	con;
    DBFactory       	db;
    ZonenItem		tz;
    
    PreparedStatement getListe;
    PreparedStatement updateZone;
    
    /** Creates a new instance of DBLager */
    public DBTemperatur(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        tz=new ZonenItem(rz);
        setStatements();
        getListe();
    }

    private void setStatements(){
        try{
            getListe    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_TEMPERATURZONEN + " ORDER BY id ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            updateZone		= con.prepareStatement("UPDATE " +DBFactory.TABLE_TEMPERATURZONEN + " SET bezeichnung=?,vg=?,hg=?,min=?,max=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBTemperatur.setStatements", e.getLocalizedMessage());
        }
    }

    public  rezepturZonenListe getListeRezeptur(String rezepturen) {
    	rezepturZonenListe ret = new rezepturZonenListe();
	   	try {
	   		Statement stm = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
	   		String sql= "SELECT id,name,artikelnummer,tempvon,tempbis FROM " + DBFactory.TABLE_REZEPTLISTE +" WHERE id in(" + rezepturen + ")"; 
	   		if(rezepturen != null && !rezepturen.equals("")) {
		   		final ResultSet rs=stm.executeQuery(sql);
		   		while(rs.next()) {
		   			ret.add(new rezepturZonenItem(
		   					rs.getInt("id"),
		   					rs.getString("name"),
		   					rs.getString("artikelnummer"),
		   					rs.getInt("tempvon"),
		   					rs.getInt("tempbis"),
		   					this.getZone(  (rs.getInt("tempvon")+rs.getInt("tempbis"))/2)
		   					));
		   			
		   		}
	   		}
	   	}  catch (final SQLException e) {
	           rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBTemperatur.getListeRezeptur", e.getLocalizedMessage());
	       }
   	return ret;
   }
    
     private void getListe() {
    	try {
    		final ResultSet rs=getListe.executeQuery();
    		while(rs.next()) {
    			tz.setZone(rs.getInt("id"),rs.getString("bezeichnung"),rs.getString("vg"),rs.getString("hg"),rs.getInt("min"),rs.getInt("max"));
    		}
    	}  catch (final SQLException e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBTemperatur.getListe", e.getLocalizedMessage());
        }
    }
    
     public void saveZonen() {
    	 try {
    		 updateZone.setString(1, tz.getItem(1).getBezeichnung());
    		 updateZone.setString(2, tz.getItem(1).getVg());
    		 updateZone.setString(3, tz.getItem(1).getHg());
    		 updateZone.setInt(4, tz.getItem(1).getMin());
    		 updateZone.setInt(5, tz.getItem(1).getMax());
    		 updateZone.setInt(6,1);
    		 updateZone.executeUpdate();
    		 
    		 updateZone.setString(1, tz.getItem(2).getBezeichnung());
    		 updateZone.setString(2, tz.getItem(2).getVg());
    		 updateZone.setString(3, tz.getItem(2).getHg());
    		 updateZone.setInt(4, tz.getItem(2).getMin());
    		 updateZone.setInt(5, tz.getItem(2).getMax());
    		 updateZone.setInt(6,2);
    		 updateZone.executeUpdate();
    		 
    		 updateZone.setString(1, tz.getItem(3).getBezeichnung());
    		 updateZone.setString(2, tz.getItem(3).getVg());
    		 updateZone.setString(3, tz.getItem(3).getHg());
    		 updateZone.setInt(4, tz.getItem(3).getMin());
    		 updateZone.setInt(5, tz.getItem(3).getMax());
    		 updateZone.setInt(6,3);
    		 updateZone.executeUpdate();
    		 
	 	}  catch (final SQLException e) {
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBTemperatur.saveZonen", e.getLocalizedMessage());
	    }
     }
     
     public ZonenItem getZonen() {
    	 return tz;
     }
     
     public temperaturZonenItem getZone(int temp) {
    	 if(temp >= tz.getItem(1).getMin() && temp <= tz.getItem(1).getMax()) {
    		 return tz.getItem(1);
    	 }
    	 if(temp >= tz.getItem(2).getMin() && temp <= tz.getItem(2).getMax()) {
    		 return tz.getItem(2);
    	 }
    	 if(temp >= tz.getItem(3).getMin() && temp <= tz.getItem(3).getMax()) {
    		 return tz.getItem(3);
    	 }
    	 return tz.getItem(3);
     }
}
