package de.lunqual.rzpro.database;

/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.zutatenverzeichnis.ZutatenverzeichnisItem;
import de.lunqual.rzpro.items.zutatenverzeichnis.ZutatenverzeichnisListe;
import de.lunqual.rzpro.log.LogFactory;

/**
 *
 * @author  lunqual
 */
public class DBZutatenverzeichnis{

    RzPro           		rz;
    Connection      	con;
    DBFactory       	db;
    DialogItem			dlgItem;

    PreparedStatement   getVerzeichnis;
    PreparedStatement   saveVerzeichnis;
    PreparedStatement   getItem;
    PreparedStatement  deleteVerzeichnis;

    /** Creates a new instance of DBLager */
    public DBZutatenverzeichnis(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }

    private void setStatements(){
        try{
            getVerzeichnis    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_ZUTATENVERZEICHNIS + " ORDER BY priority",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getItem		= con.prepareStatement("SELECT id,priority,stichwort,einheit,wert,bezeichnung FROM " +DBFactory.TABLE_ZUTATENVERZEICHNIS + "  WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveVerzeichnis        = con.prepareStatement("INSERT INTO " +DBFactory.TABLE_ZUTATENVERZEICHNIS+ " (priority,stichwort,einheit,wert,bezeichnung) VALUES(?,?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteVerzeichnis        = con.prepareStatement("DELETE FROM " +DBFactory.TABLE_ZUTATENVERZEICHNIS,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);

        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBZutatenverzeichnis.setStatements", e.getLocalizedMessage());
        }
    }

    public ZutatenverzeichnisItem getItem(int id) {
    	ZutatenverzeichnisItem zi=null;
    	if(id == 0) {
    		zi = new ZutatenverzeichnisItem(rz,0,0,null,0,1.0,"?");
    	} else {
	    	 try{
	    		getItem.setInt(1,id);
	          	final ResultSet rs = getItem.executeQuery();
	            if (rs.next()) {
	          		zi = new ZutatenverzeichnisItem(
	          				rz,
	          				rs.getInt("id"),
	          				rs.getInt("priority"),
	          			    rs.getInt("stichwort") != 0?rz.getDatabase().getSTW().dbGetStichwort(rs.getInt("stichwort")):null,
	          				rs.getInt("einheit"),
	          				rs.getDouble("wert"),
	          				rs.getString("bezeichnung")
	          		);

	          	}
	          }
	          catch (final Exception e){
	              rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBZutatenverzeichnis.getVerzeichnis", e.getLocalizedMessage());
	          }
    	}
    	return zi;
    }


    public ZutatenverzeichnisListe getListe() {
    	final ZutatenverzeichnisListe zl = new ZutatenverzeichnisListe(rz);
    	 try{
         	final ResultSet rs = getVerzeichnis.executeQuery();
         	while(rs.next()) {
         		zl.addItem(new ZutatenverzeichnisItem(
         				rz,
         				rs.getInt("id"),
         				rs.getInt("priority"),
         				rz.getDatabase().getSTW().dbGetStichwort(rs.getInt("stichwort")),
         				rs.getInt("einheit"),
         				rs.getDouble("wert"),
         				rs.getString("bezeichnung")
         		),zl.size());

         	}
         }
         catch (final Exception e){
             rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBZutatenverzeichnis.getVerzeichnis", e.getLocalizedMessage());
         }
    	return zl;
    }

    public void saveVerzeichnis(ZutatenverzeichnisListe zl) {
    	try {
    		deleteVerzeichnis.executeUpdate();
    		if (!zl.isEmpty()) {
    			zl.reIndex();
    			for(int i =0;i<zl.size();i++) {
    				final ZutatenverzeichnisItem zi = zl.getItem(i);
    				saveVerzeichnis.setInt(1,zi.getPriority());
    				saveVerzeichnis.setInt(2,zi.getStichwort().getID());
    				saveVerzeichnis.setInt(3,zi.getEinheit());
    				saveVerzeichnis.setDouble(4,zi.getWert());
    				saveVerzeichnis.setString(5,zi.getBezeichnung());
    				saveVerzeichnis.executeUpdate();
    			}
    		}
    	}         catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBZutatenverzeichnis.saveVerzeichnis", e.getLocalizedMessage());
        }
    }
}
