/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.designs;


//java-pakete
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import de.lunqual.rzpro.*;



/**
 * @author lunqual
 * kennt eine Reihe von Look- and Feels zum Einstellen
 */
public class DesignFactory {

	RzPro				rz;
	
	public DesignFactory(RzPro r) {
		rz = r;
		setDesign("javax.swing.plaf.nimbus.NimbusLookAndFeel");
	}
	
	public void setDesign(String className) {
		   try {
		    	UIManager.setLookAndFeel(className);
		    } catch (Exception e) {
		        // If Nimbus is not available, fall back to cross-platform
		            try {
						UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
					} catch (ClassNotFoundException e1) {
					} catch (InstantiationException e1) {
					} catch (IllegalAccessException e1) {
					} catch (UnsupportedLookAndFeelException e1) {
					}
		    }
	}
	

	
}
