/*
 * Created on 24.08.2004
 */
package de.lunqual.rzpro.fenster;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;



/**
 * @author lunqual
 * JNumberField stellt ein Textfeld zur Verfügung, das zwar alles eingeben kann,
 * aber nur Zahlen validiert.
 *
 * Der Inhalt des Feldes wird vollständig selektiert, wenn das Feld den Focus
 * erhält.
 *
 * Das Feld wird beim Drücken der ENTER-Taste und beim verlassen des Focus
 * validiert
 */
public class JIntegerField extends JTextField {

	int defaultValue;
	int value;
	int min;
	int max;
	/**
	 * JNumberField Constructor
	 * @param nDef Defaultwert, wenn ungültige Eingaben vorliegen
	 * @param nMin Minimalwert
	 * @param nMax Maximalwert
	 */
	public JIntegerField(int nDef,int nMin,int nMax) {
		super();
        this.setDocument(new IntegerDocument());
		defaultValue = nDef; min = nMin;max = nMax;
		value = defaultValue;
		setValue(value);
		this.setSelectedTextColor(Color.WHITE);
		this.setSelectionColor(Color.BLUE);
	    this.addKeyListener(new java.awt.event.KeyAdapter() {
            @Override
			public void keyReleased(java.awt.event.KeyEvent evt) {
            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
            		validateField();
            	}
            }
        });
		this.addFocusListener(new FocusListener() {
			public void focusGained(FocusEvent evt) {
				selectAll();
			}
			public void focusLost(FocusEvent evt) {
				validateField();}
    		});
	}

	/** holt den Text aus dem Textfeld und versucht diesen in eine Zahl
	 * zu wandeln. Wenn das nicht möglich ist, wird der Defaultwert in den
	 * Text eingetragen.
	 * Wenn es eine Zahl ergibt, wird geprüft ob diese kleiner als der Minimalwert
	 * oder größer als der Maximalwert ist und diese Werte werden entsprechend
	 * angenommen.
	 * Anschliessend wird die entstandene Zahl wieder in den Text geschrieben
	 */
	public void validateField() {
		try {
			int n = Integer.parseInt(this.getText());
			n = checkValue(n);
			this.setText(String.valueOf(n));
			value = n;
			defaultValue = n;
		}catch (final NumberFormatException e) {
			this.setText(String.valueOf(defaultValue));
		}
	}

	/** den Wert - nach Überprüfung ins Textfeld setzen
	 *
	 * @param aValue
	 */
	public void setValue(int aValue) {
	    value = checkValue(aValue);
	    defaultValue=value;
		this.setText(String.valueOf(value));
	}

	/** das Feld validieren und den Wert aus dem Textfeld holen
	 *
	 * @return value
	 */
	public int getValue() {
	    validateField();
	    return value;
	}

	/** den Wert prüfen, ob er größer oder kleiner ist als
	 * erlaubt
	 * @param n Wert zum prüfen
	 * @return n wenn ok, min oder max bei Wertüberschreitung
	 */
	private int checkValue(int n) {
		if (n < min) {
			return min;
		}
		if(n > max) {
			return  max;
		}
		return n;
	}

    class IntegerDocument extends PlainDocument {

        @Override
		public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            str=checkNumber(str);
            super.insertString(offs, str, a);
       }
        /**
         * prüft, ob der übergebene String eine Zahl,+ - oder DecimalSeparator ist.
         * tab und newline werden natürlich auch durchgelassen;)
         * @param in Engabestring
         * @return derselbe String, nur ohne alle Nicht-Zahlen
         */
       String checkNumber(String in) {
       	String ret = "";
       	int i;
       	for(i = 0;i < in.length();i++) {
       		final char t = in.charAt(i);
       		if(Character.isDigit(t) || (t=='-') || (t == '+') ||  Character.isISOControl(t) ) {
           		ret += in.charAt(i);
       		}
       	}
       	return ret;
       }
   }
}