/*
 * Created on 27.08.2004
 */
package de.lunqual.rzpro.fenster;


import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;

import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.log.LogFactory;

/**
 * @author labor
 * DAs ist die Basisklasse aller Fenster
 */
public abstract class JRzFrame extends JFrame{

	/* (non-Javadoc)
	 * @see java.awt.Window#setVisible(boolean)
	 */
	@Override
	public void setVisible(boolean b) {
		super.setVisible(b);
		if(b) {
			setComponentProperties();
		}else {
			saveComponentProperties();
		}
	}

	/*
	 * Component types
	 */
	private final static int	COMPONENT_TABLE = 1;
	private final static int 	COMPONENT_SPLITTER = 2;
	
	protected RzPro rz;
    protected HashMap actionList;

    public JRzFrame(RzPro r, String name,Object extendedData) {
        super();
        rz = r;
        actionList = new HashMap();
        setName(name);
        
        
        addComponentListener(new java.awt.event.ComponentAdapter() {

			@Override
			public void componentMoved(java.awt.event.ComponentEvent evt) {
            	saveLocation();
            }
            @Override
			public void componentResized(java.awt.event.ComponentEvent evt) {
               saveLocation();
            }
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {

            }

        });
        addWindowListener(new java.awt.event.WindowAdapter() {
            @Override
			public void windowClosing(java.awt.event.WindowEvent evt) {
                closeWindow();
            }
        });
    }


	/** die Fensterposition speichern
     */
    private void saveLocation() {
    	try {
	    	if(this.getName().indexOf(FensterFactory.WINDOW_SEPARATOR) != -1) {
	    		if(this.isVisible()) {
	    			rz.getFensterFactory().saveLocation(this);
	    		}
	    	}
    	}
    	catch (final Exception e) {
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"JRzFrame.saveLocation",e.getLocalizedMessage());
    	}
    }


    public RzPro getRz() {
        return rz;
    }
    public abstract void closeWindow();
    public abstract void createActions();
    public abstract void createGUIComponents();
    public abstract void getMessage(MessageItem msg);
	public void putMessage(JRzFrame recipient, MessageItem msg) {
			try {
				recipient.putMessage(this,msg);
			} catch (final Exception e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN,this.getName()+ ".putMessage","could not deliver message");
			}
	}
    public abstract void openWindow();
    public abstract void setGUIComponents();

    /**
     * Interface für die ActionEvents
     */
    public Action getAction(int actionCode) {
    	return (Action)actionList.get(String.valueOf(actionCode));
    }

    /**
     *Fenster neu zeichnen, nach Änderung der Schriftgößen
     *
     */
    public void redrawFrame() {
        rz.getFontFactory().setFrameFonts(this);
        this.getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,0,null,this));
        this.invalidate();
    }
    /**
     * das Design wurde geändert....
     */
    public void updateFrameDesign() {
    	SwingUtilities.updateComponentTreeUI(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    
    public void setComponentProperties() {
    	setTableProperties(this.getContentPane());
    }
    
    public void saveComponentProperties() {
    	saveTableProperties(this.getContentPane());
    }
    
    private void setTableProperties(Container c) {
        for (int i=0;i<c.getComponentCount();i++){
            final Component co = c.getComponent(i);
            if ((co instanceof JPanel) || (co instanceof JTabbedPane) || (co instanceof JScrollPane) || (co instanceof JSplitPane) || ( co instanceof JViewport)) {
            	setTableProperties((Container)co);
            } else {
            	if (co instanceof JTable) {
            		getSpalten((JTable)co);
            	}
            }
        }
    }
    
    private void saveTableProperties(Container c) {
        for (int i=0;i<c.getComponentCount();i++){
            final Component co = c.getComponent(i);
            if ((co instanceof JPanel) || (co instanceof JTabbedPane) || (co instanceof JScrollPane) || (co instanceof JSplitPane) ||( co instanceof JViewport)) {
            	saveTableProperties((Container)co);
            } else {
            	if (co instanceof JTable) {
            		saveSpalten((JTable)co);
            	}
            }
        }
    }
    
	public void getSpalten(JTable tbl) {
		String key = tbl.getName();
		if(!key.equals("")) {
		    final String b= rz.getOptionFactory().getOption(key);
		    if(!b.equals("")) {
		        final String breiten[] = b.split(",");
			    for (int i = 0; i < breiten.length;i++) {
			    	try {
			    		tbl.getColumnModel().getColumn(i).setPreferredWidth(Integer.parseInt(breiten[i]));
			    	}catch (Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "getSpalten:",key );
			    	}
			    }
			    tbl.validate();
		    }
		}
	}
	
	private void saveSpalten(JTable tbl) {
	    String breiten = "";
	    String key = tbl.getName();
	    if(!key.equals("")) {
		    for(int i = 0;i < tbl.getColumnCount();i++) {
		    	try {
		    		breiten += tbl.getColumnModel().getColumn(i).getWidth() + ",";
		    	}catch (Exception e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "saveSpalten:",key );
		    	}
		    }
		    if(breiten != null && breiten.length()>0) {
		    	breiten = breiten.substring(0,breiten.length()-1);
		    }
		    rz.getOptionFactory().setOption(key,breiten);
		    rz.getOptionFactory().saveOptions();
	    }
	}
    
}
