/*
 * Created on 01.11.2004
 *
 */
package de.lunqual.rzpro.fenster;

import java.awt.Color;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JLabel;

import de.lunqual.rzpro.items.stichworte.StichwortItem;





public class JRzLabel extends JLabel {

	Color		emptyColor;
	Color		notEmptyColor;
	ArrayList	liste;
	

	public JRzLabel() {
		super();
		notEmptyColor = Color.WHITE;
		emptyColor = Color.GRAY;
		setOpaque(true);
		setBackground(Color.WHITE);
		setBorder(BorderFactory.createEtchedBorder());
	}


	public void setListData(ArrayList liste) {
		this.liste=liste;
		showText();
	}
	
	private void showText() {
		if(liste != null && !liste.isEmpty()) {
			String text = "<html>";
			for(int i=0;i < liste.size();i++) {
				StichwortItem si = (StichwortItem)liste.get(i);
				text += "<span color=" + si.getVg() + " bgcolor="+si.getHg() + ">" + si.getName() + "</span><br>";
			}
			text += "</html>";
			setText(text);
		} else {
			setText("");
		}
	}
}
