/*
 * Created on 01.11.2004
 *
 */
package de.lunqual.rzpro.fenster;

import java.awt.Color;

import javax.swing.JList;


/**
 * @author lunqual
 * erweitert eine JList um ein bisschen Farbe...
 * leere Listen werden in der Fenster-Hintergrundfarbe dargestellt, sobald
 * Einträge vorhanden sind, wechselte der Hintergrund auf eine andere Farbe
 * (Default=weiss)
 */


public class JRzList extends JList {

	Color		emptyColor;
	Color		notEmptyColor;


	public JRzList() {
		super();
		notEmptyColor = new Color(255,255,255);
		emptyColor = Color.getColor("awt.window");
		setOpaque(true);
		this.setBackground(emptyColor);
	}

	/**
	 * setzt die hintergrundfarbe in Abhängigkeit davon, ob
	 * die Liste Einträge enthält oder nicht...
	 *
	 */
	private void setContentColor() {
		if(this.getModel().getSize() == 0) {
			this.setBackground(emptyColor);
		} else {
			this.setBackground(notEmptyColor);
		}
	}

	@Override
	public void setListData(Object[] listData) {
		super.setListData(listData);
		setContentColor();
	}
}
